/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.search;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.core.search.SearchDocument;
import org.eclipse.dltk.mod.core.search.SearchParticipant;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.core.search.SearchRequestor;
import org.eclipse.dltk.mod.core.search.index.Index;
import org.eclipse.dltk.mod.core.search.index.MixinIndex;
import org.eclipse.dltk.mod.core.search.indexing.SourceIndexer;
import org.eclipse.dltk.mod.core.search.matching.MatchLocator;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.search.IndexSelector;
import org.eclipse.dltk.mod.internal.core.search.LazyDLTKSearchDocument;

public class DLTKSearchParticipant
extends SearchParticipant {
    private IndexSelector indexSelector;
    private boolean bOnlyMixin = false;

    @Override
    public void beginSearching() {
        super.beginSearching();
        this.indexSelector = null;
    }

    @Override
    public void doneSearching() {
        this.indexSelector = null;
        super.doneSearching();
    }

    @Override
    public String getDescription() {
        return "DLTK";
    }

    @Override
    public SearchDocument getDocument(String documentPath, IProject project) {
        return new LazyDLTKSearchDocument(documentPath, this, this.isExternal(documentPath), project);
    }

    private boolean isExternal(String documentPath) {
        Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)new Path(documentPath), true);
        return !(target instanceof IResource);
    }

    @Override
    public void indexDocument(SearchDocument document, IPath indexPath) {
        document.removeAllIndexEntries();
        new SourceIndexer(document).indexDocument();
    }

    @Override
    public void locateMatches(SearchDocument[] indexMatches, SearchPattern pattern, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = this.createMatchLocator(pattern, requestor, scope, monitor);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        matchLocator.locateMatches(indexMatches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    @Override
    public ISourceModule[] locateModules(SearchDocument[] indexMatches, SearchPattern pattern, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        MatchLocator matchLocator = this.createMatchLocator(pattern, null, scope, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 95)));
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ISourceModule[] modules = matchLocator.locateModules(indexMatches);
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return modules;
    }

    protected MatchLocator createMatchLocator(SearchPattern pattern, SearchRequestor requestor, IDLTKSearchScope scope, IProgressMonitor monitor) {
        MatchLocator locator;
        IDLTKLanguageToolkit toolkit = scope.getLanguageToolkit();
        if (toolkit != null && (locator = DLTKLanguageManager.createMatchLocator(toolkit.getNatureId(), pattern, requestor, scope, monitor == null ? null : new SubProgressMonitor(monitor, 95))) != null) {
            return locator;
        }
        return new MatchLocator(pattern, requestor, scope, (IProgressMonitor)(monitor == null ? null : new SubProgressMonitor(monitor, 95)));
    }

    @Override
    public IPath[] selectIndexes(SearchPattern pattern, IDLTKSearchScope scope) {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(scope, pattern);
        }
        return this.indexSelector.getIndexLocations();
    }

    @Override
    public IPath[] selectMixinIndexes(SearchPattern query, IDLTKSearchScope scope) {
        this.skipNotMixin();
        return this.selectIndexes(query, scope);
    }

    @Override
    public void skipNotMixin() {
        this.bOnlyMixin = true;
    }

    @Override
    public boolean isSkipped(Index index) {
        boolean mixinIndex = index instanceof MixinIndex || index.containerPath.startsWith("#special#mixin#");
        return this.bOnlyMixin ^ mixinIndex;
    }
}

