/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom.util;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.vjet.dsf.common.xml.IIndenter;

public interface ILineLocateIndenter
extends IIndenter {
    public static final String NEW_LINE = "\n";
    public static final String NEW_LINE_2 = System.getProperty("line.separator");

    public String getLineNumber();

    public String lineNumberText(String var1);

    public static class DefaultLineLocateIndenter
    implements ILineLocateIndenter {
        protected int m_numWrites = 0;

        public void indent(Writer writer, int level) throws IOException {
            if (this.m_numWrites++ > 0) {
                writer.write(ILineLocateIndenter.NEW_LINE);
            }
        }

        @Override
        public String getLineNumber() {
            return String.valueOf(this.m_numWrites + 1);
        }

        @Override
        public String lineNumberText(String text) {
            if (text == null) {
                return null;
            }
            String modTxt = text.replaceAll(NEW_LINE_2, ILineLocateIndenter.NEW_LINE);
            int idx = modTxt.indexOf(ILineLocateIndenter.NEW_LINE);
            while (idx != -1) {
                ++this.m_numWrites;
                idx = modTxt.indexOf(ILineLocateIndenter.NEW_LINE, idx + 1);
            }
            return text;
        }
    }

    public static class LineNumberIndenter
    extends DefaultLineLocateIndenter {
        @Override
        public void indent(Writer writer, int level) throws IOException {
            super.indent(writer, level);
            writer.write(String.valueOf(this.m_numWrites));
        }

        @Override
        public String lineNumberText(String text) {
            if (text == null) {
                return null;
            }
            String modTxt = text.replaceAll(NEW_LINE_2, ILineLocateIndenter.NEW_LINE);
            int idx = modTxt.indexOf(ILineLocateIndenter.NEW_LINE);
            if (idx == -1) {
                return text;
            }
            StringBuffer tmp = new StringBuffer();
            int preIdx = 0;
            while (idx != -1) {
                if (preIdx != 0) {
                    tmp.append(++this.m_numWrites);
                }
                tmp.append(modTxt.substring(preIdx, idx + 1));
                preIdx = idx + 1;
                idx = modTxt.indexOf(ILineLocateIndenter.NEW_LINE, preIdx);
            }
            if (preIdx != 0) {
                tmp.append(++this.m_numWrites);
                tmp.append(modTxt.substring(preIdx));
            }
            return tmp.toString();
        }
    }
}

