/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.dom;

import org.eclipse.vjet.dsf.dom.DDOMImplementation;
import org.eclipse.vjet.dsf.dom.DDOMImplementationList;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.DOMImplementationList;
import org.w3c.dom.DOMImplementationSource;

class DDOMImplementationSource
implements DOMImplementationSource {
    private static final DOMImplementation s_impl = new DDOMImplementation();
    private static final DOMImplementationList s_list = new DDOMImplementationList(s_impl);

    DDOMImplementationSource() {
    }

    @Override
    public DOMImplementation getDOMImplementation(String features) {
        if (features == null) {
            return null;
        }
        String normalizedFeatures = features.trim().toLowerCase();
        int len = s_list.getLength();
        int i = 0;
        while (i < len) {
            DOMImplementation impl = s_list.item(i);
            if (impl.hasFeature(normalizedFeatures, null)) {
                return impl;
            }
            ++i;
        }
        return null;
    }

    @Override
    public DOMImplementationList getDOMImplementationList(String features) {
        if (features == null) {
            return null;
        }
        String normalizedFeatures = features.trim().toLowerCase();
        int len = s_list.getLength();
        DDOMImplementationList answer = new DDOMImplementationList(new DOMImplementation[0]);
        int i = 0;
        while (i < len) {
            DOMImplementation impl = s_list.item(i);
            if (impl.hasFeature(normalizedFeatures, null)) {
                answer.add(impl);
            }
            ++i;
        }
        return answer;
    }
}

