/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.mod.ast.references.SimpleReference;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.ts.GenericVisitor;

class VjoCalleeAnalyzerVisitor
extends GenericVisitor {
    private Map fSearchResults = new HashMap();
    private IMethod fMethod;
    private IJstType fCompilationUnit;
    private IProgressMonitor fProgressMonitor;
    private int fMethodEndPosition;
    private int fMethodStartPosition;

    VjoCalleeAnalyzerVisitor(IMethod method, IJstType jstType, IProgressMonitor progressMonitor) {
        this.fMethod = method;
        this.fCompilationUnit = jstType;
        this.fProgressMonitor = progressMonitor;
        try {
            ISourceRange sourceRange = method.getSourceRange();
            this.fMethodStartPosition = sourceRange.getOffset();
            this.fMethodEndPosition = this.fMethodStartPosition + sourceRange.getLength();
        }
        catch (ModelException jme) {
            VjetPlugin.error("Model exception occurs when getting source range", jme);
        }
    }

    public Map getCallees() {
        return this.fSearchResults;
    }

    private void progressMonitorWorked(int work) {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.worked(work);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }

    @Override
    public void visit(MtdInvocationExpr expr) {
        this.progressMonitorWorked(1);
        IModelElement[] modelElement = CodeassistUtils.getModelElementByMtdInvoExpr(expr, (IVjoSourceModule)this.fMethod.getSourceModule());
        if (modelElement != null && modelElement instanceof IMethod[]) {
            this.addMethodCall((IMethod[])modelElement, expr);
        }
    }

    protected void addMethodCall(IMethod[] calledMethod, MtdInvocationExpr node) {
        JstSource jstSource = node.getMethodIdentifier().getSource();
        String methodName = node.getMethodIdentifier().toString();
        SimpleReference ref = null;
        ref = jstSource != null ? new SimpleReference(jstSource.getStartOffSet(), jstSource.getStartOffSet() + methodName.length(), node.toExprText()) : new SimpleReference(-1, 0, node.toExprText());
        this.fSearchResults.put(ref, calledMethod);
    }
}

