/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.validation;

import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRulePolicy;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationDriver;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationResult;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.eclipse.core.validation.AbstractValidator;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class BasicValidator
extends AbstractValidator {
    private static BasicValidator validator = null;

    public static synchronized BasicValidator getInstance() {
        if (validator == null) {
            return new BasicValidator();
        }
        return validator;
    }

    @Override
    public List<IScriptProblem> doValidate(IJstType scriptUnit) {
        LinkedList<IJstType> typeList = new LinkedList<IJstType>();
        typeList.add(scriptUnit);
        VjoValidationDriver driver = new VjoValidationDriver();
        driver.setTypeSpaceMgr(TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr());
        VjoValidationResult result = driver.validateComplete(typeList, scriptUnit.getPackage().getGroupName(), VjoValidationDriver.VjoValidationMode.validateType);
        LinkedList<IScriptProblem> problems = new LinkedList<IScriptProblem>();
        for (VjoSemanticProblem prob : result.getAllProblems()) {
            problems.add((IScriptProblem)prob);
        }
        return problems;
    }

    public VjoSemanticRulePolicy getRulePolicy(String severity) {
        if ("error".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_ERROR_POLICY;
        }
        if ("warning".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_WARNING_POLICY;
        }
        if ("ignore".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_IGNORE_POLICY;
        }
        return VjoSemanticRulePolicy.GLOBAL_ERROR_POLICY;
    }

    @Override
    public Set<IResource> deriveResources(Object object) {
        return null;
    }
}

