/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.ts;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.vjet.dsf.ts.event.group.BatchGroupLoadingEvent;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.ts.TypeSpaceGroupLoadJob;
import org.eclipse.vjet.vjo.tool.typespace.GroupInfo;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class TypeSpaceTracer {
    private static final boolean DEBUG_TS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.vjet.eclipse.core/typespace"));

    public static void logLoadEvent(List<GroupInfo> groups) {
        if (!DEBUG_TS) {
            return;
        }
        StringBuilder listOfProjects = new StringBuilder();
        System.out.println("==================");
        System.out.println("Loading Groups:");
        for (GroupInfo p : groups) {
            TypeSpaceTracer.println(p.getGroupName());
            TypeSpaceTracer.print("\t");
            TypeSpaceTracer.println("bootstrap path:" + p.getBootstrapPath());
            TypeSpaceTracer.print("\t");
            TypeSpaceTracer.println("direct group dependencies: ");
            for (String dd : p.getDirectDependency()) {
                TypeSpaceTracer.print("\t");
                TypeSpaceTracer.println(dd);
            }
            listOfProjects.append(p.getGroupName()).append(" ");
        }
        System.out.println("==================");
        VjetPlugin.getDefault().getLog().log((IStatus)new Status(1, "org.eclipse.vjet.eclipse.core", 1, String.valueOf(TypeSpaceGroupLoadJob.class.getName()) + " List of projects: " + listOfProjects, null));
    }

    static void print(Object obj) {
        System.out.print(obj);
    }

    static void println(Object obj) {
        System.out.println(obj);
    }

    public static void loadRefreshEvent(List<SourceTypeName> changedTypes) {
        if (!DEBUG_TS) {
            return;
        }
        System.out.println("==================");
        System.out.println("Refreshing Types:");
        for (SourceTypeName type : changedTypes) {
            TypeSpaceTracer.println(type);
        }
        System.out.println("==================");
    }

    public static void onBatchLoaded(BatchGroupLoadingEvent event) {
        if (!DEBUG_TS) {
            return;
        }
        System.out.println("onBatchLoaded for groups" + event.getAllGroups());
    }

    public static void loadReloadEvent(TypeSpaceMgr mgr) {
        if (!DEBUG_TS) {
            return;
        }
        System.out.println("==================");
        System.out.println("loadReloadEvent:");
        System.out.println("==================");
    }
}

