/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.search;

import java.util.List;
import org.eclipse.dltk.mod.core.ISourceRange;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.search.SearchPattern;
import org.eclipse.dltk.mod.internal.core.search.matching.OrPattern;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.core.search.AbstractVjoElementSearcher;
import org.eclipse.vjet.eclipse.core.search.ReferenceSearchTraversal;
import org.eclipse.vjet.eclipse.core.search.SearchQueryParameters;
import org.eclipse.vjet.eclipse.core.search.VjoMatch;
import org.eclipse.vjet.eclipse.core.search.VjoMatchFactory;
import org.eclipse.vjet.eclipse.core.search.VjoTypeOccurrenceVisitor;
import org.eclipse.vjet.eclipse.core.search.VjoTypeReferencesVisitor;

public class VjoTypeSearcher
extends AbstractVjoElementSearcher {
    @Override
    public Class<? extends SearchPattern> getSearchPatternClass() {
        return OrPattern.class;
    }

    @Override
    protected void searchDeclarations(SearchQueryParameters params, List<VjoMatch> result) {
        IType type = (IType)params.getElement();
        if (!this.isInScope(type)) {
            return;
        }
        try {
            ISourceRange nameRange = type.getNameRange();
            if (nameRange == null) {
                return;
            }
            if (type.getDeclaringType() != null) {
                type = type.getDeclaringType();
            }
            VjoMatch match = VjoMatchFactory.createFieldMatch(type, nameRange.getOffset(), nameRange.getLength());
            result.add(match);
        }
        catch (ModelException modelException) {}
    }

    @Override
    protected void searchReferences(SearchQueryParameters params, List<VjoMatch> result) {
        String fullTypeName;
        IType type = (IType)params.getElement();
        IVjoSourceModule module = (IVjoSourceModule)type.getSourceModule();
        List dependents = this.mgr.getDirectDependents(module.getTypeName());
        for (IJstType dependentType : dependents) {
            this.findRefs(type, dependentType.getRootType(), result);
        }
        String groupName = type.getScriptProject().getElementName();
        IJstType declaringType = this.mgr.findType(new TypeName(groupName, fullTypeName = type.getFullyQualifiedName(".")));
        if (declaringType != null) {
            this.findRefs(type, declaringType.getRootType(), result);
        }
    }

    private void findRefs(IType mainType, IJstType dependentType, List<VjoMatch> result) {
        VjoTypeReferencesVisitor typeRefVisitor = new VjoTypeReferencesVisitor(mainType, dependentType, result);
        ReferenceSearchTraversal.accept((IJstNode)dependentType, typeRefVisitor);
    }

    @Override
    public List<VjoMatch> findOccurrence(IJstNode searchedType, IJstNode searchedTree) {
        VjoTypeOccurrenceVisitor visitor = new VjoTypeOccurrenceVisitor((IJstType)searchedType);
        searchedTree.accept((IJstNodeVisitor)visitor);
        return visitor.getMatches();
    }
}

