/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKContentTypeManager;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.VjoSourceHelper;
import org.eclipse.dltk.mod.internal.core.builder.StandardScriptBuilder;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.mixer.TypeExtensionRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.FunctionMetaRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeResolverRegistry;
import org.eclipse.vjet.dsf.ts.event.EventListenerStatus;
import org.eclipse.vjet.dsf.ts.event.ISourceEventCallback;
import org.eclipse.vjet.dsf.ts.event.ISourceEventListener;
import org.eclipse.vjet.dsf.ts.event.dispatch.IEventListenerHandle;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupDependencyEvent;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.ts.event.group.BatchGroupLoadingEvent;
import org.eclipse.vjet.dsf.ts.event.group.IGroupEventListener;
import org.eclipse.vjet.dsf.ts.event.group.RemoveGroupDependencyEvent;
import org.eclipse.vjet.dsf.ts.event.group.RemoveGroupEvent;
import org.eclipse.vjet.dsf.ts.event.type.AddTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.ITypeEventListener;
import org.eclipse.vjet.dsf.ts.event.type.ModifyTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.RemoveTypeEvent;
import org.eclipse.vjet.dsf.ts.event.type.RenameTypeEvent;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.PiggyBackClassPathUtil;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.VjoLanguageToolkit;
import org.eclipse.vjet.eclipse.core.ts.EclipseTypeLoadMonitor;
import org.eclipse.vjet.eclipse.core.ts.TypeSpaceTracer;
import org.eclipse.vjet.vjo.lib.TsLibLoader;
import org.eclipse.vjet.vjo.tool.typespace.GroupInfo;
import org.eclipse.vjet.vjo.tool.typespace.SourcePathInfo;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeLoadMonitor;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class TypeSpaceBuilder {
    public void buildProject(ScriptProject project, Map args, IProgressMonitor monitor, List<String> groupDepends, IBuildpathEntry bootstrapPath) {
        ArrayList<String> bootstrapDirs = new ArrayList<String>();
        if (bootstrapPath != null) {
            String portableString = "";
            portableString = TypeSpaceBuilder.getRelativeProjectPath((IScriptProject)project, bootstrapPath);
            bootstrapDirs.add(portableString);
        }
        ArrayList<GroupInfo> info = new ArrayList<GroupInfo>();
        TypeSpaceBuilder.processAddGroup(info, project.getProject());
        TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
        TypeSpaceTracer.logLoadEvent(info);
        mgr.load((TypeLoadMonitor)new EclipseTypeLoadMonitor(monitor), info);
        if (VjetPlugin.TRACE_TYPESPACE) {
            System.out.println("project: " + project);
            System.out.println("args: " + args);
            System.out.println("monitor: " + monitor);
            System.out.println("project buildpath: " + groupDepends);
            System.out.println("bootstrapPath: " + bootstrapPath);
        }
    }

    public void incrementalBuildProject(List<SourceTypeName> changedTypes) {
        if (!changedTypes.isEmpty()) {
            TypeSpaceTracer.loadRefreshEvent(changedTypes);
            for (SourceTypeName type : changedTypes) {
                TypeSpaceMgr.doProcessType((SourceTypeName)type, null);
            }
        }
    }

    public static void processAddGroup(List<GroupInfo> info, IProject project) {
        try {
            Model model = ModelManager.getModelManager().getModel();
            IScriptProject scriptProject = model.getScriptProject(project.getName());
            if (scriptProject.exists()) {
                HashMap<String, List<String>> groups = new HashMap<String, List<String>>();
                TypeSpaceBuilder.createDepends(groups, scriptProject);
                TypeSpaceBuilder.populateGroupInfos(info, scriptProject, groups);
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
    }

    private static IBuildpathEntry[] createDepends(Map<String, List<String>> groups, IScriptProject project) throws ModelException {
        List<String> list = TypeSpaceBuilder.getDependsProjects(groups, project.getElementName());
        IBuildpathEntry[] entries = TypeSpaceBuilder.getSerFileGroupDepends(project, list);
        groups.put(project.getElementName(), list);
        return entries;
    }

    private static List<String> getDependsProjects(Map<String, List<String>> groups, String group) {
        List<String> list = groups.get(group);
        if (list == null) {
            list = new ArrayList<String>();
            groups.put(group, list);
        }
        return list;
    }

    private List<SourceTypeName> loadFile(IResourceDelta delta, IResource resource) {
        IFile file = (IFile)resource;
        if (this.isValidFile(file)) {
            return this.loadVjoFile(delta, file);
        }
        return null;
    }

    private boolean isValidFile(IFile file) {
        return this.isValidName(file) && PiggyBackClassPathUtil.isInSourceFolder((IResource)file);
    }

    private boolean isValidName(IFile file) {
        boolean isValid = false;
        try {
            isValid = DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)VjoLanguageToolkit.getDefault(), (IPath)file.getLocation());
        }
        catch (Exception e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
        return isValid;
    }

    private SourceTypeName createSourceTypeName(IFile file) {
        byte[] content = SourceTypeName.EMPTY_CONTENT;
        content = this.getFileContent(file);
        return this.createSourceTypeName(file, content);
    }

    private byte[] getFileContent(IFile file) {
        byte[] bs = SourceTypeName.EMPTY_CONTENT;
        try {
            bs = this.doGetFileContent(file);
        }
        catch (IOException e) {
            this.logError(e);
        }
        catch (ResourceException resourceException) {
            this.refresh(file);
            try {
                bs = this.doGetFileContent(file);
            }
            catch (Exception e1) {
                this.logError(e1);
            }
        }
        catch (CoreException e) {
            this.logError((Exception)((Object)e));
        }
        return bs;
    }

    private void refresh(IFile file) {
        try {
            file.refreshLocal(2, null);
        }
        catch (CoreException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    private void logError(Exception e1) {
        DLTKCore.error((String)e1.getMessage(), (Throwable)e1);
    }

    private byte[] doGetFileContent(IFile file) throws CoreException, IOException {
        InputStream stream = file.getContents();
        int available = stream.available();
        byte[] bs = new byte[available];
        stream.read(bs);
        stream.close();
        return bs;
    }

    private SourceTypeName createSourceTypeName(IFile file, byte[] bs) {
        String group = file.getProject().getName();
        String source = new String(bs);
        String name = CodeassistUtils.getClassName(file);
        SourceTypeName typeName = new SourceTypeName(group, name, source);
        return typeName;
    }

    private List<SourceTypeName> loadVjoFile(IResourceDelta delta, IFile file) {
        ArrayList<SourceTypeName> changedTypes = new ArrayList<SourceTypeName>();
        TypeSpaceMgr tsmgr = TypeSpaceMgr.getInstance();
        SourceTypeName name = file.exists() ? this.createSourceTypeName(file) : this.createSourceTypeName(file, SourceTypeName.EMPTY_CONTENT);
        String typeName = CodeassistUtils.getClassName(file);
        switch (delta.getKind()) {
            case 1: {
                if (tsmgr.existType(file.getProject().getName(), typeName)) break;
                name.setAction(1);
                changedTypes.add(name);
                if (!file.exists()) break;
                tsmgr.getController().parseAndResolve(name.groupName(), file.getLocation().toFile());
                break;
            }
            case 4: {
                if (!tsmgr.existType(file.getProject().getName(), typeName)) break;
                name.setAction(4);
                changedTypes.add(name);
                break;
            }
            case 2: {
                if (!tsmgr.existType(file.getProject().getName(), typeName)) break;
                name.setAction(2);
                changedTypes.add(name);
                break;
            }
        }
        return changedTypes;
    }

    private List<SourceTypeName> processDelta(IResourceDelta delta) {
        ArrayList<SourceTypeName> changedTypes;
        block9: {
            IResource resource;
            block8: {
                resource = delta.getResource();
                changedTypes = new ArrayList<SourceTypeName>();
                if (!(resource instanceof IFile)) break block8;
                switch (delta.getKind()) {
                    case 4: {
                        if ((delta.getFlags() & 0xFFFCFFFF) != 0) {
                            changedTypes.addAll(this.loadFile(delta, resource));
                            break;
                        }
                        break block9;
                    }
                    case 1: {
                        changedTypes.addAll(this.loadFile(delta, resource));
                        break;
                    }
                    case 2: {
                        changedTypes.addAll(this.loadFile(delta, resource));
                        break;
                    }
                }
                break block9;
            }
            if (PiggyBackClassPathUtil.isInSourceFolder(resource) || resource instanceof IProject) {
                IResourceDelta[] deltas;
                IResourceDelta[] iResourceDeltaArray = deltas = delta.getAffectedChildren();
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta resourceDelta = iResourceDeltaArray[n2];
                    changedTypes.addAll(this.processDelta(resourceDelta));
                    ++n2;
                }
            }
        }
        return changedTypes;
    }

    private static void populateGroupInfos(List<GroupInfo> info, IScriptProject project, Map<String, List<String>> groupDependency) throws ModelException {
        if (!PiggyBackClassPathUtil.ifScriptProjectInitializedFromJavaProject(project)) {
            PiggyBackClassPathUtil.initializeScriptProjectFromJavProject(project);
        }
        ArrayList<String> classPaths = new ArrayList<String>();
        List<URL> urls = PiggyBackClassPathUtil.getProjectDependantJars_DLTK(project);
        ArrayList<String> groupDepends = new ArrayList<String>();
        TypeSpaceBuilder.getSerFileGroupDepends(project, groupDepends);
        IBuildpathEntry bootstrapPath = TypeSpaceBuilder.getBootstrapDir(project);
        for (URL u : urls) {
            File file = new File(u.getFile());
            String fileName = file.getName();
            if (TypeSpaceMgr.getInstance().existGroup(fileName) || classPaths.contains(fileName)) continue;
            SourcePathInfo srcPathInfo = new SourcePathInfo();
            srcPathInfo.addSourcePath(file.getPath());
            GroupInfo groupInfo = new GroupInfo(file.getName(), file.getAbsolutePath(), srcPathInfo, null, groupDependency.get(file.getName()));
            groupInfo.setLibrary(true);
            info.add(groupInfo);
            classPaths.add(fileName);
            System.out.println("ScriptProject<" + project.getElementName() + "> depends on :" + u);
        }
        SourcePathInfo sourcePathInfo = PiggyBackClassPathUtil.getProjectSrcPath_DLTK(project);
        List srcPaths = sourcePathInfo.getSourcePaths();
        sourcePathInfo.setSourcePaths(srcPaths);
        String name = project.getProject().getName();
        File groupPath = project.getProject().getLocation().toFile();
        ArrayList<String> bootstrapDirs = new ArrayList<String>();
        if (bootstrapPath != null) {
            String portableString = "";
            portableString = TypeSpaceBuilder.getRelativeProjectPath(project, bootstrapPath);
            bootstrapDirs.add(portableString);
        }
        info.add(new GroupInfo(name, groupPath.getAbsolutePath(), sourcePathInfo, classPaths, groupDependency.get(name), bootstrapDirs));
    }

    private static String getRelativeProjectPath(IScriptProject project, IBuildpathEntry bootstrap) {
        String name = project.getElementName();
        String bootstrapPath = bootstrap.getPath().toPortableString();
        if (bootstrapPath.lastIndexOf(name) != -1) {
            bootstrapPath = bootstrapPath.equals(name) ? "" : bootstrapPath.substring(bootstrapPath.indexOf(name) + name.length());
        }
        return bootstrapPath;
    }

    public static IBuildpathEntry getBootstrapDir(IScriptProject project) throws ModelException {
        IBuildpathEntry[] entries;
        IBuildpathEntry[] iBuildpathEntryArray = entries = project.getRawBuildpath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() == 6) {
                return entry;
            }
            ++n2;
        }
        return null;
    }

    public static IBuildpathEntry[] getSerFileGroupDepends(IScriptProject project, List<String> list) throws ModelException {
        IBuildpathEntry[] entries;
        IBuildpathEntry[] iBuildpathEntryArray = entries = project.getRawBuildpath();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() == 2) {
                list.add(entry.getPath().segment(0));
                TypeSpaceBuilder.getSerFileGroupDepends((IScriptProject)CodeassistUtils.getScriptProject(entry.getPath().segment(0)), list);
            } else if (entry.getEntryKind() == 1) {
                id = entry.getPath().segment(entry.getPath().segmentCount() - 1);
                list.add(id);
            } else if (entry.getEntryKind() == 5) {
                int i;
                String[] defaultLibs;
                id = entry.getPath().segment(0);
                if ("org.eclipse.vjet.eclipse.core.VJETTL".equals(id)) {
                    list.add(entry.getPath().lastSegment());
                }
                if ("org.eclipse.vjet.eclipse.core.VJO_CONTAINER".equals(id)) {
                    defaultLibs = TsLibLoader.getVjoGroups();
                    i = 0;
                    while (i < defaultLibs.length) {
                        list.add(defaultLibs[i]);
                        ++i;
                    }
                }
                if ("org.eclipse.vjet.eclipse.core.BROWSER_CONTAINER".equals(id)) {
                    defaultLibs = TsLibLoader.getBrowserGroups();
                    i = 0;
                    while (i < defaultLibs.length) {
                        list.add(defaultLibs[i]);
                        ++i;
                    }
                }
                if ("org.eclipse.vjet.eclipse.core.JSNATIVE_CONTAINER".equals(id)) {
                    defaultLibs = TsLibLoader.getJsNativeGroups();
                    i = 0;
                    while (i < defaultLibs.length) {
                        list.add(defaultLibs[i]);
                        ++i;
                    }
                }
                if ("org.eclipse.vjet.eclipse.core.SDK_CONTAINER".equals(id)) {
                    defaultLibs = TsLibLoader.getDefaultLibNames();
                    i = 0;
                    while (i < defaultLibs.length) {
                        list.add(defaultLibs[i]);
                        ++i;
                    }
                }
            }
            ++n2;
        }
        return entries;
    }

    public static void addGroupTraceEventListeners(JstTypeSpaceMgr jstTypeSpace) {
        jstTypeSpace.registerSourceEventListener((ISourceEventListener)new IGroupEventListener<IJstType>(){

            public EventListenerStatus<IJstType> onBatchGroupLoaded(BatchGroupLoadingEvent event, IEventListenerHandle handle, ISourceEventCallback callBack) {
                System.out.println("on batch group add dependendency");
                TypeSpaceTracer.onBatchLoaded(event);
                return null;
            }

            public EventListenerStatus onGroupAddDependency(AddGroupDependencyEvent event, IEventListenerHandle handle, ISourceEventCallback callBack) {
                System.out.println("onGroupAddDependency for group:" + event.getGroupName());
                System.out.println("\tgroup path: " + event.getGroupPath());
                System.out.println("\tdependency list: " + event.getDependencyList());
                return null;
            }

            public EventListenerStatus onGroupAdded(AddGroupEvent event, IEventListenerHandle handle, ISourceEventCallback callBack) {
                System.out.println("on group added");
                System.out.println("bootstrap paths:" + event.getBootStrapList());
                System.out.println(event);
                return null;
            }

            public EventListenerStatus onGroupRemoveDependency(RemoveGroupDependencyEvent event, IEventListenerHandle handle, ISourceEventCallback callBack) {
                System.out.println("on group remove dependency");
                System.out.println(event);
                return null;
            }

            public void onGroupRemoved(RemoveGroupEvent event) {
                System.out.println("on group removed");
                System.out.println(event);
            }
        });
    }

    public static void addGroupEventListeners(JstTypeSpaceMgr jstTypeSpaceMgr) {
        jstTypeSpaceMgr.registerSourceEventListener((ISourceEventListener)new ITypeEventListener<JstType>(){

            public EventListenerStatus<JstType> onTypeAdded(AddTypeEvent<JstType> event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                return null;
            }

            public EventListenerStatus<JstType> onTypeRenamed(RenameTypeEvent event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                return null;
            }

            public EventListenerStatus<JstType> onTypeModified(ModifyTypeEvent event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                TypeSpaceMgr ts = TypeSpaceMgr.getInstance();
                IJstType type = ts.findType(event.getTypeName());
                this.buildType(type);
                List dependents = ts.getTypeSpace().getAllDependents(event.getTypeName());
                if (dependents != null) {
                    for (IJstType jstType : dependents) {
                        this.buildType(jstType);
                    }
                }
                return null;
            }

            private void buildType(IJstType jstType) {
                LinkedList<ISourceModule> selectedSourceModules = new LinkedList<ISourceModule>();
                StandardScriptBuilder scriptBuild = new StandardScriptBuilder();
                ScriptProject scriptProject = CodeassistUtils.getScriptProject(jstType.getPackage().getGroupName());
                ArrayList<IJstType> dependant = new ArrayList<IJstType>();
                dependant.add(jstType);
                VjoSourceHelper.getAllSourceModulesFromJst(selectedSourceModules, dependant, scriptProject);
                if (selectedSourceModules.size() > 0) {
                    scriptBuild.initialize((IScriptProject)scriptProject);
                    scriptBuild.buildModelElements((IScriptProject)scriptProject, selectedSourceModules, (IProgressMonitor)new NullProgressMonitor(), 1);
                }
            }

            public EventListenerStatus<JstType> onTypeRemoved(RemoveTypeEvent event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                return null;
            }
        });
        jstTypeSpaceMgr.registerSourceEventListener((ISourceEventListener)new IGroupEventListener<JstType>(){

            public EventListenerStatus<JstType> onBatchGroupLoaded(BatchGroupLoadingEvent event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                return null;
            }

            public EventListenerStatus<JstType> onGroupAddDependency(AddGroupDependencyEvent event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                return null;
            }

            public EventListenerStatus<JstType> onGroupAdded(AddGroupEvent event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                return null;
            }

            public EventListenerStatus<JstType> onGroupRemoveDependency(RemoveGroupDependencyEvent event, IEventListenerHandle handle, ISourceEventCallback<JstType> callBack) {
                return null;
            }

            public void onGroupRemoved(RemoveGroupEvent event) {
                String groupId = event.getGroupName();
                TypeResolverRegistry.getInstance().clear(groupId);
                TypeExtensionRegistry.getInstance().clear(groupId);
                FunctionMetaRegistry.getInstance().clear(groupId);
            }
        });
    }
}

