/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.JSSourceField;
import org.eclipse.dltk.mod.internal.core.JSSourceFieldElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoLocalVariable;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.codeassist.compliance.SupportedByAnnotationAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.MethodCompletionHandler;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.internal.core.util.Util;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class FieldExpressionHandler {
    private static final String GLOBAL = "Global";
    private boolean forceInherits;

    static FieldExpressionHandler getNonForcedHandler() {
        return new FieldExpressionHandler(false);
    }

    private FieldExpressionHandler(boolean forceInherits) {
        this.forceInherits = forceInherits;
    }

    FieldExpressionHandler() {
        this(true);
    }

    private boolean isAccepted(IJstNode jst, SupportedByAnnotationAcceptor acceptor) {
        boolean isAccepted = true;
        if (jst != null) {
            isAccepted = acceptor.accept(jst.getAnnotations());
        }
        return isAccepted;
    }

    public void complete(ISourceModule module, int position, JstCompletion completion, List<CompletionProposal> list, Object jstNode) {
        String token = completion.getToken();
        String typeName = completion.getOwnerType().getName();
        IType currentType = CodeassistUtils.getCurrentType(module, typeName);
        IType type = FieldExpressionHandler.getType(module, jstNode, typeName);
        if (type != null) {
            CompletionProposal data;
            List jstTypes;
            IProject typeProject = type.getParent().getScriptProject().getProject();
            SupportedByAnnotationAcceptor acceptor = SupportedByAnnotationAcceptor.getAcceptor(typeProject);
            IJstType nativeJstType = null;
            if (type.getSourceModule() instanceof NativeVjoSourceModule && (jstTypes = TypeSpaceMgr.getInstance().findType(type.getElementName())) != null && jstTypes.size() > 0) {
                nativeJstType = (IJstType)jstTypes.get(0);
            }
            MethodCompletionHandler.TypeMembersRequestor requestor = new MethodCompletionHandler.TypeMembersRequestor(token, false, currentType, completion);
            if (this.forceInherits) {
                this.getMembers(requestor, type);
            } else {
                this.getOwnMembers(requestor, type);
            }
            if (this.isNeededGlobal(type)) {
                IType global = CodeassistUtils.createNativeType(module, GLOBAL);
                this.getMembers(requestor, global);
            }
            List<IMethod> methods = requestor.getMethods();
            for (IMethod method : methods) {
                if (nativeJstType != null && !this.isAccepted((IJstNode)nativeJstType.getMethod(method.getElementName()), acceptor)) continue;
                char[] name = method.getElementName().toCharArray();
                boolean isConstructor = false;
                try {
                    isConstructor = method.isConstructor();
                }
                catch (ModelException e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                }
                if (isConstructor && type.equals(method.getParent())) continue;
                if (isConstructor) {
                    name = "base".toCharArray();
                }
                data = CompletionProposal.create((int)5, (int)position);
                data.setCompletion(name);
                data.setName(name);
                data.setModelElement((IModelElement)method);
                this.setParameters(method, data);
                int flags = 0;
                try {
                    flags = method.getFlags();
                }
                catch (ModelException e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                }
                data.setFlags(flags);
                data.setReplaceRange(position - token.length(), position);
                String returnType = null;
                try {
                    if (method instanceof IJSMethod) {
                        returnType = ((IJSMethod)method).getReturnType();
                        data.extraInfo = String.valueOf(returnType) + " - " + method.getParent().getElementName();
                    }
                }
                catch (ModelException e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                }
                list.add(data);
            }
            List<IField> fields = requestor.getFields();
            for (IField field : fields) {
                if (nativeJstType != null && !this.isAccepted((IJstNode)nativeJstType.getProperty(field.getElementName()), acceptor)) continue;
                int flags = 0;
                try {
                    flags = field.getFlags();
                }
                catch (ModelException e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                }
                data = CompletionProposal.create((int)1, (int)position);
                data.setCompletion(field.getElementName().toCharArray());
                data.setName(field.getElementName().toCharArray());
                data.setModelElement((IModelElement)field);
                data.setFlags(flags);
                data.setReplaceRange(position - token.length(), position);
                try {
                    JSSourceFieldElementInfo info = (JSSourceFieldElementInfo)((JSSourceField)field).getElementInfo();
                    typeName = info.getType();
                }
                catch (ModelException e) {
                    DLTKCore.error((String)e.toString(), (Throwable)e);
                }
                data.extraInfo = String.valueOf(typeName) + " - " + field.getParent().getElementName();
                list.add(data);
            }
        }
    }

    private boolean isNeededGlobal(IType type) {
        String name = type.getElementName();
        return "Object".equals(name) || !TypeSpaceMgr.isNativeGlobalObject((String)name);
    }

    public static IType getType(ISourceModule module, Object jstNode, String typeName) {
        IType type;
        IModelElement element = FieldExpressionHandler.getElement(module, jstNode);
        if (element instanceof JSSourceType) {
            type = (IType)element;
        } else {
            try {
                if (element instanceof JSSourceMethod) {
                    typeName = ((JSSourceMethod)element).getReturnType();
                } else if (element instanceof JSSourceField) {
                    JSSourceFieldElementInfo info = (JSSourceFieldElementInfo)((JSSourceField)element).getElementInfo();
                    typeName = info.getType();
                } else if (element instanceof VjoLocalVariable) {
                    typeName = ((VjoLocalVariable)element).getTypeSignature();
                }
            }
            catch (Exception e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
            IModelElement sm = element;
            if (sm == null) {
                return null;
            }
            type = CodeassistUtils.findType((ISourceModule)(sm = sm.getAncestor(5)), typeName);
            if (type == null) {
                type = CodeassistUtils.getType((ISourceModule)sm, typeName);
            }
            if (type == null) {
                type = CodeassistUtils.findNativeSourceType((ISourceModule)sm, typeName);
            }
        }
        return type;
    }

    private static IModelElement getElement(ISourceModule module, Object jstNode) {
        IModelElement[] modelElements;
        IModelElement element = null;
        if (element == null && (modelElements = CodeassistUtils.resolveQualifiedNameReference(jstNode, module)) != null && modelElements.length > 0) {
            element = modelElements[0];
        }
        return element;
    }

    public Class getCompletionClass() {
        return null;
    }

    protected void getOwnMembers(MethodCompletionHandler.TypeMembersRequestor requestor, IType type) {
        if (type == null || requestor == null) {
            return;
        }
        try {
            IMethod[] methods = type.getMethods();
            IField[] fields = type.getFields();
            IMethod[] iMethodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                requestor.acceptMember((IMember)method);
                ++n2;
            }
            iMethodArray = fields;
            n = fields.length;
            n2 = 0;
            while (n2 < n) {
                IMethod field = iMethodArray[n2];
                requestor.acceptMember((IMember)field);
                ++n2;
            }
        }
        catch (ModelException me) {
            DLTKCore.error((String)me.toString(), (Throwable)me);
        }
    }

    protected void getMembers(MethodCompletionHandler.TypeMembersRequestor requestor, IType type) {
        if (type == null || requestor == null) {
            return;
        }
        try {
            IJstType jstType;
            IType superType;
            this.getOwnMembers(requestor, type);
            String[] superClassNames = type.getSuperClasses();
            if (superClassNames != null && superClassNames.length > 0 && (superType = CodeassistUtils.findResourceType((ISourceModule)type.getParent(), superClassNames[0])) != null) {
                this.getMembers(requestor, superType);
            }
            if ((jstType = Util.toJstType(type)) != null) {
                List mixinTypes = Util.toJstType(type).getMixinsRef();
                for (IJstTypeReference mixinType : mixinTypes) {
                    this.getMembers(requestor, Util.toIType(mixinType.getReferencedType()));
                }
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    protected void setParameters(IMethod method, CompletionProposal data) {
        try {
            String[] paramNames = method.getParameters();
            char[][] params = this.createParameters(paramNames);
            data.setParameterNames(params);
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
    }

    protected char[][] createParameters(String[] paramNames) {
        char[][] parameters = new char[paramNames.length][];
        int i = 0;
        while (i < paramNames.length) {
            parameters[i] = paramNames[i].toCharArray();
            ++i;
        }
        return parameters;
    }
}

