/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstTypeCompletion;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.codeassist.keywords.AcceptCatchCompletion;
import org.eclipse.vjet.eclipse.codeassist.keywords.BreakCompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.CaseCompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.CompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.ContinueCompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.DefaultVjoKeyword;
import org.eclipse.vjet.eclipse.codeassist.keywords.ElseCompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.IAutoComplemented;
import org.eclipse.vjet.eclipse.codeassist.keywords.IVjoCompletionData;
import org.eclipse.vjet.eclipse.codeassist.keywords.KeywordCompletionEngine;
import org.eclipse.vjet.eclipse.codeassist.keywords.ThisBaseCompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.ThisVj$CompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordCompletionResult;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordFactory;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoStaticCompletionAcceptor;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoSysoutCompletionAcceptor;

public class DictionaryKeywordCompletionEngine
implements KeywordCompletionEngine {
    private int position;
    private JstCompletion completion;
    private ISourceModule module;
    private static Map<IVjoCompletionData, CompletionAcceptor> acceptors = new HashMap<IVjoCompletionData, CompletionAcceptor>();

    static {
        acceptors.put(VjoKeywordFactory.KWD_CATCH, new AcceptCatchCompletion());
        acceptors.put(VjoKeywordFactory.KWD_FINALLY, new AcceptCatchCompletion());
        acceptors.put(VjoKeywordFactory.KWD_ELSE, new ElseCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_CONTINUE, new ContinueCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_BREACK, new BreakCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_CASE, new CaseCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_DEFAULT, new CaseCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_SYSTEM_OUT, new VjoStaticCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_SYSTEM_ERR, new VjoStaticCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_PRINTLN, new VjoSysoutCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_PRINT, new VjoSysoutCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_PRINT_STACK_TRACE, new VjoStaticCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_BASE, new ThisBaseCompletionAcceptor());
        acceptors.put(VjoKeywordFactory.KWD_VJ$, new ThisVj$CompletionAcceptor());
    }

    public DictionaryKeywordCompletionEngine(ISourceModule sourceModule, int position, JstCompletion completion) {
        this.position = position;
        this.module = sourceModule;
        this.completion = completion;
    }

    @Override
    public VjoKeywordCompletionResult getCompletionResult() {
        VjoKeywordCompletionResult result;
        if (this.completion != null) {
            String token;
            int idx;
            List<IVjoCompletionData> list = this.createCompletaionData(this.module, this.completion);
            int offset = this.completion.getSource().getStartOffSet();
            if (this.isEmptyInCompletePart(this.completion)) {
                offset = this.position;
            }
            if ((idx = (token = this.completion.getToken()).lastIndexOf(46)) != -1) {
                offset = offset + idx + 1;
            }
            result = new VjoKeywordCompletionResult(list, offset);
        } else {
            result = null;
        }
        return result;
    }

    private boolean isEmptyInCompletePart(JstCompletion completion) {
        return completion.getIncompletePart() != null && completion.getIncompletePart().trim().length() == 0;
    }

    private List<IVjoCompletionData> createCompletaionData(ISourceModule sourceModule, JstCompletion completion) {
        ArrayList<IVjoCompletionData> list = new ArrayList<IVjoCompletionData>();
        if (completion != null) {
            String[] strings;
            String[] stringArray = strings = completion.getCompletion();
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                IVjoCompletionData keyword = VjoKeywordFactory.getKeywordByName(string);
                if (keyword != null && keyword instanceof IAutoComplemented) {
                    ((IAutoComplemented)((Object)keyword)).autoComplete(CodeassistUtils.autoCreateTypeNameFor(sourceModule));
                }
                if (keyword == null) {
                    keyword = new DefaultVjoKeyword(string);
                }
                list.add(keyword);
                ++n2;
            }
        }
        List<IVjoCompletionData> globals = this.createGlobalCompletions(completion);
        list.addAll(globals);
        return list;
    }

    private List<IVjoCompletionData> createGlobalCompletions(JstCompletion comp) {
        IVjoCompletionData[] datas;
        ArrayList<IVjoCompletionData> list = new ArrayList<IVjoCompletionData>();
        String token = comp.getToken();
        if (comp.inScope(ScopeIds.METHOD)) {
            datas = VjoKeywordFactory.METHOD_KEYWORDS;
            this.addCompletions(list, datas, token);
            datas = VjoKeywordFactory.UTILITY_METHOD_KEYWORDS;
            this.addCompletions(list, datas, token);
        }
        if (comp.isEmptyStack() && comp.getCompletion().length == 0 && this.isTypeCompletion(comp)) {
            datas = VjoKeywordFactory.GLOBAL_KEYWORDS;
            this.addCompletions(list, datas, token);
        }
        return list;
    }

    private boolean isTypeCompletion(JstCompletion comp) {
        return comp.getClass().equals(JstTypeCompletion.class);
    }

    private void addCompletions(List<IVjoCompletionData> list, IVjoCompletionData[] datas, String token) {
        int i = 0;
        while (i < datas.length) {
            IVjoCompletionData vjoCompletionData = datas[i];
            if (token != null && vjoCompletionData.canComplete(token)) {
                this.addCompletionData(list, vjoCompletionData);
            }
            ++i;
        }
    }

    private void addCompletionData(List<IVjoCompletionData> list, IVjoCompletionData data) {
        CompletionAcceptor acceptor = acceptors.get(data);
        if (acceptor != null) {
            acceptor.setSourceModule(this.module);
            if (acceptor.accept(this.position, this.completion)) {
                list.add(data);
            }
        } else {
            list.add(data);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public ISourceModule getModule() {
        return this.module;
    }
}

