/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.List;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.eclipse.codeassist.keywords.AbstractCompletionAcceptor;

public abstract class AbstractCompositeCompletionAcceptor<T>
extends AbstractCompletionAcceptor {
    @Override
    public boolean accept(int position, JstCompletion completion) {
        IJstType jstType = completion.getOwnerType();
        int startIndex = completion.getSource().getStartOffSet();
        JstMethod jstMethod = (JstMethod)JstUtil.getMethod((int)startIndex, (IJstType)((JstType)jstType));
        boolean accept = false;
        if (jstMethod != null) {
            accept = this.accept(position, (IJstMethod)jstMethod);
        }
        return accept;
    }

    protected boolean accept(int position, IJstMethod jstMethod) {
        BlockStmt blockStmt = this.getBlock(position, jstMethod);
        boolean accept = false;
        if (blockStmt == null) {
            List list = jstMethod.getBlock().getStmts();
            accept = this.belowBlock(position, list);
        } else {
            accept = this.belowBlock(blockStmt, position);
        }
        return accept;
    }

    protected boolean belowBlock(BlockStmt t, int position) {
        List list = t.getBody().getStmts();
        boolean belowBlock = false;
        if (list != null) {
            belowBlock = this.belowBlock(position, list);
        }
        if (belowBlock && this.getStatementClass().equals(t.getClass())) {
            List<BaseJstNode> dependsStmts = this.getDependsStatements(t);
            belowBlock = this.notInDependsStatements(position, dependsStmts);
        }
        return belowBlock;
    }

    protected boolean belowBlock(int position, List<IStmt> list) {
        boolean belowBlock = false;
        if (list != null) {
            for (IStmt stmt : list) {
                BlockStmt tryStmt;
                if (this.getStatementClass().equals(stmt.getClass()) && (belowBlock = this.belowSource(tryStmt = (BlockStmt)stmt, position))) break;
            }
        }
        return belowBlock;
    }

    protected boolean belowSource(BlockStmt stmt, int position) {
        List<BaseJstNode> dependsStmts = this.getDependsStatements(stmt);
        boolean below = this.belowSource(stmt.getSource(), position);
        if (below) {
            below = this.notInDependsStatements(position, dependsStmts);
        }
        return below;
    }

    private boolean notInDependsStatements(int position, List<BaseJstNode> dependsStmts) {
        boolean notInSource = true;
        for (BaseJstNode stmt : dependsStmts) {
            if (stmt == null || stmt.getSource() == null) continue;
            boolean bl = notInSource = !this.inSource(stmt.getSource(), position);
            if (!notInSource) break;
        }
        return notInSource;
    }

    protected abstract List<BaseJstNode> getDependsStatements(T var1);

    protected abstract Object getStatementClass();

    protected boolean belowSource(JstSource source, int position) {
        return source.getEndOffSet() < position;
    }
}

