/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.ISourceElementParser;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.SourceParserUtil;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.mod.internal.core.ExternalJSSourceModule;
import org.eclipse.dltk.mod.internal.core.JSSourceModuleElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.StructureBuilder;
import org.eclipse.dltk.mod.internal.core.VjoSourceModuleStructureRequestor;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.codeassist.CodeassistUtils;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.internal.compiler.VjoSourceElementParser;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoExternalSourceModule
extends ExternalJSSourceModule
implements IVjoSourceModule {
    private IJstType m_jstType = null;
    private boolean isConsistent = false;
    private boolean m_typeProcessed;
    private List<IScriptProblem> m_probs;
    private List<JstBlock> m_blockList;
    private JstBlock m_block;

    public VjoExternalSourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner, boolean readOnly, IStorage storage) {
        super(parent, name, owner, readOnly, storage);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        IJstType jstType = this.getJstType();
        if (jstType == null) {
            return super.buildStructure(info, pm, newElements, underlyingResource);
        }
        try {
            JSSourceModuleElementInfo moduleInfo = (JSSourceModuleElementInfo)info;
            this.build(newElements, moduleInfo);
            if (DLTKCore.DEBUG_PRINT_MODEL) {
                System.out.println("Source Module Debug print:");
                CorePrinter printer = new CorePrinter((OutputStream)System.out);
                this.printNode(printer);
                printer.flush();
            }
            return moduleInfo.isStructureKnown();
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    private void build(Map newElements, JSSourceModuleElementInfo moduleInfo) throws CoreException, ModelException {
        VjoSourceModuleStructureRequestor requestor = new VjoSourceModuleStructureRequestor(this, moduleInfo, newElements);
        if ("org.eclipse.vjet.core.nature" == null) {
            throw new ModelException((IModelStatus)new ModelStatus(983));
        }
        VjoSourceElementParser parser = (VjoSourceElementParser)this.getSourceElementParser("org.eclipse.vjet.core.nature");
        if (!this.isReadOnly()) {
            parser.setScriptProject(this.getScriptProject());
        }
        parser.setRequestor(requestor);
        AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
        parser.setReporter((IProblemReporter)problemReporter);
        SourceParserUtil.parseSourceModule((ISourceModule)this, (ISourceElementParser)parser);
        if (problemReporter != null) {
            if (!problemReporter.hasErrors()) {
                StructureBuilder.build((String)"org.eclipse.vjet.core.nature", (ISourceModule)this, (AccumulatingProblemReporter)problemReporter);
            }
            problemReporter.reportToRequestor();
        }
    }

    @Override
    public IJstType getJstType() {
        if (this.m_jstType == null) {
            this.initJstType();
        }
        return this.m_jstType;
    }

    private void initJstType() {
        String fullName = this.getFullName();
        IJstType type = this.getJstTypeFromTypeSpace(fullName);
        this.m_jstType = type != null ? type : null;
    }

    private IJstType getJstTypeFromTypeSpace(String fullName) {
        SourceTypeName name = new SourceTypeName(this.getProjectFragment().getPath().lastSegment(), fullName, new String(""));
        TypeSpaceMgr.getInstance();
        if (TypeSpaceMgr.existType((TypeName)name)) {
            return TypeSpaceMgr.getInstance().findType((TypeName)name);
        }
        return null;
    }

    private String getFullName() {
        String fileName = this.getElementName();
        String name = fileName.substring(0, fileName.indexOf("."));
        String parentName = this.getParent().getElementName();
        if (StringUtils.isBlankOrEmpty((String)parentName)) {
            return name;
        }
        return String.valueOf(parentName) + "." + name;
    }

    public void updateScriptUnit(JstBlock block, List<JstBlock> blockList, IJstType type, List<IScriptProblem> probs) {
        this.m_block = block;
        this.m_blockList = blockList;
        this.m_jstType = type;
        this.m_probs = probs;
    }

    public IJstNode getNode(int startOffset) {
        return JstUtil.getLeafNode((IJstType)this.m_jstType, (int)startOffset, (int)startOffset);
    }

    public JstBlock getSyntaxRoot() {
        return this.m_block;
    }

    public List<JstBlock> getJstBlockList() {
        return this.m_blockList;
    }

    public IJstType getType() {
        return this.m_jstType;
    }

    public List<IScriptProblem> getProblems() {
        return this.m_probs;
    }

    public IType getType(String typeName) {
        return new VjoSourceType((ModelElement)this, typeName);
    }

    @Override
    public TypeName getTypeName() {
        return CodeassistUtils.getNativeTypeName(this.getJstType());
    }
}

