/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.mod.compiler.ISourceElementRequestor;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuffer;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.IOpenable;
import org.eclipse.dltk.mod.core.IProblemRequestor;
import org.eclipse.dltk.mod.core.ISourceElementParser;
import org.eclipse.dltk.mod.core.ISourceElementParserExtension;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.SourceParserUtil;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AbstractSourceModule;
import org.eclipse.dltk.mod.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.mod.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ImportContainer;
import org.eclipse.dltk.mod.internal.core.JSSourceModuleElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.RenameElementsOperation;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.StructureBuilder;
import org.eclipse.dltk.mod.internal.core.VjetRenameResourceElementsOperation;
import org.eclipse.dltk.mod.internal.core.VjoSourceModuleStructureRequestor;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.eclipse.core.IImportContainer;
import org.eclipse.vjet.eclipse.core.IJSSourceModule;

public class JSSourceModule
extends SourceModule
implements IJSSourceModule {
    public JSSourceModule(ScriptFolder parent, String name, WorkingCopyOwner owner) {
        super(parent, name, owner);
    }

    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
        try {
            IBuffer buffer;
            IStatus status;
            if (!this.isWorkingCopy() && !(status = this.validateSourceModule(underlyingResource)).isOK()) {
                throw this.newModelException(status);
            }
            if (this.preventReopen()) {
                throw this.newNotPresentException();
            }
            JSSourceModuleElementInfo moduleInfo = (JSSourceModuleElementInfo)info;
            if (this.hasBuffer() && (buffer = this.getBufferManager().getBuffer((IOpenable)this)) == null) {
                this.openBuffer(pm, moduleInfo);
            }
            VjoSourceModuleStructureRequestor requestor = new VjoSourceModuleStructureRequestor(this, moduleInfo, newElements);
            String natureId = this.getNatureId();
            if (natureId == null) {
                throw new ModelException((IModelStatus)new ModelStatus(983));
            }
            ISourceElementParser parser = this.getSourceElementParser(natureId);
            if (!this.isReadOnly() && parser instanceof ISourceElementParserExtension) {
                ((ISourceElementParserExtension)parser).setScriptProject(this.getScriptProject());
            }
            parser.setRequestor((ISourceElementRequestor)requestor);
            AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
            parser.setReporter((IProblemReporter)problemReporter);
            SourceParserUtil.parseSourceModule((ISourceModule)this, (ISourceElementParser)parser);
            if (problemReporter != null) {
                if (!problemReporter.hasErrors()) {
                    StructureBuilder.build((String)natureId, (ISourceModule)this, (AccumulatingProblemReporter)problemReporter);
                }
                problemReporter.reportToRequestor();
            }
            if (DLTKCore.DEBUG_PRINT_MODEL) {
                System.out.println("Source Module Debug print:");
                CorePrinter printer = new CorePrinter((OutputStream)System.out);
                this.printNode(printer);
                printer.flush();
            }
            if (underlyingResource == null) {
                underlyingResource = this.getResource();
            }
            if (underlyingResource != null) {
                moduleInfo.setTimestamp(((IFile)underlyingResource).getModificationStamp());
            }
            return moduleInfo.isStructureKnown();
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected Object createElementInfo() {
        return new JSSourceModuleElementInfo();
    }

    @Override
    public IImportContainer getImportContainer() {
        return new ImportContainer((AbstractSourceModule)this);
    }

    protected ISourceModule getOriginalSourceModule() {
        return new JSSourceModule((ScriptFolder)this.getParent(), this.getElementName(), (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    public ISourceModule getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws ModelException {
        JSSourceModule workingCopy;
        if (!this.isPrimary()) {
            return this;
        }
        ModelManager manager = ModelManager.getModelManager();
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo((SourceModule)(workingCopy = new JSSourceModule((ScriptFolder)this.getParent(), this.getElementName(), workingCopyOwner)), false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation((SourceModule)workingCopy, problemRequestor);
        op.runOperation(monitor);
        return workingCopy;
    }

    public IType getType(String typeName) {
        return new JSSourceType((ModelElement)this, typeName);
    }

    public void rename(String newName, boolean replace, IProgressMonitor monitor) throws ModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.operation_nullName);
        }
        IModelElement[] elements = new IModelElement[]{this};
        IModelElement[] dests = new IModelElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        Object op = elements != null && elements.length > 0 && elements[0] != null && elements[0].getElementType() < 7 ? new VjetRenameResourceElementsOperation(elements, dests, renamings, replace) : new RenameElementsOperation(elements, dests, renamings, replace);
        op.runOperation(monitor);
    }
}

