/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IObjectLiteralField;
import org.eclipse.mod.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.VjoOLFieldTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstFieldOrMethodCompletion;

public class VjoOLTranslator
extends BaseAst2JstTranslator<ObjectLiteral, IJstNode> {
    private static List<Character> CONTROL_SYMBOLS = new ArrayList<Character>();

    static {
        CONTROL_SYMBOLS.add(Character.valueOf(','));
        CONTROL_SYMBOLS.add(Character.valueOf(':'));
        CONTROL_SYMBOLS.add(Character.valueOf(';'));
    }

    public VjoOLTranslator() {
    }

    public VjoOLTranslator(TranslateCtx ctx) {
        super.setTranslateCtx(ctx);
    }

    @Override
    protected IJstNode doTranslate(ObjectLiteral astObjectLiteral) {
        ObjLiteral result = null;
        if (this.m_ctx.isSkipJsExtSyntaxArgs()) {
            result = new ObjLiteral();
            result.setSource(TranslateHelper.getSource((IASTNode)astObjectLiteral, (IFindTypeSupport.ILineInfoProvider)this.m_ctx.getSourceUtil()));
            return result;
        }
        if (astObjectLiteral.fields != null) {
            result = this.processPropsAndMethods(astObjectLiteral);
        } else {
            result = new ObjLiteral();
            result.setSource(TranslateHelper.getSource((IASTNode)astObjectLiteral, (IFindTypeSupport.ILineInfoProvider)this.m_ctx.getSourceUtil()));
        }
        ScopeId scopeId = this.m_ctx.getCurrentScope();
        if (scopeId == ScopeIds.PROPS || scopeId == ScopeIds.PROTOS || scopeId == ScopeIds.VALUES || scopeId == ScopeIds.DEFS) {
            return null;
        }
        return result;
    }

    private ObjLiteral processPropsAndMethods(ObjectLiteral astObjectLiteral) {
        ArrayList<ObjectLiteralField> astFields = new ArrayList<ObjectLiteralField>(astObjectLiteral.fields.length);
        ObjLiteral result = new ObjLiteral();
        TranslateHelper.addSourceInfo((IASTNode)astObjectLiteral, (BaseJstNode)result, this.m_ctx.getSourceUtil());
        int i = 0;
        while (i < astObjectLiteral.fields.length) {
            astFields.add(astObjectLiteral.fields[i]);
            ++i;
        }
        int len = astFields.size();
        int i2 = 0;
        while (i2 < len) {
            int nextNodeStart = i2 + 1 < astFields.size() ? ((ObjectLiteralField)astFields.get(i2 + 1)).sourceStart() : astObjectLiteral.sourceEnd();
            this.m_ctx.setNextNodeSourceStart(nextNodeStart);
            if (i2 == 0) {
                this.m_ctx.setPreviousNodeSourceEnd(astObjectLiteral.sourceStart());
            } else {
                this.m_ctx.setPreviousNodeSourceEnd(((ObjectLiteralField)astFields.get(i2 - 1)).sourceEnd());
            }
            ObjectLiteralField astObjectLiteralField = (ObjectLiteralField)astFields.get(i2);
            VjoOLFieldTranslator translator = new VjoOLFieldTranslator(this.m_ctx);
            translator.setParent(this.m_parent);
            IJstNode jstNode = (IJstNode)translator.translate(astObjectLiteralField);
            int sourceEnd = jstNode != null && jstNode.getSource() != null ? jstNode.getSource().getEndOffSet() : astObjectLiteralField.sourceEnd;
            this.m_ctx.setPreviousNodeSourceEnd(sourceEnd);
            if (jstNode instanceof NV) {
                result.add((NV)jstNode);
            }
            List<IASTNode> recoveredNodes = translator.getRecoveredNodes();
            int added = 0;
            for (IASTNode node : recoveredNodes) {
                if (!(node instanceof ObjectLiteralField)) continue;
                astFields.add(i2 + 1 + added, (ObjectLiteralField)node);
                ++added;
            }
            ++i2;
        }
        if (len > 0) {
            this.m_ctx.setPreviousNodeSourceEnd(astObjectLiteral.sourceEnd);
        }
        return result;
    }

    @Override
    protected JstCompletion createCompletion(ObjectLiteral astNode, boolean isAfterSource) {
        ScopeId scopeId = this.m_ctx.getCurrentScope();
        if (scopeId == ScopeIds.OPTIONS) {
            return null;
        }
        JstFieldOrMethodCompletion completion = null;
        CategorizedProblem problem = this.findProblem();
        if (problem != null) {
            int problemStart = problem.getSourceStart();
            char[] source = this.m_ctx.getOriginalSource();
            String prefix = new String(source, problemStart, this.m_ctx.getCompletionPos() - problemStart);
            String wholeError = new String(source, problemStart, problem.getSourceEnd() + 1 - problemStart);
            prefix.length();
            if (prefix.length() > 0 && this.isJavaIdentifier(prefix)) {
                completion = new JstFieldOrMethodCompletion((BaseJstNode)this.m_ctx.getCurrentType(), this.isStaticBlock());
                completion.setSource(VjoOLTranslator.createSource(problemStart, problem.getSourceEnd() + 1, this.m_ctx.getSourceUtil()));
                completion.setToken(prefix);
                completion.setCompositeToken(wholeError);
                this.m_ctx.setCreatedCompletion(true);
            }
        }
        if (!isAfterSource && completion == null) {
            if (this.inFieldArea(astNode)) {
                return null;
            }
            int lastFieldPos = this.getLastFieldPos(astNode);
            String token = this.getToken(lastFieldPos);
            if (this.isInvalidValidToken(token)) {
                return null;
            }
            completion = new JstFieldOrMethodCompletion((BaseJstNode)this.m_ctx.getCurrentType(), this.isStaticBlock());
            if (token.trim().length() == 0) {
                completion.setCompositeToken(token.trim());
            } else {
                completion.setCompositeToken(token);
            }
            completion.setToken(token.trim());
            int startSource = this.m_ctx.getCompletionPos() - token.length();
            int endSource = startSource + token.length();
            completion.setSource(VjoOLTranslator.createSource(startSource, endSource, this.m_ctx.getSourceUtil()));
            this.m_ctx.setCreatedCompletion(true);
        }
        return completion;
    }

    private boolean isInvalidValidToken(String token) {
        return token == null || token.indexOf("(") >= 0 || token.indexOf("<") >= 0 || token.indexOf(">") >= 0;
    }

    private boolean inFieldArea(ObjectLiteral astNode) {
        int cursorPos = this.m_ctx.getCompletionPos() - 1;
        if (astNode.getFields() == null) {
            return false;
        }
        IObjectLiteralField[] iObjectLiteralFieldArray = astNode.getFields();
        int n = iObjectLiteralFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObjectLiteralField field = iObjectLiteralFieldArray[n2];
            if (field.sourceStart() < cursorPos && field.sourceEnd() >= cursorPos) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isStaticBlock() {
        return ScopeIds.PROPS == this.m_ctx.getCurrentScope();
    }

    private String getToken(int lastFieldPos) {
        int index = this.m_ctx.getCompletionPos() - 1;
        StringBuffer buffer = new StringBuffer();
        boolean started = false;
        int i = index;
        while (i >= 0) {
            char c = this.m_ctx.getOriginalSource()[i];
            if (c == '{' || c == '}' || c == '\r' || c == '\n') break;
            if (i <= lastFieldPos) {
                return null;
            }
            if (CONTROL_SYMBOLS.contains(Character.valueOf(c))) {
                if (started) {
                    break;
                }
            } else {
                started = true;
            }
            if (started) {
                buffer.insert(0, c);
            }
            --i;
        }
        return buffer.toString();
    }

    private int getLastFieldPos(ObjectLiteral astNode) {
        int cursorPos = this.m_ctx.getCompletionPos() - 1;
        int lastPos = 0;
        if (astNode.getFields() == null) {
            return lastPos;
        }
        IObjectLiteralField[] iObjectLiteralFieldArray = astNode.getFields();
        int n = iObjectLiteralFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObjectLiteralField field = iObjectLiteralFieldArray[n2];
            int temp = field.sourceEnd();
            if (temp < cursorPos && temp > lastPos) {
                lastPos = temp;
            }
            ++n2;
        }
        return lastPos;
    }

    private CategorizedProblem findProblem() {
        CategorizedProblem problemAtCursor = null;
        CategorizedProblem[] problems = this.m_ctx.getAST().compilationResult().getAllProblems();
        if (problems != null) {
            int completionPos = this.m_ctx.getCompletionPos();
            CategorizedProblem[] categorizedProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                CategorizedProblem problem = categorizedProblemArray[n2];
                if (problem.getSourceStart() <= completionPos && completionPos <= problem.getSourceEnd() + 1) {
                    problemAtCursor = problem;
                    break;
                }
                ++n2;
            }
        }
        return problemAtCursor;
    }
}

