/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstCommentLocation;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.JsDocHelper;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstFieldOrMethodCompletion;

public class ObjectLiteralFieldTranslator
extends BaseAst2JstTranslator<ObjectLiteralField, Object> {
    private NV m_result;

    @Override
    protected Object doTranslate(ObjectLiteralField astObjectliteralField) {
        int completionPos = this.m_ctx.getCompletionPos();
        try {
            NV nv = new NV();
            if (astObjectliteralField.initializer instanceof ObjectLiteral) {
                this.m_ctx.enterBlock(ScopeIds.PROPERTY);
            }
            IExpr value = (IExpr)this.getTranslatorAndTranslate((IASTNode)astObjectliteralField.initializer);
            JstIdentifier id = this.createId(astObjectliteralField);
            this.bindObjLiteralId(astObjectliteralField, id, value, nv);
            nv.setName(id);
            nv.addChild((IJstNode)id);
            nv.setValue(value);
            nv.addChild((IJstNode)value);
            JstCommentLocation comment = this.m_ctx.getCommentCollector().getCommentLocationNonMeta2(astObjectliteralField.sourceStart);
            if (comment != null) {
                nv.addCommentLocation(comment);
            }
            int start = id.getSource().getStartOffSet();
            if (value != null && value.getSource() != null) {
                int end = value.getSource().getEndOffSet();
                int length = end - start;
                nv.setSource(TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), length, start, end));
            }
            if (astObjectliteralField.initializer instanceof ObjectLiteral) {
                this.m_ctx.exitBlock();
            }
            this.m_result = nv;
            NV nV = nv;
            return nV;
        }
        finally {
            this.m_ctx.setCompletionPos(completionPos);
        }
    }

    private void bindObjLiteralId(ObjectLiteralField astObjectliteralField, JstIdentifier id, IExpr value, NV nv) {
        IJsCommentMeta meta;
        List<IJsCommentMeta> metaArr;
        if (value instanceof FuncExpr) {
            TranslateHelper.RenameableSynthJstProxyMethod mtdBinding = new TranslateHelper.RenameableSynthJstProxyMethod((IJstMethod)((FuncExpr)value).getFunc(), id.getName());
            id.setJstBinding((IJstNode)mtdBinding);
            id.setType((IJstType)new JstFuncType((IJstMethod)mtdBinding));
        }
        if ((metaArr = this.getCommentMeta(astObjectliteralField)) != null && metaArr.size() > 0 && (meta = metaArr.get(0)).getTyping() != null) {
            nv.setOptional(meta.getTyping().isOptional());
            IJstType metaDefinedType = TranslateHelper.findType(this.m_ctx, meta.getTyping(), meta);
            if (metaDefinedType != null) {
                id.setType(metaDefinedType);
                if (metaDefinedType instanceof JstFuncType) {
                    IJstMethod replacement = TranslateHelper.MethodTranslateHelper.createJstSynthesizedMethod(metaArr, (IFindTypeSupport)this.m_ctx, id.getName());
                    String commentStr = this.m_ctx.getCommentCollector().getCommentNonMeta2(astObjectliteralField.sourceStart);
                    JsDocHelper.addJsDoc(commentStr, (JstMethod)((JstFuncType)metaDefinedType).getFunction());
                    if (replacement != null) {
                        JsDocHelper.addJsDoc(commentStr, (JstMethod)replacement);
                        TranslateHelper.replaceSynthesizedMethodBinding(id, replacement);
                    }
                }
            }
        }
    }

    private List<IJsCommentMeta> getCommentMeta(ObjectLiteralField ast) {
        return this.m_ctx.getCommentCollector().getCommentMeta(ast.sourceStart, this.m_ctx.getPreviousNodeSourceEnd(), this.m_ctx.getNextNodeSourceStart());
    }

    private JstIdentifier createId(ObjectLiteralField astObjectliteralField) {
        JstIdentifier id = new JstIdentifier(astObjectliteralField.getFieldName().toString());
        int startOffset = astObjectliteralField.fieldName.sourceStart;
        int endOffset = astObjectliteralField.fieldName.sourceEnd;
        int length = endOffset - startOffset + 1;
        id.setSource(TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), length, startOffset, endOffset));
        return id;
    }

    @Override
    protected void checkForCompletion(ObjectLiteralField astNode) {
        JstCompletion completion;
        SingleNameReference missing;
        boolean isAfterSource;
        if (this.m_ctx.isCreatedCompletion()) {
            return;
        }
        int startPos = astNode.sourceStart();
        int endPos = this.getSourceEnd(astNode);
        int completionPos = this.m_ctx.getCompletionPos();
        boolean insideSource = completionPos >= startPos && completionPos <= endPos;
        boolean bl = isAfterSource = completionPos == endPos + 1;
        if (!isAfterSource && astNode.getInitializer() instanceof SingleNameReference && "$missing$".equals(String.valueOf((missing = (SingleNameReference)astNode.getInitializer()).getToken()))) {
            isAfterSource = true;
        }
        if ((insideSource || isAfterSource) && (completion = this.createCompletion(astNode, isAfterSource)) != null) {
            JstCommentUtil.fillCompletion((ASTNode)astNode, this.m_ctx, completion);
            this.m_ctx.addSyntaxError(completion);
        }
    }

    @Override
    protected JstCompletion createCompletion(ObjectLiteralField astObjectLiteralField, boolean isAfterSource) {
        int completionPos = this.m_ctx.getCompletionPos();
        if (completionPos < astObjectLiteralField.sourceStart) {
            return null;
        }
        String preStr = new String(this.m_ctx.getOriginalSource(), astObjectLiteralField.sourceStart, completionPos - astObjectLiteralField.sourceStart);
        if (preStr == null) {
            return null;
        }
        String[] strs = (" " + preStr + " ").split(":");
        if (strs.length == 0) {
            return null;
        }
        if (strs.length == 1) {
            String token = strs[0].trim();
            JstFieldOrMethodCompletion completion = new JstFieldOrMethodCompletion((BaseJstNode)this.m_result, this.m_ctx.getCurrentScope() == ScopeIds.PROPS);
            IExpression expr = astObjectLiteralField.getFieldName();
            JstSource jstSource = null;
            if (expr != null) {
                jstSource = expr.sourceEnd() + 1 > completionPos ? ObjectLiteralFieldTranslator.createSource(expr.sourceStart(), expr.sourceEnd() + 1, this.m_ctx.getSourceUtil()) : ObjectLiteralFieldTranslator.createSource(expr.sourceStart(), completionPos, this.m_ctx.getSourceUtil());
            }
            completion.setSource(jstSource);
            completion.setCompositeToken(preStr);
            completion.setToken(token);
            this.m_ctx.setCreatedCompletion(true);
            completion.setScopeStack(this.m_ctx.getScopeStack());
            return completion;
        }
        if (strs.length == 2) {
            String token = strs[1].trim();
            if (token.indexOf("(") >= 0 || !this.isJavaIdentifier(token)) {
                return null;
            }
            JstFieldOrMethodCompletion completion = new JstFieldOrMethodCompletion((BaseJstNode)this.m_result, ScopeIds.PROPS == this.m_ctx.getCurrentScope());
            completion.setCompositeToken(preStr);
            completion.setToken(token);
            this.m_ctx.setCreatedCompletion(true);
            completion.setScopeStack(this.m_ctx.getScopeStack());
            return completion;
        }
        return null;
    }
}

