/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstProxyIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.VjoOLTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstComletionOnMessageSend;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnQualifiedNameReference;

public class MessageSendTranslator
extends BaseAst2JstTranslator<MessageSend, MtdInvocationExpr> {
    private static final String EMPTY = "";
    private MtdInvocationExpr jstInvocation;

    @Override
    protected MtdInvocationExpr doTranslate(MessageSend astMsgSend) {
        int sourceEnd;
        String methodNameStr = null;
        if (astMsgSend.getSelector() == null) {
            IExpression astReceiver = astMsgSend.getReceiver();
            BaseAst2JstTranslator translator = this.getTranslator((IASTNode)astReceiver);
            IExpr mtdIdentifier = (IExpr)translator.translate(astReceiver);
            this.jstInvocation = mtdIdentifier instanceof JstIdentifier ? new MtdInvocationExpr(mtdIdentifier, new IExpr[0]) : new MtdInvocationExpr((JstIdentifier)new JstProxyIdentifier(mtdIdentifier), new IExpr[0]);
        } else {
            methodNameStr = new String(astMsgSend.getSelector());
            this.jstInvocation = new MtdInvocationExpr(methodNameStr, new IExpr[0]);
        }
        try {
            this.m_ctx.enterBlock(ScopeIds.METHOD_CALL);
            IExpression[] args = astMsgSend.getArguments();
            if (args != null) {
                int prev = 0;
                int next = 0;
                int len = args.length;
                int i = 0;
                while (i < len) {
                    IExpression rec;
                    prev = i == 0 ? ((rec = astMsgSend.getReceiver()) != null ? rec.sourceStart() : astMsgSend.sourceStart()) : args[i - 1].sourceEnd();
                    next = i + 1 < len ? args[i + 1].sourceStart() : astMsgSend.statementEnd;
                    IExpression argExpression = args[i];
                    BaseAst2JstTranslator translator = argExpression instanceof ObjectLiteral && this.isVjoOL(methodNameStr) ? new VjoOLTranslator(this.m_ctx) : this.getTranslator((IASTNode)argExpression);
                    Object stmt = translator.translate(argExpression);
                    if (stmt instanceof IExpr) {
                        List<IJsCommentMeta> metaList = null;
                        IExpr jstArg = null;
                        if (stmt instanceof BaseJstNode) {
                            metaList = TranslateHelper.findMetaFromExpr((BaseJstNode)stmt);
                        }
                        if (metaList != null) {
                            jstArg = TranslateHelper.getCastable((IExpr)stmt, metaList, this.m_ctx);
                            metaList = null;
                        } else {
                            jstArg = TranslateHelper.getCastable((IExpr)stmt, (IStatement)argExpression, prev, next, this.m_ctx);
                        }
                        this.jstInvocation.addArg(jstArg);
                    } else if (stmt instanceof JstMethod) {
                        FuncExpr jstArg = new FuncExpr((JstMethod)stmt);
                        jstArg = TranslateHelper.getCastable((IExpr)jstArg, (IStatement)argExpression, prev, next, this.m_ctx);
                        this.jstInvocation.addArg((IExpr)jstArg);
                    } else if (this.m_ctx.getCurrentType() != null && this.m_ctx.getCurrentType().getName() != null) {
                        String name = this.m_ctx.getCurrentType().getName();
                        this.m_ctx.getErrorReporter().error("Cannot cast jstArg from " + argExpression.getClass() + " to " + IExpr.class + " in " + MessageSendTranslator.class, name, 0, 0);
                    }
                    ++i;
                }
            }
        }
        finally {
            this.m_ctx.exitBlock();
        }
        int sourceStart = astMsgSend.sourceStart;
        IExpression astReceiver = astMsgSend.getReceiver();
        if (astReceiver != null) {
            sourceStart = this.calculateSourceStart((IExpression)astMsgSend, astReceiver, astMsgSend.getSelector());
        }
        if (methodNameStr != null) {
            if (astReceiver != null) {
                BaseAst2JstTranslator translator = this.getTranslator((IASTNode)astReceiver);
                IExpr jstQualifier = (IExpr)translator.translate(astReceiver);
                this.jstInvocation.setQualifyExpr(jstQualifier);
            }
            JstSource nameSource = TranslateHelper.getMethodSource(this.m_ctx.getOriginalSource(), this.m_ctx.getSourceUtil(), sourceStart, astMsgSend.sourceEnd, methodNameStr.length());
            ((JstIdentifier)this.jstInvocation.getMethodIdentifier()).setSource(nameSource);
        }
        if ((sourceEnd = astMsgSend.statementEnd) == -1) {
            sourceEnd = astMsgSend.sourceEnd;
        }
        JstSource methodSource = TranslateHelper.getMethodSource(this.m_ctx.getOriginalSource(), this.m_ctx.getSourceUtil(), astMsgSend.sourceStart, sourceEnd, sourceEnd - astMsgSend.sourceStart);
        this.jstInvocation.setSource(methodSource);
        return this.jstInvocation;
    }

    private boolean isVjoOL(String methodNameStr) {
        return "protos".equals(methodNameStr) || "props".equals(methodNameStr) || "defs".equals(methodNameStr);
    }

    private int calculateSourceStart(IExpression astIExpression, IExpression astReceiver, char[] cs) {
        String s;
        int index;
        int messageEnd = astIExpression.sourceEnd();
        int receiverEnd = astReceiver.sourceEnd();
        if (cs == null) {
            return receiverEnd + 1;
        }
        if (messageEnd > receiverEnd && messageEnd < this.m_ctx.getOriginalSource().length && (index = (s = new String(this.m_ctx.getOriginalSource(), receiverEnd, messageEnd - receiverEnd)).indexOf(new String(cs))) >= 0) {
            return receiverEnd + index;
        }
        return receiverEnd + 1;
    }

    @Override
    protected JstCompletion createCompletion(MessageSend node, boolean isAfter) {
        int indexCloseBracket;
        int tempBegin = node.sourceStart();
        if (node.getReceiver() != null) {
            tempBegin = node.getReceiver().sourceEnd() + 1;
        }
        String literal = new String(this.m_ctx.getOriginalSource(), tempBegin, node.sourceEnd() - tempBegin + 1);
        JstCompletion completion = null;
        int indexOpenBracket = tempBegin + literal.indexOf("(");
        completion = this.createCompletion(node, indexOpenBracket, indexCloseBracket = tempBegin + literal.lastIndexOf(")"));
        if (completion != null) {
            this.m_ctx.setCreatedCompletion(true);
        }
        return completion;
    }

    private JstCompletion createCompletion(MessageSend node, int indexOpen, int indexClose) {
        JstCompletion completion = null;
        IExpr mtdIdentifier = this.jstInvocation.getMethodIdentifier();
        if (!(mtdIdentifier instanceof JstIdentifier)) {
            return completion;
        }
        JstIdentifier mtdNameIdentifier = (JstIdentifier)mtdIdentifier;
        JstSource nameSource = mtdNameIdentifier.getSource();
        if (this.isInBracket(indexOpen, indexClose, node) && node.selector != null) {
            String token = this.getTokenInArgurent(node);
            if (this.isJavaIdentifier(token) || this.isJavaPackageIdentifier(token)) {
                completion = new JstComletionOnMessageSend((BaseJstNode)this.jstInvocation);
                completion.setToken(token);
                completion.setCompositeToken(this.getCompositeTokenInArgument(node));
            }
        } else if (this.isInName(nameSource)) {
            completion = new JstCompletionOnQualifiedNameReference((BaseJstNode)this.jstInvocation);
            String token = this.getNameToken(mtdNameIdentifier);
            completion.setToken(token);
            completion.setCompositeToken(mtdNameIdentifier.getName());
            completion.setSource(this.createSource(token));
        } else if (this.afterRecevier(node)) {
            completion = new JstCompletionOnQualifiedNameReference((BaseJstNode)this.jstInvocation);
            String token = this.getTokenByPos(node);
            String compoiteToken = this.getCompositeTokenByPos(node, token);
            completion.setToken(token);
            completion.setCompositeToken(compoiteToken);
            completion.setSource(this.createSource(token));
        }
        return completion;
    }

    private String getCompositeTokenInArgument(MessageSend node) {
        IExpression[] exprs = node.getArguments();
        int pos = this.m_ctx.getCompletionPos();
        if (exprs == null || exprs.length == 0) {
            return EMPTY;
        }
        IExpression[] iExpressionArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression expr = iExpressionArray[n2];
            if (expr.sourceStart() < pos && expr.sourceEnd() >= pos) {
                String s = new String(this.m_ctx.getOriginalSource(), expr.sourceStart() + 1, expr.sourceEnd() - expr.sourceStart() - 1);
                s = (String.valueOf(s) + "a").trim();
                s = s.substring(0, s.length() - 1);
                return s;
            }
            ++n2;
        }
        return EMPTY;
    }

    private String getTokenInArgurent(MessageSend node) {
        IExpression[] exprs = node.getArguments();
        int pos = this.m_ctx.getCompletionPos();
        if (exprs == null || exprs.length == 0) {
            return EMPTY;
        }
        IExpression[] iExpressionArray = exprs;
        int n = exprs.length;
        int n2 = 0;
        while (n2 < n) {
            IExpression expr = iExpressionArray[n2];
            if (expr.sourceStart() < pos && expr.sourceEnd() >= pos) {
                String s = new String(this.m_ctx.getOriginalSource(), expr.sourceStart() + 1, pos - expr.sourceStart() - 1);
                s = (String.valueOf(s) + "a").trim();
                s = s.substring(0, s.length() - 1);
                return s;
            }
            ++n2;
        }
        return EMPTY;
    }

    private String getCompositeTokenByPos(MessageSend node, String preToken) {
        int pos = this.m_ctx.getCompletionPos();
        StringBuffer buff = new StringBuffer();
        buff.append(preToken);
        char[] chars = this.m_ctx.getOriginalSource();
        ++pos;
        while (pos < chars.length && Character.isJavaIdentifierPart(chars[pos])) {
            buff.append(chars[pos]);
            ++pos;
        }
        return buff.toString();
    }

    private String getTokenByPos(MessageSend node) {
        int pos = this.m_ctx.getCompletionPos();
        int recEnd = node.getReceiver().sourceEnd() + 1;
        if (recEnd < pos) {
            String s = new String(this.m_ctx.getOriginalSource(), recEnd, pos - recEnd).trim();
            if (s.startsWith(".")) {
                s = s.substring(1, s.length());
            }
            return s;
        }
        return EMPTY;
    }

    private boolean afterRecevier(MessageSend node) {
        int pos = this.m_ctx.getCompletionPos();
        if (node.getReceiver() == null) {
            return false;
        }
        int recEnd = node.getReceiver().sourceEnd() + 1;
        if (recEnd < pos) {
            String s = new String(this.m_ctx.getOriginalSource(), recEnd, pos - recEnd).trim();
            if (s.startsWith(".")) {
                s = s.substring(1, s.length());
            }
            if (s.equals(EMPTY)) {
                return true;
            }
            if (Character.isWhitespace(s.charAt(s.length() - 1))) {
                return false;
            }
            int i = 0;
            while (i < s.length()) {
                if (!Character.isJavaIdentifierPart(s.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private JstSource createSource(String token) {
        return MessageSendTranslator.createSource(this.m_ctx.getCompletionPos() - token.length(), this.m_ctx.getCompletionPos(), this.m_ctx.getSourceUtil());
    }

    private boolean isInName(JstSource nameSource) {
        int pos = this.m_ctx.getCompletionPos();
        return nameSource.getStartOffSet() <= pos && nameSource.getEndOffSet() + 1 >= pos;
    }

    private String getNameToken(JstIdentifier mtdNameIdentifier) {
        String name = mtdNameIdentifier.getName();
        JstSource nameSource = mtdNameIdentifier.getSource();
        return name.substring(0, this.m_ctx.getCompletionPos() - nameSource.getStartOffSet());
    }

    private boolean isInBracket(int indexOpen, int indexClose, MessageSend astNode) {
        int pos = this.m_ctx.getCompletionPos();
        boolean isInBracket = false;
        if (indexOpen != -1) {
            boolean bl = isInBracket = pos > indexOpen && pos <= indexClose;
        }
        if (indexOpen != -1 && indexClose != -1 && astNode.statementEnd != -1) {
            isInBracket = pos > indexOpen && pos <= astNode.statementEnd;
        }
        return isInBracket;
    }
}

