/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.JstSourceUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.TranslatorFactory;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;

public abstract class BaseAst2JstTranslator<T extends IASTNode, E> {
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String DOUBLE_SLASH = "//";
    protected TranslateCtx m_ctx;
    protected BaseJstNode m_parent;
    protected List<IASTNode> m_recoveredNodes = new ArrayList<IASTNode>();
    protected static final String CLOSE_BRACKET = ")";
    protected static final String OPEN_BRACKET = "(";

    public final E translate(T astNode) {
        if (this.m_ctx == null) {
            throw new NullPointerException("Translate context is null!");
        }
        E jstResult = this.doTranslate(astNode);
        this.checkForCompletion(astNode);
        this.checkForCommentCompletion(astNode);
        return jstResult;
    }

    protected abstract E doTranslate(T var1);

    protected void checkForCompletion(T astNode) {
        JstCompletion completion;
        boolean isAfterSource;
        if (this.m_ctx.isCreatedCompletion()) {
            return;
        }
        int startPos = astNode.sourceStart();
        int completionPos = this.m_ctx.getCompletionPos();
        boolean insideSource = completionPos >= startPos && completionPos <= this.getSourceEnd(astNode);
        boolean bl = isAfterSource = completionPos == this.getSourceEnd(astNode) + 1;
        if ((insideSource || isAfterSource || this.closeToSource(astNode, completionPos)) && (completion = this.createCompletion(astNode, isAfterSource)) != null) {
            JstCommentUtil.fillCompletion((ASTNode)astNode, this.m_ctx, completion);
            this.m_ctx.addSyntaxError(completion);
        }
    }

    protected void checkForCommentCompletion(T astNode) {
        if (this.m_ctx.isCreatedCompletion()) {
            return;
        }
        int completionPos = this.m_ctx.getCompletionPos();
        if (completionPos == -1) {
            return;
        }
        if (astNode instanceof Argument || astNode instanceof SingleNameReference || astNode instanceof AllocationExpression || astNode instanceof Literal) {
            return;
        }
        List<IJsCommentMeta> metas = JstCommentUtil.getCommentMeta((ASTNode)astNode, this.m_ctx);
        for (IJsCommentMeta meta : metas) {
            if (!JstCommentUtil.isWithInComment(meta.getBeginOffset(), meta.getEndOffset(), completionPos)) continue;
            JstCommentUtil.createComentCompletion((ASTNode)astNode, meta, this.m_ctx);
        }
        List<String> comments = JstCommentUtil.getNonMetaComments((ASTNode)astNode, this.m_ctx);
        for (String comment : comments) {
            int beginOffset;
            if (!this.isCommentMeta(comment) || (beginOffset = this.m_ctx.getCommentCollector().getCommentNonMetaBeginOffset(comment)) == -1 || !JstCommentUtil.isWithInComment(beginOffset, beginOffset + comment.length(), completionPos)) continue;
            JstCommentUtil.createComentCompletion((ASTNode)astNode, comment, beginOffset, beginOffset + comment.length(), this.m_ctx);
        }
    }

    private boolean isCommentMeta(String comment) {
        return comment.contains(DOUBLE_SLASH) && (comment.contains(GT) || comment.contains(LT));
    }

    private boolean closeToSource(T astNode, int completionPos) {
        if (completionPos == -1) {
            return false;
        }
        if (!astNode.getClass().equals(SingleNameReference.class)) {
            return false;
        }
        if (astNode.sourceEnd() != astNode.sourceStart()) {
            return false;
        }
        int delta = astNode.sourceStart() - completionPos;
        if (delta > 0) {
            String s = new String(this.m_ctx.getOriginalSource(), completionPos, delta);
            return s.trim().length() == 0;
        }
        return false;
    }

    protected int getSourceEnd(T astNode) {
        return astNode.sourceEnd();
    }

    protected JstCompletion createCompletion(T astNode, boolean isAfterSource) {
        return null;
    }

    public static JstSource createSource(int start, int end, JstSourceUtil util) {
        return TranslateHelper.createJstSource(util, end - start, start, end);
    }

    protected void setTranslateCtx(TranslateCtx ctx) {
        this.m_ctx = ctx;
    }

    protected BaseAst2JstTranslator getTranslator(IASTNode astNode) {
        return TranslatorFactory.getTranslator(astNode, this.m_ctx);
    }

    public void setParent(BaseJstNode parent) {
        this.m_parent = parent;
    }

    protected Object getTranslatorAndTranslate(IASTNode astNode) {
        BaseAst2JstTranslator translator = this.getTranslator(astNode);
        Object object = null;
        if (translator != null) {
            translator.setParent(this.m_parent);
            object = translator.translate(astNode);
        } else {
            System.err.println("Not found translator for node :" + astNode);
        }
        return object;
    }

    private boolean isVjoContext() {
        ScopeId scopeId = this.m_ctx.getCurrentScope();
        return scopeId == ScopeIds.PROPS || scopeId == ScopeIds.PROTOS || scopeId == ScopeIds.VALUES || scopeId == ScopeIds.DEFS || this.m_ctx.getCurrentType() instanceof JstObjectLiteralType;
    }

    protected Object getTranslatorAndTranslate(IASTNode astNode, BaseJstNode parent) {
        BaseAst2JstTranslator translator = this.getTranslator(astNode);
        translator.setParent(parent);
        return translator.translate(astNode);
    }

    protected BaseAst2JstTranslator getProblemTranslator(IASTNode astNode, int problemStart) {
        return TranslatorFactory.getProblemTranslator(astNode, this.m_ctx, problemStart);
    }

    protected Object getProblemTranslatorAndTranslate(IASTNode astNode, int problemStart) {
        BaseAst2JstTranslator translator = this.getProblemTranslator(astNode, problemStart);
        return translator.translate(astNode);
    }

    protected List<IASTNode> getRecoveredNodes() {
        ArrayList<IASTNode> copy = new ArrayList<IASTNode>(this.m_recoveredNodes);
        this.m_recoveredNodes.clear();
        return copy;
    }

    protected void setCompletionParams(JstCompletion completion, T astNode) {
        int sourceStart = astNode.sourceStart();
        int sourceEnd = this.getSourceEnd(astNode);
        completion.setSource(BaseAst2JstTranslator.createSource(sourceStart, sourceEnd + 1, this.m_ctx.getSourceUtil()));
        String prefix = new String(this.m_ctx.getOriginalSource(), sourceStart, this.m_ctx.getCompletionPos() - sourceStart);
        String wholeWord = new String(this.m_ctx.getOriginalSource(), sourceStart, sourceEnd + 1 - sourceStart);
        completion.setCompositeToken(wholeWord);
        completion.setToken(prefix);
    }

    protected boolean isJavaIdentifier(String token) {
        char[] chs;
        char[] cArray = chs = token.toCharArray();
        int n = chs.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!Character.isJavaIdentifierPart(ch)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected boolean isJavaPackageIdentifier(String token) {
        String[] ss;
        if (this.isJavaIdentifier(token)) {
            return true;
        }
        String[] stringArray = ss = token.split("\\.");
        int n = ss.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!this.isJavaIdentifier(s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

