/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.controller;

import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.jstvalidator.DefaultJstProblem;
import org.eclipse.vjet.dsf.jst.IJstGlobalFunc;
import org.eclipse.vjet.dsf.jst.IJstGlobalProp;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefResolver;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.ProblemSeverity;
import org.eclipse.vjet.dsf.jst.ResolutionResult;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalProp;
import org.eclipse.vjet.dsf.jst.declaration.JstSynthesizedProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.controller.GroupInfo;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinker;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinkerHelper;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinkerTraversal;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.jstojava.report.DefaultErrorReporter;
import org.eclipse.vjet.dsf.jstojava.report.ErrorReporter;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.ts.ITypeSpace;

public class JstExpressionBindingResolver
implements IJstRefResolver {
    private static final boolean DEBUG = false;
    private final JstParseController m_controller;
    private final JstExpressionTypeLinker m_typeLinkerVisitor;
    private ErrorReporter m_errorReporter = new DefaultErrorReporter();

    public JstExpressionBindingResolver(JstParseController controller) {
        this.m_controller = controller;
        this.m_typeLinkerVisitor = new JstExpressionTypeLinker(this);
    }

    public synchronized ResolutionResult resolve(IJstType type) {
        ResolutionResult rr = new ResolutionResult();
        this.resolveTypeInternal(type, rr);
        return rr;
    }

    private void resolveTypeInternal(IJstType type, ResolutionResult rr) {
        this.promoteGlobals(type, this.m_controller.getJstTypeSpaceMgr(), rr);
        this.m_typeLinkerVisitor.setCurrentType(type);
        this.m_typeLinkerVisitor.setGroupName(type.getPackage().getGroupName());
        JstExpressionTypeLinkerTraversal.accept((IJstNode)type, this.m_typeLinkerVisitor);
        if (this.m_typeLinkerVisitor.getTypeConstructedDuringLink()) {
            JstExpressionTypeLinkerTraversal.accept((IJstNode)this.m_typeLinkerVisitor.getType(), this.m_typeLinkerVisitor);
            type = this.m_typeLinkerVisitor.getType();
        }
        if (type instanceof JstType) {
            JstType type2 = (JstType)type;
            this.setResolutionStatus(type2);
            rr.setType((IJstType)type2);
        }
    }

    private void promoteGlobals(IJstType type, JstTypeSpaceMgr mgr, ResolutionResult rr) {
        if (type.hasGlobalVars()) {
            JstType type2;
            ITypeSpace typeSpace = mgr.getTypeSpace();
            boolean error = false;
            if (type instanceof JstType && !(type2 = (JstType)type).getStatus().areGlobalsPromoted()) {
                typeSpace.removeGlobalsFromType(type.getPackage().getGroupName(), type.getName());
                error = this.validateGlobal(type, mgr, rr, error);
                if (!error) {
                    for (IJstGlobalVar gvar : type.getGlobalVars()) {
                        IJstGlobalProp globalPty;
                        String groupName = type.getPackage().getGroupName();
                        IJstNode globalBinding = JstExpressionTypeLinkerHelper.look4ActualBinding(this, gvar.getType(), new GroupInfo(groupName, null));
                        if (gvar.getType() instanceof JstAttributedType && !gvar.isFunc() && (globalPty = gvar.getProperty()) instanceof JstGlobalProp) {
                            if (globalBinding instanceof IJstProperty) {
                                ((JstGlobalProp)globalPty).setProperty((IJstProperty)new TranslateHelper.RenameableSynthJstProxyProp((IJstProperty)globalBinding, globalPty.getName().getName()));
                            } else if (globalBinding instanceof IJstMethod) {
                                ((JstGlobalProp)globalPty).setProperty((IJstProperty)new JstSynthesizedProperty((IJstType)new JstFuncType((IJstMethod)globalBinding), globalPty.getName().getName(), null, null));
                            }
                        }
                        typeSpace.addToGlobalSymbolMap(groupName, gvar.getName().getName(), gvar.getOwnerType().getName(), (Object)gvar);
                    }
                }
            }
        }
    }

    private boolean validateGlobal(IJstType type, JstTypeSpaceMgr mgr, ResolutionResult rr, boolean error) {
        for (IJstGlobalVar var : type.getGlobalVars()) {
            IScriptProblem prblm;
            String glbScope = var.getScopeForGlobal();
            if (glbScope != null) continue;
            String name = var.getName().getName();
            String groupName = type.getPackage().getGroupName();
            IJstNode findGlobal = mgr.getQueryExecutor().findGlobalVar(groupName, name, true);
            if (findGlobal == null) continue;
            List list = mgr.getTypeSpace().getType(name);
            if (!list.isEmpty()) {
                prblm = this.reportError(type, var, name, findGlobal, "global " + name + " has already been defined in type: " + ((IJstType)list.get(0)).getName());
                rr.addProblem(prblm);
                error = true;
                continue;
            }
            if (!(findGlobal instanceof IJstGlobalProp) && !(findGlobal instanceof IJstGlobalFunc) || findGlobal.getOwnerType().equals(type)) continue;
            prblm = this.reportError(type, var, name, findGlobal, "global " + name + " has already been defined in type: " + type.getName());
            rr.addProblem(prblm);
            error = true;
        }
        return error;
    }

    private IScriptProblem reportError(IJstType type, IJstGlobalVar vars, String name, IJstNode findGlobal, String msg) {
        JstSource.IBinding binding = type.getSource().getBinding();
        DefaultJstProblem prblm = new DefaultJstProblem(null, null, msg, binding.getName().toCharArray(), vars.getSource().getStartOffSet(), vars.getSource().getEndOffSet(), vars.getSource().getRow(), vars.getSource().getColumn(), ProblemSeverity.error);
        return prblm;
    }

    private void setResolutionStatus(JstType type) {
        List oTypes;
        type.getStatus().setHasResolution();
        List innerTypes = type.getEmbededTypes();
        if (innerTypes != null && !innerTypes.isEmpty()) {
            for (JstType innerType : innerTypes) {
                this.setResolutionStatus(innerType);
            }
        }
        if ((oTypes = type.getOTypes()) != null && !oTypes.isEmpty()) {
            for (IJstOType oType : oTypes) {
                if (!(oType instanceof JstType)) continue;
                JstType oJstType = (JstType)oType;
                this.setResolutionStatus(oJstType);
            }
        }
    }

    public synchronized ResolutionResult resolve(String groupName, IJstType type) {
        ResolutionResult rr = new ResolutionResult();
        this.promoteGlobals(type, this.m_controller.getJstTypeSpaceMgr(), rr);
        this.m_typeLinkerVisitor.setGroupName(groupName);
        return this.resolve(type);
    }

    public synchronized ResolutionResult resolve(IJstProperty property) {
        return this.resolvePropertyInternal(property, new ResolutionResult());
    }

    private ResolutionResult resolvePropertyInternal(IJstProperty property, ResolutionResult rr) {
        IExpr node = property.getInitializer();
        if (node == null) {
            node = property;
        }
        this.m_typeLinkerVisitor.setCurrentType(property.getOwnerType());
        JstExpressionTypeLinkerTraversal.accept((IJstNode)node, this.m_typeLinkerVisitor);
        return rr;
    }

    public synchronized ResolutionResult resolve(String groupName, IJstProperty property) {
        this.m_typeLinkerVisitor.setGroupName(groupName);
        return this.resolvePropertyInternal(property, new ResolutionResult());
    }

    public synchronized ResolutionResult resolve(IJstMethod method) {
        ResolutionResult rr = new ResolutionResult();
        this.m_typeLinkerVisitor.setCurrentType(method.getOwnerType());
        JstExpressionTypeLinkerTraversal.accept((IJstNode)method, this.m_typeLinkerVisitor);
        return rr;
    }

    public synchronized ResolutionResult resolve(String groupName, IJstMethod method) {
        this.m_typeLinkerVisitor.setGroupName(groupName);
        return this.resolve(method);
    }

    public JstParseController getController() {
        return this.m_controller;
    }

    @Deprecated
    public ErrorReporter getErrorReporter() {
        if (this.m_errorReporter == null) {
            this.m_errorReporter = new DefaultErrorReporter();
        }
        return this.m_errorReporter;
    }

    @Deprecated
    public void setErrorReporter(ErrorReporter reporter) {
        this.m_errorReporter = reporter;
    }

    @Deprecated
    public void error(String message, String resource, int start, int end, int line, int column) {
    }

    @Deprecated
    public void warning(String message, String resource, int start, int end, int line, int column) {
    }

    public synchronized ResolutionResult resolve(IJstType ownerType, IJstNode node) {
        ResolutionResult rr = new ResolutionResult();
        this.m_typeLinkerVisitor.setCurrentType(ownerType);
        JstExpressionTypeLinkerTraversal.accept(node, this.m_typeLinkerVisitor);
        return rr;
    }
}

