/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.impl;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.ids.VjoSyntaxProbIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticProblem;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationDriver;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoValidationResult;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IScriptProblem;
import org.eclipse.vjet.dsf.jst.JstProblemId;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.IHeadLessLauncher;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadLessLauncherResult;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadlessLauncherConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.EVLauncherResult;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.VjetvHeadlessConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.IHeadLessReporter;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.ReporterFactory;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.impl.BaseReporter;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.reporter.impl.VjetVReporter;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.FileOperator;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.jstojava.loader.OnDemandAllTypeLoader;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.dsf.ts.event.ISourceEvent;
import org.eclipse.vjet.dsf.ts.event.group.AddGroupEvent;
import org.eclipse.vjet.dsf.ts.event.type.AddTypeEvent;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.vjo.lib.LibManager;
import org.eclipse.vjet.vjo.lib.TsLibLoader;

public class EVHeadlessLauncher
implements IHeadLessLauncher {
    private static final String ONDEMAND = "ONDEMAND";
    HashMap<File, Object> resultDataMap = new LinkedHashMap<File, Object>();
    VjoParser p = new VjoParser();
    JstParseController c = new JstParseController(this.p);

    private List<VjoSemanticProblem> doSemanticValidate(IJstType unit, JstTypeSpaceMgr ts) throws AssertionError {
        IJstType jstType = null;
        VjoValidationDriver driver = new VjoValidationDriver();
        if (unit == null) {
            throw new AssertionError((Object)"Unable to find specified test file.");
        }
        jstType = (IJstType)ts.getTypeSpace().getType(new TypeName(ONDEMAND, unit.getName()));
        ts.processEvent((ISourceEvent)new AddTypeEvent(new TypeName(ONDEMAND, unit.getName()), unit));
        driver.setTypeSpaceMgr(ts);
        ArrayList<IJstType> types = new ArrayList<IJstType>();
        types.add(jstType);
        VjoValidationResult result = driver.validateComplete(types, ONDEMAND);
        return result.getAllProblems();
    }

    private IHeadLessLauncherResult generateResult(EVLauncherResult result, IHeadlessLauncherConfigure conf, Date startTime, IHeadLessReporter reporter) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        String startTimeString = df.format(startTime);
        Date endTime = new Date();
        String endTimeString = df.format(endTime);
        result.setResultMap(this.resultDataMap);
        result.setStartTime(startTimeString);
        result.setEndTime(endTimeString);
        reporter.generateReport(result, conf);
        this.setResultInformation(conf, startTime, startTimeString, endTime, endTimeString, result);
        reporter.printSummaryInformation(result);
        FileOperator.delFolder(FileOperator.TEMPFOLDER);
        return result;
    }

    private List<VjoSemanticProblem> handleSyntaxProblems(List<VjoSemanticProblem> actualProblemList, IJstType unit) {
        List lists = unit.getProblems();
        for (IScriptProblem scriptProblem : lists) {
            JstProblemId problemID = scriptProblem.getID() != null ? scriptProblem.getID() : VjoSyntaxProbIds.IncorrectVjoSyntax;
            actualProblemList.add(new VjoSemanticProblem(null, problemID, scriptProblem.getMessage(), scriptProblem.getOriginatingFileName(), scriptProblem.getSourceStart(), scriptProblem.getSourceEnd(), scriptProblem.getSourceLineNumber(), 0, scriptProblem.type()));
        }
        return actualProblemList;
    }

    @Override
    public IHeadLessLauncherResult launch(IHeadlessLauncherConfigure conf, IHeadLessReporter reporter) {
        if (conf instanceof VjetvHeadlessConfigure) {
            this.resultDataMap.clear();
            Date startTime = new Date();
            EVLauncherResult result = new EVLauncherResult();
            this.launchValidate(conf, reporter, result);
            return this.generateResult(result, conf, startTime, reporter);
        }
        return null;
    }

    private void launchValidate(IHeadlessLauncherConfigure conf, IHeadLessReporter reporter, EVLauncherResult result) {
        File validateFile2 = null;
        List<String> librariesToLoad = conf.getLibrariesToLoad();
        LinkedHashSet<File> jsFiles = conf.getValidatedJSFiles();
        List<VjoSemanticProblem> actualProblemList = null;
        BaseReporter baseReporter = (BaseReporter)reporter;
        jsFiles.size();
        this.c.parse(ONDEMAND, "", "");
        JstTypeSpaceMgr mgr = new JstTypeSpaceMgr((IJstParseController)this.c, (IJstTypeLoader)new OnDemandAllTypeLoader(ONDEMAND, (IJstType)JstFactory.getInstance().createJstType(false)));
        mgr.initialize();
        TsLibLoader.loadDefaultLibs((JstTypeSpaceMgr)mgr);
        try {
            JstCache.getInstance().addLib(LibManager.getInstance().getVjoJavaLib());
            mgr.loadLibrary(LibManager.getInstance().getVjoJavaLib(), "VjoJavaLib");
        }
        catch (Exception exception) {}
        mgr.processEvent((ISourceEvent)new AddGroupEvent(ONDEMAND, null, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, null, conf.getExclusionPatterns()));
        IGroup jsnative = mgr.getTypeSpace().getGroup("JsNativeLib");
        IGroup group = mgr.getTypeSpace().getGroup(ONDEMAND);
        group.addGroupDependency(jsnative);
        IGroup browserlib = mgr.getTypeSpace().getGroup("JsBrowserLib");
        group.addGroupDependency(browserlib);
        IGroup vjolib = mgr.getTypeSpace().getGroup("VjoSelfDescribed");
        group.addGroupDependency(vjolib);
        for (String library : librariesToLoad) {
            mgr.processEvent((ISourceEvent)new AddGroupEvent(library, library));
            group.addGroupDependency(mgr.getTypeSpace().getGroup(library));
        }
        baseReporter.printCurrentStates("<Start to Validate... ======================================================================================================================>\n");
        for (File validateFile2 : jsFiles) {
            try {
                actualProblemList = this.validateFile(validateFile2);
                if (actualProblemList == null || actualProblemList.size() <= 0) continue;
                String printProblems = baseReporter.printProblems(actualProblemList, result, conf.getReportLevel(), true, validateFile2);
                if (printProblems != null) {
                    baseReporter.printCurrentStates(printProblems);
                }
                this.resultDataMap.put(validateFile2, actualProblemList);
            }
            catch (Throwable e) {
                e.printStackTrace();
                reporter.printCurrentStates("Error Message :  " + e.getMessage() + "\n");
                reporter.printCurrentStates("Please check file:" + validateFile2 + ". \n");
                this.resultDataMap.put(validateFile2, e.getMessage());
            }
        }
    }

    public IHeadLessLauncherResult launchValidation(VjetvHeadlessConfigure conf, VjetVReporter reporter) {
        return this.launch(conf, reporter);
    }

    private void setResultInformation(IHeadlessLauncherConfigure conf, Date startTime, String startTimeString, Date endTime, String endTimeString, EVLauncherResult result) {
        long l = endTime.getTime() - startTime.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        if (conf.getReportPath() != null) {
            sb.append("Result file at : " + conf.getReportPath() + "\n");
        }
        sb.append("Total validated JS files number: " + conf.getValidatedJSFiles().size() + "\n");
        sb.append("Total errors number: " + result.getErrorNumber() + " \n");
        if (!conf.getReportLevel().equals("ERROR")) {
            sb.append("Total warning number: " + result.getWarningNumber() + "\n");
        }
        sb.append("Start Time : " + startTimeString + "\n");
        sb.append("End   Time : " + endTimeString + "\n");
        sb.append("Total use time : " + hour + ":" + min + ":" + s + "\n");
        result.setResultInformation(sb.toString());
    }

    public List<VjoSemanticProblem> validateFile(File validateFile) {
        List<VjoSemanticProblem> actualProblemList = new ArrayList<VjoSemanticProblem>();
        IJstType unit = this.c.parseAndResolve(ONDEMAND, validateFile.getAbsolutePath(), VjoParser.getContent(validateFile));
        if (unit.getProblems().size() > 0) {
            return this.handleSyntaxProblems(actualProblemList, unit);
        }
        actualProblemList = this.doSemanticValidate(unit, this.c.getJstTypeSpaceMgr());
        return actualProblemList;
    }

    @Override
    public IHeadLessLauncherResult launch(IHeadlessLauncherConfigure conf) {
        return this.launch(conf, ReporterFactory.getReporter(conf.isVerbose()));
    }
}

