/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp.file;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.file.IVFile;
import org.eclipse.vjet.dsf.js.dbgp.file.IVFileManager;
import org.eclipse.vjet.dsf.js.dbgp.file.VFile;

public class VFileManager
implements IVFileManager {
    private Map<URI, IVFile> m_uri2FileMap = new HashMap<URI, IVFile>();
    private Map<String, IVFile> m_name2FileMap = new HashMap<String, IVFile>();
    private int m_count = 1;

    @Override
    public void addFile(IVFile file) {
        this.m_uri2FileMap.put(file.toURI(), file);
        this.m_name2FileMap.put(file.getName(), file);
    }

    @Override
    public void clear() {
        this.m_uri2FileMap.clear();
        this.m_name2FileMap.clear();
    }

    @Override
    public boolean contains(IVFile file) {
        return this.m_name2FileMap.get(file.getName()) != null;
    }

    @Override
    public IVFile createFile(int id, String name, String contents) {
        VFile file = new VFile(this.m_count++, name, contents, this);
        this.addFile(file);
        return file;
    }

    @Override
    public IVFile getFileByName(String sourceName) {
        return this.m_name2FileMap.get(sourceName);
    }

    @Override
    public IVFile[] getFiles() {
        return this.m_uri2FileMap.values().toArray(new IVFile[this.m_uri2FileMap.size()]);
    }

    @Override
    public IVFile remove(IVFile file) {
        if (!this.contains(file)) {
            return null;
        }
        this.m_uri2FileMap.remove(file.toURI());
        this.m_name2FileMap.remove(file.getName());
        return file;
    }

    @Override
    public IVFile remove(URI uri) {
        IVFile file = this.m_uri2FileMap.get(uri);
        if (file != null) {
            this.remove(file);
        }
        return file;
    }

    @Override
    public IVFile resolve(URI fileUri) {
        return this.m_uri2FileMap.get(fileUri);
    }
}

