/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugFrame;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.VMBridge;
import org.mozilla.mod.javascript.debug.Debugger;

final class ContextGetCommand
extends DBGPDebugger.Command {
    private final DBGPDebugger m_debugger;

    ContextGetCommand(DBGPDebugger debugger) {
        this.m_debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        String id;
        StringBuffer properties = new StringBuffer();
        int level = Integer.parseInt(options.get("-d"));
        DBGPDebugFrame stackFrame = this.m_debugger.m_stackmanager.getStackFrame(level);
        if (Context.getCurrentContext() == null) {
            Object helper = VMBridge.instance.getThreadContextHelper();
            VMBridge.instance.setContext(helper, stackFrame.getContext());
        }
        Context currentContext = Context.getCurrentContext();
        Debugger debugger = currentContext.getDebugger();
        Object contextData = currentContext.getDebuggerContextData();
        currentContext.setDebugger(null, null);
        this.m_debugger.setCurrentScope(stackFrame.getThis());
        String[] propertyIds = stackFrame.getParametersAndVars();
        int a = 0;
        while (a < propertyIds.length) {
            id = propertyIds[a];
            Object value = stackFrame.getValue(a);
            this.m_debugger.printProperty(id, id, value, properties, 0, true);
            ++a;
        }
        Scriptable this1 = stackFrame.getThis();
        if (this1 != null) {
            id = "this";
            this.m_debugger.printProperty(id, id, this1, properties, 0, false);
        }
        currentContext.setDebugger(debugger, contextData);
        this.m_debugger.printResponse("<response command=\"context_get\"\r\nstatus=\"starting\" reason=\"ok\" transaction_id=\"" + options.get("-i") + "\">\r\n" + properties + "</response>\r\n");
    }
}

