/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.Base64Helper;

public class BreakPoint {
    static int s_last_id = 0;
    protected final String m_file;
    protected final int m_line;
    protected final int m_id;
    protected boolean m_enabled = true;
    protected boolean m_isTemporary = false;
    protected int m_hitValue = 0;
    protected int m_hitCondition = 0;
    protected int m_currentHitCount = 0;
    protected String m_expression;
    protected boolean m_isExitBreakpoint;
    protected String m_method;
    protected boolean m_isReturn;
    protected boolean m_isWatch;
    protected boolean m_isCall;
    protected boolean m_isModification;
    protected boolean m_isAccess;
    private String m_type;

    protected BreakPoint(Map<String, String> options) {
        String hitValue;
        String uri;
        this.m_type = options.get("-t");
        if (this.m_type.equals("call") || this.m_type.equals("return")) {
            this.m_method = options.get("-m");
            this.m_isReturn = this.m_type.equals("return");
            this.m_isCall = this.m_type.equals("call");
        }
        if (this.m_type.equals("watch")) {
            this.m_isWatch = true;
        }
        if ((uri = options.get("-f")) != null) {
            if (uri.startsWith("dbgp")) {
                this.m_file = uri;
            } else {
                try {
                    this.m_file = new URL(uri).toExternalForm();
                }
                catch (MalformedURLException mue) {
                    throw new RuntimeException(mue);
                }
            }
        } else {
            this.m_file = "";
        }
        String line = options.get("-n");
        this.m_line = line != null ? Integer.parseInt(line) : -1;
        String tm = options.get("-r");
        if (tm != null) {
            this.m_isTemporary = tm.equals("1");
        }
        if ((hitValue = options.get("-h")) != null) {
            this.m_hitValue = Integer.parseInt(hitValue);
        }
        String hitCondition = options.get("-o");
        this.setHitCondition(hitCondition);
        String exp = options.get("--");
        String disable = options.get("-s");
        if (disable.equals("disabled")) {
            this.setEnabled(false);
        }
        if (exp != null) {
            this.m_expression = Base64Helper.decodeString(exp);
            if (this.m_expression != null) {
                this.m_expression = this.m_expression.trim();
            }
        }
        if (this.m_isWatch) {
            this.m_isModification = this.m_expression.charAt(this.m_expression.length() - 1) == '1';
            this.m_isAccess = this.m_expression.charAt(this.m_expression.length() - 2) == '1';
            this.m_expression = this.m_expression.substring(0, this.m_expression.length() - 2);
        }
        this.m_id = s_last_id++;
    }

    protected void setHitCondition(String hitCondition) {
        if (hitCondition != null) {
            if (hitCondition.equals(">=")) {
                this.m_hitCondition = 1;
            }
            if (hitCondition.equals("==")) {
                this.m_hitCondition = 2;
            }
            if (hitCondition.equals("%")) {
                this.m_hitCondition = 3;
            }
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.m_file == null ? 0 : this.m_file.hashCode());
        result = 31 * result + this.m_line;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BreakPoint other = (BreakPoint)obj;
        if (this.m_file == null ? other.m_file != null : !this.m_file.equals(other.m_file)) {
            return false;
        }
        return this.m_line == other.m_line;
    }

    protected boolean isEnabled() {
        return this.m_enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public String getType() {
        return this.m_type;
    }

    public String getState() {
        return "";
    }

    public String getHitCondition() {
        if (this.m_hitCondition == 1) {
            return ">=";
        }
        if (this.m_hitCondition == 2) {
            return "==";
        }
        if (this.m_hitCondition == 3) {
            return "%";
        }
        return "==";
    }
}

