/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.debug;

import org.eclipse.dltk.mod.debug.core.model.ArrayScriptType;
import org.eclipse.dltk.mod.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.mod.debug.core.model.ComplexScriptType;
import org.eclipse.dltk.mod.debug.core.model.IScriptType;
import org.eclipse.dltk.mod.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.mod.debug.core.model.IScriptValue;
import org.eclipse.dltk.mod.debug.core.model.StringScriptType;

public class VjetTypeFactory
implements IScriptTypeFactory {
    private static final String[] atomicTypes = new String[]{"number", "boolean", "date"};

    public IScriptType buildType(String type) {
        int i = 0;
        while (i < atomicTypes.length) {
            if (atomicTypes[i].equals(type)) {
                return new AtomicScriptType(type);
            }
            ++i;
        }
        if ("javaarray".equals(type) || "array".equals(type)) {
            return new ArrayScriptType();
        }
        if ("string".equals(type)) {
            return new StringScriptType("string");
        }
        return new ComplexScriptType(type){

            public String formatValue(IScriptValue value) {
                StringBuffer sb = new StringBuffer();
                sb.append(value.getRawValue());
                String id = value.getInstanceId();
                if (id != null) {
                    sb.append(" (id = " + id + ")");
                }
                return sb.toString();
            }
        };
    }
}

