/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.List;
import java.util.Stack;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IBinaryExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.core.ast.ILiteral;
import org.eclipse.mod.wst.jsdt.core.ast.IPostfixExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.vjet.dsf.common.exceptions.DsfRuntimeException;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstGlobalFunc;
import org.eclipse.vjet.dsf.jst.IJstGlobalProp;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.JstCommentLocation;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstDefaultConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalFunc;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalProp;
import org.eclipse.vjet.dsf.jst.declaration.JstGlobalVar;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstSynthesizedProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.TextExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ISimpleTerm;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsParam;
import org.eclipse.vjet.dsf.jstojava.translator.BlockTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.JsDocHelper;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.TypeTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IRobustTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.TypeRobustTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.VjoRobustTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.FunctionExpressionTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstFieldOrMethodCompletion;

public class VjoOLFieldTranslator
extends BaseAst2JstTranslator<ObjectLiteralField, Object> {
    private static String MISSING = "$missing$";

    public VjoOLFieldTranslator() {
    }

    public VjoOLFieldTranslator(TranslateCtx ctx) {
        super.setTranslateCtx(ctx);
    }

    @Override
    protected Object doTranslate(ObjectLiteralField astObjectliteralField) {
        if (this.m_ctx.isSkipJsExtSyntaxArgs()) {
            return null;
        }
        IExpression initializer = astObjectliteralField.getInitializer();
        IExpression fieldName = astObjectliteralField.getFieldName();
        if (ScopeIds.OPTIONS.equals((Object)this.m_ctx.getCurrentScope()) && this.m_parent instanceof JstType) {
            if (fieldName instanceof SingleNameReference) {
                JstType type = (JstType)this.m_parent;
                String name = ((SingleNameReference)fieldName).toString();
                if ("metatype".equals(name)) {
                    type.setMetaType(initializer instanceof TrueLiteral);
                } else {
                    type.addOption(name, (Object)initializer.toString());
                }
            }
            return null;
        }
        Object result = null;
        if (initializer instanceof FunctionExpression) {
            FunctionExpressionTranslator translator = (FunctionExpressionTranslator)this.getTranslator((IASTNode)initializer);
            translator.setParent(this.m_parent);
            FuncExpr functionExpr = translator.doTranslate((FunctionExpression)initializer, this.getSimpleName(astObjectliteralField));
            translator.checkForCompletion((FunctionExpression)initializer);
            if (this.m_parent == null && fieldName instanceof SingleNameReference) {
                return new NV(((SingleNameReference)fieldName).toString(), (IExpr)functionExpr);
            }
            JstMethod meth = null;
            if (ScopeIds.GLOBAL.equals((Object)this.m_ctx.getCurrentScope())) {
                meth = this.buildMethod(fieldName, functionExpr.getFunc(), false);
                meth = functionExpr.getFunc();
                JstGlobalFunc globalFunc = new JstGlobalFunc((IJstMethod)meth);
                JstGlobalVar globalVar = new JstGlobalVar((IJstGlobalFunc)globalFunc);
                globalVar.setScopeForGlobal(this.m_ctx.getScopeForGlobals());
                if (this.m_parent instanceof JstType) {
                    ((JstType)this.m_parent).addGlobalVar((IJstGlobalVar)globalVar);
                }
            } else {
                meth = this.buildMethod(fieldName, functionExpr.getFunc(), true);
                if (this.m_parent instanceof JstType && ((JstType)this.m_parent).isOType()) {
                    System.out.println("doTranslate");
                    JstFunctionRefType ref = new JstFunctionRefType((IJstMethod)meth);
                    ((JstType)this.m_parent).addOType((IJstOType)ref);
                    ref.setPackage(new JstPackage(((IJstType)this.m_parent).getName()));
                    this.checkIfTypeExistsForFunction(ref);
                }
            }
            result = meth;
        } else if (this.isPropertyInitExpression(initializer)) {
            result = this.processCorrectProperty(astObjectliteralField);
        } else if (MISSING.equals(initializer.toString())) {
            if (this.onlyWhiteSpaces(astObjectliteralField.sourceEnd, this.m_ctx.getCompletionPos())) {
                astObjectliteralField.sourceEnd = astObjectliteralField.initializer.sourceEnd = this.m_ctx.getCompletionPos() - 1;
            }
        } else if (initializer instanceof FieldReference) {
            result = this.checkForProblemAndProcess(astObjectliteralField);
            if (result == null) {
                result = this.processCorrectProperty(astObjectliteralField);
            }
        } else if (initializer instanceof ConditionalExpression) {
            result = this.checkForProblemAndProcess(astObjectliteralField);
        } else {
            Stack<IASTNode> list = JstUtil.createMessageSendStack(initializer);
            if (JstUtil.isInnerType(list)) {
                String typeName = JstUtil.getInnerTypeName(list);
                result = this.processInnerType(astObjectliteralField, typeName);
            } else {
                this.processCorrectProperty(astObjectliteralField);
            }
        }
        return result;
    }

    private boolean isPropertyInitExpression(IExpression initializer) {
        return initializer instanceof ILiteral || initializer instanceof ObjectLiteral || initializer instanceof ArrayInitializer || initializer instanceof UnaryExpression || initializer instanceof IBinaryExpression || initializer instanceof IPostfixExpression || initializer instanceof SingleNameReference || initializer instanceof EqualExpression || initializer instanceof ConditionalExpression || initializer instanceof OR_OR_Expression || initializer instanceof AND_AND_Expression || initializer instanceof AllocationExpression;
    }

    private void createJstBlock(IProgramElement elem, IJstType innerType) {
        List<JstBlock> listBlocks = this.m_ctx.getScriptUnitBlockList();
        if (listBlocks == null) {
            return;
        }
        TranslateConfig cfg = new TranslateConfig();
        cfg.setSkiptImplementation(false);
        cfg.setSkipJsExtSyntaxArgs(true);
        TranslateCtx ctx2 = new TranslateCtx(cfg);
        ctx2.setCurrentType((JstType)innerType);
        ctx2.setCreatedCompletion(this.m_ctx.isCreatedCompletion());
        ctx2.setCompletionPos(this.m_ctx.getCompletionPos());
        ctx2.getScopeStack().addAll(this.m_ctx.getScopeStack());
        ctx2.setAST(this.m_ctx.getAST());
        listBlocks.add(BlockTranslator.createJstBlock(ctx2, (IASTNode)elem));
        this.copyInnerCtxToOut(ctx2, this.m_ctx);
    }

    private void copyInnerCtxToOut(TranslateCtx innerCtx, TranslateCtx outerCtx) {
        outerCtx.setCreatedCompletion(innerCtx.isCreatedCompletion());
        List<JstCompletion> list = innerCtx.getJstErrors();
        if (list != null && !list.isEmpty()) {
            outerCtx.addSyntaxError(list.get(0));
        }
    }

    private Object processInnerType(ObjectLiteralField field, String typeName) {
        JstMethod constructor;
        JstType currentType = this.m_ctx.getCurrentType();
        String fullName = String.valueOf(currentType.getName()) + "." + field.getFieldName();
        JstType innerType = JstCache.getInstance().getType(fullName);
        if (innerType == null) {
            innerType = this.createInnerType(field);
            currentType.addInnerType(innerType);
            JstCache.getInstance().addType(innerType);
        } else {
            this.clearInnerType(innerType);
            this.updateInnerType(field, innerType);
            currentType.addInnerType(innerType);
        }
        if (typeName != null && (typeName = typeName.trim()).startsWith("<") && typeName.endsWith(">")) {
            TranslateHelper.addParamsToType(this.m_ctx, innerType, typeName.substring(1, typeName.length() - 1));
        }
        this.m_ctx.setCurrentType(innerType);
        this.processInnerType(field, innerType);
        this.createJstBlock((IProgramElement)field.getInitializer(), (IJstType)innerType);
        this.m_ctx.setCurrentType(currentType);
        List<IJsCommentMeta> meta = this.getCommentMeta(field);
        if (meta.size() > 0) {
            TranslateHelper.setModifiersFromMeta(meta.get(0), innerType.getModifiers());
        }
        this.createInnerTypeRefProperty(currentType, innerType);
        this.updateInnerTypeReferences(currentType, innerType);
        if (innerType.isClass() && (constructor = innerType.getConstructor()) == null) {
            innerType.setConstructor((JstMethod)new JstDefaultConstructor((IJstType)innerType));
        }
        return innerType;
    }

    private void createInnerTypeRefProperty(JstType currentType, JstType innerType) {
        if (currentType.isOType()) {
            return;
        }
        JstModifiers mod = innerType.getModifiers().getCopy();
        JstSynthesizedProperty property = new JstSynthesizedProperty((IJstType)this.getTypeRef((IJstType)innerType), innerType.getSimpleName(), null, mod);
        property.setParent((IJstNode)currentType);
        if (currentType.getProperty(property.getName().getName()) != null) {
            int line = 0;
            int column = 0;
            int start = 0;
            int end = 0;
            JstSource src = innerType.getSource();
            if (src != null) {
                line = src.getRow();
                column = src.getColumn();
                start = src.getStartOffSet();
                end = src.getEndOffSet();
            }
            this.m_ctx.getErrorReporter().error("Inner type: " + innerType.getSimpleName() + " already exists in type: " + this.m_ctx.getCurrentType().getName(), this.m_ctx.getCurrentType().getName(), start, end, line, column);
        } else {
            currentType.addProperty((IJstProperty)property);
        }
    }

    private IJstRefType getTypeRef(IJstType type) {
        if (type instanceof IJstRefType) {
            return (IJstRefType)type;
        }
        return JstTypeHelper.getJstTypeRefType((IJstType)type);
    }

    private void clearInnerType(JstType innerType) {
        innerType.clearAll();
        innerType.setPackage(null);
    }

    private void updateInnerTypeReferences(JstType currentType, JstType innerType) {
        if (currentType == null || innerType == null) {
            return;
        }
        String innerTypeName = innerType.getSimpleName();
        if (innerTypeName == null) {
            return;
        }
        for (IJstProperty pty : currentType.getProperties()) {
            if (pty instanceof ISynthesized || !innerTypeName.equals(pty.getType().getName()) || !(pty instanceof JstProperty)) continue;
            ((JstProperty)pty).setType((IJstType)innerType);
        }
        for (IJstMethod mtd : currentType.getMethods()) {
            if (!(mtd instanceof JstMethod)) continue;
            JstMethod method = (JstMethod)mtd;
            IJstType rtnType = method.getRtnType();
            if (rtnType != null) {
                if (rtnType instanceof IJstTypeReference) {
                    rtnType = ((IJstTypeReference)rtnType).getReferencedType();
                }
                if (innerTypeName.equals(rtnType.getName()) && rtnType instanceof JstType) {
                    method.setRtnType((IJstType)innerType);
                }
            }
            int i = 0;
            while (i < mtd.getArgs().size()) {
                JstArg arg = (JstArg)mtd.getArgs().get(i);
                for (IJstType argType : arg.getTypes()) {
                    if (argType == null || !innerTypeName.equals(argType.getName())) continue;
                    arg.updateType(argType.getName(), (IJstType)innerType);
                }
                ++i;
            }
        }
    }

    private String getSimpleName(ObjectLiteralField field) {
        Expression expression = field.fieldName;
        String name = JstUtil.getName((IASTNode)expression);
        return name;
    }

    private void processInnerType(ObjectLiteralField field, JstType innerType) {
        TypeTranslator translator = new TypeTranslator(this.m_ctx);
        MessageSend obj = (MessageSend)field.initializer;
        MessageSend rootElem = null;
        MessageSend send = obj;
        Stack<IProgramElement> astElements = new Stack<IProgramElement>();
        do {
            if (JstUtil.isType(String.valueOf(send.selector))) {
                rootElem = send;
                astElements.add((IProgramElement)send);
            }
            if (send.receiver instanceof SingleNameReference) {
                send = null;
                continue;
            }
            astElements.add((IProgramElement)send);
            send = (MessageSend)send.receiver;
        } while (send != null);
        if (astElements.size() > 0) {
            VjoRobustTranslator vjoT = new VjoRobustTranslator(this.m_ctx);
            IRobustTranslator t = vjoT.getSubTranslator((IProgramElement)rootElem);
            t.configure(astElements, innerType, translator, TypeRobustTranslator.getIntegerHolder(this.m_ctx.getCompletionPos()));
            t.transform();
            JstSource source = VjoOLFieldTranslator.createSource(field.fieldName.sourceStart, field.fieldName.sourceEnd, this.m_ctx.getSourceUtil());
            innerType.setSource(source);
        }
    }

    private JstType createInnerType(ObjectLiteralField field) {
        JstType innerType = JstFactory.getInstance().createJstType(false);
        return this.updateInnerType(field, innerType);
    }

    private JstType updateInnerType(ObjectLiteralField field, JstType innerType) {
        if (this.m_ctx.getCurrentScope().equals((Object)ScopeIds.PROTOS)) {
            innerType.getModifiers().setStatic(false).setDefault();
        } else if (this.m_ctx.getCurrentScope().equals((Object)ScopeIds.PROPS)) {
            innerType.getModifiers().setStatic(true).setDefault();
        } else if (this.m_ctx.getCurrentScope().equals((Object)ScopeIds.PROPS)) {
            innerType.getModifiers().setStatic(true).setDefault();
        }
        innerType.getModifiers().setAbstract(false).setFinal(false);
        JstSource source = VjoOLFieldTranslator.createSource(field.sourceStart, field.sourceEnd, this.m_ctx.getSourceUtil());
        innerType.setSource(source);
        String name = this.getSimpleName(field);
        innerType.setSimpleName(name);
        return innerType;
    }

    private JstObjectLiteralType createOType(ObjectLiteralField field) {
        String name = this.getSimpleName(field);
        JstObjectLiteralType otype = new JstObjectLiteralType(name);
        if (this.m_parent instanceof IJstType) {
            otype.setPackage(new JstPackage(((IJstType)this.m_parent).getName()));
        }
        JstSource source = VjoOLFieldTranslator.createSource(field.sourceStart, field.sourceEnd, this.m_ctx.getSourceUtil());
        otype.setSource(source);
        otype.setSimpleName(name);
        return otype;
    }

    private JstMethod buildMethod(IExpression fieldName, JstMethod jstMethod, boolean addToParent) {
        jstMethod = TranslateHelper.createRealMethod(fieldName, jstMethod, this.m_ctx);
        if (addToParent && this.m_parent != null && this.m_parent instanceof JstType) {
            if (this.m_ctx.getCurrentScope() == ScopeIds.PROTOS && "constructs".equals(fieldName.toString())) {
                for (IJstMethod mtd : jstMethod.getOverloaded()) {
                    ((JstType)this.m_parent).removeChild((IJstNode)mtd);
                }
                ((JstType)this.m_parent).setConstructor(jstMethod);
            } else {
                ((JstType)this.m_parent).addMethod((IJstMethod)jstMethod);
            }
            jstMethod.setParent((IJstNode)this.m_parent);
        }
        if (jstMethod.getParentNode() == null) {
            throw new DsfRuntimeException("null parent not expected");
        }
        return jstMethod;
    }

    private Object processCorrectProperty(ObjectLiteralField astObjectliteralField) {
        NV result;
        boolean isFuncRef;
        int completionPos = this.m_ctx.getCompletionPos();
        String simpleName = this.getSimpleName(astObjectliteralField);
        IExpr value = null;
        JstType parent = null;
        BaseJstNode prevParent = this.m_parent;
        List<IJsCommentMeta> metaArr = null;
        if (!this.isEnumContext()) {
            this.m_ctx.enterBlock(ScopeIds.PROPERTY);
        }
        try {
            if (astObjectliteralField.initializer instanceof ObjectLiteral && this.m_parent != null && this.m_parent instanceof JstType && ((JstType)this.m_parent).isOType()) {
                String fullName = String.valueOf(((IJstType)this.m_parent).getName()) + "." + simpleName;
                parent = JstCache.getInstance().getType(fullName);
                if (parent == null || !(parent instanceof JstObjectLiteralType)) {
                    if (parent != null) {
                        parent.getStatus().setIsPhantom();
                    }
                    parent = this.createOType(astObjectliteralField);
                    JstCache.getInstance().addOType(parent);
                } else {
                    this.clearInnerType(parent);
                    JstSource source = VjoOLFieldTranslator.createSource(astObjectliteralField.sourceStart, astObjectliteralField.sourceEnd, this.m_ctx.getSourceUtil());
                    parent.setSource(source);
                    parent.setPackage(new JstPackage(((IJstType)this.m_parent).getName()));
                    parent.setSimpleName(simpleName);
                }
                this.m_ctx.setCurrentType(parent);
                if (this.m_parent != null && this.m_parent instanceof IJstType) {
                    ((IJstType)this.m_parent).addOType((IJstOType)((JstObjectLiteralType)parent));
                }
                this.m_parent = parent;
            }
            value = this.isEnumContext() ? this.createEnumValue(astObjectliteralField.initializer) : (IExpr)this.getTranslatorAndTranslate((IASTNode)astObjectliteralField.initializer);
        }
        finally {
            if (!this.isEnumContext()) {
                this.m_ctx.exitBlock();
            }
            this.m_ctx.setCompletionPos(completionPos);
            metaArr = this.getCommentMeta(astObjectliteralField);
        }
        this.m_parent = prevParent;
        if (prevParent instanceof JstType) {
            this.m_ctx.setCurrentType((JstType)prevParent);
        }
        boolean isTypedObjLiteral = this.m_parent instanceof JstObjectLiteralType;
        boolean isMeth = metaArr != null && metaArr.size() > 0 && metaArr.get(0).isMethod();
        boolean isFnExpr = false;
        if (value instanceof FieldAccessExpr) {
            IJstType type = ((FieldAccessExpr)value).getType();
            JstType fnType = JstCache.getInstance().getType("Function");
            if (fnType != null && fnType.equals(type)) {
                isFnExpr = true;
            }
        }
        boolean bl = isFuncRef = isMeth && this.m_parent instanceof JstType && ((JstType)this.m_parent).isOType();
        if (this.m_parent == null || !(this.m_parent instanceof JstType)) {
            result = this.buildNV(astObjectliteralField, value, metaArr);
        } else if ((this.m_ctx.getCurrentScope() == ScopeIds.PROPERTY || isFuncRef) && !isTypedObjLiteral) {
            result = this.buildNV(astObjectliteralField, value, metaArr);
            if (isFuncRef) {
                this.addFuncRef((JstType)this.m_parent, astObjectliteralField, metaArr);
            }
        } else {
            JstType current = (JstType)this.m_parent;
            if (isFnExpr || isMeth) {
                IJsCommentMeta meta;
                List<JsParam> params;
                JstMethod meth = TranslateHelper.createRealMethod((IExpression)astObjectliteralField.fieldName, TranslateHelper.MethodTranslateHelper.createJstMethod((IExpression)astObjectliteralField.initializer, metaArr, this.m_ctx, simpleName), this.m_ctx);
                if (meth == null) {
                    return null;
                }
                if (metaArr != null && metaArr.size() > 1 && meth.getArgs() != null && meth.getArgs().size() == 0 && (params = TranslateHelper.getParams(meta = this.getLongestArgList(metaArr))) != null) {
                    for (JsParam param : params) {
                        IJstType metaDefinedType = TranslateHelper.findType(this.m_ctx, meta.getTyping(), meta);
                        JstArg arg = new JstArg(metaDefinedType, param.getName(), param.isVariable(), param.isOptional());
                        meth.addArg(arg);
                    }
                }
                meth.setBlock(null);
                if (this.m_ctx.getCurrentScope().equals((Object)ScopeIds.GLOBAL)) {
                    JstGlobalFunc globalFunc = new JstGlobalFunc((IJstMethod)meth);
                    JstGlobalVar global = new JstGlobalVar((IJstGlobalFunc)globalFunc);
                    global.setScopeForGlobal(this.m_ctx.getScopeForGlobals());
                    current.addGlobalVar((IJstGlobalVar)global);
                    result = globalFunc;
                } else {
                    if (isTypedObjLiteral) {
                        JstProperty mtdProperty4Otype = this.buildProperty(astObjectliteralField, value, metaArr, parent);
                        mtdProperty4Otype.setType((IJstType)new JstFuncType((IJstMethod)meth));
                        current.addProperty((IJstProperty)mtdProperty4Otype);
                    } else if (meth.isConstructor()) {
                        current.setConstructor(meth);
                    } else {
                        current.addMethod((IJstMethod)meth);
                    }
                    result = meth;
                }
            } else if (ScopeIds.GLOBAL.equals((Object)this.m_ctx.getCurrentScope())) {
                JstGlobalVar global = this.buildGlobalNonFunc(astObjectliteralField, value, metaArr, parent);
                current.addGlobalVar((IJstGlobalVar)global);
                result = global;
            } else {
                JstProperty jstProp = this.buildProperty(astObjectliteralField, value, metaArr, parent);
                if (this.isEnumContext()) {
                    current.addEnumValue((IJstProperty)jstProp);
                } else {
                    current.addProperty((IJstProperty)jstProp);
                }
                result = jstProp;
            }
        }
        return result;
    }

    private IJsCommentMeta getLongestArgList(List<IJsCommentMeta> metaArr) {
        IJsCommentMeta maxMeta = null;
        int maxParamCount = 0;
        List<JsParam> params = null;
        for (IJsCommentMeta meta : metaArr) {
            if (maxMeta == null) {
                maxMeta = meta;
                params = TranslateHelper.getParams(meta);
                if (params == null) continue;
                maxParamCount = params.size();
                continue;
            }
            params = TranslateHelper.getParams(meta);
            if (params == null || params.size() <= maxParamCount) continue;
            maxParamCount = params.size();
            maxMeta = meta;
        }
        return maxMeta;
    }

    private IExpr createEnumValue(Expression valuesExpr) {
        if (valuesExpr == null) {
            return null;
        }
        if (valuesExpr instanceof ArrayInitializer) {
            ArrayInitializer values = (ArrayInitializer)valuesExpr;
            if (values.expressions == null) {
                return new JstArrayInitializer();
            }
            JstType type = this.m_ctx.getCurrentType();
            IExpr[] args = new IExpr[values.expressions.length];
            int i = 0;
            while (i < values.expressions.length) {
                Expression expr = values.expressions[i];
                args[i] = (IExpr)this.getTranslatorAndTranslate((IASTNode)expr);
                ++i;
            }
            JstIdentifier thisIdentifier = new JstIdentifier("this");
            JstIdentifier vj$Identifier = new JstIdentifier("vj$");
            FieldAccessExpr thisVj$ = new FieldAccessExpr(vj$Identifier, (IExpr)thisIdentifier);
            JstIdentifier simpleNameIdentifier = new JstIdentifier(type.getSimpleName());
            FieldAccessExpr constructor = new FieldAccessExpr(simpleNameIdentifier, (IExpr)thisVj$);
            MtdInvocationExpr mtdInv = new MtdInvocationExpr((IExpr)constructor, args);
            ObjCreationExpr val = new ObjCreationExpr(mtdInv);
            return val;
        }
        System.err.println("Invalid enum values: " + valuesExpr.toString());
        return new TextExpr(valuesExpr.toString());
    }

    private void addFuncRef(JstType type, ObjectLiteralField astObjectliteralField, List<IJsCommentMeta> metaArr) {
        JstMethod mtd = TranslateHelper.MethodTranslateHelper.createJstMethod((IExpression)astObjectliteralField.initializer, metaArr, this.m_ctx, this.getSimpleName(astObjectliteralField));
        JstSource mtdNameSource = TranslateHelper.getSource((IASTNode)astObjectliteralField.fieldName, this.m_ctx.getSourceUtil());
        if (mtd.getName() != null) {
            mtd.getName().setSource(mtdNameSource);
        }
        type.addMethod((IJstMethod)mtd);
        if (mtd != null) {
            JstFunctionRefType ref = new JstFunctionRefType((IJstMethod)mtd);
            if (this.m_parent instanceof IJstType) {
                ref.setPackage(new JstPackage(((IJstType)this.m_parent).getName()));
            }
            type.addOType((IJstOType)ref);
        }
    }

    private void checkIfTypeExistsForFunction(JstFunctionRefType ref) {
        JstType replaceType = JstCache.getInstance().getType(ref.getName());
        if (replaceType != null) {
            this.m_ctx.addTypeReplacement(replaceType, ref);
        }
    }

    private IJstNode checkForProblemAndProcess(ObjectLiteralField astObjectliteralField) {
        Expression initializer = astObjectliteralField.initializer;
        CategorizedProblem problem = this.findProblemInNode((IASTNode)initializer);
        JstMethod res = null;
        if (problem != null) {
            BaseAst2JstTranslator translator = this.getProblemTranslator((IASTNode)initializer, problem.getSourceStart());
            Object value = translator.translate(initializer);
            this.m_recoveredNodes.addAll(translator.getRecoveredNodes());
            List<IJsCommentMeta> metaArr = this.getCommentMeta(astObjectliteralField);
            if (value instanceof JstMethod) {
                res = this.buildMethod(astObjectliteralField.getFieldName(), (JstMethod)value, true);
            } else {
                JstProperty jstProp = this.buildProperty(astObjectliteralField, (IExpr)value, metaArr);
                ((JstType)this.m_parent).addProperty((IJstProperty)jstProp);
                res = jstProp;
            }
        }
        return res;
    }

    private NV buildNV(ObjectLiteralField astObjectLiteralField, IExpr value, List<IJsCommentMeta> metaArr) {
        JstIdentifier tmp;
        if (value instanceof JstIdentifier) {
            tmp = (JstIdentifier)value;
            if (tmp.getType() == null) {
                tmp.setType(this.getNativeObject());
            }
        } else if (value instanceof FieldAccessExpr && (tmp = (FieldAccessExpr)value).getType() == null) {
            tmp.setType(this.getNativeObject());
        }
        JstIdentifier id = this.createId(astObjectLiteralField);
        NV nv = new NV(id, value);
        return nv;
    }

    private CategorizedProblem findProblemInNode(IASTNode astNode) {
        CategorizedProblem[] problems = this.m_ctx.getAST().compilationResult().getAllProblems();
        if (problems != null) {
            CategorizedProblem[] categorizedProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                CategorizedProblem problem = categorizedProblemArray[n2];
                if (problem.getSourceStart() <= astNode.sourceEnd() && problem.getSourceEnd() >= astNode.sourceStart()) {
                    return problem;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean onlyWhiteSpaces(int startIdx, int endIdx) {
        char[] source = this.m_ctx.getOriginalSource();
        if (startIdx + 1 >= endIdx) {
            return false;
        }
        int i = startIdx + 1;
        while (i < endIdx) {
            if (!Character.isWhitespace(source[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private JstProperty buildProperty(ObjectLiteralField astObjectLiteralField, IExpr value, List<IJsCommentMeta> metaArr) {
        return this.buildProperty(astObjectLiteralField, value, metaArr, null);
    }

    private JstGlobalVar buildGlobalNonFunc(ObjectLiteralField astObjectLiteralField, IExpr value, List<IJsCommentMeta> metaArr, JstType override) {
        JstProperty global = null;
        IJsCommentMeta meta = null;
        if (metaArr != null && metaArr.size() > 0) {
            meta = metaArr.get(0);
        }
        String type = "Object";
        JsTypingMeta typing = null;
        if (meta != null && meta.getTyping() != null) {
            typing = meta.getTyping();
        }
        Object propType = null;
        propType = this.isEnumContext() ? this.m_ctx.getCurrentType() : (override != null ? override : (typing != null ? TranslateHelper.findType(this.m_ctx, typing, meta) : TranslateHelper.findType((IFindTypeSupport)this.m_ctx, type)));
        if (propType == null) {
            int begin = 0;
            int end = 0;
            if (meta != null) {
                begin = meta.getBeginOffset();
                end = typing != null && typing.getTypingToken() != null ? typing.getTypingToken().endOffset : 0;
            }
            this.m_ctx.getErrorReporter().error("Can not find type: " + type + " in type: " + this.m_ctx.getCurrentType().getName(), this.m_ctx.getCurrentType().getName(), begin, end);
        }
        global = new JstProperty((IJstType)propType, astObjectLiteralField.fieldName.toString());
        if (meta != null) {
            JsDocHelper.addJsDoc(meta, global);
        }
        JstCommentLocation comment = this.m_ctx.getCommentCollector().getCommentLocationNonMeta2(astObjectLiteralField.sourceStart);
        global.addCommentLocation(comment);
        value = TranslateHelper.getCastable(value, metaArr, this.m_ctx);
        if (value instanceof ISimpleTerm) {
            global.setValue((ISimpleTerm)value);
        } else if (value instanceof IExpr) {
            global.setInitializer(value);
        } else {
            JstSource source = value.getSource();
            value = new SimpleLiteral(Object.class, this.getNativeObject(), value.toExprText());
            ((SimpleLiteral)value).setSource(source);
            global.setValue((ISimpleTerm)value);
        }
        global.addChild((IJstNode)value);
        global.getName().setSource(TranslateHelper.getSource((IASTNode)astObjectLiteralField.fieldName, this.m_ctx.getSourceUtil()));
        int sourceEnd = value instanceof IJstNode && value.getSource() != null ? value.getSource().getEndOffSet() : astObjectLiteralField.sourceEnd;
        global.setSource(VjoOLFieldTranslator.createSource(astObjectLiteralField.sourceStart, sourceEnd, this.m_ctx.getSourceUtil()));
        if (meta != null) {
            TranslateHelper.setTypeRefSource((BaseJstNode)((JstTypeReference)global.getTypeRef()), meta);
        }
        JstGlobalVar gvar = this.createGlobalVar(value, global, meta);
        gvar.setParent((IJstNode)this.m_parent);
        return gvar;
    }

    private JstGlobalVar createGlobalVar(IExpr value, JstProperty global, IJsCommentMeta meta) {
        JstGlobalProp jstGlobalProp = new JstGlobalProp((IJstProperty)global);
        JstGlobalVar gvar = new JstGlobalVar((IJstGlobalProp)jstGlobalProp);
        gvar.setScopeForGlobal(this.m_ctx.getScopeForGlobals());
        return gvar;
    }

    private JstProperty buildProperty(ObjectLiteralField astObjectLiteralField, IExpr value, List<IJsCommentMeta> metaArr, JstType override) {
        JstCommentLocation location;
        IJsCommentMeta meta = null;
        if (metaArr != null && metaArr.size() > 0) {
            meta = metaArr.get(0);
        }
        boolean isTypeInferred = true;
        String type = "Undefined";
        JsTypingMeta jsTyping = null;
        if (meta != null && (jsTyping = meta.getTyping()) != null) {
            isTypeInferred = false;
        }
        JstType propType = null;
        if (this.isEnumContext()) {
            propType = this.m_ctx.getCurrentType();
            isTypeInferred = false;
        } else if (override != null) {
            propType = override;
            isTypeInferred = false;
        } else {
            propType = jsTyping != null ? TranslateHelper.findType(this.m_ctx, jsTyping, meta) : TranslateHelper.findType((IFindTypeSupport)this.m_ctx, type);
        }
        if (propType == null) {
            int begin = 0;
            int end = 0;
            if (meta != null) {
                begin = meta.getBeginOffset();
                end = jsTyping != null && jsTyping.getTypingToken() != null ? jsTyping.getTypingToken().endOffset : 0;
            }
            this.m_ctx.getErrorReporter().error("Can not find type: " + type + " in type: " + this.m_ctx.getCurrentType().getName(), this.m_ctx.getCurrentType().getName(), begin, end);
        }
        if (isTypeInferred) {
            propType = new JstInferredType((IJstType)propType);
        }
        JstProperty property = new JstProperty((IJstType)propType, astObjectLiteralField.fieldName.toString());
        property.setParent((IJstNode)this.m_parent);
        if (this.m_ctx.getCurrentType().isInterface()) {
            property.getModifiers().setFinal();
        }
        if (this.m_parent instanceof JstObjectLiteralType) {
            property.getModifiers().setPublic();
            if (jsTyping != null) {
                JstObjectLiteralType olType = (JstObjectLiteralType)this.m_parent;
                if (jsTyping.isOptional()) {
                    olType.addOptionalField((IJstProperty)property);
                }
            }
        }
        if ((value = TranslateHelper.getCastable(value, metaArr, this.m_ctx)) instanceof ISimpleTerm) {
            property.setValue((ISimpleTerm)value);
        } else if (value instanceof IExpr) {
            property.setInitializer(value);
        } else {
            JstSource source = value.getSource();
            value = new SimpleLiteral(Object.class, this.getNativeObject(), value.toExprText());
            ((SimpleLiteral)value).setSource(source);
            property.setValue((ISimpleTerm)value);
        }
        property.addChild((IJstNode)value);
        property.getName().setSource(TranslateHelper.getSource((IASTNode)astObjectLiteralField.fieldName, this.m_ctx.getSourceUtil()));
        int sourceEnd = value instanceof IJstNode && value.getSource() != null ? value.getSource().getEndOffSet() : astObjectLiteralField.sourceEnd;
        property.setSource(VjoOLFieldTranslator.createSource(astObjectLiteralField.sourceStart, sourceEnd, this.m_ctx.getSourceUtil()));
        if (this.isEnumContext()) {
            property.getModifiers().setStatic(true);
            property.getModifiers().setPublic();
            property.getModifiers().setFinal();
        }
        if (meta != null) {
            TranslateHelper.setModifiersFromMeta(meta, property.getModifiers());
            TranslateHelper.setTypeRefSource((BaseJstNode)((JstTypeReference)property.getTypeRef()), meta);
            property.addCommentLocation(meta.getBeginOffset(), meta.getEndOffset(), true);
        }
        if ((location = this.m_ctx.getCommentCollector().getCommentLocationNonMeta2(astObjectLiteralField.sourceStart())) != null) {
            property.addCommentLocation(location);
        }
        if (this.m_ctx.getCurrentScope() == ScopeIds.PROPS) {
            property.getModifiers().setStatic(true);
        } else if (this.m_ctx.getCurrentScope() == ScopeIds.PROTOS) {
            property.getModifiers().setStatic(false);
        }
        if (isTypeInferred) {
            JstLiteral val;
            if (property.getInitializer() != null) {
                IExpr initializer = property.getInitializer();
                if (initializer.getResultType() != null) {
                    property.setType((IJstType)new JstInferredType(initializer.getResultType()));
                }
            } else if (property.getValue() != null && property.getValue() instanceof JstLiteral && (val = (JstLiteral)property.getValue()).getResultType() != null) {
                property.setType((IJstType)new JstInferredType(val.getResultType()));
            }
        }
        return property;
    }

    private boolean isEnumContext() {
        return this.m_ctx.getCurrentScope() == ScopeIds.VALUES;
    }

    private List<IJsCommentMeta> getCommentMeta(ObjectLiteralField astObjectLiteralField) {
        return this.m_ctx.getCommentCollector().getCommentMeta(astObjectLiteralField.sourceStart, this.m_ctx.getPreviousNodeSourceEnd(), this.m_ctx.getNextNodeSourceStart());
    }

    private static String getComments(IASTNode ast, TranslateCtx ctx) {
        return ctx.getCommentCollector().getCommentNonMeta2(ast.sourceStart());
    }

    @Override
    protected JstCompletion createCompletion(ObjectLiteralField astObjectLiteralField, boolean isAfterSource) {
        int completionPos = this.m_ctx.getCompletionPos();
        String preStr = new String(this.m_ctx.getOriginalSource(), astObjectLiteralField.sourceStart, completionPos - astObjectLiteralField.sourceStart);
        if (preStr == null) {
            return null;
        }
        String[] strs = (" " + preStr + " ").split(":");
        if (strs.length == 0) {
            return null;
        }
        if (strs.length == 1) {
            String token = strs[0].trim();
            JstFieldOrMethodCompletion completion = new JstFieldOrMethodCompletion((BaseJstNode)this.m_ctx.getCurrentType(), this.m_ctx.getCurrentScope() == ScopeIds.PROPS);
            IExpression expr = astObjectLiteralField.getFieldName();
            JstSource jstSource = null;
            if (expr != null) {
                jstSource = expr.sourceEnd() + 1 > completionPos ? VjoOLFieldTranslator.createSource(expr.sourceStart(), expr.sourceEnd() + 1, this.m_ctx.getSourceUtil()) : VjoOLFieldTranslator.createSource(expr.sourceStart(), completionPos, this.m_ctx.getSourceUtil());
            }
            completion.setSource(jstSource);
            completion.setCompositeToken(preStr);
            completion.setToken(token);
            this.m_ctx.setCreatedCompletion(true);
            completion.setScopeStack(this.m_ctx.getScopeStack());
            return completion;
        }
        if (strs.length == 2) {
            String token = strs[1].trim();
            if (token.indexOf("(") >= 0 || !this.isJavaIdentifier(token)) {
                return null;
            }
            JstCompletionOnSingleNameReference completion = new JstCompletionOnSingleNameReference((BaseJstNode)this.m_ctx.getCurrentType());
            completion.setToken(token);
            this.m_ctx.setCreatedCompletion(true);
            completion.setScopeStack(this.m_ctx.getScopeStack());
            return completion;
        }
        return null;
    }

    private IJstType getNativeObject() {
        return JstCache.getInstance().getType("Object");
    }

    private JstIdentifier createId(ObjectLiteralField astObjectliteralField) {
        JstIdentifier id = new JstIdentifier(astObjectliteralField.getFieldName().toString());
        int startOffset = astObjectliteralField.sourceStart;
        int endOffset = astObjectliteralField.sourceEnd;
        int length = endOffset - startOffset + 1;
        id.setSource(TranslateHelper.createJstSource(this.m_ctx.getSourceUtil(), length, startOffset, endOffset));
        return id;
    }
}

