/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.List;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsCommentMetaNode;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.MethodDeclarationTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnMemberAccess;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstTypeCompletion;

public class FunctionExpressionTranslator
extends BaseAst2JstTranslator<FunctionExpression, FuncExpr> {
    private static final char DOT = '.';
    private static final char LBRACKET = '.';
    private static final String EMPTY = "";
    public static final String DUMMY_METHOD_NAME = "anonymous_function";

    @Override
    protected FuncExpr doTranslate(FunctionExpression astFunctionExpression) {
        return this.doTranslate(astFunctionExpression, null);
    }

    protected FuncExpr doTranslate(FunctionExpression astFunctionExpression, String name) {
        List<IJsCommentMeta> metaArr = this.getCommentMeta(astFunctionExpression);
        if (metaArr != null) {
            MethodDeclaration astMethodDeclaration = astFunctionExpression instanceof FunctionExpression ? astFunctionExpression.getMethodDeclaration() : null;
            JstMethod jstMethod = MethodDeclarationTranslator.createJstMethodFromMethodDeclAst(this.m_ctx, astMethodDeclaration, metaArr, name);
            return this.createFuncExpr(jstMethod, metaArr);
        }
        return null;
    }

    private FuncExpr createFuncExpr(JstMethod jstMethod, List<IJsCommentMeta> metaArr) {
        IJsCommentMeta originalMeta;
        IJstType metaTyping;
        FuncExpr expr = new FuncExpr(jstMethod);
        expr.setType((IJstType)TranslateHelper.createJstFuncType(this.m_ctx, (IJstMethod)jstMethod));
        if (DUMMY_METHOD_NAME.equals(jstMethod.getName().getName()) && metaArr.size() > 0 && (metaTyping = TranslateHelper.findType(this.m_ctx, (originalMeta = metaArr.get(0)).getTyping(), originalMeta)) != null && (metaTyping instanceof JstAttributedType || metaTyping instanceof JstFunctionRefType)) {
            expr.setType(metaTyping);
        }
        JsCommentMetaNode metaJstNode = new JsCommentMetaNode();
        metaJstNode.setJsCommentMetas(metaArr);
        expr.addChild((IJstNode)metaJstNode);
        return expr;
    }

    public static boolean isNotCompleteExpression(TranslateCtx m_ctx, int statEnd) {
        return m_ctx.getOriginalSource()[statEnd] != ';';
    }

    private List<IJsCommentMeta> getCommentMeta(FunctionExpression astFunctionExpression) {
        MethodDeclaration astMethodDeclaration = astFunctionExpression.getMethodDeclaration();
        int next = this.m_ctx.getNextNodeSourceStart();
        if (astMethodDeclaration != null) {
            if (astMethodDeclaration.statements != null && astMethodDeclaration.statements.length > 0) {
                next = astMethodDeclaration.statements[0].sourceStart();
            } else if (next <= 0) {
                next = astFunctionExpression.getMethodDeclaration().bodyEnd;
            }
        }
        return this.m_ctx.getCommentCollector().getCommentMeta(astFunctionExpression.getMethodDeclaration().bodyStart, this.m_ctx.getPreviousNodeSourceEnd(), next);
    }

    @Override
    protected JstCompletion createCompletion(FunctionExpression astNode, boolean isAfterSource) {
        MethodDeclaration astMethodDeclaration = astNode.getMethodDeclaration();
        boolean inBody = astMethodDeclaration.bodyStart <= this.m_ctx.getCompletionPos();
        String token = EMPTY;
        if (!inBody) {
            String preStr = new String(this.m_ctx.getOriginalSource(), astNode.sourceStart, this.m_ctx.getCompletionPos() - astNode.sourceStart);
            if (preStr.indexOf("(") < 0) {
                token = preStr;
            } else {
                return null;
            }
        }
        char c = this.m_ctx.getOriginalSource()[this.m_ctx.getCompletionPos() - 1];
        JstTypeCompletion completion = null;
        JstType type = this.m_ctx.getCurrentType();
        completion = c == '.' ? new JstCompletionOnMemberAccess((BaseJstNode)type) : new JstCompletionOnSingleNameReference((BaseJstNode)type);
        completion.setToken(token);
        this.m_ctx.setCreatedCompletion(true);
        completion.setScopeStack(this.m_ctx.getScopeStack());
        if (inBody) {
            completion.pushScope(ScopeIds.METHOD);
        }
        return completion;
    }
}

