/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.mod.wst.jsdt.core.ast.IArgument;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.core.ast.IStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.EmptyExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.NullLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.UndefinedLiteral;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jsnative.global.Object;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstCommentLocation;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstAnnotation;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncArgAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncScopeAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstModifiers;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstPotentialAttributedMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstPotentialOtypeMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstSynthesizedMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeWithArgs;
import org.eclipse.vjet.dsf.jst.declaration.JstVariantType;
import org.eclipse.vjet.dsf.jst.declaration.JstWildcardType;
import org.eclipse.vjet.dsf.jst.declaration.SynthJstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.SynthJstProxyProp;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.meta.ArgType;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsAnnotation;
import org.eclipse.vjet.dsf.jst.meta.JsCommentMetaNode;
import org.eclipse.vjet.dsf.jst.meta.JsType;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.stmt.BlockStmt;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsAttributed;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsFuncArgAttributedType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsFuncScopeAttributedType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsFuncType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsMixinType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsParam;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsVariantType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.ParseException;
import org.eclipse.vjet.dsf.jstojava.parser.comments.VjComment;
import org.eclipse.vjet.dsf.jstojava.translator.FakeJstWithStmt;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.robust.JstSourceUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.ArgumentTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.OverloadInfo;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.TranslatorFactory;

public class TranslateHelper {
    private static final String EMPTYSTRING = "";
    private static final String COMMA = ",";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final Pattern pattern = Pattern.compile(".[\\s]*");
    public static final String MISSING_TOKEN = "$missing$";
    private static final String DEFAULT_ARG_PREFIX = "p";
    private static final IJsCommentMeta DUMMY_FUNC_META = new IJsCommentMeta(){

        public boolean isMethod() {
            return true;
        }

        public boolean isCast() {
            return false;
        }

        public boolean isAnnotation() {
            return false;
        }

        public JsTypingMeta getTyping() {
            return null;
        }

        public String getName() {
            return TranslateHelper.EMPTYSTRING;
        }

        public JstModifiers getModifiers() {
            return new JstModifiers();
        }

        public int getEndOffset() {
            return 0;
        }

        public IJsCommentMeta.DIRECTION getDirection() {
            return IJsCommentMeta.DIRECTION.FORWARD;
        }

        public String getCommentSrc() {
            return TranslateHelper.EMPTYSTRING;
        }

        public int getBeginOffset() {
            return 0;
        }

        public List<ArgType> getArgs() {
            return Collections.emptyList();
        }

        public JsAnnotation getAnnotation() {
            return null;
        }
    };

    public static String getMethodName(MessageSend el) {
        if (el != null && el.selector != null) {
            IExpression receiver = el.getReceiver();
            if (receiver instanceof MessageSend) {
                return TranslateHelper.getMethodName((MessageSend)receiver);
            }
            return String.valueOf(el.selector);
        }
        return null;
    }

    public static String getStringToken(IProgramElement programElement) {
        String token = null;
        if (programElement instanceof SingleNameReference) {
            token = ((SingleNameReference)programElement).getToken() == null ? new String() : new String(((SingleNameReference)programElement).getToken());
        } else if (programElement instanceof FieldReference) {
            token = ((FieldReference)programElement).token == null ? new String() : new String(((FieldReference)programElement).token);
        } else if (programElement instanceof MessageSend) {
            token = ((MessageSend)programElement).getSelector() == null ? new String() : new String(((MessageSend)programElement).getSelector());
        } else if (programElement instanceof EmptyExpression) {
            token = new String();
        }
        if (token.equals(MISSING_TOKEN)) {
            token = new String();
        }
        return token;
    }

    static boolean isVjoFieldRef(IProgramElement programElement) {
        return programElement instanceof FieldReference && TranslateHelper.getStringToken(programElement).equals("vjo");
    }

    public static JstSource getSource(IASTNode field, IFindTypeSupport.ILineInfoProvider util) {
        if (field instanceof IAbstractVariableDeclaration) {
            return TranslateHelper.getSource((IAbstractVariableDeclaration)field, util);
        }
        return new JstSource(2, util.line(field.sourceStart()), util.col(field.sourceStart()), field.sourceEnd() - field.sourceStart() + 1, field.sourceStart(), field.sourceEnd());
    }

    public static JstSource getSourceFunc(MethodDeclaration field, IFindTypeSupport.ILineInfoProvider util) {
        return new JstSource(2, util.line(field.sourceStart()), util.col(field.sourceStart()), field.bodyStart - field.sourceStart() + 1, field.sourceStart(), field.bodyStart);
    }

    public static JstSource getSource(IAbstractVariableDeclaration field, IFindTypeSupport.ILineInfoProvider util) {
        int sourceEnd = field.sourceEnd();
        AbstractVariableDeclaration aField = (AbstractVariableDeclaration)field;
        int declEnd = aField.declarationEnd;
        int end = sourceEnd > declEnd ? sourceEnd : declEnd;
        return new JstSource(2, util.line(field.sourceStart()), util.col(field.sourceStart()), end - field.sourceStart() + 1, field.sourceStart(), end);
    }

    public static JstSource getIdentifierSource(IAbstractVariableDeclaration field, IFindTypeSupport.ILineInfoProvider util) {
        return new JstSource(2, util.line(field.sourceStart()), util.col(field.sourceStart()), field.sourceEnd() - field.sourceStart() + 1, field.sourceStart(), field.sourceEnd());
    }

    public static JstSource getSource(int fullEnd, int nameLength) {
        return new JstSource(2, -1, -1, nameLength, fullEnd - nameLength + 1, fullEnd);
    }

    public static void setTypeRefSource(BaseJstNode refType, IJsCommentMeta meta) {
        JsTypingMeta typing = meta.getTyping();
        if (typing == null || typing.getTypingToken() == null) {
            return;
        }
        int commentOffset = meta.getBeginOffset() + 1;
        int retTypeBeginOffset = typing.getTypingToken().beginColumn + commentOffset;
        int retTypeEndOffset = typing.getTypingToken().endColumn + commentOffset;
        JstSource source = new JstSource(2, -1, -1, retTypeEndOffset - retTypeBeginOffset + 1, retTypeBeginOffset, retTypeEndOffset);
        if (refType != null) {
            refType.setSource(source);
        }
    }

    public static void setModifiersFromMeta(IJsCommentMeta meta, JstModifiers modifiers) {
        JstModifiers mods = meta.getModifiers();
        modifiers.merge(JstModifiers.getFlag((String)mods.getAccessScope()));
        if (mods.isFinal()) {
            modifiers.merge(16);
        }
        if (mods.isAbstract()) {
            modifiers.merge(1024);
        }
    }

    public static void addSourceInfo(IASTNode field, BaseJstNode jstType, IFindTypeSupport.ILineInfoProvider util) {
        JstSource source = TranslateHelper.getSource(field, util);
        jstType.setSource(source);
    }

    public static JstSource getMethodSource(char[] originalSource, IFindTypeSupport.ILineInfoProvider util, int sourceStart, int sourceEnd, int length) {
        if (originalSource == null) {
            return TranslateHelper.createJstSource(util, sourceEnd - sourceStart + 1, sourceStart, sourceEnd);
        }
        int start = 0;
        int i = sourceStart;
        while (i < sourceEnd) {
            if (!Character.isWhitespace(originalSource[i]) && originalSource[i] != '.') {
                start = i;
                break;
            }
            ++i;
        }
        return TranslateHelper.createJstSource(util, length, start, start + length - 1);
    }

    public static BoolExpr buildCondition(IExpr condition) {
        if (condition instanceof BoolExpr) {
            return (BoolExpr)condition;
        }
        return new BoolExpr(condition);
    }

    public static JstMethod createRealMethod(IExpression fieldName, JstMethod jstMethod, TranslateCtx translateContext) {
        JstMethod newMethod;
        String name = fieldName.toString();
        if (jstMethod == null) {
            return null;
        }
        JstArg[] argsArray = null;
        if (jstMethod.getArgs() != null) {
            List args = jstMethod.getArgs();
            argsArray = args.toArray(new JstArg[args.size()]);
        }
        if (translateContext.getCurrentScope() == ScopeIds.PROTOS && "constructs".equals(name) && !(jstMethod instanceof JstConstructor)) {
            newMethod = new JstConstructor(jstMethod.getModifiers(), argsArray);
            List omtds = jstMethod.getOverloaded();
            if (omtds != null) {
                for (IJstMethod omtd : omtds) {
                    List omargs = omtd.getArgs();
                    JstArg[] omargsArray = omargs.toArray(new JstArg[omargs.size()]);
                    newMethod.addOverloaded((JstMethod)new JstConstructor(omtd.getModifiers(), omargsArray));
                }
            }
            newMethod.setSource(BaseAst2JstTranslator.createSource(fieldName.sourceStart(), jstMethod.getSource().getEndOffSet(), translateContext.getSourceUtil()));
            IJstType retType = jstMethod.getRtnType();
            if (retType != null) {
                newMethod.setRtnType(retType);
                TranslateHelper.setReferenceSource(newMethod, jstMethod.getRtnTypeRef().getSource());
            }
            JstBlock body = newMethod.getBlock(true);
            for (IStmt statement : jstMethod.getBlock(true).getStmts()) {
                body.addStmt(statement);
            }
            List list = jstMethod.getBlock(true).getChildren();
            IJstNode[] jstNodes = list.toArray(new IJstNode[list.size()]);
            int i = 0;
            while (i < jstNodes.length) {
                IJstNode jstNode = jstNodes[i];
                if (jstNode instanceof BaseJstNode) {
                    BaseJstNode node = (BaseJstNode)jstNode;
                    node.setParent((IJstNode)body);
                }
                ++i;
            }
        } else {
            newMethod = jstMethod;
            newMethod.setName(name);
            if (jstMethod.getOverloaded() != null) {
                for (IJstMethod omtd : jstMethod.getOverloaded()) {
                    JstMethod jstMethod2 = (JstMethod)omtd;
                    jstMethod2.setName(name);
                }
            }
            newMethod.getBlock(true);
        }
        newMethod.getName().setSource(TranslateHelper.getSource((IASTNode)fieldName, translateContext.getSourceUtil()));
        return newMethod;
    }

    public static boolean isWhitespacesFollowsDotSeq(char[] chunk) {
        return pattern.matcher(new String(chunk)).find();
    }

    public static boolean isLetter(char c) {
        return c >= 'A' && c <= 'z';
    }

    public static String calculatePrefix(char[] chars, int endPos, int sourceStart) {
        StringBuffer buffer = new StringBuffer();
        while (sourceStart < endPos) {
            char ch = chars[endPos - 1];
            if (ch == '(') break;
            buffer.append(ch);
            --endPos;
        }
        buffer.reverse();
        return buffer.toString();
    }

    public static IJstType findType(IFindTypeSupport findSupport, JsTypingMeta jsTypingMeta, IJsCommentMeta originalMeta) {
        if (jsTypingMeta == null) {
            return null;
        }
        java.lang.Object jstType = null;
        if (jsTypingMeta instanceof JsType) {
            jstType = ((JsType)jsTypingMeta).isAliasRef() ? JstCache.getInstance().getAliasType(jsTypingMeta.getType(), true) : TranslateHelper.findType(findSupport, (JsType)jsTypingMeta);
        } else if (jsTypingMeta instanceof JsFuncType) {
            JsFuncType jsFuncType = (JsFuncType)jsTypingMeta;
            IJstMethod synthesizedFunction = MethodTranslateHelper.createJstSynthesizedMethod(jsFuncType, findSupport, jsFuncType.getFuncName());
            jstType = TranslateHelper.createJstFuncType(findSupport, synthesizedFunction);
        } else if (jsTypingMeta instanceof JsAttributed) {
            JsAttributed jsAttributed = (JsAttributed)jsTypingMeta;
            JsType attributor = jsAttributed.getAttributor();
            IJstType attributorType = attributor == null ? TranslateHelper.getGlobalType() : TranslateHelper.findType(findSupport, (JsTypingMeta)attributor, originalMeta);
            String attributeName = jsAttributed.getName();
            if (MISSING_TOKEN.equals(attributeName) && originalMeta != null) {
                IJstType translatingType = findSupport.getCurrentType();
                findSupport.getErrorReporter().error("Cannot translate attributed meta: " + jsTypingMeta + " to attributed type declaration " + " in " + TranslateHelper.class, translatingType != null ? translatingType.getName() : "unknown type", originalMeta.getBeginOffset(), originalMeta.getEndOffset(), findSupport.getLineInfoProvider().line(originalMeta.getBeginOffset()), findSupport.getLineInfoProvider().col(originalMeta.getBeginOffset()));
            } else {
                boolean isStatic = !jsAttributed.isInstance();
                jstType = new JstAttributedType(attributorType, attributeName, isStatic);
            }
        } else if (jsTypingMeta instanceof JsVariantType) {
            jstType = TranslateHelper.findType(findSupport, (JsVariantType)jsTypingMeta);
        } else if (jsTypingMeta instanceof JsMixinType) {
            jstType = TranslateHelper.findType(findSupport, (JsMixinType)jsTypingMeta);
        } else if (jsTypingMeta instanceof JsFuncScopeAttributedType) {
            jstType = TranslateHelper.findType(findSupport, (JsFuncScopeAttributedType)jsTypingMeta);
        } else if (jsTypingMeta instanceof JsFuncArgAttributedType) {
            jstType = TranslateHelper.findType(findSupport, (JsFuncArgAttributedType)jsTypingMeta);
        }
        if (jstType == null) {
            return null;
        }
        int dimension = jsTypingMeta.getDimension();
        if (dimension > 0) {
            IJstType arrayType = jstType;
            int i = 0;
            int d = dimension;
            while (i < d) {
                arrayType = new JstArray(arrayType);
                ++i;
            }
            jstType = arrayType;
        }
        return jstType;
    }

    private static IJstType findType(IFindTypeSupport findSupport, JsType typing) {
        IJstType jstType = TranslateHelper.findType(findSupport, typing.getType());
        if (typing.getArgs().size() > 0) {
            JstTypeWithArgs typeWithArgs = new JstTypeWithArgs(jstType);
            TranslateHelper.addArgsToType(findSupport, typeWithArgs, typing);
            jstType = typeWithArgs;
        }
        if (typing.isTypeRef()) {
            jstType = JstTypeHelper.getJstTypeRefType((IJstType)jstType);
        }
        return jstType;
    }

    private static IJstType findType(IFindTypeSupport findSupport, JsVariantType typing) {
        ArrayList<IJstType> types = new ArrayList<IJstType>(3);
        for (JsTypingMeta t : typing.getTypes()) {
            types.add(TranslateHelper.findType(findSupport, t, null));
        }
        return new JstVariantType(types);
    }

    private static IJstType findType(IFindTypeSupport findSupport, JsMixinType typing) {
        ArrayList<IJstType> types = new ArrayList<IJstType>(3);
        for (JsTypingMeta t : typing.getTypes()) {
            types.add(TranslateHelper.findType(findSupport, t, null));
        }
        return new JstMixedType(types);
    }

    private static IJstType findType(IFindTypeSupport findSupport, JsFuncScopeAttributedType typing) {
        return new JstFuncScopeAttributedType();
    }

    private static IJstType findType(IFindTypeSupport findSupport, JsFuncArgAttributedType typing) {
        return new JstFuncArgAttributedType(typing.getArgIndex());
    }

    public static JstFuncType createJstFuncType(IFindTypeSupport ctx, IJstMethod synthesizedFunction) {
        return new JstFuncType(synthesizedFunction);
    }

    public static IJstType findType(IFindTypeSupport findSupport, String name) {
        if ((name = name.trim()).equals(EMPTYSTRING)) {
            return null;
        }
        IJstType type = null;
        int start = name.indexOf(LT);
        if (start > 1 && name.charAt(name.length() - 1) == '>') {
            try {
                JsCommentMeta commentMeta = VjComment.parse("//<" + name);
                JsTypingMeta typingMeta = commentMeta.getTyping();
                return TranslateHelper.findType(findSupport, typingMeta, commentMeta);
            }
            catch (ParseException parseException) {
                name = name.substring(0, start);
            }
        }
        if ((type = TranslateHelper.findTypeRefInCurrentType(findSupport, name)) == null && findSupport != null) {
            type = TranslateHelper.findKnownType(findSupport.getCurrentType(), name);
        }
        if (name.equals("java.lang.String")) {
            type = JstCache.getInstance().getType(null, "String");
            return type;
        }
        if (name.startsWith("js.")) {
            String suffix = name.substring(name.indexOf("js.") + 3);
            type = JstCache.getInstance().getType(null, suffix);
        }
        if (type == null) {
            String fullyQualifiedName = name;
            if (findSupport != null) {
                fullyQualifiedName = TranslateHelper.getFullyQualifiedName(findSupport.getCurrentType(), name);
            }
            type = JstFactory.getInstance().createJstType(fullyQualifiedName, true);
        }
        return type;
    }

    private static IJstType findTypeRefInCurrentType(IFindTypeSupport findSupport, String longname) {
        if (findSupport == null) {
            return null;
        }
        return findSupport.findTypeByName(longname);
    }

    protected static IJstType findInnerOrOType(IJstType parentType, String longName) {
        if (longName == null || longName.length() == 0) {
            return null;
        }
        int firstDotIdx = longName.indexOf(46);
        String shortName = null;
        shortName = firstDotIdx == -1 ? longName : longName.substring(0, firstDotIdx);
        if (shortName != null && shortName.length() != 0) {
            IJstOType subType = parentType.getOType(shortName);
            if (subType == null) {
                subType = parentType.getEmbededType(shortName);
            }
            if (subType != null) {
                if (firstDotIdx == -1) {
                    return subType;
                }
                if (firstDotIdx + 1 < longName.length()) {
                    return TranslateHelper.findInnerOrOType((IJstType)subType, longName.substring(firstDotIdx + 1));
                }
            }
        }
        return null;
    }

    protected static IJstType findOuterType(IJstType currentType, String name) {
        if (currentType == null || name == null) {
            return null;
        }
        if (name.equals(currentType.getSimpleName())) {
            return currentType;
        }
        if (currentType.getOType(name) != null) {
            return currentType.getOType(name);
        }
        for (IJstType importedType : currentType.getImports()) {
            if (name.equals(importedType.getSimpleName())) {
                return importedType;
            }
            if (!name.equals(importedType.getAlias())) continue;
            return importedType;
        }
        for (IJstType importedType : currentType.getSatisfies()) {
            if (name.equals(importedType.getSimpleName())) {
                return importedType;
            }
            if (!name.equals(importedType.getAlias())) continue;
            return importedType;
        }
        for (IJstType importedType : currentType.getExtends()) {
            if (name.equals(importedType.getSimpleName())) {
                return importedType;
            }
            if (!name.equals(importedType.getAlias())) continue;
            return importedType;
        }
        for (IJstType importedType : currentType.getInactiveImports()) {
            if (name.equals(importedType.getSimpleName())) {
                return importedType;
            }
            if (!name.equals(importedType.getAlias())) continue;
            return importedType;
        }
        return null;
    }

    private static String getFullyQualifiedName(IJstType currentType, String name) {
        if (currentType instanceof IJstOType) {
            currentType = (JstType)currentType.getParentNode();
        }
        int start = name.indexOf(".");
        String simpleName = name;
        if (start != -1) {
            String[] names = name.split("\\.");
            String outerTypeName = names[0];
            simpleName = names[0];
            IJstType outerType = currentType;
            IJstType type = null;
            while (outerType != null) {
                type = TranslateHelper.findOuterType(outerType, outerTypeName);
                if (type != null) {
                    String fullyQualifiedName = type.getName();
                    return String.valueOf(fullyQualifiedName) + name.substring(start);
                }
                outerType = outerType.getOuterType();
            }
        }
        if (currentType != null) {
            IJstType innerType = currentType.getEmbededType(simpleName);
            if (innerType == null) {
                innerType = currentType.getOType(simpleName);
            }
            if (innerType != null) {
                return String.valueOf(currentType.getName()) + "." + name;
            }
        }
        return name;
    }

    private static IJstType getParamType(IJstType ownerType, String name) {
        if (name == null) {
            throw new IllegalArgumentException("param type's name shouldn't be null");
        }
        JstParamType paramType = null;
        List m_paramTypes = ownerType.getParamTypes();
        if (m_paramTypes != null) {
            for (JstParamType it : m_paramTypes) {
                if (!it.getName().equals(name)) continue;
                paramType = it;
                break;
            }
        }
        if (paramType == null && ownerType.isEmbededType()) {
            return TranslateHelper.getParamType(ownerType.getOuterType(), name);
        }
        return paramType;
    }

    private static IJstType findKnownType(IJstType currentType, String name) {
        String longName;
        IJstType otype;
        IJstType paramType;
        IJstType type = null;
        if (currentType instanceof IJstOType) {
            currentType = (JstType)currentType.getParentNode();
        }
        if (currentType != null && (paramType = TranslateHelper.getParamType(currentType, name)) != null) {
            return paramType;
        }
        String[] names = name.split("\\.");
        if (name.indexOf(".") == -1) {
            if (currentType != null && (type = TranslateHelper.findOuterType(currentType, name)) != null) {
                return type;
            }
        } else if (currentType != null && names.length == 2 && (otype = TranslateHelper.getTypeFromInactive(name, currentType)) != null) {
            return otype;
        }
        if ((longName = JstCache.getInstance().getTypeSymbolMapping(name)) != null && longName.length() > 0) {
            name = longName;
        }
        type = JstCache.getInstance().getType(TranslateHelper.getFullyQualifiedName(currentType, name));
        return type;
    }

    public static IJstTypeReference getType(TranslateCtx ctx, Literal literal) {
        assert (literal != null);
        String typeName = JstUtil.getCorrectName(literal);
        JstSource source = new JstSource(2, -1, -1, typeName.length(), literal.sourceStart + 1, literal.sourceStart + typeName.length());
        return TranslateHelper.getType(ctx, typeName, source);
    }

    public static IJstTypeReference getType(TranslateCtx ctx, String typeName, JstSource source) {
        IJstType type = TranslateHelper.getJstType(TranslateHelper.findType((IFindTypeSupport)ctx, typeName));
        return TranslateHelper.createRef(type, source);
    }

    public static IJsCommentMeta getMatchingMetaWithAstFunction(List<IJsCommentMeta> metaArr, Expression astFunctionExpression) {
        if (astFunctionExpression instanceof FunctionExpression) {
            for (IJsCommentMeta meta : metaArr) {
                IArgument[] astArgs = ((FunctionExpression)astFunctionExpression).getMethodDeclaration().getArguments();
                List<JsParam> metaArgs = TranslateHelper.getParams(meta);
                if (astArgs == null && (metaArgs == null || metaArgs.size() == 0)) {
                    return meta;
                }
                if (astArgs == null || metaArgs == null || astArgs.length != metaArgs.size()) continue;
                return meta;
            }
        }
        IJsCommentMeta maxMeta = null;
        int maxParamCount = 0;
        List<JsParam> params = null;
        for (IJsCommentMeta meta : metaArr) {
            if (maxMeta == null) {
                maxMeta = meta;
                params = TranslateHelper.getParams(meta);
                if (params == null) continue;
                maxParamCount = params.size();
                continue;
            }
            params = TranslateHelper.getParams(meta);
            if (params.size() <= maxParamCount) continue;
            maxParamCount = params.size();
            maxMeta = meta;
        }
        return maxMeta;
    }

    public static OverloadInfo determineOverloadCount(List<JsParam> params) {
        OverloadInfo info = new OverloadInfo();
        if (params == null) {
            return info;
        }
        int optionalCount = 0;
        int reqCount = 0;
        for (JsParam p : params) {
            if (p.isOptional()) {
                ++optionalCount;
                continue;
            }
            ++reqCount;
        }
        if (optionalCount > 0) {
            info.requiredParams = reqCount;
            info.totalOverloads = reqCount + optionalCount + 1;
        }
        return info;
    }

    private static void fixModifiersForDispatchMethod(JstMethod jstMethod) {
        if (jstMethod.isDispatcher()) {
            JstModifiers dispatcherModifiers = jstMethod.getModifiers();
            for (IJstMethod overload : jstMethod.getOverloaded()) {
                dispatcherModifiers.merge(overload.getModifiers().getFlags());
            }
        }
    }

    private static void fixRtnTypeForDispatchMethod(JstMethod jstMethod) {
        if (jstMethod.isDispatcher()) {
            for (IJstMethod overload : jstMethod.getOverloaded()) {
                if (overload.getRtnType() == null) continue;
                jstMethod.setRtnType(overload.getRtnType());
                break;
            }
        }
    }

    public static void fixArgsForDispatchMethod(JstMethod jstMethod) {
        int i = 0;
        while (i < jstMethod.getArgs().size()) {
            JstArg arg = (JstArg)jstMethod.getArgs().get(i);
            ArrayList<IJstTypeReference> types = new ArrayList<IJstTypeReference>();
            for (IJstMethod mtd : jstMethod.getOverloaded()) {
                JstArg a;
                if (i >= mtd.getArgs().size() || TranslateHelper.doesTypeExist(types, (a = (JstArg)mtd.getArgs().get(i)).getTypeRef().getReferencedType())) continue;
                types.add(a.getTypeRef());
            }
            if (!types.isEmpty()) {
                arg.clearTypes();
                arg.addTypesRefs(types);
            }
            ++i;
        }
        boolean olRetTypeSame = true;
        boolean optionalReturn = false;
        IJstType rtnType = null;
        for (IJstMethod mtd : jstMethod.getOverloaded()) {
            if (mtd.isReturnTypeOptional()) {
                optionalReturn = true;
            }
            IJstType currType = mtd.getRtnType();
            if (rtnType != null && currType != null && !rtnType.getName().equals(currType.getName())) {
                olRetTypeSame = false;
                break;
            }
            rtnType = currType;
        }
        jstMethod.setReturnOptional(optionalReturn);
        if (olRetTypeSame && rtnType != null) {
            jstMethod.setRtnType(rtnType);
        } else {
            jstMethod.setRtnType(null);
        }
    }

    private static boolean doesTypeExist(List<IJstTypeReference> types, IJstType jstType) {
        int i = 0;
        while (i < types.size()) {
            if (jstType.getName() != null && jstType.getName().equals(types.get(i).getReferencedType().getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static JstFuncType replaceSynthesizedMethodBinding(JstIdentifier jstIdentifier, IJstMethod replacement) {
        jstIdentifier.setJstBinding((IJstNode)replacement);
        jstIdentifier.addChild((IJstNode)replacement);
        JstFuncType jstFuncType = new JstFuncType(replacement);
        jstIdentifier.setType((IJstType)jstFuncType);
        return jstFuncType;
    }

    private static List<String> splitParamTypeNames(String paramTypeNames) {
        StringTokenizer tokens = new StringTokenizer(paramTypeNames, "<>,", true);
        ArrayList<String> typeNames = new ArrayList<String>();
        int level = 0;
        StringBuffer typeName = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (level == 0 && COMMA.equals(token)) {
                typeNames.add(typeName.toString());
                typeName = new StringBuffer();
                continue;
            }
            typeName.append(token);
            if (LT.equals(token)) {
                ++level;
                continue;
            }
            if (!GT.equals(token)) continue;
            --level;
        }
        if (level == 0) {
            typeNames.add(typeName.toString());
        }
        return typeNames;
    }

    public static void addParamsToType(TranslateCtx ctx, JstType type, String params) {
        if (params == null || EMPTYSTRING.equals(params)) {
            return;
        }
        String[] pArr = params.split(COMMA);
        int i = 0;
        while (i < pArr.length) {
            String param = pArr[i];
            String[] name = param.split(" extends ");
            if (name.length == 1) {
                type.addParam(param);
            } else if (name.length == 2) {
                JstParamType ptype = type.addParam(name[0]);
                ptype.addBound((IJstType)new JstParamType(name[1]));
            }
            ++i;
        }
    }

    public static void addParamsToType(TranslateCtx ctx, JstType type, JsType jsType) {
        if (jsType != null && jsType.getArgs().size() > 0) {
            for (ArgType arg : jsType.getArgs()) {
                JstWildcardType wildcard;
                JstParamType ptype = type.addParam(arg.getName());
                if (arg.getWildCardType() == ArgType.WildCardType.EXTENDS) {
                    wildcard = new JstWildcardType((IJstType)JstFactory.getInstance().createJstType(arg.getFamily().getType(), true));
                    ptype.addBound((IJstType)wildcard);
                    continue;
                }
                if (arg.getWildCardType() != ArgType.WildCardType.SUPER) continue;
                wildcard = new JstWildcardType((IJstType)JstFactory.getInstance().createJstType(arg.getFamily().getType(), true), false);
                ptype.addBound((IJstType)wildcard);
            }
        }
    }

    @Deprecated
    public static IExpr getCastable(IExpr expr, IStatement realExpr, TranslateCtx ctx) {
        return TranslateHelper.getCastable(expr, realExpr.sourceStart(), realExpr.sourceEnd(), ctx.getPreviousNodeSourceEnd(), ctx.getNextNodeSourceStart(), ctx);
    }

    public static IExpr getCastable(IExpr expr, IStatement realExpr, int prev, int next, TranslateCtx ctx) {
        return TranslateHelper.getCastable(expr, realExpr.sourceStart(), realExpr.sourceEnd(), prev, next, ctx);
    }

    public static List<IJsCommentMeta> findMetaFromExpr(BaseJstNode expr) {
        for (IJstNode child : expr.getChildren()) {
            if (!(child instanceof JsCommentMetaNode)) continue;
            return ((JsCommentMetaNode)child).getJsCommentMetas();
        }
        return null;
    }

    public static IExpr getCastable(IExpr expr, int start, int end, int prev, int next, TranslateCtx ctx) {
        List<IJsCommentMeta> metaList = ctx.getCommentCollector().getCommentMeta(start, end, prev, next);
        return TranslateHelper.getCastable(expr, metaList, ctx);
    }

    public static IExpr getCastable(IExpr expr, List<IJsCommentMeta> metaList, TranslateCtx ctx) {
        IJsCommentMeta originalMeta;
        if (metaList.size() > 0 && metaList.get(0).isCast() && (originalMeta = metaList.get(0)) != null) {
            if (originalMeta.getTyping() != null) {
                return (IExpr)TranslateHelper.attachMeta((BaseJstNode)new CastExpr(expr, TranslateHelper.findType(TranslateHelper.fromCtx(ctx), originalMeta.getTyping(), originalMeta)), metaList, ctx);
            }
            return (IExpr)TranslateHelper.attachMeta((BaseJstNode)new CastExpr(expr), metaList, ctx);
        }
        return expr instanceof BaseJstNode ? (IExpr)TranslateHelper.attachMeta((BaseJstNode)expr, metaList, ctx) : expr;
    }

    public static IFindTypeSupport fromCtx(TranslateCtx ctx) {
        return ctx;
    }

    public static JsCommentMetaNode getJsCommentMetaNode(IJstNode node) {
        if (node != null) {
            for (IJstNode child : node.getChildren()) {
                if (child == null || !(child instanceof JsCommentMetaNode)) continue;
                return (JsCommentMetaNode)child;
            }
        }
        return null;
    }

    public static BaseJstNode attachMeta(BaseJstNode node, List<IJsCommentMeta> metaList, TranslateCtx ctx) {
        if (node != null && metaList != null && metaList.size() > 0) {
            JsCommentMetaNode commentMetaNode = TranslateHelper.getJsCommentMetaNode((IJstNode)node);
            if (commentMetaNode == null) {
                commentMetaNode = new JsCommentMetaNode();
                node.addChild((IJstNode)commentMetaNode);
            }
            commentMetaNode.setJsCommentMetas(metaList);
            int beginOffset = -1;
            int endOffset = -1;
            for (IJsCommentMeta meta : metaList) {
                beginOffset = beginOffset < 0 ? meta.getBeginOffset() : (meta.getBeginOffset() < beginOffset ? meta.getBeginOffset() : beginOffset);
                int n = endOffset = meta.getEndOffset() > endOffset ? meta.getEndOffset() : endOffset;
            }
            JstSource source = TranslateHelper.createJstSource(ctx.getSourceUtil(), endOffset - beginOffset, beginOffset, endOffset);
            commentMetaNode.setSource(source);
        }
        return node;
    }

    private static void addArgsToType(IFindTypeSupport findSupport, JstTypeWithArgs type, JsType jsType) {
        if (jsType != null && jsType.getArgs().size() > 0) {
            for (ArgType arg : jsType.getArgs()) {
                if (arg.getWildCardType() == ArgType.WildCardType.EXTENDS) {
                    type.addArgType((IJstType)new JstWildcardType(TranslateHelper.findType(findSupport, arg.getFamily().getType()), true));
                    continue;
                }
                if (arg.getWildCardType() == ArgType.WildCardType.SUPER) {
                    type.addArgType((IJstType)new JstWildcardType(TranslateHelper.findType(findSupport, arg.getFamily().getType()), false));
                    continue;
                }
                if (arg.getType() == null) {
                    type.addArgType((IJstType)new JstWildcardType(null));
                    continue;
                }
                type.addArgType(TranslateHelper.findType(findSupport, arg.getType(), null));
            }
        }
    }

    public static JstTypeWithArgs getJstWithArgs(IFindTypeSupport ctx, IJstType type, String params) {
        if (params == null || EMPTYSTRING.equals(params)) {
            return null;
        }
        JstTypeWithArgs jstType = new JstTypeWithArgs(type);
        List<String> plist = TranslateHelper.splitParamTypeNames(params);
        for (String param : plist) {
            boolean isUpper = param.contains(" extends ");
            boolean isLower = param.contains(" super ");
            if (isUpper || isLower) {
                String[] name;
                String[] stringArray = name = isUpper ? param.split(" extends ") : param.split(" super ");
                if ("?".equals(name[0].trim())) {
                    jstType.addArgType((IJstType)new JstWildcardType(TranslateHelper.findType(ctx, name[1]), isUpper));
                    continue;
                }
                JstParamType pType = new JstParamType(name[0]);
                pType.addBound((IJstType)new JstWildcardType(TranslateHelper.findType(ctx, name[1]), isUpper));
                jstType.addArgType((IJstType)pType);
                continue;
            }
            jstType.addArgType(TranslateHelper.findType(ctx, param));
        }
        return jstType;
    }

    public static void addStatementsToJstBlock(Statement[] statements, JstBlock jstBlock, int sourceEnd, TranslateCtx ctx) {
        if (statements == null) {
            return;
        }
        int i = 0;
        int len = statements.length;
        while (i < len) {
            Statement astStatement = statements[i];
            if (i + 1 < len) {
                ctx.setNextNodeSourceStart(statements[i + 1].sourceStart);
            } else {
                ctx.setNextNodeSourceStart(sourceEnd);
            }
            BaseAst2JstTranslator translator = TranslatorFactory.getTranslator((IASTNode)astStatement, ctx);
            translator.setParent((BaseJstNode)jstBlock);
            java.lang.Object result = translator.translate(astStatement);
            if (result instanceof BaseJstNode[]) {
                BaseJstNode[] baseJstNodeArray = (BaseJstNode[])result;
                int n = baseJstNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseJstNode node = baseJstNodeArray[n2];
                    TranslateHelper.handleResult(jstBlock, ctx, (IStatement)astStatement, node);
                    ++n2;
                }
            } else {
                TranslateHelper.handleResult(jstBlock, ctx, (IStatement)astStatement, result);
            }
            ++i;
        }
    }

    private static void handleResult(JstBlock jstBlock, TranslateCtx ctx, IStatement astStatement, java.lang.Object result) {
        if (result instanceof BaseJstNode) {
            BaseJstNode baseNode = (BaseJstNode)result;
            if (baseNode.getSource() == null) {
                baseNode.setSource(TranslateHelper.getSource((IASTNode)astStatement, ctx.getSourceUtil()));
            }
            TranslateHelper.createJsAnnotations(result, astStatement, ctx);
        }
        if (result instanceof IStmt) {
            jstBlock.addStmt((IStmt)result);
        } else if (result instanceof IExpr) {
            if (result instanceof JstIdentifier) {
                JstIdentifier id = (JstIdentifier)result;
                List<IJsCommentMeta> metaList = ctx.getCommentCollector().getCommentMeta(id.getSource().getStartOffSet(), id.getSource().getEndOffSet(), ctx.getPreviousNodeSourceEnd(), ctx.getNextNodeSourceStart());
                TranslateHelper.attachMeta((BaseJstNode)id, metaList, ctx);
            }
            jstBlock.addStmt((IStmt)new ExprStmt((IExpr)result));
        } else if (result instanceof FakeJstWithStmt) {
            for (IStmt statement : ((FakeJstWithStmt)result).getStatements()) {
                jstBlock.addStmt(statement);
            }
        } else if (result instanceof JstMethod) {
            jstBlock.addStmt((IStmt)new ExprStmt((IExpr)new FuncExpr((JstMethod)result)));
        } else if (result instanceof JstBlock) {
            jstBlock.addStmt((IStmt)new BlockStmt((JstBlock)result));
        } else if (result instanceof BaseJstNode) {
            BaseJstNode node = (BaseJstNode)result;
            node.setParent((IJstNode)jstBlock);
        }
        ctx.setPreviousNodeSourceEnd(astStatement.sourceEnd());
    }

    private static void createJsAnnotations(java.lang.Object result, IStatement statement, TranslateCtx ctx) {
        JsAnnotation jsAnnotation = TranslateHelper.getJsAnnotation(statement, ctx);
        if (jsAnnotation == null) {
            return;
        }
        if (result == null) {
            return;
        }
        if (!(result instanceof BaseJstNode)) {
            return;
        }
        if (jsAnnotation.isSupressTypeCheck()) {
            JstAnnotation jstAnno = new JstAnnotation();
            jstAnno.setName(JsAnnotation.JsAnnotationType.SUPRESSTYPECHECK.toString());
            ((BaseJstNode)result).addAnnotation(jstAnno);
        }
    }

    private static JsAnnotation getJsAnnotation(IStatement statement, TranslateCtx ctx) {
        List<IJsCommentMeta> annotationMeta = null;
        annotationMeta = ctx.getCommentCollector().getAnnotationMeta(statement.sourceStart(), ctx.getPreviousNodeSourceEnd(), ctx.getNextNodeSourceStart());
        if (annotationMeta.isEmpty()) {
            return null;
        }
        return annotationMeta.get(0).getAnnotation();
    }

    public static JstTypeReference createRef(IJstType extendedType, JstSource source) {
        JstTypeReference reference = new JstTypeReference(extendedType);
        reference.setSource(source);
        return reference;
    }

    public static void setReferenceSource(JstProperty method, JstSource source) {
        ((JstTypeReference)method.getTypeRef()).setSource(source);
    }

    public static void setReferenceSource(JstMethod property, JstSource source) {
        ((JstTypeReference)property.getRtnTypeRef()).setSource(source);
    }

    public static void setReferenceSource(JstMethod method, IJsCommentMeta meta) {
        BaseJstNode reference = (BaseJstNode)method.getRtnTypeRef();
        TranslateHelper.setTypeRefSource(reference, meta);
    }

    public static void setReferenceSource(JstProperty property, JsCommentMeta meta) {
        JstTypeReference reference = (JstTypeReference)property.getTypeRef();
        TranslateHelper.setTypeRefSource((BaseJstNode)reference, meta);
    }

    public static JstArg createJstArg(JstMethod jstMethod, String argName, JsParam param, IJsCommentMeta meta, TranslateCtx ctx) {
        ArrayList<JsTypingMeta> types = new ArrayList<JsTypingMeta>(param.getTypes());
        boolean isOpt = param.isOptional();
        boolean isVar = param.isVariable();
        boolean isFinal = param.isFinal();
        JstSource source = null;
        if (meta != null && ctx != null) {
            int commentOffset = meta.getBeginOffset() + 1;
            int startOffset = commentOffset + param.getBeginColumn();
            int endOffset = commentOffset + param.getEndColumn();
            int length = endOffset - startOffset + 1;
            source = TranslateHelper.createJstSource(ctx.getSourceUtil(), length, startOffset, endOffset);
        }
        ArrayList<JstTypeReference> jstTypes = new ArrayList<JstTypeReference>();
        if (types.isEmpty()) {
            JstType argType = JstCache.getInstance().getType("Object");
            JstTypeReference reference = TranslateHelper.createRef((IJstType)argType, null);
            reference.setSource(null);
            jstTypes.add(reference);
        } else {
            for (JsTypingMeta pType : types) {
                JstTypeReference reference = null;
                JstParamType paramType = jstMethod.getParamType(pType.getType());
                if (paramType != null) {
                    reference = TranslateHelper.createRef((IJstType)paramType, null);
                    reference.setSource(source);
                    jstTypes.add(reference);
                    reference = TranslateHelper.createRef((IJstType)paramType, null);
                    continue;
                }
                IJstType argType = TranslateHelper.findType(ctx, pType, meta);
                reference = TranslateHelper.createRef(argType, null);
                reference.setSource(null);
                jstTypes.add(reference);
            }
        }
        if (argName == null) {
            argName = param.getName();
        }
        JstArg arg = new JstArg(jstTypes, 0, argName, isVar, isOpt, isFinal);
        arg.setSource(source);
        return arg;
    }

    public static JstArg createJstArg(JstMethod jstMethod, String argName, IASTNode argSource, IJsCommentMeta meta, int argIndex, IFindTypeSupport ctx) {
        List<JsParam> params;
        List<java.lang.Object> types = new ArrayList();
        JstSource source = null;
        boolean isOpt = false;
        boolean isVar = false;
        boolean isFinal = false;
        if (meta != null && (params = TranslateHelper.getParams(meta)) != null && params.size() > argIndex) {
            JsParam jsParam = params.get(argIndex);
            types = jsParam.getTypes();
            isOpt = jsParam.isOptional();
            isVar = jsParam.isVariable();
            isFinal = jsParam.isFinal();
            if (ctx != null) {
                int commentOffset = meta.getBeginOffset() + 1;
                int startOffset = commentOffset + jsParam.getBeginColumn();
                int endOffset = commentOffset + jsParam.getEndColumn();
                int length = endOffset - startOffset + 1;
                source = TranslateHelper.createJstSource(ctx.getLineInfoProvider(), length, startOffset, endOffset);
            }
        }
        ArrayList<JstTypeReference> jstTypes = new ArrayList<JstTypeReference>();
        if (types.isEmpty()) {
            JstType argType = JstCache.getInstance().getType("Undefined");
            JstTypeReference reference = TranslateHelper.createRef((IJstType)argType, source);
            reference.setSource(source);
            jstTypes.add(reference);
        } else {
            for (JsTypingMeta pType : types) {
                JstParamType paramType = jstMethod.getParamType(pType.getType());
                if (paramType != null) {
                    JstTypeReference reference = TranslateHelper.createRef((IJstType)paramType, source);
                    reference.setSource(source);
                    jstTypes.add(reference);
                    continue;
                }
                IJstType argType = TranslateHelper.findType(ctx, pType, meta);
                JstTypeReference reference = TranslateHelper.createRef(argType, source);
                reference.setSource(source);
                jstTypes.add(reference);
            }
        }
        if (argName == null && meta != null) {
            argName = TranslateHelper.getParams(meta).get(argIndex).getName();
        }
        JstArg arg = new JstArg(jstTypes, 0, argName, isVar, isOpt, isFinal);
        if (argSource != null) {
            arg.setSource(TranslateHelper.getSource(argSource, ctx.getLineInfoProvider()));
        } else {
            arg.setSource(source);
        }
        return arg;
    }

    public static JstSource createJstSource(JstSourceUtil util, int length, int startOffset, int endOffset) {
        int line = util.line(startOffset);
        int col = util.col(startOffset);
        return new JstSource(2, line, col, length, startOffset, endOffset);
    }

    public static JstSource createJstSource(IFindTypeSupport.ILineInfoProvider provider, int length, int startOffset, int endOffset) {
        return new JstSource(2, provider.line(startOffset), provider.col(startOffset), length, startOffset, endOffset);
    }

    public static IJstType getJstType(IJstType type) {
        IJstType jstType = type;
        while (jstType != null) {
            if (jstType instanceof IJstRefType || !(jstType instanceof JstProxyType)) break;
            jstType = ((JstProxyType)jstType).getType();
        }
        return jstType;
    }

    public static IJstType getGlobalType() {
        JstType globalJstType = JstCache.getInstance().getType("Global");
        if (globalJstType == null) {
            globalJstType = JstFactory.getInstance().createJstType("Global", true);
        }
        return globalJstType;
    }

    public static IJstType getObjectType() {
        JstType functionJstType = JstCache.getInstance().getType("Object");
        if (functionJstType == null) {
            functionJstType = JstFactory.getInstance().createJstType("Object", true);
        }
        return functionJstType;
    }

    public static IJstType getFunctionType() {
        JstType functionJstType = JstCache.getInstance().getType("Function");
        if (functionJstType == null) {
            functionJstType = JstFactory.getInstance().createJstType("Function", true);
        }
        return functionJstType;
    }

    public static IJstType getTypeFromInactive(String typeName, IJstType type) {
        String[] names = typeName.split("\\.");
        if (names.length == 2) {
            List types = type.getInactiveImports();
            if (type.isOType() && names[0].equals(type.getSimpleName()) && type.getOType(names[1]) != null) {
                return type.getOType(names[1]);
            }
            IJstType otype = TranslateHelper.getOTypeFromInactive(names, types);
            if (otype != null) {
                return otype;
            }
            for (IJstTypeReference mixin : type.getMixinsRef()) {
                otype = TranslateHelper.getOTypeFromInactive(names, mixin.getReferencedType().getInactiveImports());
                if (otype == null) continue;
                return otype;
            }
        }
        return null;
    }

    private static IJstType getOTypeFromInactive(String[] names, List<? extends IJstType> types) {
        for (IJstType iJstType : types) {
            if (!names[0].equals(iJstType.getSimpleName()) || iJstType.getOType(names[1]) == null) continue;
            return iJstType.getOType(names[1]);
        }
        return null;
    }

    public static JstType getNativeJsObject() {
        return JstCache.getInstance().getType(Object.class.getSimpleName());
    }

    public static boolean isArgsMatch(IArgument[] astArgs, List<JsParam> metaArgs) {
        if (astArgs == null) {
            return metaArgs.size() == 0;
        }
        int metaArgsSize = 0;
        for (JsParam p : metaArgs) {
            if (p.isOptional()) continue;
            ++metaArgsSize;
        }
        return astArgs.length == metaArgsSize;
    }

    public static List<JsParam> getParams(IJsCommentMeta meta) {
        JsTypingMeta typing = meta.getTyping();
        if (typing instanceof JsFuncType) {
            return ((JsFuncType)typing).getParams();
        }
        return null;
    }

    public static JsTypingMeta getReturnTyping(IJsCommentMeta meta) {
        JsTypingMeta typing = meta.getTyping();
        if (typing instanceof JsFuncType) {
            return ((JsFuncType)typing).getReturnType();
        }
        return typing;
    }

    @Deprecated
    private static IJstType findTypeDeprecated(IJsCommentMeta meta, TranslateCtx ctx, JstMethod jstMethod, boolean isOtype, JsTypingMeta returnType, IJstType currentType) {
        IJstType type;
        IJstType retType = null;
        String typeName = returnType == null ? "void" : returnType.getType();
        String[] names = typeName.split("\\.");
        if (typeName.indexOf(46) == -1) {
            IJstType importedType;
            if (currentType != null && (importedType = currentType.getImport(typeName)) != null) {
                typeName = importedType.getName();
            }
        } else if (meta.getName() == null && meta.getArgs().size() == 0 && names.length == 2 && (type = TranslateHelper.getTypeFromInactive(typeName, currentType)) != null && type instanceof JstFunctionRefType) {
            isOtype = true;
            jstMethod.setOType((JstFunctionRefType)type);
        }
        if (!isOtype) {
            for (ArgType a : meta.getArgs()) {
                if (!typeName.equals(a.getName())) continue;
                retType = jstMethod.getParamType(typeName);
            }
            if (retType == null) {
                retType = TranslateHelper.findTypeInGenerics(typeName, currentType);
            }
            boolean rtnSet = false;
            if (meta.getArgs().size() > 0) {
                for (ArgType p : meta.getArgs()) {
                    String name = retType.getName();
                    boolean isA = false;
                    if (retType instanceof JstArray) {
                        name = ((JstArray)retType).getComponentType().getName();
                        isA = true;
                    }
                    if (!p.getName().equals(name)) continue;
                    java.lang.Object aJst = isA ? new JstArray((IJstType)new JstParamType(name)) : retType;
                    retType = aJst;
                    rtnSet = true;
                    break;
                }
            }
            if (!rtnSet && (meta.getName() == null || EMPTYSTRING.equals(meta.getName())) && "Function".equals(typeName)) {
                retType = JstCache.getInstance().getType("void");
            }
        }
        return retType;
    }

    @Deprecated
    private static IJstType findTypeInGenerics(String typeName, IJstType currentType) {
        if ("void".equalsIgnoreCase(typeName)) {
            return null;
        }
        IJstType retType = null;
        for (IJstType argType : currentType.getParamTypes()) {
            if (!typeName.equals(argType.getSimpleName())) continue;
            retType = argType;
            break;
        }
        if (retType == null && currentType.getOuterType() != null && currentType.getOuterType() != currentType) {
            retType = TranslateHelper.findTypeInGenerics(typeName, currentType.getOuterType());
        }
        return retType;
    }

    public static class MethodTranslateHelper {
        public static JstMethod createJstMethod(IExpression astExpr, List<IJsCommentMeta> metaArr, TranslateCtx ctx, String methodName) {
            JstMethod method = null;
            if (astExpr instanceof FieldReference) {
                if ("NEEDS_IMPL".equals(String.valueOf(((FieldReference)astExpr).token)) && "vjo".equals(((FieldReference)astExpr).receiver.toString())) {
                    method = MethodTranslateHelper.createJstMethodFromAst((IASTNode)astExpr, true, metaArr, ctx, methodName);
                }
            } else if (astExpr instanceof NullLiteral) {
                method = MethodTranslateHelper.createJstMethodFromAst((IASTNode)astExpr, true, metaArr, ctx, methodName);
            } else if (astExpr instanceof UndefinedLiteral) {
                method = MethodTranslateHelper.createJstMethodFromAst((IASTNode)astExpr, true, metaArr, ctx, methodName);
            } else if (astExpr instanceof FunctionExpression) {
                method = MethodTranslateHelper.createJstMethod(((FunctionExpression)astExpr).getMethodDeclaration(), metaArr, ctx, methodName);
            }
            if (method != null) {
                MethodTranslateHelper.addMethodCommentsAndSource(ctx, (IASTNode)astExpr, method);
            }
            return method;
        }

        public static JstMethod createJstMethod(MethodDeclaration astMtdDecl, List<IJsCommentMeta> metaArr, TranslateCtx ctx, String methodName) {
            return MethodTranslateHelper.createJstMethodFromAst((IASTNode)astMtdDecl, false, metaArr, ctx, methodName);
        }

        private static JstMethod createJstMethodFromAst(IASTNode astNode, boolean isNeedsImpl, List<IJsCommentMeta> metaArr, TranslateCtx ctx, String methodName) {
            IArgument[] astParams;
            List<IJsCommentMeta> funcMetaList = MethodTranslateHelper.filterFuncMetas(ctx, metaArr);
            MethodDeclaration astMtdDecl = astNode != null && astNode instanceof MethodDeclaration ? (MethodDeclaration)astNode : null;
            IArgument[] iArgumentArray = astParams = astMtdDecl == null ? null : astMtdDecl.getArguments();
            if (funcMetaList.isEmpty()) {
                ScopeId topScope = ctx.getScopeStack().peek();
                if (ScopeIds.PROPS.equals((java.lang.Object)topScope) || ScopeIds.PROTOS.equals((java.lang.Object)topScope)) {
                    return MethodTranslateHelper.createJstMethod(astMtdDecl, astParams, null, ctx, true, methodName);
                }
                return MethodTranslateHelper.createJstMethodWithoutMeta(astMtdDecl, null, ctx, false, methodName);
            }
            if (funcMetaList.size() == 1) {
                IJsCommentMeta singleMeta = funcMetaList.get(0);
                if (singleMeta instanceof PotentialOtypeMemberTypeMeta) {
                    PotentialOtypeMemberTypeMeta potentialOtypeMemberTypeMeta = (PotentialOtypeMemberTypeMeta)singleMeta;
                    JstMethod dumpMtd = MethodTranslateHelper.createJstMethod(astMtdDecl, astParams, null, ctx, false, methodName);
                    return new JstPotentialOtypeMethod(methodName, potentialOtypeMemberTypeMeta.getPotentialOtypeMemberType(), dumpMtd.getArgs().toArray(new JstArg[dumpMtd.getArgs().size()]));
                }
                if (singleMeta instanceof PotentialAttributedTypeMeta) {
                    PotentialAttributedTypeMeta potentialAttributedTypeMeta = (PotentialAttributedTypeMeta)singleMeta;
                    JstMethod dumpMtd = MethodTranslateHelper.createJstMethod(astMtdDecl, astParams, null, ctx, false, methodName);
                    return new JstPotentialAttributedMethod(methodName, potentialAttributedTypeMeta.getPotentialAttributedType(), dumpMtd.getArgs().toArray(new JstArg[dumpMtd.getArgs().size()]));
                }
                if (isNeedsImpl || MethodTranslateHelper.isMetaMatchingAst(singleMeta, astMtdDecl)) {
                    return MethodTranslateHelper.createJstMethod(astMtdDecl, astParams, singleMeta, ctx, true, methodName);
                }
            }
            JstMethod dispatcher = MethodTranslateHelper.createJstMethod(astMtdDecl, astParams, null, ctx, false, methodName);
            for (IJsCommentMeta meta : funcMetaList) {
                JstMethod overloaded = MethodTranslateHelper.createJstMethod(astMtdDecl, astParams, meta, ctx, true, methodName);
                MethodTranslateHelper.attachOverloaded(dispatcher, overloaded);
            }
            MethodTranslateHelper.fixDispatcher(dispatcher);
            return dispatcher;
        }

        public static IJstMethod createJstSynthesizedMethod(List<IJsCommentMeta> metaArr, IFindTypeSupport ctx, String methName) {
            List<IJsCommentMeta> funcMetaList = MethodTranslateHelper.filterFuncMetas(ctx, metaArr);
            if (funcMetaList.isEmpty()) {
                return null;
            }
            if (funcMetaList.size() == 1) {
                IJsCommentMeta singleMeta = funcMetaList.get(0);
                if (singleMeta instanceof PotentialOtypeMemberTypeMeta) {
                    PotentialOtypeMemberTypeMeta potentialOtypeMemberTypeMeta = (PotentialOtypeMemberTypeMeta)singleMeta;
                    return new JstPotentialOtypeMethod(methName, potentialOtypeMemberTypeMeta.getPotentialOtypeMemberType(), new JstArg[0]);
                }
                if (singleMeta instanceof PotentialAttributedTypeMeta) {
                    PotentialAttributedTypeMeta potentialAttributedTypeMeta = (PotentialAttributedTypeMeta)singleMeta;
                    return new JstPotentialAttributedMethod(methName, potentialAttributedTypeMeta.getPotentialAttributedType(), new JstArg[0]);
                }
                return MethodTranslateHelper.createJstSynthesizedMethod(singleMeta, ctx, true, methName);
            }
            JstSynthesizedMethod dispatcher = MethodTranslateHelper.createJstSynthesizedMethod(null, ctx, true, methName);
            for (IJsCommentMeta meta : funcMetaList) {
                JstSynthesizedMethod overloaded = MethodTranslateHelper.createJstSynthesizedMethod(meta, ctx, true, methName);
                MethodTranslateHelper.attachOverloaded((JstMethod)dispatcher, (JstMethod)overloaded);
            }
            return dispatcher;
        }

        public static void addMethodCommentsAndSource(TranslateCtx ctx, IASTNode ast, JstMethod method) {
            JstSource methodSource = TranslateHelper.getSource(ast, ctx.getSourceUtil());
            JstCommentLocation methodComments = ctx.getCommentCollector().getCommentLocationNonMeta2(ast.sourceStart());
            if (!method.isDispatcher()) {
                method.setSource(methodSource);
                if (methodComments != null) {
                    method.addCommentLocation(methodComments);
                }
            } else {
                method.setSource(methodSource);
                if (methodComments != null) {
                    method.addCommentLocation(methodComments);
                }
                for (IJstMethod overload : method.getOverloaded()) {
                    if (!(overload instanceof JstMethod)) continue;
                    ((JstMethod)overload).setSource(methodSource);
                }
            }
        }

        private static List<String> getComments2(IASTNode ast, TranslateCtx ctx) {
            if (ast == null) {
                return Collections.EMPTY_LIST;
            }
            return ctx.getCommentCollector().getCommentNonMeta(ast.sourceStart(), ctx.getPreviousNodeSourceEnd());
        }

        private static List<JstCommentLocation> getCommentLocations2(IASTNode ast, TranslateCtx ctx) {
            if (ast == null) {
                return null;
            }
            return ctx.getCommentCollector().getCommentLocationNonMeta(ast.sourceStart(), ctx.getPreviousNodeSourceEnd());
        }

        private static String getComments(IASTNode ast, TranslateCtx ctx) {
            return ctx.getCommentCollector().getCommentNonMeta2(ast.sourceStart());
        }

        private static IJstMethod createJstSynthesizedMethod(JsFuncType jsFuncType, IFindTypeSupport ctx, String methName) {
            ArrayList<IJsCommentMeta> funcMetaList = new ArrayList<IJsCommentMeta>(1);
            funcMetaList.add(new OverwritableJsCommentMeta(DUMMY_FUNC_META, jsFuncType));
            return MethodTranslateHelper.createJstSynthesizedMethod(funcMetaList, ctx, methName);
        }

        public static void attachOverloaded(JstMethod dispatcher, JstMethod overloaded) {
            dispatcher.addOverloaded(overloaded);
            overloaded.setParent((IJstNode)dispatcher, false);
        }

        private static boolean isMetaMatchingAst(IJsCommentMeta meta, MethodDeclaration astMtdDecl) {
            if (meta == null) {
                throw new IllegalArgumentException("meta for method or ast function expression couldn't be null");
            }
            IArgument[] astArgs = astMtdDecl != null ? astMtdDecl.getArguments() : null;
            JsTypingMeta typing = meta.getTyping();
            if (!(typing instanceof JsFuncType)) {
                return false;
            }
            return ((JsFuncType)typing).getParams().size() == (astArgs == null ? 0 : astArgs.length);
        }

        public static List<IJsCommentMeta> filterFuncMetas(IFindTypeSupport ctx, List<IJsCommentMeta> original) {
            if (original == null || original.isEmpty()) {
                return Collections.emptyList();
            }
            LinkedList<IJsCommentMeta> filteredFuncMetas = new LinkedList<IJsCommentMeta>();
            for (IJsCommentMeta originalMeta : original) {
                if (originalMeta == null) continue;
                if (originalMeta.isMethod() && originalMeta.getTyping() instanceof JsFuncType) {
                    filteredFuncMetas.addAll(MethodTranslateHelper.expandFuncMetas4Params(originalMeta));
                    continue;
                }
                IJstType furtherAttemptedType = TranslateHelper.findType(ctx, originalMeta.getTyping(), originalMeta);
                if (!(furtherAttemptedType instanceof JstAttributedType) && !(furtherAttemptedType instanceof JstFunctionRefType)) {
                    filteredFuncMetas.addAll(MethodTranslateHelper.expandFuncMetas4Params(originalMeta));
                    continue;
                }
                if (furtherAttemptedType instanceof JstAttributedType) {
                    filteredFuncMetas.add(new PotentialAttributedTypeMeta(originalMeta, furtherAttemptedType));
                    continue;
                }
                filteredFuncMetas.add(new PotentialOtypeMemberTypeMeta(originalMeta, furtherAttemptedType));
            }
            return filteredFuncMetas;
        }

        private static List<IJsCommentMeta> expandFuncMetas4Params(IJsCommentMeta original) {
            LinkedList<IJsCommentMeta> expanded = new LinkedList<IJsCommentMeta>();
            if (!MethodTranslateHelper.hasOptionalArgs(original)) {
                expanded.add(original);
            } else {
                JsTypingMeta originalTyping = original.getTyping();
                if (originalTyping != null && originalTyping instanceof JsFuncType) {
                    int noneOptionalEnds;
                    List<JsParam> params = TranslateHelper.getParams(original);
                    int paramCount = noneOptionalEnds = MethodTranslateHelper.getNoneOptionalEnds(params);
                    int maxParamCount = params.size() + 1;
                    while (paramCount < maxParamCount) {
                        if (paramCount <= 0 || !params.get(paramCount - 1).isOptional() || paramCount >= params.size() || !params.get(paramCount).isVariable()) {
                            expanded.add(MethodTranslateHelper.getSynthesizedMethodCommentForOptional(original, paramCount));
                        }
                        ++paramCount;
                    }
                }
            }
            if (!MethodTranslateHelper.hasMultiValueParams(original)) {
                return expanded;
            }
            LinkedList<IJsCommentMeta> furtherExpanded = new LinkedList<IJsCommentMeta>();
            for (IJsCommentMeta furtherExpanding : expanded) {
                if (!MethodTranslateHelper.hasMultiValueParams(furtherExpanding)) {
                    furtherExpanded.add(furtherExpanding);
                    continue;
                }
                furtherExpanded.addAll(MethodTranslateHelper.expandFuncMetas4MultiValues(furtherExpanding));
            }
            return furtherExpanded;
        }

        private static int getNoneOptionalEnds(List<JsParam> params) {
            int noneOptionalStops = 0;
            for (JsParam paramIt : params) {
                if (paramIt.isOptional()) break;
                ++noneOptionalStops;
            }
            return noneOptionalStops;
        }

        private static boolean hasOptionalArgs(IJsCommentMeta meta) {
            List<JsParam> params = TranslateHelper.getParams(meta);
            if (params == null) {
                return false;
            }
            for (JsParam p : params) {
                if (!p.isOptional()) continue;
                return true;
            }
            return false;
        }

        private static boolean hasMultiValueParams(IJsCommentMeta meta) {
            List<JsParam> params = TranslateHelper.getParams(meta);
            if (params == null) {
                return false;
            }
            for (JsParam p : params) {
                if (p.getTypes().size() <= 1) continue;
                return true;
            }
            return false;
        }

        private static IJsCommentMeta getSynthesizedMethodCommentForOptional(IJsCommentMeta meta, int paramCount) {
            List<JsParam> originalParams = TranslateHelper.getParams(meta);
            assert (originalParams != null);
            ArrayList<JsParam> newParams = new ArrayList<JsParam>(originalParams.size());
            int i = 0;
            while (i < paramCount) {
                JsParam originalParam = originalParams.get(i);
                List<JsTypingMeta> originalParamTypes = originalParam.getTypes();
                newParams.add(MethodTranslateHelper.buildJsParam(originalParam.getName(), originalParam.isFinal(), originalParam.isOptional(), originalParam.isVariable(), originalParamTypes.toArray(new JsTypingMeta[originalParamTypes.size()])));
                ++i;
            }
            return new OverwritableJsCommentMeta(meta, new OverwritableJsFuncType((JsFuncType)meta.getTyping(), null, newParams));
        }

        private static List<IJsCommentMeta> expandFuncMetas4MultiValues(IJsCommentMeta original) {
            List<JsParam> originalJsParams = TranslateHelper.getParams(original);
            if (originalJsParams == null) {
                throw new IllegalStateException("params should have been checked, and couldn't be null in this context");
            }
            LinkedList<IJsCommentMeta> expanded = new LinkedList<IJsCommentMeta>();
            if (originalJsParams == null || originalJsParams.size() == 0) {
                expanded.add(original);
            } else {
                for (List<JsParam> expandedParams : MethodTranslateHelper.getFollowingParamsPermutations(originalJsParams, 0)) {
                    expanded.add(MethodTranslateHelper.getSynthesizedMethodCommentForMultiValues(original, expandedParams));
                }
            }
            return expanded;
        }

        private static IJsCommentMeta getSynthesizedMethodCommentForMultiValues(IJsCommentMeta originalMeta, List<JsParam> expandedParams) {
            return new OverwritableJsCommentMeta(originalMeta, new OverwritableJsFuncType((JsFuncType)originalMeta.getTyping(), null, expandedParams));
        }

        private static List<List<JsParam>> getFollowingParamsPermutations(List<JsParam> originalJsParams, int begin) {
            int paramsCount = originalJsParams.size();
            if (begin >= paramsCount) {
                throw new IllegalArgumentException("param index exceeds the params count");
            }
            JsParam paramAtBegin = originalJsParams.get(begin);
            if (begin == paramsCount - 1) {
                LinkedList<List<JsParam>> allPermutations = new LinkedList<List<JsParam>>();
                for (JsTypingMeta paramMetaAtBegin : paramAtBegin.getTypes()) {
                    List<JsParam> paramsGroup = MethodTranslateHelper.initParamsGroup(paramsCount);
                    paramsGroup.set(begin, MethodTranslateHelper.createSingleTypedJsParam(paramAtBegin, paramMetaAtBegin));
                    allPermutations.add(paramsGroup);
                }
                return allPermutations;
            }
            LinkedList<List<JsParam>> allPermutations = new LinkedList<List<JsParam>>();
            List<List<JsParam>> followingPermutations = MethodTranslateHelper.getFollowingParamsPermutations(originalJsParams, begin + 1);
            for (List<JsParam> paramsGroup : followingPermutations) {
                if (paramAtBegin.getTypes().size() == 1) {
                    paramsGroup.set(begin, paramAtBegin);
                    allPermutations.add(paramsGroup);
                    continue;
                }
                for (JsTypingMeta paramMetaAtBegin : paramAtBegin.getTypes()) {
                    JsParam newParamAtBegin = MethodTranslateHelper.createSingleTypedJsParam(paramAtBegin, paramMetaAtBegin);
                    ArrayList<JsParam> replicatedParamsGroup = new ArrayList<JsParam>(paramsGroup);
                    replicatedParamsGroup.set(begin, newParamAtBegin);
                    allPermutations.add(replicatedParamsGroup);
                }
            }
            return allPermutations;
        }

        private static List<JsParam> initParamsGroup(int paramsCount) {
            java.lang.Object[] paramsArr = new JsParam[paramsCount];
            Arrays.fill(paramsArr, null);
            return Arrays.asList(paramsArr);
        }

        private static JsParam createSingleTypedJsParam(JsParam originalParam, JsTypingMeta typing) {
            return MethodTranslateHelper.buildJsParam(originalParam.getName(), originalParam.isFinal(), originalParam.isOptional(), originalParam.isVariable(), typing);
        }

        public static JsParam buildJsParam(String name, boolean isFinal, boolean isOptional, boolean isVariable, JsTypingMeta ... typing) {
            JsParam newParam = new JsParam(name);
            newParam.setFinal(isFinal);
            newParam.setOptional(isOptional);
            newParam.setVariable(isVariable);
            JsTypingMeta[] jsTypingMetaArray = typing;
            int n = typing.length;
            int n2 = 0;
            while (n2 < n) {
                JsTypingMeta it = jsTypingMetaArray[n2];
                newParam.addTyping(it);
                ++n2;
            }
            return newParam;
        }

        public static void fixDispatcher(JstMethod dispatcher) {
            TranslateHelper.fixArgsForDispatchMethod(dispatcher);
            TranslateHelper.fixModifiersForDispatchMethod(dispatcher);
            TranslateHelper.fixRtnTypeForDispatchMethod(dispatcher);
        }

        private static JstMethod createJstMethodWithoutMeta(MethodDeclaration astMtdDecl, IJsCommentMeta meta, TranslateCtx ctx, boolean useJsAnnotForArgs, String methName) {
            IArgument[] astParams;
            IArgument[] iArgumentArray = astParams = astMtdDecl == null ? null : astMtdDecl.getArguments();
            if (astParams == null || astParams.length == 0) {
                return MethodTranslateHelper.createJstMethod(astMtdDecl, astParams, meta, ctx, useJsAnnotForArgs, methName);
            }
            JstMethod dispatcher = MethodTranslateHelper.createJstMethod(astMtdDecl, astMtdDecl.getArguments(), null, ctx, false, methName);
            int paramsLength = 0;
            int paramsMaxLength = astParams.length;
            while (paramsLength <= paramsMaxLength) {
                IArgument[] overloadedAstParams = Arrays.copyOf(astParams, paramsLength);
                JstMethod overloaded = MethodTranslateHelper.createJstMethod(astMtdDecl, overloadedAstParams, meta, ctx, true, methName);
                MethodTranslateHelper.attachOverloaded(dispatcher, overloaded);
                ++paramsLength;
            }
            return dispatcher;
        }

        public static JstMethod createJstMethodNoMeta(IJsCommentMeta meta, TranslateCtx ctx, boolean useJsAnnotForArgs, String methName) {
            return MethodTranslateHelper.createJstMethod(null, null, meta, ctx, useJsAnnotForArgs, methName);
        }

        public static JstMethod createJstMethod(MethodDeclaration astMtdDecl, IArgument[] astArgs, IJsCommentMeta meta, TranslateCtx ctx, boolean useJsAnnotForArgs, String methName) {
            List<JsParam> params;
            List<java.lang.Object> types;
            String methodName = methName;
            if (methName == null) {
                methodName = meta != null ? meta.getName() : "anonymous_function";
            }
            java.lang.Object jstMethod = "constructs".equals(methodName) ? new JstConstructor(new JstArg[0]) : new JstMethod(methodName, new JstArg[0]);
            if (meta != null) {
                jstMethod.setHasJsAnnotation(true);
                jstMethod.setName(methodName);
                TranslateHelper.setModifiersFromMeta(meta, jstMethod.getModifiers());
                jstMethod.addCommentLocation(meta.getBeginOffset(), meta.getEndOffset(), true);
                for (ArgType arg : meta.getArgs()) {
                    jstMethod.addParam(arg.getName());
                }
                JsTypingMeta typing = meta.getTyping();
                if (typing != null) {
                    JsTypingMeta returnType = TranslateHelper.getReturnTyping(meta);
                    jstMethod.setReturnOptional(typing.isOptional());
                    IJstType retType = TranslateHelper.findType(ctx, returnType, meta);
                    jstMethod.setRtnType(retType);
                    if (typing instanceof JsFuncType) {
                        JsFuncType funcType = (JsFuncType)typing;
                        if (funcType.isTypeFactoryEnabled()) {
                            jstMethod.setTypeFactoryEnabled(true);
                        }
                        if (funcType.isFuncArgMetaExtensionEnabled()) {
                            jstMethod.setFuncArgMetaExtensionEnabled(true);
                        }
                    }
                }
                TranslateHelper.setReferenceSource((JstMethod)jstMethod, meta);
            }
            if (ctx.getCurrentScope() == ScopeIds.PROPS) {
                jstMethod.getModifiers().merge(8);
            }
            if (astArgs != null) {
                if (meta != null) {
                    int annArgsCount;
                    int idx = 0;
                    IArgument[] iArgumentArray = astArgs;
                    int n = astArgs.length;
                    int funcType = 0;
                    while (funcType < n) {
                        List<JsParam> params2;
                        IArgument astArg = iArgumentArray[funcType];
                        types = new ArrayList();
                        if (meta != null && (params2 = TranslateHelper.getParams(meta)) != null && params2.size() > idx) {
                            types = params2.get(idx).getTypes();
                        }
                        if (!types.isEmpty() || !useJsAnnotForArgs) {
                            ArgumentTranslator atrans = (ArgumentTranslator)TranslatorFactory.getTranslator((IASTNode)astArg, ctx);
                            atrans.setCommentMetaAndIndex(meta, idx);
                            JstArg jstArg = atrans.doTranslate((JstMethod)jstMethod, astArg);
                            jstMethod.addArg(jstArg);
                        }
                        ++idx;
                        ++funcType;
                    }
                    int astArgsCount = idx;
                    List<JsParam> params3 = TranslateHelper.getParams(meta);
                    int n2 = annArgsCount = params3 == null ? 0 : params3.size();
                    if (astArgsCount < annArgsCount) {
                        int i = astArgsCount;
                        while (i < annArgsCount) {
                            JstArg jstArg = TranslateHelper.createJstArg((JstMethod)jstMethod, params3.get(i).getName(), null, meta, i, ctx);
                            if (jstArg != null) {
                                jstMethod.addArg(jstArg);
                            }
                            ++i;
                        }
                    }
                } else {
                    IArgument[] iArgumentArray = astArgs;
                    int params3 = astArgs.length;
                    int astArgsCount = 0;
                    while (astArgsCount < params3) {
                        IArgument astArg = iArgumentArray[astArgsCount];
                        ArgumentTranslator atrans = (ArgumentTranslator)TranslatorFactory.getTranslator((IASTNode)astArg, ctx);
                        JstArg jstArg = atrans.doTranslate((JstMethod)jstMethod, astArg);
                        jstMethod.addArg(jstArg);
                        ++astArgsCount;
                    }
                }
            } else if (meta != null && useJsAnnotForArgs && (params = TranslateHelper.getParams(meta)) != null && params.size() > 0) {
                int idx = 0;
                types = new ArrayList();
                for (JsParam param : params) {
                    String argName = param.getName() != null ? param.getName() : TranslateHelper.DEFAULT_ARG_PREFIX + idx;
                    JstArg jstArg = TranslateHelper.createJstArg((JstMethod)jstMethod, argName, null, meta, idx, ctx);
                    if (params.size() > idx) {
                        types = params.get(idx).getTypes();
                    }
                    if (types.isEmpty()) continue;
                    jstMethod.addArg(jstArg);
                    ++idx;
                }
            }
            if (astMtdDecl != null && jstMethod != null) {
                jstMethod.getName().setSource(TranslateHelper.getSourceFunc(astMtdDecl, ctx.getSourceUtil()));
            }
            return jstMethod;
        }

        private static JstSynthesizedMethod createJstSynthesizedMethod(IJsCommentMeta meta, IFindTypeSupport ctx, boolean useJsAnnotForArgs, String methName) {
            List<JsParam> params;
            String methodName = methName;
            if (methName == null) {
                methodName = meta != null ? meta.getName() : TranslateHelper.EMPTYSTRING;
            }
            JstSynthesizedMethod jstMethod = new JstSynthesizedMethod(methodName, new JstModifiers(), null);
            if (meta != null) {
                TranslateHelper.setModifiersFromMeta(meta, jstMethod.getModifiers());
                for (ArgType arg : meta.getArgs()) {
                    jstMethod.addParam(arg.getName());
                }
                if (meta.getTyping() != null) {
                    JsTypingMeta retTyping = TranslateHelper.getReturnTyping(meta);
                    IJstType retType = TranslateHelper.findType(ctx, retTyping, meta);
                    jstMethod.setRtnType(retType);
                    jstMethod.setReturnOptional(retTyping.isOptional());
                }
            }
            if (meta != null && useJsAnnotForArgs && (params = TranslateHelper.getParams(meta)) != null && params.size() > 0) {
                int idx = 0;
                List<java.lang.Object> types = new ArrayList();
                for (JsParam param : params) {
                    String argName = param.getName() != null ? param.getName() : TranslateHelper.DEFAULT_ARG_PREFIX + idx;
                    JstArg jstArg = TranslateHelper.createJstArg((JstMethod)jstMethod, argName, null, meta, idx, ctx);
                    if (params.size() > idx) {
                        types = params.get(idx).getTypes();
                    }
                    if (types.isEmpty()) continue;
                    jstMethod.addArg(jstArg);
                    ++idx;
                }
            }
            return jstMethod;
        }

        public static final class PotentialAttributedTypeMeta
        implements IJsCommentMeta {
            private final IJsCommentMeta m_originalMeta;
            private final IJstType m_potentialAttributedType;

            public PotentialAttributedTypeMeta(IJsCommentMeta meta, IJstType potentialAttributedType) {
                this.m_originalMeta = meta;
                this.m_potentialAttributedType = potentialAttributedType;
            }

            public IJstType getPotentialAttributedType() {
                return this.m_potentialAttributedType;
            }

            public boolean isMethod() {
                return this.m_originalMeta.isMethod();
            }

            public boolean isCast() {
                return this.m_originalMeta.isCast();
            }

            public boolean isAnnotation() {
                return this.m_originalMeta.isAnnotation();
            }

            public JsTypingMeta getTyping() {
                return this.m_originalMeta.getTyping();
            }

            public String getName() {
                return this.m_originalMeta.getName();
            }

            public JstModifiers getModifiers() {
                return this.m_originalMeta.getModifiers();
            }

            public int getEndOffset() {
                return this.m_originalMeta.getEndOffset();
            }

            public IJsCommentMeta.DIRECTION getDirection() {
                return this.m_originalMeta.getDirection();
            }

            public String getCommentSrc() {
                return this.m_originalMeta.getCommentSrc();
            }

            public int getBeginOffset() {
                return this.m_originalMeta.getBeginOffset();
            }

            public List<ArgType> getArgs() {
                return this.m_originalMeta.getArgs();
            }

            public JsAnnotation getAnnotation() {
                return this.m_originalMeta.getAnnotation();
            }
        }

        public static final class PotentialOtypeMemberTypeMeta
        implements IJsCommentMeta {
            private final IJsCommentMeta m_originalMeta;
            private final IJstType m_potentialOtypeMemberType;

            public PotentialOtypeMemberTypeMeta(IJsCommentMeta meta, IJstType potentialOtypeMemberType) {
                this.m_originalMeta = meta;
                this.m_potentialOtypeMemberType = potentialOtypeMemberType;
            }

            public IJstType getPotentialOtypeMemberType() {
                return this.m_potentialOtypeMemberType;
            }

            public boolean isMethod() {
                return this.m_originalMeta.isMethod();
            }

            public boolean isCast() {
                return this.m_originalMeta.isCast();
            }

            public boolean isAnnotation() {
                return this.m_originalMeta.isAnnotation();
            }

            public JsTypingMeta getTyping() {
                return this.m_originalMeta.getTyping();
            }

            public String getName() {
                return this.m_originalMeta.getName();
            }

            public JstModifiers getModifiers() {
                return this.m_originalMeta.getModifiers();
            }

            public int getEndOffset() {
                return this.m_originalMeta.getEndOffset();
            }

            public IJsCommentMeta.DIRECTION getDirection() {
                return this.m_originalMeta.getDirection();
            }

            public String getCommentSrc() {
                return this.m_originalMeta.getCommentSrc();
            }

            public int getBeginOffset() {
                return this.m_originalMeta.getBeginOffset();
            }

            public List<ArgType> getArgs() {
                return this.m_originalMeta.getArgs();
            }

            public JsAnnotation getAnnotation() {
                return this.m_originalMeta.getAnnotation();
            }
        }
    }

    private static class OverwritableJsCommentMeta
    implements IJsCommentMeta {
        private final IJsCommentMeta m_originalMeta;
        private final JsFuncType m_jsFuncType;

        public OverwritableJsCommentMeta(IJsCommentMeta meta, JsFuncType func) {
            this.m_originalMeta = meta;
            this.m_jsFuncType = func;
        }

        public boolean isMethod() {
            return this.m_originalMeta.isMethod();
        }

        public boolean isCast() {
            return this.m_originalMeta.isCast();
        }

        public boolean isAnnotation() {
            return this.m_originalMeta.isAnnotation();
        }

        public JsTypingMeta getTyping() {
            return this.m_jsFuncType;
        }

        public String getName() {
            return this.m_originalMeta.getName();
        }

        public JstModifiers getModifiers() {
            return this.m_originalMeta.getModifiers();
        }

        public int getEndOffset() {
            return this.m_originalMeta.getEndOffset();
        }

        public IJsCommentMeta.DIRECTION getDirection() {
            return this.m_originalMeta.getDirection();
        }

        public String getCommentSrc() {
            return this.m_originalMeta.getCommentSrc();
        }

        public int getBeginOffset() {
            return this.m_originalMeta.getBeginOffset();
        }

        public List<ArgType> getArgs() {
            return this.m_originalMeta.getArgs();
        }

        public JsAnnotation getAnnotation() {
            return this.m_originalMeta.getAnnotation();
        }
    }

    private static class OverwritableJsFuncType
    extends JsFuncType {
        private final JsFuncType m_originalJsFunc;
        private String m_overwriteName;
        private List<JsParam> m_overwriteJsParams;

        public OverwritableJsFuncType(JsFuncType originalJsFunc, String overwriteName, List<JsParam> overwriteJsParams) {
            super(originalJsFunc.getReturnType());
            this.m_originalJsFunc = originalJsFunc;
            this.m_overwriteName = overwriteName;
            this.m_overwriteJsParams = overwriteJsParams;
            if (originalJsFunc != null) {
                this.setDimension(originalJsFunc.getDimension());
                this.setFinal(originalJsFunc.isFinal());
                this.setVariable(originalJsFunc.isVariable());
            }
        }

        public boolean isOptional() {
            return this.m_originalJsFunc.isOptional();
        }

        @Override
        public JsTypingMeta getReturnType() {
            return this.m_originalJsFunc.getReturnType();
        }

        @Override
        public String getFuncName() {
            return this.m_overwriteName != null ? this.m_overwriteName : this.m_originalJsFunc.getFuncName();
        }

        @Override
        public List<JsParam> getParams() {
            return this.m_overwriteJsParams != null ? this.m_overwriteJsParams : this.m_originalJsFunc.getParams();
        }

        @Override
        public String getType() {
            return this.m_originalJsFunc.getType();
        }
    }

    public static class RenameableSynthJstProxyMethod
    extends SynthJstProxyMethod {
        private static final long serialVersionUID = 1L;
        private JstName jstRename;

        public RenameableSynthJstProxyMethod(IJstMethod targetMethod, JstName rename) {
            super(targetMethod);
            if (rename != null) {
                this.jstRename = new JstName(rename.getName());
                this.jstRename.setSource(rename.getSource());
            }
        }

        public RenameableSynthJstProxyMethod(IJstMethod targetMethod, String rename) {
            super(targetMethod);
            if (rename != null) {
                this.jstRename = new JstName(rename);
            }
        }

        public void setName(String rename) {
            this.jstRename = new JstName(rename);
        }

        public JstName getName() {
            if (this.jstRename != null) {
                return this.jstRename;
            }
            return super.getName();
        }

        public List<IJstMethod> getOverloaded() {
            List overloadedMtds = super.getOverloaded();
            ArrayList<IJstMethod> renamedMtds = new ArrayList<IJstMethod>(overloadedMtds.size());
            for (IJstMethod overloaded : overloadedMtds) {
                renamedMtds.add((IJstMethod)new RenameableSynthJstProxyMethod(overloaded, this.jstRename != null ? this.jstRename.getName() : null));
            }
            return renamedMtds;
        }
    }

    public static class RenameableSynthJstProxyProp
    extends SynthJstProxyProp {
        private static final long serialVersionUID = 1L;
        private JstName jstRename;

        public RenameableSynthJstProxyProp(IJstProperty targetProperty, String rename) {
            super(targetProperty);
            if (rename != null) {
                this.jstRename = new JstName(rename);
            }
        }

        public void setName(String rename) {
            this.jstRename = new JstName(rename);
        }

        public JstName getName() {
            if (this.jstRename != null) {
                return this.jstRename;
            }
            return super.getName();
        }
    }
}

