/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jstojava.resolver.ITypeResolver;
import org.eclipse.vjet.dsf.jstojava.resolver.SingleThreadExecutor;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.Function;
import org.mozilla.mod.javascript.Scriptable;

public class ScriptableBasedTypeResolver
implements ITypeResolver {
    private final String m_groupId;
    private final Context m_cx;
    private final Scriptable m_scope;
    private final Function m_func;
    private final Map<String, String> m_cache = new HashMap<String, String>();

    public ScriptableBasedTypeResolver(String groupId, Context cx, Scriptable scope, Function func) {
        this.m_groupId = groupId;
        this.m_cx = cx;
        this.m_scope = scope;
        this.m_func = func;
    }

    @Override
    public String[] getGroupIds() {
        return new String[]{this.m_groupId};
    }

    @Override
    public String resolve(String[] args) {
        String key = this.createKey(args);
        String result = this.m_cache.get(key);
        if (result != null) {
            return result;
        }
        Runner runner = new Runner(args);
        SingleThreadExecutor.getInstance().execute(runner);
        Object val = runner.m_result;
        if (val != null) {
            result = val.toString();
            this.m_cache.put(key, result);
        }
        return result;
    }

    private String createKey(String[] args) {
        StringBuilder b = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            b.append(a);
            b.append(",");
            ++n2;
        }
        return b.toString();
    }

    private class Runner
    implements Runnable {
        private Object m_result;
        private Object[] m_args;

        private Runner(Object[] args) {
            this.m_args = args;
        }

        @Override
        public void run() {
            this.m_result = ScriptableBasedTypeResolver.this.m_func.call(ScriptableBasedTypeResolver.this.m_cx, ScriptableBasedTypeResolver.this.m_scope, null, this.m_args);
        }
    }
}

