/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.parser.comments.ParseException;
import org.eclipse.vjet.dsf.jstojava.parser.comments.VjComment;
import org.eclipse.vjet.dsf.jstojava.resolver.IMetaExtension;
import org.eclipse.vjet.dsf.jstojava.translator.BaseFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;

public class FunctionParamsMetaMapping {
    private Map<String, Map<String, MetaExtension>> m_maps = new HashMap<String, Map<String, MetaExtension>>();
    private final String m_groupId;

    public FunctionParamsMetaMapping(String groupId) {
        this.m_groupId = groupId;
    }

    public String getGroupId() {
        return this.m_groupId;
    }

    public boolean hasMetaExtension(String targetFunc) {
        return this.m_maps.containsKey(targetFunc);
    }

    public IMetaExtension getExtension(String targetFunc, String key) {
        Map<String, MetaExtension> funcMetaMap = this.m_maps.get(targetFunc);
        if (funcMetaMap == null) {
            return null;
        }
        return funcMetaMap.get(key);
    }

    public FunctionParamsMetaMapping addMapping(String targetFunc, String key, String[] metaArr) {
        ArrayList<IJsCommentMeta> metaList = new ArrayList<IJsCommentMeta>();
        String[] stringArray = metaArr;
        int n = metaArr.length;
        int n2 = 0;
        while (n2 < n) {
            String metaDef = stringArray[n2];
            try {
                metaList.add(VjComment.parse("//>" + metaDef));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        if (metaList.isEmpty()) {
            return this;
        }
        Map<String, MetaExtension> funcMetaMap = this.m_maps.get(targetFunc);
        if (funcMetaMap == null) {
            funcMetaMap = new HashMap<String, MetaExtension>();
            this.m_maps.put(targetFunc, funcMetaMap);
        }
        funcMetaMap.put(key, new MetaExtension(metaList));
        return this;
    }

    public IMetaExtension getExtentedArgBinding(String targetFunc, String key) {
        return this.getExtension(targetFunc, key);
    }

    public Set<String> getSupportedTargetFuncs() {
        return this.m_maps.keySet();
    }

    public static class MetaExtension
    implements IMetaExtension {
        private List<IJsCommentMeta> m_metaList;

        MetaExtension(List<IJsCommentMeta> metaList) {
            this.m_metaList = metaList;
        }

        @Override
        public IJstMethod getMethod() {
            return TranslateHelper.MethodTranslateHelper.createJstSynthesizedMethod(this.m_metaList, (IFindTypeSupport)new BaseFindTypeSupport(){

                @Override
                public int[] getLineEndings() {
                    return null;
                }
            }, "_fn_");
        }
    }
}

