/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.comments;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.meta.Token;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsParam;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsVariantType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.ParseException;

public class JsFuncType
extends JsTypingMeta {
    private JsTypingMeta m_returnType;
    private String m_funcName;
    private List<JsParam> m_params = new ArrayList<JsParam>();
    private boolean m_typeFactoryEnabled = false;
    private boolean m_funcArgMetaExtensionEnabled = false;

    public JsFuncType(JsTypingMeta returnType) {
        this.m_returnType = returnType;
        if (returnType != null) {
            this.setTypingToken(returnType.getTypingToken());
        }
    }

    public JsTypingMeta getReturnType() {
        return this.m_returnType;
    }

    public JsFuncType setFuncName(String name, Token nameToken) {
        this.m_funcName = name;
        if (nameToken != null) {
            this.setTypingToken(nameToken);
        }
        return this;
    }

    public String getFuncName() {
        return this.m_funcName;
    }

    public List<JsParam> getParams() {
        return this.m_params;
    }

    public JsFuncType addParam(JsParam param) {
        this.m_params.add(param);
        return this;
    }

    public boolean isTypeFactoryEnabled() {
        return this.m_typeFactoryEnabled;
    }

    public JsFuncType setTypeFactoryEnabled(boolean set) {
        this.m_typeFactoryEnabled = set;
        return this;
    }

    public boolean isFuncArgMetaExtensionEnabled() {
        return this.m_funcArgMetaExtensionEnabled;
    }

    public JsFuncType setFuncArgMetaExtensionEnabled(boolean set) {
        this.m_funcArgMetaExtensionEnabled = set;
        return this;
    }

    void addParam(String name, JsTypingMeta typing, boolean isFinal, boolean isOptional, boolean isVariable) throws ParseException {
        JsParam param = new JsParam(name);
        if (typing instanceof JsVariantType) {
            for (JsTypingMeta t : ((JsVariantType)typing).getTypes()) {
                this.update(param, t, isFinal, isOptional, isVariable);
            }
        } else {
            this.update(param, typing, isFinal, isOptional, isVariable);
        }
        int size = this.m_params.size();
        if (size != 0) {
            JsParam prevParam = this.m_params.get(size - 1);
            if (prevParam.isVariable()) {
                throw new ParseException("Only the last argument in your parameter list can be variable.");
            }
            if (prevParam.isOptional() && !isOptional && !isVariable) {
                throw new ParseException("optional param can't be followed by regular param");
            }
        }
        param.setVariable(isVariable);
        param.setOptional(isOptional);
        param.setFinal(isFinal);
        this.m_params.add(param);
    }

    void update(JsParam param, JsTypingMeta t, boolean isFinal, boolean isOptional, boolean isVariable) {
        t.setFinal(isFinal);
        t.setOptional(isOptional);
        t.setVariable(isVariable);
        param.addTyping(t);
    }

    public String getType() {
        return this.m_returnType == null ? "void" : this.m_returnType.getType();
    }
}

