/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRule;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.IVjoSemanticRuleSet;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.VjoSemanticRulePolicy;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.VjoSemanticRuleRepo;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.ValidateClassLoader;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.messages.Messages;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadlessParserConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.HeadlessParserConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.BasicParser;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.CommandLine;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.OptionGroup;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.Options;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.parser.ParseException;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.FileOperator;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.ParserHelper;
import org.eclipse.vjet.dsf.jstojava.loader.OnDemandAllTypeLoader;

public class ArgumentsParser {
    public static final String BLANK = " ";
    private static final String ARGFILE_PREFIX = "@";
    private static final String BUILD_PATH = "bp";
    private static final String BOOT_PATH = "bootp";
    private static final String SOURCE_PATH = "sp";
    private static final String REPORT_PATH = "d";
    private static final String IMPORT_POLICY = "policy";
    private static final String EXPORT_POLICY = "ep";
    private static final String EXCLUSION_RULE = "exclude";
    private static final String REPORT_TYPE = "rt";
    private static final String NO_WARN = "nw";
    private static final String VERBOSE = "vb";
    private static final String BUILD = "b";
    private static final int SHORT_OPTION = 0;
    private static final int LONG_OPTION = 1;
    private static final int OPTION_DESC = 2;
    private static final String ARGFILE = "ARGFILE";
    private static final String SOURCEFILE = "SOURCEFILE";
    static final String[][] OPTIONARAAY = new String[][]{{"h", "help", "Print a synopsis of standard options"}, {"b", "build", "Validator will throw exception when error problems exist"}, {"v", "version", "Display VJET headless version"}, {"nw", "nowarn", "Disable warning problems"}, {"vb", "verbose", "Verbose output. This includes information about each JS validated"}, {"bp", "buildPath", "Specify the source code path to search for JS files, Source path entries are separated by semicolons(;) and can be directories, JAR archives."}, {"bootp", "bootPath", "Boot class path"}, {"d", "reportPath", "report path"}, {"policy", "importPolicy", "Import validation policy"}, {"ep", "exportPolicy", "Export valdiation policy"}, {"excl", "exclude", "Excludes directories or files matching pattern ie *mypath/*"}};

    private static void calculateAllEnv(IHeadlessParserConfigure conf, HashSet<File> buildPathSets) {
        HashSet<File> buildPath = conf.getBuildPath();
        HashSet<File> sourceLocation = conf.getSourceLocation();
        ArgumentsParser.handleValidatedJSFiles((HeadlessParserConfigure)conf);
        File sourceFolder2 = null;
        for (File sourceFolder2 : sourceLocation) {
            if (!sourceFolder2.isDirectory() || !sourceFolder2.exists()) continue;
            buildPathSets.add(sourceFolder2);
        }
        if (buildPath.size() > 0) {
            buildPathSets.addAll(buildPath);
        }
    }

    private static void createLaunchClassPath(HeadlessParserConfigure conf, HashSet<File> buildPathSets) {
        ValidateClassLoader loader = new ValidateClassLoader(ArgumentsParser.convertFileToAbPath(conf.getBootPath()).toArray(new String[0]), new String[0]);
        loader.addSourcePath(ArgumentsParser.convertFileToAbPath(buildPathSets).toArray(new String[0]));
    }

    private static HashSet<String> convertFileToAbPath(HashSet<File> files) {
        LinkedHashSet<String> paths = new LinkedHashSet<String>();
        File file2 = null;
        for (File file2 : files) {
            paths.add(file2.getAbsolutePath());
        }
        return paths;
    }

    private static Options createOptions() {
        Options opts = new Options();
        int i = 0;
        while (i < OPTIONARAAY.length) {
            opts.addOption(OPTIONARAAY[i][0], OPTIONARAAY[i][1], i > 4, OPTIONARAAY[i][2]);
            ++i;
        }
        OptionGroup og = new OptionGroup();
        og.addOption(opts.getOption("h"));
        og.addOption(opts.getOption("v"));
        OptionGroup og1 = new OptionGroup();
        og1.addOption(opts.getOption(IMPORT_POLICY));
        og1.addOption(opts.getOption(EXPORT_POLICY));
        opts.addOptionGroup(og);
        opts.addOptionGroup(og1);
        return opts;
    }

    private static LinkedHashSet<File> getAllValidateJSFiles(HeadlessParserConfigure conf) {
        LinkedHashSet<File> lists = new LinkedHashSet<File>();
        HashSet<File> sourcePaths = conf.getSourceLocation();
        for (File rootFile : sourcePaths) {
            String sourcePath = rootFile.getAbsolutePath().trim();
            if (sourcePath.endsWith(FileOperator.JS_FOLDER_SUFFIX)) {
                sourcePath = sourcePath.substring(0, sourcePath.lastIndexOf(File.separatorChar));
                rootFile = new File(sourcePath);
            }
            if (!ArgumentsParser.isPathValid(rootFile, true)) continue;
            Object exclusionPatternsChar = new char[][]{};
            List<String> exclusionPatterns = conf.getExclusionPatterns();
            if (exclusionPatterns != null) {
                exclusionPatternsChar = OnDemandAllTypeLoader.processPatterns(exclusionPatterns);
            }
            FileOperator.getAllJSFiles(rootFile, lists, exclusionPatternsChar);
            rootFile = new File(FileOperator.TEMPFOLDER);
            if (!ArgumentsParser.isPathValid(rootFile, false)) continue;
            FileOperator.getAllJSFiles(rootFile, lists, exclusionPatternsChar);
        }
        return lists;
    }

    private static HashSet<File> getBuildPath(CommandLine commandLine) {
        String classPaths = commandLine.getOptionValue(BUILD_PATH);
        return ArgumentsParser.createPath(classPaths);
    }

    private static HashSet<File> createPath(String classPaths) {
        if (classPaths == null) {
            ParserHelper.exitSystem(Messages.getString("ArgumentsParser.NEEDCLASSPATH"));
        }
        String[] paths = classPaths.split(FileOperator.SEPARATOR);
        String path = null;
        LinkedHashSet<File> al = new LinkedHashSet<File>();
        File file = null;
        int i = 0;
        while (i < paths.length) {
            path = paths[i].trim();
            file = new File(path);
            if ((path = file.getAbsolutePath()).endsWith(FileOperator.JAR_FOLDER_SUFFIX) && ArgumentsParser.isPathValid(file = new File(path = path.trim().substring(0, path.indexOf(FileOperator.JAR_FOLDER_SUFFIX))), true)) {
                FileOperator.getJarsFiles(file, al);
            }
            if (!path.equals("") && ArgumentsParser.isPathValid(file, true)) {
                al.add(file);
            }
            ++i;
        }
        return al;
    }

    private static HashSet<File> getBootPath(CommandLine commandLine) {
        String classPaths = commandLine.getOptionValue(BOOT_PATH);
        return ArgumentsParser.createPath(classPaths);
    }

    private static IHeadlessParserConfigure getConfiguration(CommandLine commandLine, HeadlessParserConfigure conf) {
        if (commandLine.hasOption('v')) {
            System.out.println(Messages.getString("ArgumentsParser.VJETVERSION"));
            ParserHelper.exitSystem();
        } else if (commandLine.hasOption('h')) {
            ArgumentsParser.printHelp();
        }
        ArgumentsParser.handleArgFiles(commandLine, conf);
        ArgumentsParser.handleSourceLoacations(commandLine, conf);
        ArgumentsParser.handleBuildPath(commandLine, conf);
        ArgumentsParser.handleBootPath(commandLine, conf);
        ArgumentsParser.handleReportPath(commandLine, conf);
        ArgumentsParser.handleReportType(commandLine, conf);
        ArgumentsParser.handleReportLevel(commandLine, conf);
        ArgumentsParser.handleVerbose(commandLine, conf);
        ArgumentsParser.handleBuildMode(commandLine, conf);
        ArgumentsParser.handleImportFunction(commandLine, conf);
        ArgumentsParser.handleExportFunction(commandLine, conf);
        ArgumentsParser.handleExclusionRules(commandLine, conf);
        return conf;
    }

    private static void handleExclusionRules(CommandLine commandLine, HeadlessParserConfigure conf) {
        String value = commandLine.getOptionValue(EXCLUSION_RULE);
        if (value == null) {
            return;
        }
        String[] rules = value.split(",");
        ArrayList<String> ruleList = new ArrayList<String>(rules.length);
        String[] stringArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            String rule = stringArray[n2];
            ruleList.add(rule);
            ++n2;
        }
        conf.setExclusionPatterns(ruleList);
    }

    private static void handleImportFunction(CommandLine commandLine, HeadlessParserConfigure conf) {
        String path = commandLine.getOptionValue(IMPORT_POLICY);
        if (path == null) {
            return;
        }
        if (ArgumentsParser.isPathValid(path, true)) {
            conf.setPolicyFilePath(path);
        }
    }

    private static void handleExportFunction(CommandLine commandLine, HeadlessParserConfigure conf) {
        String path = commandLine.getOptionValue(EXPORT_POLICY);
        if (path == null) {
            return;
        }
        ArgumentsParser.exportPolicy2File(path);
    }

    private static void exportPolicy2File(String path) {
        File exportFile = new File(path);
        if (ArgumentsParser.isPathValid(exportFile, true)) {
            Properties pro = new Properties();
            String ruleSetName = "";
            VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
            for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
                ruleSetName = ruleSet.getRuleSetName();
                for (IVjoSemanticRule rule : ruleSet.getRules()) {
                    pro.put(String.valueOf(ruleSetName) + "." + rule.getRuleName(), rule.getGlobalRulePolicy().getProblemSeverity(null).toString());
                }
            }
            try {
                if (exportFile.canWrite()) {
                    pro.store(new FileOutputStream(path), "");
                    ParserHelper.exitSystem("Successful export validation policy to :" + path);
                } else {
                    System.out.println("Can't write File :" + path);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void handleBuildMode(CommandLine commandLine, HeadlessParserConfigure conf) {
        if (commandLine.hasOption(BUILD)) {
            conf.setFailBuild(true);
        }
    }

    private static void handleVerbose(CommandLine commandLine, HeadlessParserConfigure conf) {
        if (commandLine.hasOption(VERBOSE)) {
            conf.setVerbose(true);
        } else {
            conf.setVerbose(false);
        }
    }

    private static void handleArgFiles(CommandLine commandLine, HeadlessParserConfigure conf) {
        HashSet<File> argFiles = ArgumentsParser.getNoRecognizedValue(commandLine, ARGFILE);
        File argFile2 = null;
        String args = null;
        for (File argFile2 : argFiles) {
            args = ArgumentsParser.readArgFile(argFile2);
            ArgumentsParser parser = new ArgumentsParser();
            parser.parser(args.split(BLANK), conf);
        }
    }

    public static String readArgFile(File f) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStreamReader isr = new InputStreamReader(new FileInputStream(f));
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            if (line != null) {
                line = line.trim();
            }
            block3: while (line != null) {
                if (line.endsWith(FileOperator.SEPARATOR)) {
                    sb.append(line);
                } else {
                    sb.append(String.valueOf(line) + BLANK);
                }
                line = br.readLine();
                if (line == null) break;
                line = line.trim();
                while (line.equals("") || line.equals(BLANK)) {
                    line = br.readLine();
                    if (line == null) continue block3;
                    line = line.trim();
                }
            }
            isr.close();
            br.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static void handleValidatedJSFiles(HeadlessParserConfigure conf) {
        conf.appendValidatedJSFiles(ArgumentsParser.getAllValidateJSFiles(conf));
    }

    private static void handleReportType(CommandLine commandLine, HeadlessParserConfigure conf) {
        conf.setReportType(ArgumentsParser.getReportType(commandLine));
    }

    private static void handleReportPath(CommandLine commandLine, HeadlessParserConfigure conf) {
        conf.setReportPath(ArgumentsParser.getReportPath(commandLine));
    }

    private static void handleBootPath(CommandLine commandLine, HeadlessParserConfigure conf) {
        if (commandLine.hasOption(BOOT_PATH)) {
            conf.appendBootPath(ArgumentsParser.getBootPath(commandLine));
        }
    }

    private static void handleSourceLoacations(CommandLine commandLine, HeadlessParserConfigure conf) {
        conf.appendSourceLoacation(ArgumentsParser.getNoRecognizedValue(commandLine, SOURCEFILE));
    }

    private static HashSet<File> getNoRecognizedValue(CommandLine commandLine, String type) {
        List allArgs = commandLine.getArgList();
        HashSet<File> argFiles = new HashSet<File>();
        if (allArgs.size() == 0) {
            return argFiles;
        }
        String arg = null;
        File file = null;
        Iterator iterator = allArgs.iterator();
        while (iterator.hasNext()) {
            arg = ((String)iterator.next()).trim();
            String[] args = arg.split(FileOperator.SEPARATOR);
            String tempString = null;
            int i = 0;
            while (i < args.length) {
                tempString = args[i].trim();
                if (!tempString.equals("")) {
                    if (type.equalsIgnoreCase(ARGFILE)) {
                        ArgumentsParser.addArgFiles(argFiles, file, tempString);
                    } else if (type.equalsIgnoreCase(SOURCEFILE) && !tempString.startsWith(ARGFILE_PREFIX)) {
                        ArgumentsParser.addSourceFolder(argFiles, tempString);
                    }
                }
                ++i;
            }
        }
        return argFiles;
    }

    private static void addSourceFolder(HashSet<File> argFiles, String tempString) {
        if ((tempString = tempString.trim()).endsWith(FileOperator.JS_FOLDER_SUFFIX)) {
            tempString = tempString.substring(0, tempString.lastIndexOf(FileOperator.JS_FOLDER_SUFFIX));
        }
        File file = new File(tempString);
        if (!tempString.equals("") && ArgumentsParser.isPathValid(tempString)) {
            argFiles.add(file);
        }
    }

    private static void addArgFiles(HashSet<File> argFiles, File file, String tempString) {
        if (tempString.startsWith(ARGFILE_PREFIX)) {
            if ((tempString = tempString.trim()).length() <= 1) {
                ParserHelper.exitSystem(String.valueOf(Messages.getString("ArgumentsParser.CHECKARGPATH")) + tempString);
            }
            tempString = tempString.substring(1);
            file = new File(tempString);
            if (!tempString.equals("") && ArgumentsParser.isPathValid(file, true)) {
                argFiles.add(file);
            }
        }
    }

    public static Options getEVOptions() {
        return ArgumentsParser.createOptions();
    }

    private static void handleReportLevel(CommandLine commandLine, HeadlessParserConfigure conf) {
        if (commandLine.hasOption(NO_WARN)) {
            conf.setReportLevel("ERROR");
        } else {
            conf.setReportLevel("ALL");
        }
    }

    private static String getReportPath(CommandLine commandLine) {
        return commandLine.getOptionValue(REPORT_PATH);
    }

    private static String getReportType(CommandLine commandLine) {
        String reportFileType = commandLine.getOptionValue(REPORT_TYPE, "xml");
        if (reportFileType.equalsIgnoreCase("txt") || reportFileType.equalsIgnoreCase("xml")) {
            return reportFileType;
        }
        return "xml";
    }

    private static void handleBuildPath(CommandLine commandLine, HeadlessParserConfigure conf) {
        if (commandLine.hasOption(BUILD_PATH)) {
            conf.appendBuildPath(ArgumentsParser.getBuildPath(commandLine));
        }
    }

    public void initEnv(HeadlessParserConfigure conf) {
        LinkedHashSet<File> buildPathSets = new LinkedHashSet<File>();
        ArgumentsParser.calculateAllEnv(conf, buildPathSets);
        ArgumentsParser.createLaunchClassPath(conf, buildPathSets);
        this.importPolicy(conf);
    }

    private void importPolicy(HeadlessParserConfigure conf) {
        block22: {
            String path = conf.getPolicyFilePath();
            if (path == null) {
                return;
            }
            if (ArgumentsParser.isFilePathValid(new File(path)) && path != null) {
                Properties pro = new Properties();
                FileInputStream fi = null;
                try {
                    fi = new FileInputStream(path);
                    pro.load(fi);
                    String ruleSetName = "";
                    String proKey = "";
                    VjoSemanticRuleRepo ruleRepo = VjoSemanticRuleRepo.getInstance();
                    for (IVjoSemanticRuleSet ruleSet : ruleRepo.getRuleSets()) {
                        ruleSetName = ruleSet.getRuleSetName();
                        for (IVjoSemanticRule rule : ruleSet.getRules()) {
                            proKey = String.valueOf(ruleSetName) + "." + rule.getRuleName();
                            rule.setGlobalPolicy(this.getRulePolicy(pro.getProperty(proKey)));
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    try {
                        if (fi != null) {
                            fi.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fi != null) {
                                fi.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (fi != null) {
                            fi.close();
                        }
                        break block22;
                    }
                    catch (IOException iOException) {}
                    break block22;
                }
                try {
                    if (fi != null) {
                        fi.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isJarPathValid(String path) {
        File file = new File(path);
        if (file.exists() && file.canRead() && file.getAbsolutePath().endsWith(".jar")) {
            return true;
        }
        System.out.println(String.valueOf(Messages.getString("ArgumentsParser.CHECKJARPATH")) + file.getAbsolutePath());
        ParserHelper.exitSystem();
        return false;
    }

    public static boolean isPathValid(String path) {
        return ArgumentsParser.isPathValid(path, true);
    }

    public static boolean isPathValid(String path, boolean exist) {
        if (path == null) {
            ParserHelper.exitSystem(Messages.getString("ArgumentsParser.CHECKPATH"));
        } else {
            path = path.trim();
        }
        File pathFile = new File(path);
        return ArgumentsParser.isPathValid(pathFile, exist);
    }

    private static boolean isPathValid(File pathFile, boolean exist) {
        if (pathFile.exists() && pathFile.canRead()) {
            return true;
        }
        if (exist) {
            ParserHelper.exitSystem(String.valueOf(Messages.getString("ArgumentsParser.CHECKPATH")) + pathFile.getAbsolutePath());
        }
        return false;
    }

    private static boolean isFilePathValid(File file) {
        if (ArgumentsParser.isPathValid(file, true) && file.isFile()) {
            return true;
        }
        ParserHelper.exitSystem(String.valueOf(Messages.getString("ArgumentsParser.CHECKPATH")) + file.getAbsolutePath());
        return false;
    }

    private static void printHelp(String message) {
        ParserHelper.printOptionsHelp(ArgumentsParser.getEVOptions(), message);
        ParserHelper.exitSystem();
    }

    private static void printHelp() {
        ArgumentsParser.printHelp("vjetv <options> <source files> \nWhere possible options include: \n");
    }

    public final IHeadlessParserConfigure parser(String[] args, HeadlessParserConfigure conf) {
        CommandLine commandLine = null;
        BasicParser parser = new BasicParser();
        try {
            commandLine = parser.parse(ArgumentsParser.getEVOptions(), args);
        }
        catch (ParseException e) {
            ArgumentsParser.printHelp(e.getMessage());
        }
        if (conf != null) {
            return ArgumentsParser.getConfiguration(commandLine, conf);
        }
        return null;
    }

    private VjoSemanticRulePolicy getRulePolicy(String severity) {
        if ("error".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_ERROR_POLICY;
        }
        if ("warning".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_WARNING_POLICY;
        }
        if ("ignore".equalsIgnoreCase(severity)) {
            return VjoSemanticRulePolicy.GLOBAL_IGNORE_POLICY;
        }
        return VjoSemanticRulePolicy.GLOBAL_ERROR_POLICY;
    }
}

