/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.services.concurrent.management;

import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceStatistics;
import org.eclipse.virgo.kernel.services.concurrent.management.ExecutorServiceExporter;
import org.eclipse.virgo.kernel.services.concurrent.management.StandardExecutorServiceInfo;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxExecutorServiceExporter
implements ExecutorServiceExporter {
    private static final String OBJECT_NAME_PATTERN = "%s:type=Executor Service,name=%s";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private final Set<ObjectName> exportedExecutorServices = new HashSet<ObjectName>();
    private final String managementDomain;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public JmxExecutorServiceExporter(String managementDomain) {
        this.managementDomain = managementDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(ExecutorServiceStatistics executorService) {
        try {
            JmxExecutorServiceExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                ObjectName name = new ObjectName(String.format(OBJECT_NAME_PATTERN, this.managementDomain, executorService.getPoolName()));
                StandardExecutorServiceInfo info = new StandardExecutorServiceInfo(executorService);
                this.server.registerMBean(info, name);
                Set<ObjectName> set = this.exportedExecutorServices;
                synchronized (set) {
                    this.exportedExecutorServices.add(name);
                }
            }
            catch (JMException e) {
                this.logger.warn(String.format("Unable to register executor service %s for management", executorService), (Throwable)e);
            }
            JmxExecutorServiceExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            JmxExecutorServiceExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            JmxExecutorServiceExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            Set<ObjectName> set = this.exportedExecutorServices;
            synchronized (set) {
                for (ObjectName exportedExecutorService : this.exportedExecutorServices) {
                    try {
                        this.server.unregisterMBean(exportedExecutorService);
                    }
                    catch (JMException e) {
                        this.logger.warn(String.format("Unable to unregister executor service %s from management", exportedExecutorService), (Throwable)e);
                    }
                }
            }
            JmxExecutorServiceExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            JmxExecutorServiceExporter.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("JmxExecutorServiceExporter.java", Class.forName("org.eclipse.virgo.kernel.services.concurrent.management.JmxExecutorServiceExporter"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "export", "org.eclipse.virgo.kernel.services.concurrent.management.JmxExecutorServiceExporter", "org.eclipse.virgo.kernel.services.concurrent.ExecutorServiceStatistics:", "executorService:", "", "void"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "destroy", "org.eclipse.virgo.kernel.services.concurrent.management.JmxExecutorServiceExporter", "", "", "", "void"), 67);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.services.concurrent.management.JmxExecutorServiceExporter");
    }
}

