/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg;

import java.util.Queue;
import java.util.Vector;
import org.eclipse.viatra2.gtasm.patternmatcher.IMatching;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.IKeyGenerator;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingKey;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.callgraph.FlattenedPattern;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.HistoryList;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.IQueueContentProvider;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.RemoteGoal;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.rgg.Rule;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedRule
extends Rule {
    private RemoteGoal right;
    private HistoryList<MatchingKey, MatchingFrame> leftInputQueue;
    private Integer[] parameterMapping;
    private Boolean[] adornment;
    private int arraySize = 0;
    private IKeyGenerator<MatchingKey, MatchingFrame> keyGenerator;

    public IndexedRule(FlattenedPattern pattern, IQueueContentProvider left, RemoteGoal right, Integer[] parameterMapping, Boolean[] adornment) {
        super(pattern, left);
        Vector<Integer> v = new Vector<Integer>();
        int i = 0;
        while (i < adornment.length) {
            if (adornment[i].booleanValue()) {
                v.add(parameterMapping[i]);
                ++this.arraySize;
            }
            ++i;
        }
        final Integer[] keys = new Integer[this.arraySize];
        v.toArray(keys);
        this.keyGenerator = new IKeyGenerator<MatchingKey, MatchingFrame>(){

            @Override
            public MatchingKey calculateKey(MatchingFrame value) {
                Object[] matchingKey = new Object[keys.length];
                int i = 0;
                while (i < keys.length) {
                    matchingKey[i] = value.getValue(keys[i]);
                    ++i;
                }
                return new MatchingKey(matchingKey);
            }

            @Override
            public int size() {
                return keys.length;
            }
        };
        this.right = right;
        this.leftInputQueue = new HistoryList<MatchingKey, MatchingFrame>(this.keyGenerator);
        this.parameterMapping = parameterMapping;
        this.adornment = adornment;
    }

    @Override
    public void traverseAll(Queue<MatchingFrame> resultQueue, MatchingFrame template) throws PatternMatcherRuntimeException {
        this.left.traverseAll(this.leftInputQueue, template);
        this.right.calculateAllDeltas(this, resultQueue);
    }

    MatchingKey getBoundHeader(MatchingFrame frame) {
        return this.keyGenerator.calculateKey(frame);
    }

    void merge(MatchingFrame result, IMatching other) throws PatternMatcherRuntimeException {
        assert (this.parameterMapping.length == this.adornment.length);
        int i = 0;
        while (i < this.parameterMapping.length) {
            if (this.adornment[i].booleanValue()) {
                if (!result.getValue(this.parameterMapping[i]).equals(other.lookup(i))) {
                    String[] context = new String[]{this.pattern.getParent().getPattern().getName()};
                    throw new PatternMatcherRuntimeException("[INTERNAL ERROR] An error happened during the evaluation of the adorned input parameters of the {1} pattern", context, (AnnotatedElement)this.pattern.getParent().getPattern());
                }
            } else {
                result.setValue(this.parameterMapping[i], other.lookup(i));
            }
            ++i;
        }
    }

    HistoryList<MatchingKey, MatchingFrame> getQueue() {
        return this.leftInputQueue;
    }

    @Override
    public void synchronize() {
        this.left.synchronize();
        this.leftInputQueue.clear();
    }

    @Override
    public void init() {
        this.leftInputQueue.init();
        this.left.init();
    }
}

