/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation;

import java.util.HashSet;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ExtendOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;

public class ExtendConstantNodeOperation
extends ExtendOperation {
    private IModelElement bound;

    public ExtendConstantNodeOperation(IModelElement bound, Integer unbound, SearchGraphEdge edge) {
        super(unbound, edge);
        this.bound = bound;
    }

    public void preprocess(MatchingFrame frame) throws PatternMatcherRuntimeException {
        if (this.bound == null) {
            String[] context = new String[]{this.edge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.edge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && !this.edge.isSource()) {
            this.iterator = this.bound.getAllTypes().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.INSTANCEOF && this.edge.isSource()) {
            this.iterator = this.bound.getAllInstances().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && !this.edge.isSource()) {
            this.iterator = this.bound.getAllSubtypes().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SUPERTYPEOF && this.edge.isSource()) {
            this.iterator = this.bound.getAllSupertypes().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && !this.edge.isSource()) {
            this.iterator = this.bound.getRelationsFrom().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.SOURCE && this.edge.isSource()) {
            HashSet<IModelElement> coll = new HashSet<IModelElement>();
            if (this.bound instanceof IRelation) {
                coll.add(((IRelation)this.bound).getFrom());
            }
            this.iterator = coll.iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.TARGET && !this.edge.isSource()) {
            this.iterator = this.bound.getRelationsTo().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.TARGET && this.edge.isSource()) {
            HashSet<IModelElement> coll = new HashSet<IModelElement>();
            if (this.bound instanceof IRelation) {
                coll.add(((IRelation)this.bound).getTo());
            }
            this.iterator = coll.iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.IN && this.edge.isSource()) {
            this.iterator = this.bound.getElementsInNamespace().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.BELOW && this.edge.isSource()) {
            this.iterator = this.bound.getAllElementsInNamespace().iterator();
        } else if (this.edge.getVPMEdgeType() == EdgeType.IN && !this.edge.isSource()) {
            HashSet<IModelElement> coll = new HashSet<IModelElement>();
            if (this.bound.getNamespace() != null) {
                coll.add(this.bound.getNamespace());
            }
            this.iterator = coll.iterator();
        } else {
            if (this.edge.getVPMEdgeType() == EdgeType.BELOW && !this.edge.isSource()) {
                String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.unbound).getName(), this.edge.getVPMEdgeType().toString()};
                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element generates a '{2}' type operation that is not allowed.", context, this.edge.getTraceabilityElement().getRepresentativeEMFElement());
            }
            if (this.edge.getVPMEdgeType() == EdgeType.NACCHECK) {
                String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.unbound).getName(), this.edge.getVPMEdgeType().toString()};
                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The '{1}' element generates a '{2}' type operation that is not allowed.", context, this.edge.getTraceabilityElement().getRepresentativeEMFElement());
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.bound.getName() + " -- " + this.edge.getVPMEdgeType().name() + " -> " + this.unbound;
    }
}

