/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.algorithms;

import java.util.Vector;
import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.gtasm.patternmatcher.exceptions.PatternMatcherRuntimeException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.EdgeType;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.AllEntitiesOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.AllRelationsOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.BoundToBoundCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.BoundToConstantCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ConstantToBoundCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ConstantToConstantCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.CopyValueOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ExtendBoundNodeOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.ExtendConstantNodeOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.IsEntityorRelationCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.PatternCallOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.SearchPlanOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.operation.VariableAssignmentCheckOperation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.ConstantSearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.PatternCallSearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphNode;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.VariableSearchGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPMPatternOperationGenerator {
    public static Vector<SearchPlanOperation> evaluateVPMOperationPlan(SearchGraphNode[] searchPlan, MatchingFrame template, IModelManager manager) throws PatternMatcherRuntimeException {
        SearchGraphNode node;
        Vector<SearchPlanOperation> searchOperations = new Vector<SearchPlanOperation>();
        SearchPlanOperation operation = null;
        SearchGraphNode[] searchGraphNodeArray = searchPlan;
        int n = searchPlan.length;
        int n2 = 0;
        while (n2 < n) {
            node = searchGraphNodeArray[n2];
            if (node instanceof ConstantSearchGraphNode) {
                node.setChecked(true);
            }
            if (node.getTreeEdge() != null && !node.isChecked() && (operation = VPMPatternOperationGenerator.treeEdgeSearchOperation(node.getTreeEdge(), template, manager)) != null) {
                searchOperations.add(operation);
            }
            for (SearchGraphEdge edge : node.getSources()) {
                if (!edge.getSourceNode().isChecked() || !edge.getTargetNode().isChecked() || (operation = VPMPatternOperationGenerator.evaluateEdgeSearchPlanOperation(edge, template, manager)) == null) continue;
                searchOperations.add(operation);
            }
            ++n2;
        }
        searchGraphNodeArray = searchPlan;
        n = searchPlan.length;
        n2 = 0;
        while (n2 < n) {
            node = searchGraphNodeArray[n2];
            for (SearchGraphEdge edge : node.getSources()) {
                if (edge.isChecked() || (operation = VPMPatternOperationGenerator.evaluateEdgeSearchPlanOperation(edge, template, manager)) == null) continue;
                searchOperations.add(operation);
            }
            ++n2;
        }
        return searchOperations;
    }

    public static SearchPlanOperation evaluateEdgeSearchPlanOperation(SearchGraphEdge edge, MatchingFrame template, IModelManager manager) throws PatternMatcherRuntimeException {
        SearchPlanOperation operation = null;
        if (edge.isChecked()) {
            return null;
        }
        if (edge.getVPMEdgeType() != EdgeType.BELOW && edge.getVPMEdgeType() != EdgeType.IN && edge.getVPMEdgeType() != EdgeType.INSTANCEOF && edge.getVPMEdgeType() != EdgeType.SOURCE && edge.getVPMEdgeType() != EdgeType.TARGET && edge.getVPMEdgeType() != EdgeType.SUPERTYPEOF && edge.getVPMEdgeType() != EdgeType.PATTERN_CALL_PARAMETER && edge.getVPMEdgeType() != EdgeType.VARIABLE_ASSIGNMENT) {
            String[] context = new String[]{edge.getVPMEdgeType().toString(), edge.getName()};
            throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The {1} SearchGraphEdge type of the {2} element is not supported by any current SearchPlanOperation.", context, template.getPattern().getGTASMRepresentation(edge));
        }
        operation = VPMPatternOperationGenerator.checkSearchOperation(edge, template, manager);
        return operation;
    }

    private static SearchPlanOperation checkSearchOperation(SearchGraphEdge edge, MatchingFrame template, IModelManager manager) throws PatternMatcherRuntimeException {
        CheckOperation operation = null;
        if (edge.getSourceNode() instanceof VariableSearchGraphNode && edge.getVPMEdgeType().equals((Object)EdgeType.BELOW) && template.getValue(((VariableSearchGraphNode)edge.getSourceNode()).getId()) != null && ((IModelElement)template.getValue(((VariableSearchGraphNode)edge.getSourceNode()).getId())).equals(manager.getRoot())) {
            edge.setChecked(true);
            return null;
        }
        if (edge.getSourceNode() instanceof ConstantSearchGraphNode && edge.getVPMEdgeType().equals((Object)EdgeType.INSTANCEOF) && (((ConstantSearchGraphNode)edge.getSourceNode()).getElement().equals("vpm.relation") || ((ConstantSearchGraphNode)edge.getSourceNode()).getElement().equals("vpm.entity"))) {
            operation = new IsEntityorRelationCheckOperation(((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge, ((ConstantSearchGraphNode)edge.getSourceNode()).getElement());
            edge.setChecked(true);
            return operation;
        }
        if (edge.getTargetNode() instanceof PatternCallSearchGraphNode) {
            String[] context = new String[]{edge.getTargetNode().getName()};
            throw new PatternMatcherRuntimeException("[INTERNAL_ERROR] The call node edge of the {1} Pattern call is not checked during the search plan generation.", context, template.getPattern().getGTASMRepresentation(edge));
        }
        if (edge.getVPMEdgeType().equals((Object)EdgeType.VARIABLE_ASSIGNMENT)) {
            operation = new VariableAssignmentCheckOperation(((VariableSearchGraphNode)edge.getSourceNode()).getId(), ((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge);
        } else if (edge.getSourceNode() instanceof VariableSearchGraphNode && edge.getTargetNode() instanceof VariableSearchGraphNode) {
            operation = new BoundToBoundCheckOperation(((VariableSearchGraphNode)edge.getSourceNode()).getId(), ((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge);
        } else if (edge.getSourceNode() instanceof VariableSearchGraphNode && edge.getTargetNode() instanceof ConstantSearchGraphNode) {
            operation = new BoundToConstantCheckOperation(((VariableSearchGraphNode)edge.getSourceNode()).getId(), manager.getElementByName(((ConstantSearchGraphNode)edge.getTargetNode()).getElement()), edge);
        } else if (edge.getSourceNode() instanceof ConstantSearchGraphNode && edge.getTargetNode() instanceof VariableSearchGraphNode) {
            operation = new ConstantToBoundCheckOperation(manager.getElementByName(((ConstantSearchGraphNode)edge.getSourceNode()).getElement()), ((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge);
        } else if (edge.getSourceNode() instanceof ConstantSearchGraphNode && edge.getTargetNode() instanceof ConstantSearchGraphNode) {
            operation = new ConstantToConstantCheckOperation(manager.getElementByName(((ConstantSearchGraphNode)edge.getSourceNode()).getElement()), manager.getElementByName(((ConstantSearchGraphNode)edge.getTargetNode()).getElement()), edge);
        }
        if (operation != null) {
            edge.setChecked(true);
        }
        return operation;
    }

    private static int getPatternCallParameterId(Integer id, PatternCallSearchGraphNode callNode, MatchingFrame frame) throws PatternMatcherRuntimeException {
        Integer[] inputParameterMapping = callNode.getInputParameterMapping();
        int i = 0;
        while (i < inputParameterMapping.length) {
            if (id == inputParameterMapping[i]) {
                return i;
            }
            ++i;
        }
        String[] context = new String[]{callNode.getName()};
        throw new PatternMatcherRuntimeException("[INTERNAl ERROR] The pattern call edge  of the {1} call is traversed (a tree edge) before its pattern call node was traversed.", context, frame.getPattern().getGTASMRepresentation(callNode));
    }

    public static SearchPlanOperation treeEdgeSearchOperation(SearchGraphEdge edge, MatchingFrame template, IModelManager manager) throws PatternMatcherRuntimeException {
        SearchPlanOperation operation = null;
        if (edge.getSourceNode().isChecked() && edge.getTargetNode().isChecked()) {
            operation = VPMPatternOperationGenerator.checkSearchOperation(edge, template, manager);
        } else {
            if (edge.getVPMEdgeType().equals((Object)EdgeType.PATTERN_CALL_PARAMETER) || edge.getVPMEdgeType().equals((Object)EdgeType.PATTERN_CALL_STORAGE)) {
                if (edge.isSource()) {
                    PatternCallSearchGraphNode callNode = (PatternCallSearchGraphNode)edge.getTargetNode();
                    Boolean[] boundParameters = new Boolean[callNode.getPatternNode().getPattern().getSymParameters().size()];
                    for (SearchGraphEdge callEdge : callNode.getSources()) {
                        if (callEdge.getVPMEdgeType().equals((Object)EdgeType.PATTERN_CALL_PARAMETER)) {
                            if (callEdge.getSourceNode().isChecked()) {
                                boundParameters[VPMPatternOperationGenerator.getPatternCallParameterId((Integer)((VariableSearchGraphNode)callEdge.getSourceNode()).getId(), (PatternCallSearchGraphNode)callNode, (MatchingFrame)template)] = true;
                            } else if (callEdge.getSourceNode().getTreeEdge().getSourceNode().equals(callNode)) {
                                boundParameters[VPMPatternOperationGenerator.getPatternCallParameterId((Integer)((VariableSearchGraphNode)callEdge.getSourceNode()).getId(), (PatternCallSearchGraphNode)callNode, (MatchingFrame)template)] = false;
                                callEdge.getSourceNode().setChecked(true);
                            } else {
                                String[] context = new String[]{callEdge.getSourceNode().getName(), callNode.getName()};
                                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The tree edge of the {1} unbounded input node is not its input edge to the {2} pattern call.", context, template.getPattern().getGTASMRepresentation(callNode));
                            }
                        }
                        callEdge.setChecked(true);
                    }
                    return new PatternCallOperation(callNode.getPatternNode(), callNode.getInputParameterMapping(), boundParameters);
                }
                PatternCallSearchGraphNode callNode = (PatternCallSearchGraphNode)edge.getSourceNode();
                String[] context = new String[]{edge.getName(), callNode.getName()};
                throw new PatternMatcherRuntimeException("[INTERNAL ERROR] The {1} pattern call edge is a tree edge before its corresponding {2} pattern call node was traversed.", context, template.getPattern().getGTASMRepresentation(callNode));
            }
            if (edge.getSourceNode().isChecked()) {
                if (edge.getVPMEdgeType().equals((Object)EdgeType.VARIABLE_ASSIGNMENT)) {
                    operation = new CopyValueOperation(((VariableSearchGraphNode)edge.getSourceNode()).getId(), ((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge);
                } else if (edge.getSourceNode() instanceof ConstantSearchGraphNode && ((ConstantSearchGraphNode)edge.getSourceNode()).getElement().equals("vpm.entity")) {
                    operation = new AllEntitiesOperation(((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge, manager);
                } else if (edge.getSourceNode() instanceof ConstantSearchGraphNode && ((ConstantSearchGraphNode)edge.getSourceNode()).getElement().equals("vpm.relation")) {
                    operation = new AllRelationsOperation(((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge, manager);
                } else if (edge.getSourceNode() instanceof VariableSearchGraphNode && edge.getTargetNode() instanceof VariableSearchGraphNode) {
                    operation = new ExtendBoundNodeOperation(((VariableSearchGraphNode)edge.getSourceNode()).getId(), ((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge);
                } else if (edge.getSourceNode() instanceof ConstantSearchGraphNode && edge.getTargetNode() instanceof VariableSearchGraphNode) {
                    operation = new ExtendConstantNodeOperation(manager.getElementByName(((ConstantSearchGraphNode)edge.getSourceNode()).getElement()), ((VariableSearchGraphNode)edge.getTargetNode()).getId(), edge);
                }
            } else if (edge.getTargetNode().isChecked()) {
                if (edge.getVPMEdgeType().equals((Object)EdgeType.VARIABLE_ASSIGNMENT)) {
                    operation = new CopyValueOperation(((VariableSearchGraphNode)edge.getTargetNode()).getId(), ((VariableSearchGraphNode)edge.getSourceNode()).getId(), edge);
                }
                if (edge.getTargetNode() instanceof ConstantSearchGraphNode && ((ConstantSearchGraphNode)edge.getTargetNode()).getElement().equals("vpm.entity")) {
                    operation = new AllEntitiesOperation(((VariableSearchGraphNode)edge.getSourceNode()).getId(), edge, manager);
                } else if (edge.getTargetNode() instanceof ConstantSearchGraphNode && ((ConstantSearchGraphNode)edge.getTargetNode()).getElement().equals("vpm.relation")) {
                    operation = new AllRelationsOperation(((VariableSearchGraphNode)edge.getSourceNode()).getId(), edge, manager);
                } else if (edge.getSourceNode() instanceof VariableSearchGraphNode && edge.getTargetNode() instanceof VariableSearchGraphNode) {
                    operation = new ExtendBoundNodeOperation(((VariableSearchGraphNode)edge.getTargetNode()).getId(), ((VariableSearchGraphNode)edge.getSourceNode()).getId(), edge);
                } else if (edge.getSourceNode() instanceof ConstantSearchGraphNode && edge.getTargetNode() instanceof VariableSearchGraphNode) {
                    operation = new ExtendConstantNodeOperation(manager.getElementByName(((ConstantSearchGraphNode)edge.getTargetNode()).getElement()), ((VariableSearchGraphNode)edge.getSourceNode()).getId(), edge);
                }
            }
        }
        if (operation != null) {
            edge.getSourceNode().setChecked(true);
            edge.getTargetNode().setChecked(true);
            edge.setChecked(true);
        }
        return operation;
    }
}

