/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.core.IRelation;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.SetRelation;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.SearchGraphEdge;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class SetRelationTarget
extends SetRelation {
    SearchGraphEdge relatedSearchGraphEdge;
    int target;

    public SetRelationTarget(int rel, int target, IModelManager manager, SearchGraphEdge edge) {
        super(manager, rel);
        this.target = target;
        this.relatedSearchGraphEdge = edge;
    }

    public boolean update(MatchingFrame frame) throws GTOperationException {
        IModelElement targetElement = null;
        IRelation relationElement = null;
        try {
            targetElement = (IModelElement)frame.getValue(this.target);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getSourceNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, this.relatedSearchGraphEdge.getSourceNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            relationElement = (IRelation)frame.getValue(this.relation);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not a Relation", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (targetElement == null) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.relatedSearchGraphEdge.getTargetNode().getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            if (!relationElement.getTo().equals(targetElement)) {
                this.manager.setRelationTo(relationElement, targetElement);
            }
            return true;
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{this.relatedSearchGraphEdge.getTargetNode().getName(), this.relatedSearchGraphEdge.getTargetNode().getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] The target of the '{1}' relation could not be set to the '{2}' element due to: {3}", context, this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement());
        }
    }

    public String toString() {
        return "Relation: " + this.relation + "-- set Target --> " + this.target;
    }

    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return this.relatedSearchGraphEdge.getTraceabilityElement().getRepresentativeEMFElement();
    }
}

