/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation;

import org.eclipse.viatra2.core.IModelElement;
import org.eclipse.viatra2.core.IModelManager;
import org.eclipse.viatra2.errors.VPMCoreException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.exceptions.GTOperationException;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.gtmatcher.internal.operation.CreateBound2Constant;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.MatchingFrame;
import org.eclipse.viatra2.gtasm.patternmatcher.impl.patternmatcher.internal.searchgraph.ConstantSearchGraphNode;
import org.eclipse.viatra2.gtasmmodel.gtasm.metamodel.asm.core.AnnotatedElement;

public class CreateRelationBound2Constant
extends CreateBound2Constant {
    ConstantSearchGraphNode targetNode;

    public CreateRelationBound2Constant(int s, ConstantSearchGraphNode t, int variableI, IModelManager manager) {
        super(manager, variableI);
        this.source = s;
        this.targetNode = t;
        this.target = manager.getElementByName(t.getElement());
    }

    protected boolean create(MatchingFrame frame) throws GTOperationException {
        IModelElement sourceElement = null;
        try {
            sourceElement = (IModelElement)frame.getValue(this.source);
        }
        catch (ClassCastException classCastException) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.source).getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("The '{1}' element in the {2} operation is not a ModelElement (Entity or Relation)", context, frame.getPattern().getSearchGraph().getSearchNode(this.source).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (sourceElement == null) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.source).getName(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, frame.getPattern().getSearchGraph().getSearchNode(this.source).getTraceabilityElement().getRepresentativeEMFElement());
        }
        if (this.target == null) {
            String[] context = new String[]{this.targetNode.getElement(), this.getClass().getSimpleName()};
            throw new GTOperationException("[INTERNAL ERROR] The '{1}' element in the {2} operation has an empty value (null)", context, this.targetNode.getTraceabilityElement().getRepresentativeEMFElement());
        }
        try {
            frame.setValue(this.variableIndex, this.manager.newRelation(sourceElement, this.target));
        }
        catch (VPMCoreException e) {
            String[] context = new String[]{frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getName(), e.getMessage()};
            throw new GTOperationException("[INTERNAL ERROR] Relation '{1}' creation failed due to: {2}", context, frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement());
        }
        return true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : " + this.source + " -- Relation:" + this.variableIndex + " -> " + this.target.getName();
    }

    public AnnotatedElement getErrorfulElement(MatchingFrame frame) {
        return frame.getPattern().getSearchGraph().getSearchNode(this.variableIndex).getTraceabilityElement().getRepresentativeEMFElement();
    }
}

