/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra2.editor.text.light.vtcl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.viatra2.editor.text.markers.IVTCLErrorReporter;
import org.eclipse.viatra2.errors.info.ErrorInformation;

public class VTCLMarkerManager
implements IVTCLErrorReporter {
    protected ISourceViewer sourceViewer;
    protected IFile file;

    public ISourceViewer getSourceViewer() {
        return this.sourceViewer;
    }

    public void initialize(ISourceViewer sourceViewer, IFile file) {
        this.sourceViewer = sourceViewer;
        this.file = file;
    }

    public void reportError(ErrorInformation info) {
        try {
            int severity;
            int offset = info.getLocation().getBeginColumn() == 0 || info.getLocation().getEndColumn() == 0 ? 0 : this.findOffset(info.getLocation().getBeginLine(), info.getLocation().getBeginColumn(), this.getSourceViewer());
            int endOffset = this.findOffset(info.getLocation().getEndLine(), info.getLocation().getEndColumn(), this.getSourceViewer());
            int length = endOffset - offset + 1;
            if (length <= 0) {
                length = 1;
            }
            switch (info.getErrorSeverity()) {
                case INFO: {
                    severity = 0;
                    break;
                }
                case WARNING: {
                    severity = 1;
                    break;
                }
                case ERROR: {
                    severity = 2;
                    break;
                }
                default: {
                    severity = 2;
                }
            }
            this.addAnnotation(info.getMessage(), info.getMarkerId(), severity, new Position(offset, length), info.getLocation().getBeginLine());
        }
        catch (Exception exception) {
            System.out.println("Editor::reportError exception occured!!!!");
        }
    }

    public boolean addAnnotation(String message, String markerId, int severity, Position pos, int line) {
        IAnnotationModel annotationModel = this.getSourceViewer().getAnnotationModel();
        if (annotationModel != null && this.file != null) {
            try {
                IMarker marker = this.file.createMarker(markerId);
                marker.setAttribute("severity", severity);
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("lineNumber", line);
                if (pos.offset != 0) {
                    marker.setAttribute("charStart", pos.offset);
                    marker.setAttribute("charEnd", pos.offset + pos.length);
                }
                MarkerAnnotation annotation = new MarkerAnnotation(markerId, marker);
                annotationModel.addAnnotation((Annotation)annotation, pos);
                return true;
            }
            catch (Exception exc) {
                exc.printStackTrace(System.err);
            }
        }
        return false;
    }

    public void deleteMarkers(IResource resource, String type) {
        if (resource == null) {
            return;
        }
        try {
            resource.deleteMarkers(type, true, 2);
        }
        catch (CoreException coreException) {}
    }

    public int findOffset(int line, int column, ISourceViewer viewer) {
        IDocument doc = viewer.getDocument();
        int tabwidth = viewer.getTextWidget().getTabs();
        int offset = 0;
        if (line > 0) {
            try {
                offset = doc.getLineOffset(line - 1);
                if (column > 0) {
                    int i = 0;
                    while (i < column - 1) {
                        char c = doc.getChar(offset);
                        ++offset;
                        if (c == '\t') {
                            i = i - i % tabwidth + tabwidth;
                            continue;
                        }
                        ++i;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                System.out.println(".findOffset(): Bad location: line=" + line + ", column=" + column);
            }
        }
        return offset;
    }
}

