/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.eventbus.impl.codecs;

import io.netty.util.CharsetUtil;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.json.JsonObject;

public class JsonObjectMessageCodec
implements MessageCodec<JsonObject, JsonObject> {
    @Override
    public void encodeToWire(Buffer buffer, JsonObject jsonObject) {
        String strJson = jsonObject.encode();
        byte[] encoded = strJson.getBytes(CharsetUtil.UTF_8);
        buffer.appendInt(encoded.length);
        Buffer buff = Buffer.buffer(encoded);
        buffer.appendBuffer(buff);
    }

    @Override
    public JsonObject decodeFromWire(int pos, Buffer buffer) {
        int length = buffer.getInt(pos);
        byte[] encoded = buffer.getBytes(pos += 4, pos + length);
        String str = new String(encoded, CharsetUtil.UTF_8);
        return new JsonObject(str);
    }

    @Override
    public JsonObject transform(JsonObject jsonObject) {
        return jsonObject.copy();
    }

    @Override
    public String name() {
        return "jsonobject";
    }

    @Override
    public byte systemCodecID() {
        return 13;
    }
}

