/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Constructor;
import java.util.logging.Level;

public class ThreadDumpGenerator {
    protected static final ILogger logger = Logger.getLogger(ThreadDumpGenerator.class.getName());
    private static final String THREAD_DUMP_JAVA6_CLASS_NAME = "ThreadDumpGeneratorJava6";
    private static final Class[] TYPE = new Class[]{ThreadMXBean.class};
    protected final ThreadMXBean threadMxBean;

    public static ThreadDumpGenerator newInstance() throws Exception {
        return ThreadDumpGenerator.newInstance(ManagementFactory.getThreadMXBean());
    }

    public static ThreadDumpGenerator newInstance(ThreadMXBean bean) throws Exception {
        String p = System.getProperty("java.specification.version");
        int v = Integer.parseInt(p.split("\\.")[1]);
        if (v >= 6) {
            String pkg = ThreadDumpGenerator.class.getPackage().getName();
            String className = pkg + "." + THREAD_DUMP_JAVA6_CLASS_NAME;
            Class<?> clazz = ThreadDumpGenerator.class.getClassLoader().loadClass(className);
            Constructor<?> cons = clazz.getConstructor(TYPE);
            return (ThreadDumpGenerator)cons.newInstance(bean);
        }
        if (v == 5) {
            return new ThreadDumpGenerator(bean);
        }
        throw new UnsupportedOperationException("ThreadDumpGenerator can not run on JVM version: " + p);
    }

    ThreadDumpGenerator(ThreadMXBean bean) {
        this.threadMxBean = bean;
    }

    public final String dumpAllThreads() {
        logger.log(Level.FINEST, "Generating full thread dump...");
        StringBuilder s = new StringBuilder();
        s.append("Full thread dump ");
        return this.dump(this.getAllThreads(), s);
    }

    public final String dumpDeadlocks() {
        logger.log(Level.FINEST, "Generating dead-locked threads dump...");
        StringBuilder s = new StringBuilder();
        s.append("Deadlocked thread dump ");
        return this.dump(this.findDeadlockedThreads(), s);
    }

    private String dump(ThreadInfo[] infos, StringBuilder s) {
        this.header(s);
        this.appendThreadInfos(infos, s);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "\n" + s.toString());
        }
        return s.toString();
    }

    public ThreadInfo[] getAllThreads() {
        return this.getThreads(this.threadMxBean.getAllThreadIds());
    }

    public ThreadInfo[] findDeadlockedThreads() {
        return this.getThreads(this.threadMxBean.findMonitorDeadlockedThreads());
    }

    private void header(StringBuilder s) {
        s.append(System.getProperty("java.vm.name"));
        s.append(" (");
        s.append(System.getProperty("java.vm.version"));
        s.append(" ");
        s.append(System.getProperty("java.vm.info"));
        s.append("):");
        s.append("\n\n");
    }

    private void appendThreadInfos(ThreadInfo[] infos, StringBuilder s) {
        if (infos == null || infos.length == 0) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            ThreadInfo info = infos[i];
            s.append(info);
        }
    }

    protected ThreadInfo[] getThreads(long[] tids) {
        if (tids == null || tids.length == 0) {
            return null;
        }
        return this.threadMxBean.getThreadInfo(tids, Integer.MAX_VALUE);
    }
}

