/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider2;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.profiling.core.tree.AllGroupDescriptor;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph.SortOption;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph2.DataProviderActionUtils;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph2.Messages;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph2.ThreadIdComparator;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.flamegraph2.ThreadNameComparator;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TmfFilterAppliedSignal;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.TraceCompassFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.ui.widgets.timegraph.BaseDataProviderTimeGraphPresentationProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfTimeNavigationProvider;
import org.eclipse.tracecompass.internal.tmf.ui.views.ITmfTimeZoomProvider;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.IOutputElement;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.TmfUiRefreshHandler;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProviderPreferencePage;
import org.eclipse.tracecompass.tmf.ui.symbols.SymbolProviderConfigDialog;
import org.eclipse.tracecompass.tmf.ui.symbols.TmfSymbolProviderUpdatedSignal;
import org.eclipse.tracecompass.tmf.ui.views.SaveImageUtil;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.TimeGraphControl;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

@NonNullByDefault(value={})
public class FlameGraphView
extends TmfView {
    private static final @NonNull Logger LOGGER = Logger.getLogger(FlameGraphView.class.getName());
    public static final String ID = "org.eclipse.tracecompass.analysis.profiling.ui.flamegraph";
    private static final String TMF_VIEW_UI_CONTEXT = "org.eclipse.tracecompass.tmf.ui.view.context";
    private static final @NonNull String SYMBOL_MAPPING_ICON_PATH = "icons/obj16/binaries_obj.gif";
    private static final @NonNull String GROUP_BY_ICON_PATH = "icons/etool16/group_by.gif";
    private static final String SORT_OPTION_KEY = "sort.option";
    private static final ImageDescriptor SORT_BY_NAME_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha.gif");
    private static final ImageDescriptor SORT_BY_NAME_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_alpha_rev.gif");
    private static final ImageDescriptor SORT_BY_ID_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num.gif");
    private static final ImageDescriptor SORT_BY_ID_REV_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/sort_num_rev.gif");
    private static final ImageDescriptor AGGREGATE_BY_ICON = Activator.getDefault().getImageDescripterFromPath("icons/etool16/group_by.gif");
    private static final int DEFAULT_BUFFER_SIZE = 3;
    private static final String DIRTY_UNDERFLOW = "Dirty underflow";
    private TimeGraphViewer fTimeGraphViewer;
    private SortOption fSortOption = SortOption.BY_NAME;
    private BaseDataProviderTimeGraphPresentationProvider fPresentationProvider;
    private ITmfTrace fTrace;
    private final @NonNull MenuManager fEventMenuManager = new MenuManager();
    private Action fAggregateByAction;
    private Action fSortByNameAction;
    private Action fSortByIdAction;
    private Action fConfigureSymbolsAction;
    private @Nullable IWeightedTreeGroupDescriptor fGroupBy = null;
    private final Semaphore fLock = new Semaphore(1);
    private final AtomicInteger fDirty = new AtomicInteger();
    private final Map<ITmfTrace, Job> fBuildJobMap = new HashMap<ITmfTrace, Job>();
    private final Map<ITimeGraphDataProvider<? extends @NonNull TimeGraphEntryModel>, Map<Long, @NonNull TimeGraphEntry>> fEntries = new HashMap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Map<Long, TimeGraphEntry>>();
    private @NonNull Set<@NonNull TimeGraphEntry> fVisibleEntries = Collections.emptySet();
    private long fEndTime = Long.MIN_VALUE;
    private final Map<ITmfTrace, List<@NonNull TimeGraphEntry>> fEntryListMap = new HashMap<ITmfTrace, List<TimeGraphEntry>>();
    private int fDisplayWidth;
    private @Nullable ZoomThread fZoomThread;
    private final Object fZoomThreadResultLock = new Object();
    private IContextService fContextService;
    private List<IContextActivation> fActiveContexts = new ArrayList<IContextActivation>();

    public FlameGraphView() {
        super(ID);
    }

    protected FlameGraphView(String id) {
        super(id);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.fDisplayWidth = Display.getDefault().getBounds().width;
        this.fTimeGraphViewer = new TimeGraphViewer(parent, 0);
        this.fPresentationProvider = new BaseDataProviderTimeGraphPresentationProvider();
        this.fTimeGraphViewer.setTimeGraphProvider((ITimeGraphPresentationProvider)this.fPresentationProvider);
        this.fTimeGraphViewer.setTimeFormat(Utils.TimeFormat.NUMBER);
        IEditorPart editor = this.getSite().getPage().getActiveEditor();
        ITmfTrace trace = null;
        trace = editor instanceof ITmfTraceEditor ? ((ITmfTraceEditor)editor).getTrace() : TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            this.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        this.contributeToActionBars();
        this.loadSortOption();
        TmfSignalManager.register((Object)((Object)this));
        this.getSite().setSelectionProvider(this.fTimeGraphViewer.getSelectionProvider());
        this.createTimeEventContextMenu();
        this.fTimeGraphViewer.getTimeGraphControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                TimeGraphControl timeGraphControl = FlameGraphView.this.getTimeGraphViewer().getTimeGraphControl();
                ISelection selection = timeGraphControl.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object object : ((IStructuredSelection)selection).toList()) {
                        if (!(object instanceof TimeEvent)) continue;
                        TimeEvent event = (TimeEvent)object;
                        long startTime = event.getTime();
                        long endTime = startTime + event.getDuration();
                        FlameGraphView.this.getTimeGraphViewer().setStartFinishTime(startTime, endTime);
                        break;
                    }
                }
            }
        });
        this.fTimeGraphViewer.addRangeListener(event -> this.startZoomThread(event.getStartTime(), event.getEndTime(), false));
        final TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        timeGraphControl.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TmfUiRefreshHandler.getInstance().queueUpdate((Object)this, () -> {
                    if (timeGraphControl.isDisposed()) {
                        return;
                    }
                    Set<@NonNull TimeGraphEntry> newSet = FlameGraphView.this.getVisibleItems(3);
                    if (!FlameGraphView.this.fVisibleEntries.equals(newSet)) {
                        FlameGraphView.this.fVisibleEntries = newSet;
                        FlameGraphView.this.startZoomThread(FlameGraphView.this.getTimeGraphViewer().getTime0(), FlameGraphView.this.getTimeGraphViewer().getTime1(), false);
                    }
                });
            }
        });
        this.fContextService = Objects.requireNonNull((IContextService)this.getSite().getWorkbenchWindow().getService(IContextService.class));
        if (timeGraphControl.isInFocus()) {
            this.activateContextService();
        }
        timeGraphControl.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                FlameGraphView.this.deactivateContextService();
            }

            public void focusGained(FocusEvent e) {
                FlameGraphView.this.activateContextService();
            }
        });
    }

    private void activateContextService() {
        if (this.fActiveContexts.isEmpty()) {
            this.fActiveContexts.add(this.fContextService.activateContext(TMF_VIEW_UI_CONTEXT));
        }
    }

    private void deactivateContextService() {
        this.fContextService.deactivateContexts(this.fActiveContexts);
        this.fActiveContexts.clear();
    }

    @VisibleForTesting
    public TimeGraphViewer getTimeGraphViewer() {
        return this.fTimeGraphViewer;
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        ITmfTrace trace;
        this.fTrace = trace = signal.getTrace();
        if (trace == null) {
            return;
        }
        List<@NonNull TimeGraphEntry> list = this.fEntryListMap.get(trace);
        if (list == null) {
            this.refresh();
            Display.getDefault().asyncExec(() -> this.buildFlameGraph(trace, null, null));
        } else {
            long endTime = Long.MIN_VALUE;
            for (TimeGraphEntry entry : list) {
                endTime = Math.max(endTime, entry.getEndTime());
            }
            this.setEndTime(endTime);
            this.refresh();
            this.startZoomThread(0L, endTime, false);
        }
    }

    protected Iterable<ICallGraphProvider2> getCallgraphModules() {
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            return null;
        }
        String analysisId = NonNullUtils.nullToEmptyString((Object)this.getViewSite().getSecondaryId());
        Iterable modules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, ICallGraphProvider2.class);
        return StreamSupport.stream(modules.spliterator(), false).filter(m -> {
            if (m instanceof IAnalysisModule) {
                return ((IAnalysisModule)m).getId().equals(analysisId);
            }
            return true;
        }).collect(Collectors.toSet());
    }

    private String getProviderId() {
        String secondaryId = this.getViewSite().getSecondaryId();
        return secondaryId == null ? "org.eclipse.tracecompass.analysis.profiling.core.flamegraph" : (secondaryId.contains("[COLON]") ? secondaryId.replace("[COLON]", ":") : "org.eclipse.tracecompass.analysis.profiling.core.flamegraph:" + secondaryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    private void buildEntryList(@NonNull ITmfTrace trace, @NonNull ITmfTrace parentTrace, @NonNull Map<String, Object> additionalParams, @NonNull IProgressMonitor monitor) {
        @NonNull ITimeGraphDataProvider dataProvider = (ITimeGraphDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(trace, this.getProviderId(), ITimeGraphDataProvider.class);
        if (dataProvider == null) {
            return;
        }
        BaseDataProviderTimeGraphPresentationProvider presentationProvider = this.fPresentationProvider;
        if (presentationProvider != null) {
            presentationProvider.addProvider(dataProvider, FlameGraphView.getTooltipResolver((ITimeGraphDataProvider<? extends TimeGraphEntryModel>)dataProvider));
        }
        boolean complete = false;
        while (!complete && !monitor.isCanceled()) {
            TmfModelResponse response;
            HashMap<String, Object> parameters = new HashMap<String, Object>(additionalParams);
            parameters.put("requested_times", ImmutableList.of((Object)0, (Object)Long.MAX_VALUE));
            IWeightedTreeGroupDescriptor groupBy = this.fGroupBy;
            if (groupBy != null) {
                parameters.put("group_by", groupBy.getName());
            }
            if ((response = dataProvider.fetchTree(parameters, monitor)).getStatus() == ITmfResponse.Status.FAILED) {
                Activator.getDefault().logError(((Object)((Object)this)).getClass().getSimpleName() + " Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            @NonNull TmfTreeModel model = (TmfTreeModel)response.getModel();
            long endTime = Long.MIN_VALUE;
            if (model != null) {
                Map entries;
                Map<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Map<Long, TimeGraphEntry>> map = this.fEntries;
                synchronized (map) {
                    entries = this.fEntries.computeIfAbsent((ITimeGraphDataProvider<? extends TimeGraphEntryModel>)dataProvider, dp -> new HashMap());
                    ArrayList<TimeGraphEntry> orphaned = new ArrayList<TimeGraphEntry>();
                    for (TimeGraphEntryModel entry : model.getEntries()) {
                        TimeGraphEntry uiEntry = (TimeGraphEntry)entries.get(entry.getId());
                        if (entry.getParentId() != -1L) {
                            if (uiEntry == null) {
                                uiEntry = new TimeGraphEntry(entry);
                                TimeGraphEntry parent = (TimeGraphEntry)entries.get(entry.getParentId());
                                if (parent != null) {
                                    parent.addChild(uiEntry);
                                } else {
                                    orphaned.add(uiEntry);
                                }
                                entries.put(entry.getId(), uiEntry);
                                continue;
                            }
                            uiEntry.updateModel(entry);
                            continue;
                        }
                        endTime = Long.max(endTime, entry.getEndTime() + 1L);
                        if (uiEntry != null) {
                            uiEntry.updateModel(entry);
                            continue;
                        }
                        uiEntry = new ParentEntry(entry, (ITimeGraphDataProvider<? extends TimeGraphEntryModel>)dataProvider);
                        entries.put(entry.getId(), uiEntry);
                        this.addToEntryList(parentTrace, Collections.singletonList(uiEntry));
                    }
                    this.setEndTime(endTime);
                    for (TimeGraphEntry orphanedEntry : orphaned) {
                        TimeGraphEntry parent = (TimeGraphEntry)entries.get(orphanedEntry.getEntryModel().getParentId());
                        if (parent == null) continue;
                        parent.addChild(orphanedEntry);
                    }
                }
                long start = 0L;
                long end = this.getEndTime();
                long resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
                this.zoomEntries((Iterable<TimeGraphEntry>)ImmutableList.copyOf(entries.values()), start, end, resolution, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            monitor.worked(1);
            if (complete || monitor.isCanceled()) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError("Failed to wait for data provider", e);
            }
        }
    }

    @VisibleForTesting
    public BaseDataProviderTimeGraphPresentationProvider getPresentationProvider() {
        return this.fPresentationProvider;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ITmfTimeNavigationProvider.class) {
            return (T)this.getTimeNavigator();
        }
        if (adapter == ITmfTimeZoomProvider.class) {
            return (T)this.getTimeZoomProvider();
        }
        return (T)super.getAdapter(adapter);
    }

    private ITmfTimeNavigationProvider getTimeNavigator() {
        return left -> {
            TimeGraphControl control = this.getTimeGraphControl();
            if (control != null) {
                control.horizontalScroll(left);
            }
        };
    }

    private ITmfTimeZoomProvider getTimeZoomProvider() {
        return (zoomIn, useMousePosition) -> {
            TimeGraphControl control = this.getTimeGraphControl();
            TimeGraphViewer viewer = this.getTimeGraphViewer();
            if (control != null && viewer != null) {
                if (useMousePosition) {
                    control.zoom(zoomIn);
                } else {
                    int xCoord = control.toControl((Point)control.getDisplay().getCursorLocation()).x;
                    if (viewer.getNameSpace() <= xCoord && xCoord < control.getSize().x) {
                        if (zoomIn) {
                            control.zoomIn();
                        } else {
                            control.zoomOut();
                        }
                    }
                }
            }
        };
    }

    private @Nullable TimeGraphControl getTimeGraphControl() {
        TimeGraphViewer viewer = this.getTimeGraphViewer();
        TimeGraphControl control = viewer.getTimeGraphControl();
        if (control != null) {
            return control;
        }
        return null;
    }

    private static BiFunction<ITimeEvent, Long, Map<String, String>> getTooltipResolver(ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider) {
        return (event, time) -> FlameGraphView.getTooltip(event, time, provider, false);
    }

    private static Map<String, String> getTooltip(ITimeEvent event, Long time, ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider, boolean getActions) {
        TmfModelResponse response;
        Map tooltip;
        ITimeGraphEntry entry = event.getEntry();
        if (!(entry instanceof TimeGraphEntry)) {
            return Collections.emptyMap();
        }
        long entryId = ((TimeGraphEntry)entry).getEntryModel().getId();
        ITimeElement element = null;
        if (event instanceof TimeEvent) {
            element = ((TimeEvent)event).getModel();
        }
        Map<@NonNull String, @NonNull Object> parameters = FlameGraphView.getFetchTooltipParameters(time, entryId, (IOutputElement)element);
        if (getActions) {
            parameters.put("actions", true);
        }
        return (tooltip = (Map)(response = provider.fetchTooltip(parameters, (IProgressMonitor)new NullProgressMonitor())).getModel()) == null ? Collections.emptyMap() : tooltip;
    }

    private static Map<String, Object> getFetchTooltipParameters(long time, long item, @Nullable IOutputElement element) {
        @NonNull HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("requested_times", Collections.singletonList(time));
        parameters.put("requested_items", Collections.singletonList(item));
        if (element != null) {
            parameters.put("requested_element", element);
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void startZoomThread(long startTime, long endTime, boolean force) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        this.fDirty.incrementAndGet();
        try {
            Throwable throwable = null;
            Object var8_7 = null;
            try {
                long clampedEndTime;
                long clampedStartTime;
                LogUtils.FlowScopeLog log;
                block21: {
                    log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:ZoomThreadCreated", new Object[0]).setCategory(this.getViewId()).build();
                    clampedStartTime = Math.max(0L, Math.min(startTime, this.getEndTime()));
                    clampedEndTime = Math.min(this.getEndTime(), Math.max(endTime, 0L));
                    if (clampedEndTime >= clampedStartTime) break block21;
                    if (log == null) return;
                    log.close();
                    return;
                }
                try {
                    int timeSpace;
                    ZoomThread zoomThread = this.fZoomThread;
                    if (zoomThread != null) {
                        zoomThread.cancel();
                    }
                    if ((timeSpace = this.getTimeGraphViewer().getTimeSpace()) > 0) {
                        long resolution = Long.max(1L, (clampedEndTime - clampedStartTime) / (long)timeSpace);
                        zoomThread = new ZoomThread(this.getVisibleItems(3), clampedStartTime, clampedEndTime, resolution, force);
                    } else {
                        zoomThread = null;
                    }
                    this.fZoomThread = zoomThread;
                    if (zoomThread == null) return;
                    zoomThread.setScopeId(log.getId());
                    Object object = this.fZoomThreadResultLock;
                    synchronized (object) {
                        zoomThread.start();
                        this.fDirty.incrementAndGet();
                        return;
                    }
                }
                finally {
                    if (log != null) {
                        log.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        finally {
            if (this.fDirty.decrementAndGet() < 0) {
                Activator.getDefault().logError(DIRTY_UNDERFLOW, new Throwable());
            }
        }
    }

    private @NonNull Set<@NonNull TimeGraphEntry> getVisibleItems(int buffer) {
        TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        if (timeGraphControl.isDisposed()) {
            return Collections.emptySet();
        }
        int start = Integer.max(0, this.fTimeGraphViewer.getTopIndex() - buffer);
        int end = Integer.min(this.fTimeGraphViewer.getExpandedElementCount() - 1, this.fTimeGraphViewer.getTopIndex() + timeGraphControl.countPerPage() + buffer);
        HashSet<@NonNull TimeGraphEntry> visible = new HashSet<TimeGraphEntry>(end - start + 1);
        int i = start;
        while (i <= end) {
            TimeGraphEntry element = (TimeGraphEntry)timeGraphControl.getExpandedElement(i);
            if (element != null) {
                visible.add(element);
            }
            ++i;
        }
        return visible;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void zoomEntries(@NonNull Iterable<@NonNull TimeGraphEntry> entries, long zoomStartTime, long zoomEndTime, long resolution, @NonNull IProgressMonitor monitor) {
        if (resolution < 0L) {
            return;
        }
        long start = Long.min(zoomStartTime, zoomEndTime);
        long end = Long.max(zoomStartTime, zoomEndTime);
        @NonNull List times = StateSystemUtils.getTimes((long)start, (long)end, (long)resolution);
        TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(start, end, resolution);
        Multimap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long> providersToModelIds = FlameGraphView.filterGroupEntries(entries, zoomStartTime, zoomEndTime);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)(((Object)((Object)this)).getClass().getSimpleName() + "#zoomEntries"), (int)providersToModelIds.size());
        for (Map.Entry entry : providersToModelIds.asMap().entrySet()) {
            TmfModelResponse response;
            TimeGraphModel model;
            ITimeGraphDataProvider dataProvider = (ITimeGraphDataProvider)entry.getKey();
            SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(times, (Collection)entry.getValue());
            @NonNull @NonNull Map parameters = FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter);
            Multimap<@NonNull Integer, @NonNull String> regexesMap = this.getRegexes();
            if (!regexesMap.isEmpty()) {
                parameters.put("regex_map_filters", regexesMap.asMap());
            }
            if ((model = (TimeGraphModel)(response = dataProvider.fetchRowModel(parameters, monitor)).getModel()) != null) {
                this.zoomEntries(this.fEntries.get(dataProvider), model.getRows(), response.getStatus() == ITmfResponse.Status.COMPLETED, sampling);
            }
            subMonitor.worked(1);
        }
        this.redraw();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull Multimap<@NonNull Integer, @NonNull String> getRegexes() {
        @NonNull @NonNull HashMultimap regexes = HashMultimap.create();
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return regexes;
        }
        TraceCompassFilter globalFilter = TraceCompassFilter.getFilterForTrace((ITmfTrace)trace);
        if (globalFilter == null) {
            return regexes;
        }
        regexes.putAll((Object)1, (Iterable)globalFilter.getRegexes());
        return regexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zoomEntries(Map<Long, TimeGraphEntry> map, List<ITimeGraphRowModel> model, boolean completed, TimeGraphEntry.Sampling sampling) {
        boolean isZoomThread = false;
        for (ITimeGraphRowModel rowModel : model) {
            TimeGraphEntry entry = map.get(rowModel.getEntryID());
            if (entry == null) continue;
            List<ITimeEvent> events = this.createTimeEvents(entry, rowModel.getStates());
            if (isZoomThread) {
                Object object = this.fZoomThreadResultLock;
                synchronized (object) {
                    Display.getDefault().asyncExec(() -> {
                        entry.setZoomedEventList(events);
                        if (completed) {
                            entry.setSampling(sampling);
                        }
                    });
                    continue;
                }
            }
            entry.setEventList(events);
        }
    }

    private List<ITimeEvent> createTimeEvents(TimeGraphEntry entry, List<ITimeGraphState> values) {
        ArrayList<ITimeEvent> events = new ArrayList<ITimeEvent>(values.size());
        TimeEvent prev = null;
        for (ITimeGraphState state : values) {
            long prevEnd;
            TimeEvent event = this.createTimeEvent(entry, state);
            if (prev != null && (prevEnd = prev.getTime() + prev.getDuration()) < event.getTime()) {
                TimeEvent timeEvent = new TimeEvent((ITimeGraphEntry)entry, prevEnd, event.getTime() - prevEnd);
                events.add((ITimeEvent)timeEvent);
            }
            prev = event;
            events.add((ITimeEvent)event);
        }
        return events;
    }

    protected TimeEvent createTimeEvent(TimeGraphEntry entry, ITimeGraphState state) {
        String label = state.getLabel();
        if (state.getValue() == Integer.MIN_VALUE && label == null && state.getStyle() == null) {
            return new NullTimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration());
        }
        if (label != null) {
            return new NamedTimeEvent((ITimeGraphEntry)entry, label, state);
        }
        return new TimeEvent((ITimeGraphEntry)entry, (ITimeElement)state);
    }

    private static Multimap<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Long> filterGroupEntries(Iterable<TimeGraphEntry> visible, long zoomStartTime, long zoomEndTime) {
        HashMultimap providersToModelIds = HashMultimap.create();
        for (TimeGraphEntry entry : visible) {
            ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider;
            if (zoomStartTime > entry.getEndTime() || zoomEndTime < entry.getStartTime() || !entry.hasTimeEvents() || (provider = FlameGraphView.getProvider((ITimeGraphEntry)entry)) == null) continue;
            providersToModelIds.put(provider, (Object)entry.getEntryModel().getId());
        }
        return providersToModelIds;
    }

    public static ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider(ITimeGraphEntry entry) {
        ITimeGraphEntry parent = entry;
        while (parent != null) {
            if (parent instanceof ParentEntry) {
                return ((ParentEntry)parent).getProvider();
            }
            parent = parent.getParent();
        }
        throw new IllegalStateException(String.valueOf(entry) + " should have a TraceEntry parent");
    }

    protected ITmfTrace getTrace() {
        return this.fTrace;
    }

    private void refresh() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (LogUtils.FlowScopeLog parentLogger = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:RefreshRequested", new Object[0]).setCategory(this.getViewId()).build();){
            boolean isZoomThread = Thread.currentThread() instanceof ZoomThread;
            TmfUiRefreshHandler.getInstance().queueUpdate((Object)this, () -> {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try {
                        LogUtils.FlowScopeLog log;
                        block24: {
                            log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:Refresh", new Object[0]).setParentScope((LogUtils.IFlowScopeLog)parentLogger).build();
                            this.fDirty.incrementAndGet();
                            if (!this.fTimeGraphViewer.getControl().isDisposed()) break block24;
                            if (log == null) return;
                            log.close();
                            return;
                        }
                        try {
                            boolean inputChanged;
                            List<TimeGraphEntry> entries;
                            Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
                            synchronized (map) {
                                entries = this.fEntryListMap.get(this.getTrace());
                                Comparator<ITimeGraphEntry> entryComparator = this.getEntryComparator();
                                if (entries == null) {
                                    entries = new CopyOnWriteArrayList<TimeGraphEntry>();
                                } else if (entryComparator != null) {
                                    ArrayList<TimeGraphEntry> list = new ArrayList<TimeGraphEntry>(entries);
                                    Collections.sort(list, entryComparator);
                                    Iterator iterator = list.iterator();
                                    while (true) {
                                        if (!iterator.hasNext()) {
                                            entries.clear();
                                            entries.addAll(list);
                                            break;
                                        }
                                        ITimeGraphEntry iTimeGraphEntry = (ITimeGraphEntry)iterator.next();
                                        FlameGraphView.sortChildren(iTimeGraphEntry, entryComparator);
                                    }
                                }
                            }
                            boolean bl2 = inputChanged = entries != this.fTimeGraphViewer.getInput();
                            if (inputChanged) {
                                this.fTimeGraphViewer.setInput(entries);
                            } else {
                                this.fTimeGraphViewer.refresh();
                            }
                            long startBound = 0L;
                            long l = this.getEndTime();
                            l = l == Long.MIN_VALUE ? -1L : l;
                            this.fTimeGraphViewer.setTimeBounds(startBound, l);
                            if (!inputChanged) return;
                            if (isZoomThread) return;
                            this.fTimeGraphViewer.resetStartFinishTime();
                            return;
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                        finally {
                            if (log != null) {
                                log.close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                finally {
                    if (this.fDirty.decrementAndGet() < 0) {
                        Activator.getDefault().logError(DIRTY_UNDERFLOW, new Throwable());
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Comparator<ITimeGraphEntry> getEntryComparator() {
        switch (this.fSortOption) {
            case BY_ID: {
                return ThreadIdComparator.getInstance();
            }
            case BY_ID_REV: {
                return ThreadIdComparator.getInstance().reversed();
            }
            case BY_NAME: {
                return ThreadNameComparator.getInstance();
            }
            case BY_NAME_REV: {
                return ThreadNameComparator.getInstance().reversed();
            }
        }
        return null;
    }

    private void redraw() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (LogUtils.FlowScopeLog flowParent = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:RedrawRequested", new Object[0]).setCategory(this.getViewId()).build();){
            Display.getDefault().asyncExec(() -> {
                Throwable throwable = null;
                Object var3_4 = null;
                try (LogUtils.FlowScopeLog log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:Redraw", new Object[0]).setParentScope((LogUtils.IFlowScopeLog)flowParent).build();){
                    if (this.fTimeGraphViewer.getControl().isDisposed()) {
                        return;
                    }
                    this.fTimeGraphViewer.getControl().redraw();
                    this.fTimeGraphViewer.getControl().update();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void sortChildren(ITimeGraphEntry entry, Comparator<ITimeGraphEntry> comparator) {
        if (entry instanceof TimeGraphEntry) {
            ((TimeGraphEntry)entry).sortChildren(comparator);
        }
        for (ITimeGraphEntry child : entry.getChildren()) {
            FlameGraphView.sortChildren(child, comparator);
        }
    }

    private int getDisplayWidth() {
        int displayWidth = this.fDisplayWidth;
        return displayWidth <= 0 ? 1 : displayWidth;
    }

    private synchronized void setEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    private long getEndTime() {
        return this.fEndTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToEntryList(ITmfTrace trace, List<@NonNull TimeGraphEntry> list) {
        Map<ITmfTrace, List<TimeGraphEntry>> map = this.fEntryListMap;
        synchronized (map) {
            List<TimeGraphEntry> entryList = this.fEntryListMap.get(trace);
            if (entryList == null) {
                this.fEntryListMap.put(trace, new CopyOnWriteArrayList<TimeGraphEntry>(list));
            } else {
                for (TimeGraphEntry entry : list) {
                    if (entryList.contains(entry)) continue;
                    entryList.add(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetEntries(ITmfTrace trace) {
        Map<ITimeGraphDataProvider<? extends TimeGraphEntryModel>, Map<Long, TimeGraphEntry>> map = this.fEntries;
        synchronized (map) {
            Map<ITmfTrace, List<TimeGraphEntry>> map2 = this.fEntryListMap;
            synchronized (map2) {
                List<@NonNull TimeGraphEntry> entries = this.fEntryListMap.remove(trace);
                if (entries == null) {
                    return;
                }
                for (TimeGraphEntry entry : entries) {
                    if (!(entry instanceof ParentEntry)) continue;
                    this.fEntries.remove(((ParentEntry)entry).getProvider());
                }
                this.refresh();
            }
        }
    }

    @VisibleForTesting
    public void buildFlameGraph(final @NonNull ITmfTrace viewTrace, final @Nullable ITmfTimestamp selStart, final @Nullable ITmfTimestamp selEnd) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (final LogUtils.FlowScopeLog log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:Building", new Object[0]).setCategory(this.getViewId()).build();){
            Job buildJob;
            try {
                this.fLock.acquire();
            }
            catch (InterruptedException e) {
                Activator.getDefault().logError(e.getMessage(), e);
                this.fLock.release();
            }
            IWorkbenchSiteProgressService service = null;
            IWorkbenchPartSite site = this.getSite();
            if (site != null) {
                service = (IWorkbenchSiteProgressService)site.getService(IWorkbenchSiteProgressService.class);
            }
            if ((buildJob = this.fBuildJobMap.remove(viewTrace)) != null) {
                buildJob.cancel();
            }
            this.resetEntries(viewTrace);
            buildJob = new Job(this.getTitle() + Messages.FlameGraphView_RetrievingData){

                protected IStatus run(IProgressMonitor monitor) {
                    new BuildRunnable(viewTrace, viewTrace, selStart, selEnd, log).run(monitor);
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            this.fBuildJobMap.put(viewTrace, buildJob);
            if (service != null) {
                service.schedule(buildJob);
            } else {
                buildJob.schedule();
            }
            this.fLock.release();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @VisibleForTesting
    public boolean isDirty() throws InterruptedException {
        this.fLock.acquire();
        this.fLock.release();
        return this.fDirty.get() != 0;
    }

    @VisibleForTesting
    public void setTrace(ITmfTrace trace) {
        this.fTrace = trace;
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (signal.getTrace() == this.fTrace) {
            this.fTimeGraphViewer.setInput(null);
        }
    }

    public void setFocus() {
        this.fTimeGraphViewer.setFocus();
    }

    private void createTimeEventContextMenu() {
        this.fEventMenuManager.setRemoveAllWhenShown(true);
        final TimeGraphControl timeGraphControl = this.fTimeGraphViewer.getTimeGraphControl();
        final Menu timeEventMenu = this.fEventMenuManager.createContextMenu((Control)timeGraphControl);
        timeGraphControl.addTimeGraphEntryMenuListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        timeGraphControl.addTimeEventMenuListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                Menu menu = timeEventMenu;
                if (event.data instanceof TimeEvent && !(event.data instanceof NullTimeEvent)) {
                    timeGraphControl.setMenu(menu);
                    return;
                }
                timeGraphControl.setMenu(null);
                event.doit = false;
            }
        });
        this.fEventMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FlameGraphView.this.fillTimeEventContextMenu((IMenuManager)FlameGraphView.this.fEventMenuManager);
                FlameGraphView.this.fEventMenuManager.add((IContributionItem)new GroupMarker("additions"));
            }
        });
        this.getSite().registerContextMenu(this.fEventMenuManager, this.fTimeGraphViewer.getSelectionProvider());
    }

    protected void fillTimeEventContextMenu(@NonNull IMenuManager menuManager) {
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object object : ((IStructuredSelection)selection).toList()) {
                if (!(object instanceof ITimeEvent)) continue;
                ITimeEvent event = (ITimeEvent)object;
                ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider = FlameGraphView.getProvider(event.getEntry());
                Map<String, String> tooltip = FlameGraphView.getTooltip(event, event.getTime(), provider, true);
                for (final Map.Entry<String, String> entry : tooltip.entrySet()) {
                    String tooltipKey = entry.getKey();
                    if (!tooltipKey.startsWith("#")) continue;
                    menuManager.add((IAction)new Action(tooltipKey.substring("#".length())){

                        public void run() {
                            DataProviderActionUtils.executeAction((String)entry.getValue());
                        }
                    });
                }
            }
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.getConfigureSymbolsAction());
        manager.add((IAction)this.getAggregateByAction());
        manager.add((IAction)this.getSortByNameAction());
        manager.add((IAction)this.getSortByIdAction());
        manager.add((IContributionItem)new Separator());
    }

    private Action getAggregateByAction() {
        if (this.fAggregateByAction == null) {
            this.fAggregateByAction = new Action(Messages.FlameGraphView_GroupByName, 4){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fSortOption;
                    if (sortOption == SortOption.BY_NAME) {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME);
                    }
                }
            };
            this.fAggregateByAction.setToolTipText(Messages.FlameGraphView_GroupByTooltip);
            this.fAggregateByAction.setImageDescriptor(AGGREGATE_BY_ICON);
            this.fAggregateByAction.setMenuCreator(new IMenuCreator(){
                private Menu menu = null;

                public void dispose() {
                    if (this.menu != null) {
                        this.menu.dispose();
                        this.menu = null;
                    }
                }

                public Menu getMenu(Control parent) {
                    if (this.menu != null) {
                        this.menu.dispose();
                    }
                    this.menu = new Menu(parent);
                    Iterable<ICallGraphProvider2> callgraphModules = FlameGraphView.this.getCallgraphModules();
                    Iterator<ICallGraphProvider2> iterator = callgraphModules.iterator();
                    if (!iterator.hasNext()) {
                        return this.menu;
                    }
                    ICallGraphProvider2 provider = iterator.next();
                    Action allGroupAction = FlameGraphView.this.createActionForGroup(AllGroupDescriptor.getInstance());
                    new ActionContributionItem((IAction)allGroupAction).fill(this.menu, -1);
                    Collection series = provider.getGroupDescriptors();
                    series.forEach(group -> {
                        IWeightedTreeGroupDescriptor subGroup = group;
                        do {
                            Action groupAction = FlameGraphView.this.createActionForGroup(subGroup);
                            new ActionContributionItem((IAction)groupAction).fill(this.menu, -1);
                        } while ((subGroup = subGroup.getNextGroup()) != null);
                    });
                    return this.menu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }
            });
        }
        return this.fAggregateByAction;
    }

    private Action createActionForGroup(final IWeightedTreeGroupDescriptor descriptor) {
        return new Action(descriptor.getName(), 8){

            public void run() {
                ITmfTrace trace = FlameGraphView.this.getTrace();
                if (trace == null) {
                    return;
                }
                FlameGraphView.this.fGroupBy = descriptor;
                FlameGraphView.this.buildFlameGraph(trace, null, null);
            }
        };
    }

    private Action getSortByNameAction() {
        if (this.fSortByNameAction == null) {
            this.fSortByNameAction = new Action(Messages.FlameGraph_SortByThreadName, 2){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fSortOption;
                    if (sortOption == SortOption.BY_NAME) {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_NAME);
                    }
                }
            };
            this.fSortByNameAction.setToolTipText(Messages.FlameGraph_SortByThreadName);
            this.fSortByNameAction.setImageDescriptor(SORT_BY_NAME_ICON);
        }
        return this.fSortByNameAction;
    }

    private Action getSortByIdAction() {
        if (this.fSortByIdAction == null) {
            this.fSortByIdAction = new Action(Messages.FlameGraph_SortByThreadId, 2){

                public void run() {
                    SortOption sortOption = FlameGraphView.this.fSortOption;
                    if (sortOption == SortOption.BY_ID) {
                        FlameGraphView.this.setSortOption(SortOption.BY_ID_REV);
                    } else {
                        FlameGraphView.this.setSortOption(SortOption.BY_ID);
                    }
                }
            };
            this.fSortByIdAction.setToolTipText(Messages.FlameGraph_SortByThreadId);
            this.fSortByIdAction.setImageDescriptor(SORT_BY_ID_ICON);
        }
        return this.fSortByIdAction;
    }

    private void setSortOption(SortOption sortOption) {
        this.getSortByNameAction().setChecked(false);
        this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_ICON);
        this.getSortByIdAction().setChecked(false);
        this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_ICON);
        if (sortOption == SortOption.BY_NAME) {
            this.fSortOption = SortOption.BY_NAME;
            this.getSortByNameAction().setChecked(true);
        } else if (sortOption == SortOption.BY_NAME_REV) {
            this.fSortOption = SortOption.BY_NAME_REV;
            this.getSortByNameAction().setChecked(true);
            this.getSortByNameAction().setImageDescriptor(SORT_BY_NAME_REV_ICON);
        } else if (sortOption == SortOption.BY_ID) {
            this.fSortOption = SortOption.BY_ID;
            this.getSortByIdAction().setChecked(true);
        } else if (sortOption == SortOption.BY_ID_REV) {
            this.fSortOption = SortOption.BY_ID_REV;
            this.getSortByIdAction().setChecked(true);
            this.getSortByIdAction().setImageDescriptor(SORT_BY_ID_REV_ICON);
        }
        this.saveSortOption();
        this.refresh();
    }

    private void saveSortOption() {
        SortOption sortOption = this.fSortOption;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            section = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        section.put(SORT_OPTION_KEY, sortOption.name());
    }

    private void loadSortOption() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (section == null) {
            return;
        }
        String sortOption = section.get(SORT_OPTION_KEY);
        if (sortOption == null) {
            return;
        }
        this.setSortOption(SortOption.fromName(sortOption));
    }

    private Action getConfigureSymbolsAction() {
        if (this.fConfigureSymbolsAction != null) {
            return this.fConfigureSymbolsAction;
        }
        this.fConfigureSymbolsAction = new Action(Messages.FlameGraphView_ConfigureSymbolProvidersText){

            public void run() {
                SymbolProviderConfigDialog dialog = new SymbolProviderConfigDialog(FlameGraphView.this.getSite().getShell(), FlameGraphView.this.getProviderPages());
                if (dialog.open() == 0) {
                    FlameGraphView.this.startZoomThread(FlameGraphView.this.getTimeGraphViewer().getTime0(), FlameGraphView.this.getTimeGraphViewer().getTime1(), true);
                }
            }
        };
        this.fConfigureSymbolsAction.setToolTipText(Messages.FlameGraphView_ConfigureSymbolProvidersTooltip);
        this.fConfigureSymbolsAction.setImageDescriptor(Activator.getDefault().getImageDescripterFromPath(SYMBOL_MAPPING_ICON_PATH));
        this.fConfigureSymbolsAction.setEnabled(true);
        return this.fConfigureSymbolsAction;
    }

    private ISymbolProviderPreferencePage[] getProviderPages() {
        ArrayList<ISymbolProviderPreferencePage> pages = new ArrayList<ISymbolProviderPreferencePage>();
        ITmfTrace trace = this.fTrace;
        if (trace != null) {
            for (ITmfTrace subTrace : TmfTraceManager.getTraceSet((ITmfTrace)trace)) {
                for (ISymbolProvider provider : SymbolProviderManager.getInstance().getSymbolProviders(subTrace)) {
                    org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider provider2;
                    ISymbolProviderPreferencePage page;
                    if (!(provider instanceof org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider) || (page = (provider2 = (org.eclipse.tracecompass.tmf.ui.symbols.ISymbolProvider)provider).createPreferencePage()) == null) continue;
                    pages.add(page);
                }
            }
        }
        return pages.toArray(new ISymbolProviderPreferencePage[pages.size()]);
    }

    @TmfSignalHandler
    public void symbolMapUpdated(TmfSymbolProviderUpdatedSignal signal) {
        if (signal.getSource() != this) {
            this.startZoomThread(this.getTimeGraphViewer().getTime0(), this.getTimeGraphViewer().getTime1(), true);
        }
    }

    protected @Nullable IAction createSaveAction() {
        return SaveImageUtil.createSaveAction((String)this.getName(), this::getTimeGraphViewer);
    }

    public void restartZoomThread() {
        ZoomThread zoomThread = this.fZoomThread;
        if (zoomThread != null) {
            zoomThread.cancel();
            this.fZoomThread = null;
        }
        this.startZoomThread(this.getTimeGraphViewer().getTime0(), this.getTimeGraphViewer().getTime1(), true);
    }

    @TmfSignalHandler
    public void regexFilterApplied(TmfFilterAppliedSignal signal) {
        Display.getDefault().asyncExec(() -> this.restartZoomThread());
    }

    @TmfSignalHandler
    public void analysisStart(TmfStartAnalysisSignal signal) {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            return;
        }
        IAnalysisModule module = signal.getAnalysisModule();
        if (module instanceof IWeightedTreeProvider) {
            this.buildFlameGraph(trace, null, null);
        }
    }

    private class BuildRunnable {
        private final @NonNull ITmfTrace fBuildTrace;
        private final @NonNull ITmfTrace fParentTrace;
        private final // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull LogUtils.FlowScopeLog fScope;
        private final @NonNull Map<String, Object> fParameters;

        public BuildRunnable(@NonNull ITmfTrace trace, @Nullable ITmfTrace parentTrace, @Nullable ITmfTimestamp selStart, @NonNull ITmfTimestamp selEnd, LogUtils.FlowScopeLog log) {
            this.fBuildTrace = trace;
            this.fParentTrace = parentTrace;
            this.fScope = log;
            this.fParameters = selStart != null && selEnd != null ? ImmutableMap.of((Object)"selection_range", (Object)ImmutableList.of((Object)selStart.toNanos(), (Object)selEnd.toNanos())) : Collections.emptyMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(IProgressMonitor monitor) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (LogUtils.FlowScopeLog log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:BuildThread", new Object[]{"trace", this.fBuildTrace.getName()}).setParentScope((LogUtils.IFlowScopeLog)this.fScope).build();){
                FlameGraphView.this.buildEntryList(this.fBuildTrace, this.fParentTrace, this.fParameters, Objects.requireNonNull(monitor));
                Map<ITmfTrace, Job> map = FlameGraphView.this.fBuildJobMap;
                synchronized (map) {
                    FlameGraphView.this.fBuildJobMap.remove(this.fBuildTrace);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static class ParentEntry
    extends TimeGraphEntry {
        private final @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> fProvider;

        public ParentEntry(@NonNull TimeGraphEntryModel model, @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider) {
            super(model);
            this.fProvider = provider;
        }

        public @NonNull ITimeGraphDataProvider<? extends TimeGraphEntryModel> getProvider() {
            return this.fProvider;
        }
    }

    protected class ZoomThread
    extends Thread {
        private final long fZoomStartTime;
        private final long fZoomEndTime;
        private final long fResolution;
        private int fScopeId;
        private final @NonNull IProgressMonitor fMonitor;
        private @NonNull Collection<@NonNull TimeGraphEntry> fCurrentEntries;
        private boolean fForce;

        public ZoomThread(Collection<TimeGraphEntry> entries, long startTime, long endTime, long resolution, boolean force) {
            super(FlameGraphView.this.getName() + " zoom");
            this.fScopeId = -1;
            this.fZoomStartTime = startTime;
            this.fZoomEndTime = endTime;
            this.fResolution = resolution;
            this.fCurrentEntries = entries;
            this.fMonitor = new NullProgressMonitor();
            this.fForce = force;
        }

        public long getZoomStartTime() {
            return this.fZoomStartTime;
        }

        public long getZoomEndTime() {
            return this.fZoomEndTime;
        }

        public long getResolution() {
            return this.fResolution;
        }

        public @NonNull IProgressMonitor getMonitor() {
            return this.fMonitor;
        }

        public void cancel() {
            this.fMonitor.setCanceled(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try {
                    LogUtils.FlowScopeLog log;
                    block14: {
                        log = new LogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameGraphView:ZoomThread", new Object[]{"start", this.fZoomStartTime, "end", this.fZoomEndTime}).setCategoryAndId(FlameGraphView.this.getViewId(), this.fScopeId).build();
                        if (!this.fCurrentEntries.isEmpty()) break block14;
                        if (log == null) return;
                        log.close();
                        return;
                    }
                    try {
                        TimeGraphEntry.Sampling sampling = new TimeGraphEntry.Sampling(this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution());
                        Collection<@NonNull TimeGraphEntry> incorrectSample = this.fForce ? this.fCurrentEntries : Iterables.filter(this.fCurrentEntries, entry -> !sampling.equals((Object)entry.getSampling()));
                        FlameGraphView.this.zoomEntries(incorrectSample, this.getZoomStartTime(), this.getZoomEndTime(), this.getResolution(), this.getMonitor());
                        return;
                    }
                    finally {
                        if (log != null) {
                            log.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            finally {
                if (FlameGraphView.this.fDirty.decrementAndGet() < 0) {
                    Activator.getDefault().logError(FlameGraphView.DIRTY_UNDERFLOW, new Throwable());
                }
            }
        }

        public void setScopeId(int scopeId) {
            this.fScopeId = scopeId;
        }
    }
}

