/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.ErrorReporter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SimpleErrorReporter
implements ErrorReporter {
    private List<String> warnings = null;
    private List<String> errors = null;

    @Override
    public void warning(String message, String sourceName, int line, int lineOffset) {
        if (this.warnings == null) {
            this.warnings = new ArrayList<String>();
        }
        this.warnings.add(SimpleErrorReporter.formatDetailedMessage(message, sourceName, line));
    }

    @Override
    public void error(String message, String sourceName, int line, int lineOffset) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        this.errors.add(SimpleErrorReporter.formatDetailedMessage(message, sourceName, line));
    }

    private static String formatDetailedMessage(String message, String sourceName, int lineNumber) {
        String details = message;
        if (sourceName == null || lineNumber <= 0) {
            return details;
        }
        StringBuilder buf = new StringBuilder(details);
        buf.append(" (");
        if (sourceName != null) {
            buf.append(sourceName);
        }
        if (lineNumber > 0) {
            buf.append('#');
            buf.append(lineNumber);
        }
        buf.append(')');
        return buf.toString();
    }

    public static String getMessage0(String messageId) {
        return SimpleErrorReporter.getMessage(messageId, null);
    }

    public static String getMessage1(String messageId, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return SimpleErrorReporter.getMessage(messageId, arguments);
    }

    static String getMessage(String messageId, Object[] arguments) {
        String formatString;
        String defaultResource = "com.google.javascript.rhino.Messages";
        Locale locale = Locale.getDefault();
        ResourceBundle rb = ResourceBundle.getBundle("com.google.javascript.rhino.Messages", locale);
        try {
            formatString = rb.getString(messageId);
        }
        catch (MissingResourceException mre) {
            throw new RuntimeException("no message resource found for message property " + messageId);
        }
        MessageFormat formatter = new MessageFormat(formatString);
        return formatter.format(arguments);
    }
}

