/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.registry.internal;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.core.registry.IGrammarSource;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.registry.Registry;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.internal.GrammarCache;

public abstract class AbstractGrammarRegistryManager
implements IGrammarRegistryManager {
    private final GrammarCache pluginCache = new GrammarCache();
    protected final GrammarCache userCache = new GrammarCache();
    private final Registry registry;

    protected AbstractGrammarRegistryManager() {
        EclipseRegistryOptions options = new EclipseRegistryOptions();
        options.setRegistry(this);
        this.registry = new Registry((IRegistryOptions)options);
    }

    protected AbstractGrammarRegistryManager(IRegistryOptions options) {
        this.registry = new Registry(options);
    }

    @Override
    public @Nullable IGrammar getGrammarFor(IContentType @Nullable [] contentTypes) {
        if (contentTypes == null) {
            return null;
        }
        IContentType[] iContentTypeArray = contentTypes;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            IGrammar grammar;
            IContentType contentType = iContentTypeArray[n2];
            String scopeName = this.getScopeNameForContentType(contentType);
            if (scopeName != null && (grammar = this.getGrammarForScope(scopeName)) != null) {
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @Nullable IGrammar getGrammarForScope(String scopeName) {
        return this.getGrammar(scopeName);
    }

    @Override
    public @Nullable IGrammar getGrammarForFileType(String fileType) {
        IGrammarDefinition[] definitions = this.getDefinitions();
        if (fileType.startsWith(".")) {
            fileType = fileType.substring(1);
        }
        IGrammarDefinition[] iGrammarDefinitionArray = definitions;
        int n = definitions.length;
        int n2 = 0;
        while (n2 < n) {
            Collection fileTypes;
            IGrammarDefinition definition = iGrammarDefinitionArray[n2];
            IGrammar grammar = this.getGrammarForScope(definition.getScopeName());
            if (grammar != null && (fileTypes = grammar.getFileTypes()).contains(fileType)) {
                return grammar;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public @Nullable IGrammarDefinition[] getDefinitions() {
        return (IGrammarDefinition[])Stream.concat(this.pluginCache.getDefinitions().stream(), this.userCache.getDefinitions().stream()).toArray(IGrammarDefinition[]::new);
    }

    private @Nullable IGrammar getGrammar(@Nullable String scopeName) {
        if (scopeName == null) {
            return null;
        }
        IGrammar grammar = this.registry.grammarForScopeName(scopeName);
        if (grammar != null) {
            return grammar;
        }
        return this.registry.loadGrammar(scopeName);
    }

    @Override
    public @Nullable Collection<String> getInjections(String scopeName) {
        return this.pluginCache.getInjections(scopeName);
    }

    protected void registerInjection(String scopeName, String injectTo) {
        this.pluginCache.registerInjection(scopeName, injectTo);
    }

    private @Nullable String getScopeNameForContentType(@Nullable IContentType contentType) {
        while (contentType != null) {
            String scopeName = this.pluginCache.getScopeNameForContentType(contentType);
            if (scopeName != null) {
                return scopeName;
            }
            contentType = contentType.getBaseType();
        }
        return null;
    }

    @Override
    public @Nullable List<IContentType> getContentTypesForScope(String scopeName) {
        return this.pluginCache.getContentTypesForScope(scopeName);
    }

    protected void registerContentTypeBinding(IContentType contentType, String scopeName) {
        this.pluginCache.registerContentTypeBinding(contentType, scopeName);
    }

    @Override
    public void registerGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userCache.registerGrammarDefinition(definition);
        } else {
            this.pluginCache.registerGrammarDefinition(definition);
        }
    }

    @Override
    public void unregisterGrammarDefinition(IGrammarDefinition definition) {
        if (definition.getPluginId() == null) {
            this.userCache.unregisterGrammarDefinition(definition);
        } else {
            this.pluginCache.unregisterGrammarDefinition(definition);
        }
    }

    private static final class EclipseRegistryOptions
    implements IRegistryOptions {
        private @Nullable AbstractGrammarRegistryManager registryManager;

        private EclipseRegistryOptions() {
        }

        private void setRegistry(AbstractGrammarRegistryManager registryManager) {
            this.registryManager = registryManager;
        }

        public @Nullable Collection<String> getInjections(String scopeName) {
            AbstractGrammarRegistryManager registryManager = this.registryManager;
            if (registryManager == null) {
                return null;
            }
            return registryManager.getInjections(scopeName);
        }

        public @Nullable IGrammarSource getGrammarSource(String scopeName) {
            final IGrammarDefinition info = this.getDefinition(scopeName);
            if (info == null) {
                return null;
            }
            return new IGrammarSource(){

                public Reader getReader() throws IOException {
                    return new InputStreamReader(info.getInputStream());
                }

                public String getFilePath() {
                    return (String)NullSafetyHelper.defaultIfNull((Object)info.getPath(), (Object)"unknown");
                }
            };
        }

        private @Nullable IGrammarDefinition getDefinition(String scopeName) {
            AbstractGrammarRegistryManager registryManager = this.registryManager;
            if (registryManager == null) {
                return null;
            }
            IGrammarDefinition definition = registryManager.userCache.getDefinition(scopeName);
            if (definition != null) {
                return definition;
            }
            return registryManager.pluginCache.getDefinition(scopeName);
        }
    }
}

