/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.IDecode_Match;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.Restricted_Length_Template;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Pattern;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanCharString_Element;
import org.eclipse.titan.runtime.core.TitanCharString_template;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TitanUniversalChar;
import org.eclipse.titan.runtime.core.TitanUniversalCharString;
import org.eclipse.titan.runtime.core.TitanUniversalCharString_Element;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanUniversalCharString_template
extends Restricted_Length_Template {
    protected TitanUniversalCharString single_value;
    private TitanCharString pattern_string;
    private ArrayList<TitanUniversalCharString_template> value_list;
    private boolean min_is_set;
    private boolean max_is_set;
    private boolean min_is_exclusive;
    private boolean max_is_exclusive;
    private TitanUniversalChar min_value;
    private TitanUniversalChar max_value;
    private boolean pattern_value_regexp_init;
    private Pattern pattern_value_posix_regexp;
    private boolean pattern_value_nocase;
    private Unichar_Decmatch dec_match;

    public TitanUniversalCharString_template() {
    }

    public TitanUniversalCharString_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanUniversalCharString_template.check_single_selection(otherValue);
    }

    public TitanUniversalCharString_template(String otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanUniversalCharString(otherValue);
    }

    public TitanUniversalCharString_template(TitanCharString otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound charstring value.");
        this.single_value = new TitanUniversalCharString(otherValue);
    }

    public TitanUniversalCharString_template(TitanCharString_Element otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound charstring value.");
        this.single_value = new TitanUniversalCharString(String.valueOf(otherValue.get_char()));
    }

    public TitanUniversalCharString_template(TitanUniversalCharString otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound universal charstring value.");
        this.single_value = new TitanUniversalCharString(otherValue);
    }

    public TitanUniversalCharString_template(TitanUniversalCharString_Element otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound universal charstring value.");
        this.single_value = new TitanUniversalCharString(otherValue);
    }

    public TitanUniversalCharString_template(TitanUniversalCharString_template otherValue) {
        this.copy_template(otherValue);
    }

    public TitanUniversalCharString_template(Optional<TitanUniversalCharString> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanUniversalCharString(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a universal charstring template from an unbound optional field.");
            }
        }
    }

    public TitanUniversalCharString_template(TitanCharString_template otherValue) {
        this.copy_template(otherValue);
    }

    public TitanUniversalCharString_template(Base_Template.template_sel selValue, TitanCharString otherValue) {
        this(selValue, otherValue, false);
    }

    public TitanUniversalCharString_template(Base_Template.template_sel selValue, TitanCharString otherValue, boolean nocase) {
        super(Base_Template.template_sel.STRING_PATTERN);
        if (selValue != Base_Template.template_sel.STRING_PATTERN) {
            throw new TtcnError("Internal error: Initializing a universal charstring pattern template with invalid selection.");
        }
        this.pattern_string = new TitanCharString(otherValue);
        this.pattern_value_regexp_init = false;
        this.pattern_value_nocase = nocase;
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
            case VALUE_RANGE: {
                this.min_value = null;
                this.max_value = null;
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value_regexp_init = false;
                this.pattern_value_posix_regexp = null;
                this.pattern_string = null;
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanUniversalCharString_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanUniversalCharString) {
            return this.operator_assign((TitanUniversalCharString)otherValue);
        }
        if (otherValue instanceof TitanCharString) {
            return this.operator_assign((TitanCharString)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to universal charstring", otherValue));
    }

    @Override
    public TitanUniversalCharString_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanUniversalCharString_template) {
            return this.operator_assign((TitanUniversalCharString_template)otherValue);
        }
        if (otherValue instanceof TitanCharString_template) {
            return this.operator_assign((TitanCharString_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to universal charstring template", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanUniversalCharString) {
            this.log_match((TitanUniversalCharString)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to universalcharstring", match_value));
    }

    @Override
    public TitanUniversalCharString_template operator_assign(Base_Template.template_sel otherValue) {
        TitanUniversalCharString_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanUniversalCharString_template operator_assign(String otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanUniversalCharString(otherValue);
        return this;
    }

    public TitanUniversalCharString_template operator_assign(TitanUniversalCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound universal charstring value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanUniversalCharString(otherValue);
        return this;
    }

    public TitanUniversalCharString_template operator_assign(TitanUniversalCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound universal charstring element to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanUniversalCharString(otherValue);
        return this;
    }

    public TitanUniversalCharString_template operator_assign(TitanCharString otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanUniversalCharString(otherValue);
        return this;
    }

    public TitanUniversalCharString_template operator_assign(TitanCharString_Element otherValue) {
        otherValue.must_bound("Assignment of an unbound charstring element to a universal charstring template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanUniversalCharString(String.valueOf(otherValue.get_char()));
        return this;
    }

    public TitanUniversalCharString_template operator_assign(TitanCharString_template otherValue) {
        this.clean_up();
        this.copy_template(otherValue);
        return this;
    }

    public TitanUniversalCharString_template operator_assign(TitanUniversalCharString_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    private void copy_template(TitanCharString_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = new TitanUniversalCharString(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanUniversalCharString_template temp = new TitanUniversalCharString_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                if (!otherValue.min_is_set) {
                    throw new TtcnError("The lower bound is not set when copying a charstring value range template to a universal charstring template.");
                }
                if (!otherValue.max_is_set) {
                    throw new TtcnError("The upper bound is not set when copying a charstring value range template to a universal charstring template.");
                }
                this.min_is_set = true;
                this.max_is_set = true;
                this.min_is_exclusive = otherValue.min_is_exclusive;
                this.max_is_exclusive = otherValue.max_is_exclusive;
                this.min_value = new TitanUniversalChar('\u0000', '\u0000', '\u0000', otherValue.min_value.get_at(0).get_char());
                this.max_value = new TitanUniversalChar('\u0000', '\u0000', '\u0000', otherValue.max_value.get_at(0).get_char());
                break;
            }
            case STRING_PATTERN: {
                this.pattern_string = new TitanCharString(otherValue.single_value);
                this.pattern_value_regexp_init = false;
                this.pattern_value_nocase = otherValue.pattern_value_nocase;
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = otherValue.dec_match;
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported charstring template to a universal charstring template.");
            }
        }
        this.set_selection(otherValue);
    }

    private void copy_template(TitanUniversalCharString_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = new TitanUniversalCharString(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanUniversalCharString_template temp = new TitanUniversalCharString_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                this.min_is_set = otherValue.min_is_set;
                this.min_is_exclusive = otherValue.min_is_exclusive;
                if (this.min_is_set) {
                    this.min_value = new TitanUniversalChar(otherValue.min_value);
                }
                this.max_is_set = otherValue.max_is_set;
                this.max_is_exclusive = otherValue.max_is_exclusive;
                if (!this.max_is_set) break;
                this.max_value = new TitanUniversalChar(otherValue.max_value);
                break;
            }
            case STRING_PATTERN: {
                this.pattern_string = new TitanCharString(otherValue.pattern_string);
                this.pattern_value_regexp_init = false;
                this.pattern_value_nocase = otherValue.pattern_value_nocase;
                break;
            }
            case DECODE_MATCH: {
                this.dec_match = otherValue.dec_match;
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported universal charstring template.");
            }
        }
        this.set_selection(otherValue);
    }

    public TitanUniversalCharString_Element get_at(int index) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a universal charstring element of a non-specific universal charstring template.");
        }
        return this.single_value.get_at(index);
    }

    public TitanUniversalCharString_Element get_at(TitanInteger index) {
        index.must_bound("Indexing a universal charstring template with an unbound integer value.");
        return this.get_at(index.get_int());
    }

    public TitanUniversalCharString_Element constGet_at(int index) {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Accessing a universal charstring element of a non-specific universal charstring template.");
        }
        return this.single_value.constGet_at(index);
    }

    public TitanUniversalCharString_Element constGet_at(TitanInteger index) {
        index.must_bound("Indexing a universal charstring template with an unbound integer value.");
        return this.constGet_at(index.get_int());
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanUniversalCharString) {
            return this.match((TitanUniversalCharString)otherValue, legacy);
        }
        if (otherValue instanceof TitanCharString) {
            return this.match(new TitanUniversalCharString((TitanCharString)otherValue), legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to universal charstring", otherValue));
    }

    public boolean match(TitanUniversalCharString otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanUniversalCharString otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        List<TitanUniversalChar> otherStr = otherValue.get_value();
        int otherLen = otherStr.size();
        if (!this.match_length(otherLen)) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
            case VALUE_RANGE: {
                if (!this.min_is_set) {
                    throw new TtcnError("The lower bound is not set when matching with a universal charstring value range template.");
                }
                if (!this.max_is_set) {
                    throw new TtcnError("The upper bound is not set when matching with a universal charstring value range template.");
                }
                for (int i = 0; i < otherLen; ++i) {
                    TitanUniversalChar uc = otherStr.get(i);
                    if (uc.is_less_than(this.min_value) || this.max_value.is_less_than(uc)) {
                        return false;
                    }
                    if ((!this.min_is_exclusive || !uc.operator_equals(this.min_value)) && (!this.max_is_exclusive || !uc.operator_equals(this.max_value))) continue;
                    return false;
                }
                return true;
            }
            case STRING_PATTERN: {
                if (!this.pattern_value_regexp_init) {
                    this.pattern_value_posix_regexp = TTCN_Pattern.convert_pattern(this.pattern_string.get_value().toString(), this.pattern_value_nocase);
                }
                if (this.pattern_value_posix_regexp != null) {
                    return TTCN_Pattern.match(otherValue.to_utf(), this.pattern_value_posix_regexp, this.pattern_value_nocase);
                }
                throw new TtcnError(MessageFormat.format("Cannot convert pattern \"{0}\" to POSIX-equivalent.", this.pattern_string.get_value().toString()));
            }
            case DECODE_MATCH: {
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_WARNING);
                TTCN_EncDec.clear_error();
                TTCN_Buffer buffer = new TTCN_Buffer();
                switch (this.dec_match.coding) {
                    case UTF_8: {
                        otherValue.encode_utf8(buffer, false);
                        break;
                    }
                    case UTF16: 
                    case UTF16LE: 
                    case UTF16BE: {
                        otherValue.encode_utf16(buffer, this.dec_match.coding);
                        break;
                    }
                    case UTF32: 
                    case UTF32LE: 
                    case UTF32BE: {
                        otherValue.encode_utf32(buffer, this.dec_match.coding);
                        break;
                    }
                    default: {
                        throw new TtcnError("Internal error: Invalid string serialization for universal charstring template with decoded content matching.");
                    }
                }
                boolean ret_val = this.dec_match.dec_match.match(buffer);
                TTCN_EncDec.set_error_behavior(TTCN_EncDec.error_type.ET_ALL, TTCN_EncDec.error_behavior_type.EB_DEFAULT);
                TTCN_EncDec.clear_error();
                return ret_val;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported universal charstring template.");
    }

    public boolean match(TitanUniversalCharString_Element otherValue, boolean legacy) {
        return this.match(new TitanUniversalCharString(otherValue), legacy);
    }

    public TitanInteger lengthof() {
        boolean has_any_or_none;
        int min_length;
        if (this.is_ifPresent) {
            throw new TtcnError("Performing lengthof() operation on a universal charstring template which has an ifpresent attribute.");
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                min_length = this.single_value.lengthof().get_int();
                has_any_or_none = false;
                break;
            }
            case OMIT_VALUE: {
                throw new TtcnError("Performing lengthof() operation on a universal charstring template containing omit value.");
            }
            case VALUE_RANGE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                min_length = 0;
                has_any_or_none = true;
                break;
            }
            case VALUE_LIST: {
                if (this.value_list.isEmpty()) {
                    throw new TtcnError("Internal error: Performing lengthof() operation on a universal charstring template containing an empty list.");
                }
                int item_length = this.value_list.get(0).lengthof().get_int();
                for (int i = 1; i < this.value_list.size(); ++i) {
                    if (this.value_list.get(i).lengthof().get_int() == item_length) continue;
                    throw new TtcnError("Performing lengthof() operation on a universal charstring template containing a value list with different lengths.");
                }
                min_length = item_length;
                has_any_or_none = false;
                break;
            }
            case COMPLEMENTED_LIST: {
                throw new TtcnError("Performing lengthof() operation on a universal charstring template containing complemented list.");
            }
            case STRING_PATTERN: {
                throw new TtcnError("Performing lengthof() operation on a universal charstring template containing a pattern is not allowed.");
            }
            default: {
                throw new TtcnError("Performing lengthof() operation on an uninitialized/unsupported universal charstring template.");
            }
        }
        return new TitanInteger(this.check_section_is_single(min_length, has_any_or_none, "length", "a", "universal charstring template"));
    }

    @Override
    public TitanUniversalCharString valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific universal charstring template.");
        }
        return this.single_value;
    }

    @Override
    public void set_type(Base_Template.template_sel otherValue, int lenght) {
        this.clean_up();
        switch (otherValue) {
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.set_selection(otherValue);
                this.value_list = new ArrayList(lenght);
                for (int i = 0; i < lenght; ++i) {
                    this.value_list.add(new TitanUniversalCharString_template());
                }
                break;
            }
            case VALUE_RANGE: {
                this.set_selection(Base_Template.template_sel.VALUE_RANGE);
                this.min_is_set = false;
                this.max_is_set = false;
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            case DECODE_MATCH: {
                this.set_selection(Base_Template.template_sel.DECODE_MATCH);
                break;
            }
            default: {
                throw new TtcnError("Setting an invalid type for a universal charstring template.");
            }
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list universal charstring template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanUniversalCharString_template list_item(int listIndex) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list universal charstring template.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an universal charstring value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex >= this.value_list.size()) {
            throw new TtcnError("Index overflow in a universal charstring value list template.");
        }
        return this.value_list.get(listIndex);
    }

    public void set_min(TitanUniversalCharString minValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the lower bound for a non-range universal charstring template.");
        }
        minValue.must_bound("Setting an unbound value as lower bound in a universal charstring value range template.");
        int length = minValue.lengthof().get_int();
        if (length != 1) {
            throw new TtcnError("The length of the lower bound in a universal charstring value range template must be 1 instead of " + length);
        }
        this.min_is_set = true;
        this.min_is_exclusive = false;
        this.min_value = minValue.get_at(0).get_char();
        if (this.max_is_set && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The lower bound in a universal charstring value range template is greater than the upper bound.");
        }
    }

    public void set_max(TitanUniversalCharString maxValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the upper bound for a non-range universal charstring template.");
        }
        maxValue.must_bound("Setting an unbound value as upper bound in a universal charstring value range template.");
        int length = maxValue.lengthof().get_int();
        if (length != 1) {
            throw new TtcnError("The length of the upper bound in a universal charstring value range template must be 1 instead of " + length);
        }
        this.max_is_set = true;
        this.max_is_exclusive = false;
        this.max_value = maxValue.get_at(0).get_char();
        if (this.min_is_set && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The upper bound in a universal charstring value range template is smaller than the lower bound.");
        }
    }

    public void set_min(String minValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the lower bound for a non-range universal charstring template.");
        }
        int length = minValue.length();
        if (length != 1) {
            throw new TtcnError("The length of the lower bound in a universal charstring value range template must be 1 instead of " + length);
        }
        this.min_is_set = true;
        this.min_is_exclusive = false;
        this.min_value = new TitanUniversalChar('\u0000', '\u0000', '\u0000', minValue.charAt(0));
        if (this.max_is_set && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The lower bound in a universal charstring value range template is greater than the upper bound.");
        }
    }

    public void set_max(String maxValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the upper bound for a non-range universal charstring template.");
        }
        int length = maxValue.length();
        if (length != 1) {
            throw new TtcnError("The length of the upper bound in a universal charstring value range template must be 1 instead of " + length);
        }
        this.max_is_set = true;
        this.max_is_exclusive = false;
        this.max_value = new TitanUniversalChar('\u0000', '\u0000', '\u0000', maxValue.charAt(0));
        if (this.min_is_set && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The upper bound in a universal charstring value range template is smaller than the lower bound.");
        }
    }

    public void set_min(TitanCharString minValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the lower bound for a non-range universal charstring template.");
        }
        minValue.must_bound("Setting an unbound value as lower bound in a universal charstring value range template.");
        int length = minValue.lengthof().get_int();
        if (length != 1) {
            throw new TtcnError("The length of the lower bound in a universal charstring value range template must be 1 instead of " + length);
        }
        this.min_is_set = true;
        this.min_is_exclusive = false;
        this.min_value = new TitanUniversalChar('\u0000', '\u0000', '\u0000', minValue.get_at(0).get_char());
        if (this.max_is_set && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The lower bound in a universal charstring value range template is greater than the upper bound.");
        }
    }

    public void set_max(TitanCharString maxValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the upper bound for a non-range universal charstring template.");
        }
        maxValue.must_bound("Setting an unbound value as upper bound in a universal charstring value range template.");
        int length = maxValue.lengthof().get_int();
        if (length != 1) {
            throw new TtcnError("The length of the upper bound in a universal charstring value range template must be 1 instead of " + length);
        }
        this.max_is_set = true;
        this.max_is_exclusive = false;
        this.max_value = new TitanUniversalChar('\u0000', '\u0000', '\u0000', maxValue.get_at(0).get_char());
        if (this.min_is_set && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The upper bound in a universal charstring value range template is smaller than the lower bound.");
        }
    }

    public void set_min_exclusive(boolean minExclusive) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the lower bound exclusiveness for a non-range universal charstring template.");
        }
        this.min_is_exclusive = minExclusive;
    }

    public void set_max_exclusive(boolean maxExclusive) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Setting the upper bound exclusiveness for a non-range universal charstring template.");
        }
        this.max_is_exclusive = maxExclusive;
    }

    public void set_decmatch(IDecode_Match dec_match) {
        this.set_decmatch(dec_match, (String)null);
    }

    public void set_decmatch(IDecode_Match dec_match, String codingString) {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Setting the decoded content matching mechanism of a non-decmatch universal charstring template.");
        }
        TitanCharString.CharCoding new_coding = TitanUniversalCharString.get_character_coding(codingString, "decoded content match");
        this.dec_match = new Unichar_Decmatch();
        this.dec_match.dec_match = dec_match;
        this.dec_match.coding = new_coding;
    }

    public void set_decmatch(IDecode_Match dec_match, TitanCharString codingString) {
        this.set_decmatch(dec_match, codingString.get_value().toString());
    }

    public Object get_decmatch_dec_res() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoding result of a non-decmatch universal charstring template.");
        }
        return this.dec_match.dec_match.get_dec_res();
    }

    public TitanCharString.CharCoding get_decmatch_str_enc() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the encoding format of a non-decmatch universal charstring template.");
        }
        return this.dec_match.coding;
    }

    public Base_Type.TTCN_Typedescriptor get_decmatch_type_descr() {
        if (this.template_selection != Base_Template.template_sel.DECODE_MATCH) {
            throw new TtcnError("Retrieving the decoded type's descriptor in a non-decmatch universal charstring template.");
        }
        return this.dec_match.dec_match.get_type_descr();
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case STRING_PATTERN: {
                TitanCharString_template.log_pattern(this.pattern_string.lengthof().get_int(), this.pattern_string.get_value().toString(), this.pattern_value_nocase);
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.log();
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case VALUE_RANGE: {
                TTCN_Logger.log_char('(');
                if (this.min_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.min_is_set) {
                    if (TitanUniversalCharString.is_printable(this.min_value)) {
                        TTCN_Logger.log_char('\"');
                        TTCN_Logger.log_char_escaped(this.min_value.getUc_cell());
                        TTCN_Logger.log_char('\"');
                    } else {
                        TTCN_Logger.log_event(MessageFormat.format("char({0}, {1}, {2}, {3})", this.min_value.getUc_group(), this.min_value.getUc_plane(), this.min_value.getUc_row(), this.min_value.getUc_cell()), new Object[0]);
                    }
                } else {
                    TTCN_Logger.log_event_str("<unknown lower bound>");
                }
                TTCN_Logger.log_event_str(" .. ");
                if (this.max_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.max_is_set) {
                    if (TitanUniversalCharString.is_printable(this.max_value)) {
                        TTCN_Logger.log_char('\"');
                        TTCN_Logger.log_char_escaped(this.max_value.getUc_cell());
                        TTCN_Logger.log_char('\"');
                    } else {
                        TTCN_Logger.log_event(MessageFormat.format("char({0}, {1}, {2}, {3})", this.max_value.getUc_group(), this.max_value.getUc_plane(), this.max_value.getUc_row(), this.max_value.getUc_cell()), new Object[0]);
                    }
                } else {
                    TTCN_Logger.log_event_str("<unknown upper bound>");
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case DECODE_MATCH: {
                TTCN_Logger.log_event_str("decmatch(");
                switch (this.dec_match.coding) {
                    case UTF_8: {
                        TTCN_Logger.log_event_str("UTF-8");
                        break;
                    }
                    case UTF16: {
                        TTCN_Logger.log_event_str("UTF-16");
                        break;
                    }
                    case UTF16LE: {
                        TTCN_Logger.log_event_str("UTF-16LE");
                        break;
                    }
                    case UTF16BE: {
                        TTCN_Logger.log_event_str("UTF-16BE");
                        break;
                    }
                    case UTF32: {
                        TTCN_Logger.log_event_str("UTF-32");
                        break;
                    }
                    case UTF32LE: {
                        TTCN_Logger.log_event_str("UTF-32LE");
                        break;
                    }
                    case UTF32BE: {
                        TTCN_Logger.log_event_str("UTF-32BE");
                        break;
                    }
                    default: {
                        TTCN_Logger.log_event_str("<unknown coding>");
                    }
                }
                TTCN_Logger.log_event_str(")");
                this.dec_match.dec_match.log();
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_restricted();
        this.log_ifpresent();
    }

    public void log_match(TitanUniversalCharString match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue() | Param_Types.Module_Parameter.basic_check_bits_t.BC_LIST.getValue(), "universal charstring template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanUniversalCharString_template temp = new TitanUniversalCharString_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Charstring: {
                this.operator_assign(param.get_charstring());
                break;
            }
            case MP_Universal_Charstring: {
                this.operator_assign((TitanUniversalCharString)param.get_string_data());
                break;
            }
            case MP_StringRange: {
                TitanUniversalChar lower_uchar = param.get_lower_uchar();
                TitanUniversalChar upper_uchar = param.get_upper_uchar();
                this.clean_up();
                this.set_selection(Base_Template.template_sel.VALUE_RANGE);
                this.min_is_set = true;
                this.max_is_set = true;
                this.min_value = lower_uchar;
                this.max_value = upper_uchar;
                this.set_min_exclusive(param.get_is_min_exclusive());
                this.set_max_exclusive(param.get_is_max_exclusive());
                break;
            }
            case MP_Pattern: {
                this.clean_up();
                this.pattern_string = new TitanCharString(param.get_pattern());
                this.pattern_value_regexp_init = false;
                this.pattern_value_nocase = param.get_nocase();
                this.set_selection(Base_Template.template_sel.STRING_PATTERN);
                break;
            }
            case MP_Expression: {
                if (param.get_expr_type() == Param_Types.Module_Parameter.expression_operand_t.EXPR_CONCATENATE) {
                    TitanUniversalCharString operand1 = new TitanUniversalCharString();
                    TitanUniversalCharString operand2 = new TitanUniversalCharString();
                    boolean nocase = false;
                    boolean is_pattern = operand1.set_param_internal(param.get_operand1(), true, false);
                    operand2.set_param(param.get_operand2());
                    TitanUniversalCharString result = operand1.operator_concatenate(operand2);
                    if (is_pattern) {
                        this.clean_up();
                        this.pattern_string = result.charstring ? new TitanCharString(result.cstr) : new TitanCharString(result.get_stringRepr_for_pattern());
                        this.pattern_value_regexp_init = false;
                        this.pattern_value_nocase = param.get_nocase();
                        this.set_selection(Base_Template.template_sel.STRING_PATTERN);
                        break;
                    }
                    this.operator_assign(result);
                    break;
                }
                param.expr_type_error("a charstring");
                break;
            }
            default: {
                param.type_error("universal charstring template");
            }
        }
        this.is_ifPresent = param.get_ifpresent();
        if (param.get_length_restriction() != null) {
            this.set_length_range(param);
        }
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = this.single_value.get_param(param_name);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            case VALUE_RANGE: {
                mp = new Param_Types.Module_Param_StringRange(this.min_value, this.max_value, this.min_is_exclusive, this.max_is_exclusive);
                break;
            }
            case STRING_PATTERN: {
                mp = new Param_Types.Module_Param_Pattern(this.pattern_string.get_value().toString(), this.pattern_value_nocase);
                break;
            }
            case DECODE_MATCH: {
                throw new TtcnError("Referencing a decoded content matching template is not supported.");
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported universal charstring template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        mp.set_length_restriction(this.get_length_range());
        return mp;
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value.encode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            case VALUE_RANGE: {
                if (!this.min_is_set) {
                    throw new TtcnError("Text encoder: The lower bound is not set in a universal charstring value range template.");
                }
                if (!this.max_is_set) {
                    throw new TtcnError("Text encoder: The upper bound is not set in a universal charstring value range template.");
                }
                byte[] buf = new byte[]{(byte)this.min_value.getUc_group(), (byte)this.min_value.getUc_plane(), (byte)this.min_value.getUc_row(), (byte)this.min_value.getUc_cell(), (byte)this.max_value.getUc_group(), (byte)this.max_value.getUc_plane(), (byte)this.max_value.getUc_row(), (byte)this.max_value.getUc_cell()};
                text_buf.push_raw(buf);
                break;
            }
            case STRING_PATTERN: {
                text_buf.push_int(this.pattern_value_nocase ? 1 : 0);
                this.pattern_string.encode_text(text_buf);
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported universal charstring template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_restricted(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = new TitanUniversalCharString();
                this.single_value.decode_text(text_buf);
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanUniversalCharString_template temp = new TitanUniversalCharString_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                byte[] buf = new byte[8];
                text_buf.pull_raw(8, buf);
                this.min_value = new TitanUniversalChar((char)buf[0], (char)buf[1], (char)buf[2], (char)buf[3]);
                this.max_value = new TitanUniversalChar((char)buf[4], (char)buf[5], (char)buf[6], (char)buf[7]);
                this.min_is_set = true;
                this.max_is_set = true;
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            case STRING_PATTERN: {
                this.pattern_value_regexp_init = false;
                this.pattern_value_nocase = text_buf.pull_int().get_int() == 1;
                this.pattern_string = new TitanCharString();
                this.pattern_string.decode_text(text_buf);
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for a universal charstring template.");
            }
        }
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanUniversalCharString_template.get_res_name(restriction), name == null ? "universal charstring" : name));
    }

    public TitanCharString get_single_value() {
        if (this.pattern_string == null) {
            throw new TtcnError("Pattern string does not exist in universal charstring template");
        }
        return this.pattern_string;
    }

    static class Unichar_Decmatch {
        IDecode_Match dec_match;
        TitanCharString.CharCoding coding;

        Unichar_Decmatch() {
        }
    }
}

