/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanObjectid
extends Base_Type {
    private static final BER.ASN_Tag[] TitanObjectId_tag_ = new BER.ASN_Tag[]{new BER.ASN_Tag(BER.ASN_TagClass.ASN_TAG_UNIV, 6)};
    public static final BER.ASN_BERdescriptor TitanObjectId_Ber_ = new BER.ASN_BERdescriptor(1, TitanObjectId_tag_);
    public static final JSON.TTCN_JSONdescriptor TitanObjectid_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final Base_Type.TTCN_Typedescriptor TitanObjectid_descr_ = new Base_Type.TTCN_Typedescriptor("OBJECT IDENTIFIER", TitanObjectId_Ber_, null, TitanObjectid_json_, null);
    public static final int MIN_COMPONENTS = 2;
    private int n_components;
    private int overflow_idx;
    private List<TitanInteger> components_ptr;

    public TitanObjectid() {
    }

    public TitanObjectid(int init_n_components, TitanInteger ... values) {
        if (init_n_components < 0) {
            throw new TtcnError("Initializing an objid value with a negative number of components.");
        }
        this.n_components = init_n_components;
        this.overflow_idx = -1;
        this.components_ptr = new ArrayList<TitanInteger>(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.components_ptr.add(values[i]);
        }
    }

    public TitanObjectid(TitanObjectid otherValue) {
        otherValue.must_bound("Copying an unbound objid value.");
        this.components_ptr = new ArrayList<TitanInteger>();
        this.components_ptr.addAll(otherValue.components_ptr);
        this.n_components = otherValue.n_components;
        this.overflow_idx = otherValue.overflow_idx;
    }

    @Override
    public void clean_up() {
        this.components_ptr = null;
    }

    public TitanObjectid operator_assign(TitanObjectid otherValue) {
        otherValue.must_bound("Assignment of an unbound objid value.");
        this.clean_up();
        this.components_ptr = new ArrayList<TitanInteger>();
        this.components_ptr.addAll(otherValue.components_ptr);
        this.n_components = otherValue.n_components;
        this.overflow_idx = otherValue.overflow_idx;
        return this;
    }

    @Override
    public Base_Type operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanObjectid) {
            return this.operator_assign((TitanObjectid)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to objectid", otherValue));
    }

    public boolean operator_equals(TitanObjectid otherValue) {
        this.must_bound("The left operand of comparison is an unbound objid value.");
        otherValue.must_bound("The right operand of comparison is an unbound objid value.");
        if (this.n_components != otherValue.n_components) {
            return false;
        }
        if (this.overflow_idx != otherValue.overflow_idx) {
            return false;
        }
        for (int i = 0; i < this.components_ptr.size(); ++i) {
            if (this.components_ptr.get(i).operator_equals(otherValue.components_ptr.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean operator_equals(Base_Type otherValue) {
        if (otherValue instanceof TitanObjectid) {
            return this.operator_equals((TitanObjectid)otherValue);
        }
        return false;
    }

    public boolean operator_not_equals(TitanObjectid otherValue) {
        return !this.operator_equals(otherValue);
    }

    @Override
    public boolean is_present() {
        return this.components_ptr != null;
    }

    @Override
    public boolean is_bound() {
        return this.components_ptr != null;
    }

    public final TitanInteger constGet_at(int index_value) {
        if (this.components_ptr == null) {
            if (index_value != 0) {
                throw new TtcnError("Accessing a component of an unbound objid value.");
            }
            this.n_components = 1;
            this.overflow_idx = -1;
            this.components_ptr = new ArrayList<TitanInteger>();
            this.components_ptr.add(new TitanInteger(0));
            return this.components_ptr.get(0);
        }
        if (index_value < 0) {
            throw new TtcnError(MessageFormat.format("Accessing an objid component using a negative index {0}.", index_value));
        }
        if (index_value > this.n_components) {
            throw new TtcnError(MessageFormat.format("Index overflow when accessing an objid component: the index is {0}, but the value has only {1} components.", index_value, this.n_components));
        }
        if (index_value == this.n_components) {
            ++this.n_components;
            this.components_ptr.add(new TitanInteger(0));
        }
        return this.components_ptr.get(index_value);
    }

    public final TitanInteger constGet_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a objid component with an unbound integer value.");
        return this.constGet_at(index_value.get_int());
    }

    public TitanInteger get_at(int index_value) {
        if (this.components_ptr == null) {
            if (index_value != 0) {
                throw new TtcnError("Accessing a component of an unbound objid value.");
            }
            this.n_components = 1;
            this.overflow_idx = -1;
            this.components_ptr = new ArrayList<TitanInteger>();
            this.components_ptr.add(new TitanInteger(0));
            return this.components_ptr.get(0);
        }
        if (index_value < 0) {
            throw new TtcnError(MessageFormat.format("Accessing an objid component using a negative index {0}.", index_value));
        }
        if (index_value > this.n_components) {
            throw new TtcnError(MessageFormat.format("Index overflow when accessing an objid component: the index is {0}, but the value has only {1} components.", index_value, this.n_components));
        }
        if (index_value == this.n_components) {
            ++this.n_components;
            this.components_ptr.add(new TitanInteger(0));
        }
        return this.components_ptr.get(index_value);
    }

    public TitanInteger get_at(TitanInteger index_value) {
        index_value.must_bound("Indexing a objid component with an unbound integer value.");
        return this.get_at(index_value.get_int());
    }

    public TitanInteger lengthof() {
        this.must_bound("Getting the size of an unbound objid value.");
        return new TitanInteger(this.n_components);
    }

    public TitanInteger size_of() {
        this.must_bound("Getting the size of an unbound objid value.");
        return new TitanInteger(this.n_components);
    }

    public static TitanInteger from_integer(TitanInteger p_int) {
        if (p_int.is_less_than(0)) {
            throw new TtcnError("An OBJECT IDENTIFIER component cannot be negative");
        }
        return new TitanInteger(p_int);
    }

    @Override
    public void log() {
        if (this.components_ptr != null) {
            TTCN_Logger.log_event_str("objid { ");
            for (int i = 0; i < this.n_components; ++i) {
                if (i == this.overflow_idx) {
                    TTCN_Logger.log_event_str("overflow:");
                }
                this.components_ptr.get(i).log();
                TTCN_Logger.log_char(' ');
            }
            TTCN_Logger.log_char('}');
        } else {
            TTCN_Logger.log_event_unbound();
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_VALUE.getValue(), "objid value");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        if (param.get_type() != Param_Types.Module_Parameter.type_t.MP_Objid) {
            param.type_error("objid value");
        }
        this.clean_up();
        this.n_components = param.get_string_size();
        this.components_ptr = new ArrayList<TitanInteger>(Arrays.asList((TitanInteger[])param.get_string_data()));
        this.overflow_idx = -1;
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        if (!this.is_bound()) {
            return new Param_Types.Module_Param_Unbound();
        }
        TitanInteger[] intarray = new TitanInteger[this.components_ptr.size()];
        this.components_ptr.toArray(intarray);
        return new Param_Types.Module_Param_Objid(this.n_components, intarray);
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.must_bound("Text encoder: Encoding an unbound objid value.");
        text_buf.push_int(this.n_components);
        for (int i = 0; i < this.n_components; ++i) {
            text_buf.push_int(this.components_ptr.get(i));
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.n_components = text_buf.pull_int().get_int();
        if (this.n_components < 0) {
            throw new TtcnError("Text decoder: Negative number of components was received for an objid value.");
        }
        this.components_ptr = new ArrayList<TitanInteger>(this.n_components);
        for (int i = 0; i < this.n_components; ++i) {
            this.components_ptr.add(text_buf.pull_int());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-encoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(flavour != 0);
                    this.JSON_encode(p_td, tok);
                    StringBuilder temp = tok.get_buffer();
                    for (int i = 0; i < temp.length(); ++i) {
                        char temp2 = temp.charAt(i);
                        p_buf.put_c((byte)temp2);
                    }
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to encode type `{0}''", p_td.name));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decode(Base_Type.TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        switch (p_coding) {
            case CT_JSON: {
                TTCN_EncDec_ErrorContext errorContext = new TTCN_EncDec_ErrorContext("While JSON-decoding type '%s': ", p_td.name);
                try {
                    if (p_td.json == null) {
                        TTCN_EncDec_ErrorContext.error_internal("No JSON descriptor available for type '%s'.", p_td.name);
                    }
                    byte[] data = p_buf.get_data();
                    char[] temp = new char[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        temp[i] = (char)data[i];
                    }
                    JSON_Tokenizer tok = new JSON_Tokenizer(new String(temp), p_buf.get_len());
                    if (this.JSON_decode(p_td, tok, false) < 0) {
                        TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INCOMPL_MSG, "Can not decode type '%s', because invalid or incomplete message was received", p_td.name);
                    }
                    p_buf.set_pos(tok.get_buf_pos());
                    break;
                }
                finally {
                    errorContext.leave_context();
                }
            }
            default: {
                throw new TtcnError(MessageFormat.format("Unknown coding method requested to decode type `{0}''", p_td.name));
            }
        }
    }

    @Override
    public int JSON_encode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        if (!this.is_bound()) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_UNBOUND, "Encoding an unbound object identifier value.", new Object[0]);
            return -1;
        }
        StringBuilder objid_str = new StringBuilder();
        objid_str.append('\"');
        for (int i = 0; i < this.n_components; ++i) {
            if (i > 0) {
                objid_str.append('.');
            }
            objid_str.append(this.components_ptr.get(i));
        }
        objid_str.append('\"');
        int enc_len = p_tok.put_next_token(JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING, objid_str.toString());
        return enc_len;
    }

    @Override
    public int JSON_decode(Base_Type.TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        if (p_td.json.getActualDefaultValue() != null && 0 == p_tok.get_buffer_length()) {
            this.operator_assign(p_td.json.getActualDefaultValue());
            return 0;
        }
        AtomicReference<JSON_Tokenizer.json_token_t> token = new AtomicReference<JSON_Tokenizer.json_token_t>(JSON_Tokenizer.json_token_t.JSON_TOKEN_NONE);
        StringBuilder value = new StringBuilder();
        AtomicInteger value_len = new AtomicInteger(0);
        boolean error = false;
        int dec_len = p_tok.get_next_token(token, value, value_len);
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_ERROR == token.get()) {
            if (!p_silent) {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Failed to extract valid token, invalid JSON format%s", "");
            }
            return -2;
        }
        if (JSON_Tokenizer.json_token_t.JSON_TOKEN_STRING == token.get()) {
            if (value_len.get() >= 2 && value.charAt(0) == '\"' && value.charAt(value_len.get() - 1) == '\"') {
                String valueWithoutQuotes = value.substring(1, value.length() - 1);
                value.setLength(0);
                value.append(valueWithoutQuotes);
                value_len.set(value.length());
                this.from_string(value.toString());
            }
        } else {
            return -1;
        }
        if (error) {
            if (p_silent) {
                this.clean_up();
            } else {
                TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Invalid JSON %s format, expecting %s value", "string", "object identifier");
            }
            return -2;
        }
        return dec_len;
    }

    private void from_string(String p_str) {
        String[] components = p_str.split("\\.");
        ArrayList<TitanInteger> tmpList = new ArrayList<TitanInteger>();
        for (String component : components) {
            if (component.length() <= 0) continue;
            tmpList.add(new TitanInteger(Integer.parseInt(component)));
        }
        this.overflow_idx = -1;
        this.components_ptr = tmpList;
        this.n_components = this.components_ptr.size();
    }
}

