/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.utils;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.log.viewer.preferences.FilteredSilentEventUtils;

public final class ResourcePropertyHandler {
    private static final int PROPERTY_MAX_SIZE = 2048;
    private static final String PROPERTY_SIZE_KEY = "propertySize";

    private ResourcePropertyHandler() {
    }

    public static String getProperty(IResource resource, String pageId, String propertyKey) {
        try {
            String numSubValues = ResourcePropertyHandler.getSubValues(resource, pageId, propertyKey);
            if (numSubValues != null) {
                int numberOfSubValues = 0;
                try {
                    numberOfSubValues = Integer.parseInt(ResourcePropertyHandler.getSubValues(resource, pageId, propertyKey));
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
                StringBuilder value = new StringBuilder();
                for (int i = 0; i < numberOfSubValues; ++i) {
                    value.append(resource.getPersistentProperty(new QualifiedName(pageId, propertyKey + i)));
                }
                return value.toString();
            }
            String value = resource.getPersistentProperty(new QualifiedName(pageId, propertyKey));
            if (propertyKey.contentEquals("org.eclipse.titan.log.viewer_filter_silent_event_categories") && value == null && FilteredSilentEventUtils.hasPropertiesOldFilteredSilentEvents(resource, pageId)) {
                value = FilteredSilentEventUtils.getOldFilteredSilentEventsFromResource(resource, pageId);
                ResourcePropertyHandler.setProperty(resource, pageId, "org.eclipse.titan.log.viewer_filter_silent_event_categories", value);
                FilteredSilentEventUtils.clearOldFilteredSilentEventsPropertiesInResource(resource, pageId);
            }
            return value;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public static void setProperty(IResource resource, String pageId, String propertyKey, String propertyValue) throws CoreException {
        int propertySize = ResourcePropertyHandler.getPropertySize(propertyValue);
        if (propertySize > 1) {
            resource.setPersistentProperty(new QualifiedName(pageId, propertyKey + PROPERTY_SIZE_KEY), String.valueOf(propertySize));
            for (int i = 0; i < propertySize; ++i) {
                int start = i * 2048;
                int stop = (i + 1) * 2048;
                if (propertyValue.length() < stop) {
                    stop = propertyValue.length();
                }
                resource.setPersistentProperty(new QualifiedName(pageId, propertyKey + i), propertyValue.substring(start, stop));
            }
        } else {
            resource.setPersistentProperty(new QualifiedName(pageId, propertyKey + PROPERTY_SIZE_KEY), null);
            resource.setPersistentProperty(new QualifiedName(pageId, propertyKey), propertyValue);
        }
    }

    public static void removeProperty(IResource resource, String pageId, String propertyKey) {
        block6: {
            try {
                String numSubValues = ResourcePropertyHandler.getSubValues(resource, pageId, propertyKey);
                if (numSubValues != null) {
                    int numberOfSubValues = 0;
                    try {
                        numberOfSubValues = Integer.parseInt(ResourcePropertyHandler.getSubValues(resource, pageId, propertyKey));
                    }
                    catch (NumberFormatException nfe) {
                        return;
                    }
                    for (int i = 0; i < numberOfSubValues; ++i) {
                        resource.setPersistentProperty(new QualifiedName(pageId, propertyKey + i), null);
                    }
                    break block6;
                }
                resource.setPersistentProperty(new QualifiedName(pageId, propertyKey), null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private static String getSubValues(IResource resource, String pageId, String propertyKey) throws CoreException {
        return resource.getPersistentProperty(new QualifiedName(pageId, propertyKey + PROPERTY_SIZE_KEY));
    }

    private static int getPropertySize(String value) {
        int propSize = value.length() / 2048;
        if (value.length() > propSize * 2048) {
            ++propSize;
        }
        return propSize;
    }
}

