/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.FileBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.ui.dialogs.PropertyPage;

public final class FileBuildPropertyPage
extends PropertyPage {
    private Composite pageComposite = null;
    private Label headLabel = null;
    private ConfigurationManagerControl configurationManager;
    private String firstConfiguration;
    private Button excludeFromBuildButton = null;
    private static final String EXCLUDE_DISPLAY_TEXT = "Excluded from build.";
    private Button enableCodeSplittingButton = null;
    private static final String ENABLE_CODE_SPLITTING_DISPLAY_TEXT = "Enable code splitting";
    private static final String ENABLE_CODE_SPLITTING_TOOLTIP = "Selective code splitting must be enabled on project level";
    private IFile fileResource;
    private boolean hasSupportedFileExtension;

    public void dispose() {
        this.pageComposite.dispose();
        this.headLabel.dispose();
        super.dispose();
    }

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.loadProperties();
        PropertyNotificationManager.firePropertyChange((IResource)this.fileResource.getProject());
    }

    protected Control createContents(Composite parent) {
        this.fileResource = (IFile)this.getElement();
        this.pageComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.pageComposite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        this.pageComposite.setLayoutData((Object)data);
        if (TITANBuilder.isBuilderEnabled(this.fileResource.getProject())) {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN C++ builder enabled.");
        } else {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText("This TITAN project has the TITAN C++ builder disabled.");
        }
        this.configurationManager = new ConfigurationManagerControl(this.pageComposite, this.fileResource.getProject());
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FileBuildPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    FileBuildPropertyPage.this.changeConfiguration(FileBuildPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.firstConfiguration = this.configurationManager.getActualSelection();
        this.excludeFromBuildButton = new Button(this.pageComposite, 32);
        this.excludeFromBuildButton.setText(EXCLUDE_DISPLAY_TEXT);
        this.excludeFromBuildButton.setEnabled(true);
        this.hasSupportedFileExtension = FileBuildPropertyData.hasSupportedFileExtension(this.fileResource);
        if (this.hasSupportedFileExtension) {
            this.enableCodeSplittingButton = new Button(this.pageComposite, 32);
            this.enableCodeSplittingButton.setText(ENABLE_CODE_SPLITTING_DISPLAY_TEXT);
            this.enableCodeSplittingButton.setToolTipText(ENABLE_CODE_SPLITTING_TOOLTIP);
            this.updateEnableCodeSplittingButton();
        }
        boolean mode = FileBuildPropertyData.getPropertyValue(this.fileResource, "excludeFromBuild");
        this.excludeFromBuildButton.setSelection(mode);
        if (this.hasSupportedFileExtension) {
            mode = FileBuildPropertyData.getPropertyValue(this.fileResource, "enableCodeSplitting");
            this.enableCodeSplittingButton.setSelection(mode);
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    protected void performDefaults() {
        this.excludeFromBuildButton.setSelection(false);
        if (this.hasSupportedFileExtension) {
            this.enableCodeSplittingButton.setSelection(false);
            this.updateEnableCodeSplittingButton();
        }
        this.configurationManager.saveActualConfiguration();
    }

    public boolean performCancel() {
        this.configurationManager.clearActualConfiguration();
        this.loadProperties();
        return super.performCancel();
    }

    public boolean performOk() {
        boolean configurationChanged;
        IProject project = this.fileResource.getProject();
        boolean excludeFromBuildChanged = this.excludeFromBuildButton.getSelection() != FileBuildPropertyData.getPropertyValue(this.fileResource, "excludeFromBuild");
        boolean codeSplittingChanged = this.hasSupportedFileExtension && this.enableCodeSplittingButton.getSelection() != FileBuildPropertyData.getPropertyValue(this.fileResource, "enableCodeSplitting");
        boolean bl = configurationChanged = !this.firstConfiguration.equals(this.configurationManager.getActualSelection());
        if (configurationChanged || excludeFromBuildChanged || codeSplittingChanged) {
            FileBuildPropertyData.setPropertyValue(this.fileResource, "excludeFromBuild", this.excludeFromBuildButton.getSelection());
            if (codeSplittingChanged) {
                FileBuildPropertyData.setPropertyValue(this.fileResource, "enableCodeSplitting", this.enableCodeSplittingButton.getSelection());
            }
            this.configurationManager.saveActualConfiguration();
            ProjectFileHandler projectFileHandler = new ProjectFileHandler(project);
            projectFileHandler.saveProjectSettings();
            GlobalProjectStructureTracker.projectChanged(project);
            MarkerHandler.markAllMarkersForRemoval((IResource)this.fileResource);
            PropertyNotificationManager.firePropertyChange((IResource)this.fileResource);
        }
        return true;
    }

    private void loadProperties() {
        boolean temp = FileBuildPropertyData.getPropertyValue(this.fileResource, "excludeFromBuild");
        this.excludeFromBuildButton.setSelection(temp);
        if (this.hasSupportedFileExtension) {
            temp = FileBuildPropertyData.getPropertyValue(this.fileResource, "enableCodeSplitting");
            this.enableCodeSplittingButton.setSelection(temp);
            this.updateEnableCodeSplittingButton();
        }
    }

    private void updateEnableCodeSplittingButton() {
        try {
            String temp = this.fileResource.getProject().getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "selectiveCodeSplitting"));
            this.enableCodeSplittingButton.setEnabled(Boolean.parseBoolean(temp));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
    }
}

