/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.titan.designer.properties.data.COptimalizationOptionsData;
import org.eclipse.titan.designer.properties.pages.IOptionsPage;
import org.eclipse.titan.designer.properties.pages.ProjectBuildPropertyPage;

public final class COptimalizationOptionsPage
implements IOptionsPage {
    private Composite mainComposite;
    private ComboFieldEditor optimalizationLevel;
    private StringFieldEditor otherFlags;

    @Override
    public void dispose() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
            this.optimalizationLevel.dispose();
            this.otherFlags.dispose();
        }
    }

    @Override
    public Composite createContents(Composite parent) {
        if (this.mainComposite != null) {
            return this.mainComposite;
        }
        this.mainComposite = new Composite(parent, 0);
        this.mainComposite.setLayout((Layout)new GridLayout());
        this.mainComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        this.optimalizationLevel = new ComboFieldEditor("optimizationLevel", "Optimization level", new String[][]{{"Unspecified", "Unspecified"}, {"None (-O0)", "None"}, {"Minor optimizations (-O1)", "Minoroptimizations"}, {"Common optimizations (-O2)", "Commonoptimizations"}, {"Optimize for speed (-O3)", "Optimizeforspeed"}, {"Optimize for size (-Os)", "Optimizeforsize"}}, this.mainComposite);
        this.otherFlags = new StringFieldEditor("otherOptimizationFlags", "Other optimization flags:", this.mainComposite);
        return this.mainComposite;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.mainComposite == null) {
            return;
        }
        this.optimalizationLevel.setEnabled(enabled, this.mainComposite);
        this.otherFlags.setEnabled(enabled, this.mainComposite);
    }

    @Override
    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        for (int i = 0; i < COptimalizationOptionsData.PROPERTIES.length; ++i) {
            try {
                temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", COptimalizationOptionsData.PROPERTIES[i]));
                if (temp == null) continue;
                tempStorage.setValue(COptimalizationOptionsData.PROPERTIES[i], temp);
                continue;
            }
            catch (CoreException ce) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            }
        }
    }

    @Override
    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        String actualValue = null;
        String copyValue = null;
        boolean result = false;
        for (int i = 0; i < COptimalizationOptionsData.PROPERTIES.length; ++i) {
            try {
                actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", COptimalizationOptionsData.PROPERTIES[i]));
                copyValue = tempStorage.getString(COptimalizationOptionsData.PROPERTIES[i]);
                result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                result = true;
            }
        }
        return result;
    }

    @Override
    public void performDefaults() {
        if (this.mainComposite == null) {
            return;
        }
        this.optimalizationLevel.setEnabled(true, this.mainComposite);
        this.optimalizationLevel.setSelectedValue("Commonoptimizations");
        this.otherFlags.setEnabled(true, this.mainComposite);
        this.otherFlags.setStringValue("");
    }

    @Override
    public boolean checkProperties(ProjectBuildPropertyPage page) {
        return true;
    }

    @Override
    public void loadProperties(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "optimizationLevel"));
            if (temp != null && temp.length() != 0) {
                this.optimalizationLevel.setSelectedValue(temp);
            } else {
                this.optimalizationLevel.setSelectedValue("Commonoptimizations");
            }
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "otherOptimizationFlags"));
            this.otherFlags.setStringValue(temp);
        }
        catch (CoreException e) {
            this.optimalizationLevel.setSelectedValue("Commonoptimizations");
            this.otherFlags.setStringValue("");
        }
    }

    @Override
    public boolean saveProperties(IProject project) {
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "optimizationLevel");
            String newValue = this.optimalizationLevel.getActualValue();
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
            qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "otherOptimizationFlags");
            newValue = this.otherFlags.getStringValue();
            oldValue = project.getPersistentProperty(qualifiedName);
            if (newValue != null && !newValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }
}

