/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ListConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LinkerLibrariesOptionsData {
    public static final String ADDITIONAL_OBJECTS_PROPERTY = "additionalObjects";
    public static final String ADDITIONAL_OBJECTS_TAG = "additionalObjects";
    public static final String LINKER_LIBRARIES_PROPERTY = "linkerLibraries";
    public static final String LINKER_LIBRARIES_TAG = "linkerLibraries";
    public static final String LINKER_LIBRARY_SEARCH_PATH_PROPERTY = "linkerLibrarySearchPath";
    public static final String LINKER_LIBRARY_SEARCH_PATH_TAG = "linkerLibrarySearchPath";
    public static final String DISABLE_EXTERNAL_DIRS_PROPERTY = "disablePredefinedExternalFolder";
    public static final String DISABLE_EXTERNAL_DIRS_TAG = "disablePredefinedExternalFolder";
    public static final String[] PROPERTIES = new String[]{"additionalObjects", "linkerLibraries", "linkerLibrarySearchPath"};
    public static final String[] TAGS = new String[]{"additionalObjects", "linkerLibraries", "linkerLibrarySearchPath"};
    public static final String[] DEFAULT_VALUES = new String[]{"", "", ""};

    private LinkerLibrariesOptionsData() {
    }

    public static String[] getAdditionalObjects(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "additionalObjects"));
            return ListConverter.convertToList(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting additional library objects of `" + project.getName() + "'"), (Throwable)e);
            return new String[0];
        }
    }

    public static String[] getLinkerLibraries(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "linkerLibraries"));
            return ListConverter.convertToList(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting linker libraries of `" + project.getName() + "'"), (Throwable)e);
            return new String[0];
        }
    }

    public static String[] getLinkerSearchPaths(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "linkerLibrarySearchPath"));
            return ListConverter.convertToList(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting linker search paths of `" + project.getName() + "'"), (Throwable)e);
            return new String[0];
        }
    }

    public static boolean getExternalFoldersDisabled(IProject project) {
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disablePredefinedExternalFolder"));
            return "true".equals(temp);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting external folders of `" + project.getName() + "'"), (Throwable)e);
            return false;
        }
    }

    public static void removeTITANAttributes(IProject project) {
        for (int i = 0; i < PROPERTIES.length; ++i) {
            try {
                project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]), null);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While removing property `" + PROPERTIES[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
    }

    public static void loadMakefileSettings(Node root, IProject project) {
        int i;
        NodeList resourceList = root.getChildNodes();
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        String newDisableExternalDirsValue = "false";
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            Node resource = resourceList.item(i);
            String name = resource.getNodeName();
            for (int j = 0; j < TAGS.length; ++j) {
                if (!TAGS[j].equals(name)) continue;
                NodeList subResources = resource.getChildNodes();
                ArrayList<String> values = new ArrayList<String>();
                for (int i2 = 0; i2 < subResources.getLength(); ++i2) {
                    Node subResource = subResources.item(i2);
                    if (!"listItem".equals(subResource.getNodeName())) continue;
                    values.add(subResource.getTextContent());
                }
                newValues[j] = ListConverter.convertFromList(values.toArray(new String[values.size()]));
            }
            if (!"disablePredefinedExternalFolder".equals(name)) continue;
            newDisableExternalDirsValue = resourceList.item(i).getTextContent();
        }
        for (i = 0; i < TAGS.length; ++i) {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]);
            try {
                String oldValue = project.getPersistentProperty(qualifiedName);
                if (newValues[i] == null || newValues[i].equals(oldValue)) continue;
                project.setPersistentProperty(qualifiedName, newValues[i]);
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While loading tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
        try {
            QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disablePredefinedExternalFolder");
            String oldValue = project.getPersistentProperty(qualifiedName);
            if (newDisableExternalDirsValue != null && !newDisableExternalDirsValue.equals(oldValue)) {
                project.setPersistentProperty(qualifiedName, newDisableExternalDirsValue);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While loading external folders of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void saveMakefileSettings(Element makefileSettings, Document document, IProject project) {
        for (int i = 0; i < TAGS.length; ++i) {
            try {
                String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", PROPERTIES[i]));
                String[] tempList = ListConverter.convertToList(temp);
                if (tempList.length <= 0) continue;
                Element list = document.createElement(TAGS[i]);
                makefileSettings.appendChild(list);
                for (int j = 0; j < tempList.length; ++j) {
                    if (tempList[j] == null || tempList[j].length() <= 0) continue;
                    Element item = document.createElement("listItem");
                    item.appendChild(document.createTextNode(tempList[j]));
                    list.appendChild(item);
                }
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While saving tag `" + TAGS[i] + "' of `" + project.getName() + "'"), (Throwable)e);
            }
        }
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "disablePredefinedExternalFolder"));
            if (temp != null && !"false".equals(temp)) {
                Element element = document.createElement("disablePredefinedExternalFolder");
                makefileSettings.appendChild(element);
                element.appendChild(document.createTextNode(temp));
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While saving external folders of `" + project.getName() + "'"), (Throwable)e);
        }
    }

    public static void copyMakefileSettings(Node source, Node makefileSettings, Document document, boolean saveDefaultValues) {
        int j;
        int i;
        NodeList resourceList = source.getChildNodes();
        String[] newValues = new String[TAGS.length];
        System.arraycopy(DEFAULT_VALUES, 0, newValues, 0, TAGS.length);
        String newDisableExternalDirsValue = "false";
        int size = resourceList.getLength();
        for (i = 0; i < size; ++i) {
            Node resource = resourceList.item(i);
            String name = resource.getNodeName();
            for (j = 0; j < TAGS.length; ++j) {
                if (!TAGS[j].equals(name)) continue;
                NodeList subResources = resource.getChildNodes();
                ArrayList<String> values = new ArrayList<String>();
                for (int i2 = 0; i2 < subResources.getLength(); ++i2) {
                    Node subResource = subResources.item(i2);
                    if (!"listItem".equals(subResource.getNodeName())) continue;
                    values.add(subResource.getTextContent());
                }
                newValues[j] = ListConverter.convertFromList(values.toArray(new String[values.size()]));
            }
            if (!"disablePredefinedExternalFolder".equals(name)) continue;
            newDisableExternalDirsValue = resourceList.item(i).getTextContent();
        }
        for (i = 0; i < TAGS.length; ++i) {
            String temp = newValues[i];
            String[] tempList = ListConverter.convertToList(temp);
            if (tempList.length <= 0) continue;
            Element list = document.createElement(TAGS[i]);
            makefileSettings.appendChild(list);
            for (j = 0; j < tempList.length; ++j) {
                if (tempList[j] == null || tempList[j].length() <= 0) continue;
                Element item = document.createElement("listItem");
                item.appendChild(document.createTextNode(tempList[j]));
                list.appendChild(item);
            }
        }
        if (saveDefaultValues || newDisableExternalDirsValue != null && !"false".equals(newDisableExternalDirsValue)) {
            Element element = document.createElement("disablePredefinedExternalFolder");
            makefileSettings.appendChild(element);
            element.appendChild(document.createTextNode(newDisableExternalDirsValue));
        }
    }
}

