/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.controls;

import java.io.RandomAccessFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.swt.graphics.Color;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.editors.ColorManager;
import org.eclipse.titan.designer.editors.asn1editor.CodeScanner;
import org.eclipse.titan.designer.editors.controls.HoverContentType;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PeekSource {
    private static Location lastPeekedLocation;
    private static PeekType lastPeekedType;

    public static String getPeekSource(IEditorPart targetEditor, Location codeLoc) {
        if (codeLoc == null || codeLoc.equals(NULL_Location.INSTANCE)) {
            return null;
        }
        IResource fileToLoad = codeLoc.getFile();
        if (fileToLoad instanceof IFile) {
            IFile file = (IFile)fileToLoad;
            switch (file.getFileExtension()) {
                case "asn": 
                case "asn1": {
                    lastPeekedType = PeekType.Asn1;
                    break;
                }
                default: {
                    lastPeekedType = PeekType.Ttcn3;
                }
            }
        }
        IResource actual = (IResource)targetEditor.getEditorInput().getAdapter(IFile.class);
        String codeText = null;
        if (targetEditor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)targetEditor;
            IDocumentProvider provider = textEditor.getDocumentProvider();
            IEditorInput input = targetEditor.getEditorInput();
            if (actual.getFullPath().equals((Object)fileToLoad.getFullPath())) {
                IDocument document = provider.getDocument((Object)input);
                StringBuilder code = new StringBuilder();
                try {
                    for (int i = codeLoc.getOffset(); i <= codeLoc.getEndOffset(); ++i) {
                        char c = document.getChar(i);
                        code.append(c);
                    }
                }
                catch (Exception e) {
                    return null;
                }
                codeText = code.toString();
            } else {
                try {
                    RandomAccessFile f2 = new RandomAccessFile(fileToLoad.getLocation().toString(), "r");
                    int size = codeLoc.getEndOffset() - codeLoc.getOffset();
                    byte[] buffer = new byte[size];
                    f2.seek(codeLoc.getOffset());
                    f2.read(buffer, 0, size);
                    codeText = new String(buffer);
                }
                catch (Exception e) {
                    return null;
                }
            }
            lastPeekedLocation = codeLoc;
            return codeText;
        }
        return null;
    }

    public static void addStyledSource(String source, Ttcn3HoverContent content) {
        IToken token;
        if (source == null || source.isEmpty()) {
            content.addContent(HoverContentType.SOURCE, "");
            return;
        }
        String[] lines = source.split("\n");
        int minspaces = Integer.MAX_VALUE;
        int spacecount = 0;
        if (lines.length > 1) {
            StringBuilder notabs = new StringBuilder();
            for (int i = 1; i < lines.length; ++i) {
                spacecount = 0;
                for (int j = 0; j < lines[i].length(); ++j) {
                    if (lines[i].charAt(j) == '\t') {
                        spacecount += 4;
                        notabs.append("    ");
                        continue;
                    }
                    if (lines[i].charAt(j) == ' ') {
                        ++spacecount;
                        notabs.append(" ");
                        continue;
                    }
                    notabs.append(lines[i].substring(j));
                    break;
                }
                notabs.append("\n");
                if (spacecount >= minspaces) continue;
                minspaces = spacecount;
            }
            StringBuilder stripped = new StringBuilder();
            if (minspaces != Integer.MAX_VALUE && minspaces > 0) {
                stripped.append(lines[0]);
                lines = notabs.toString().split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    stripped.append("\n");
                    stripped.append(lines[i].substring(minspaces));
                }
                source = stripped.toString();
            }
        }
        Document doc = new Document(source);
        RuleBasedScanner scanner = null;
        switch (lastPeekedType) {
            case Asn1: {
                scanner = new CodeScanner(new ColorManager());
                break;
            }
            default: {
                scanner = new org.eclipse.titan.designer.editors.ttcn3editor.CodeScanner(new ColorManager(), lastPeekedLocation);
            }
        }
        scanner.setRange((IDocument)doc, 0, source.length());
        StringBuilder codestr = new StringBuilder("<pre>");
        while (!(token = scanner.nextToken()).isEOF()) {
            boolean isBold = false;
            boolean isItalic = false;
            String item = source.substring(scanner.getTokenOffset(), scanner.getTokenOffset() + scanner.getTokenLength());
            item.replaceAll("\n", "<br>").replaceAll("\t", "  ");
            if (token.getData() instanceof TextAttribute) {
                TextAttribute attrib = (TextAttribute)token.getData();
                switch (attrib.getStyle()) {
                    case 1: {
                        isBold = true;
                        break;
                    }
                    case 2: {
                        isItalic = true;
                    }
                }
                codestr.append("<span style=\"");
                if (isBold) {
                    codestr.append("font-weight: bold; ");
                }
                if (isItalic) {
                    codestr.append("font-style: italic; ");
                }
                Color color = attrib.getForeground();
                String colorcode = "rgb(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + ")";
                codestr.append("color : ").append(colorcode).append("; >");
                codestr.append(" \">").append(item);
                codestr.append("</span>");
                continue;
            }
            codestr.append(item);
        }
        content.addContent(HoverContentType.SOURCE, codestr.toString());
    }

    private static enum PeekType {
        Ttcn3,
        Asn1;

    }
}

