/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.values.expressions;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class MTCComponentExpression
extends Expression_Value {
    @Override
    public Expression_Value.Operation_type getOperationType() {
        return Expression_Value.Operation_type.MTC_COMPONENT_OPERATION;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        return IType.Type_type.TYPE_COMPONENT;
    }

    @Override
    public boolean checkExpressionSelfReference(CompilationTimeStamp timestamp, Assignment lhs) {
        return false;
    }

    @Override
    public String createStringRepresentation() {
        return "mtc";
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp) && this.myGovernor != null) {
            return this.myGovernor;
        }
        if (this.myScope != null) {
            return this.myScope.getMtcSystemComponentType(timestamp, false);
        }
        return null;
    }

    @Override
    public boolean isUnfoldable(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        return true;
    }

    private void checkExpressionOperands(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.myGovernor == null || this.myScope == null) {
            return;
        }
        IType governorLast = this.myGovernor.getTypeRefdLast(timestamp);
        if (!IType.Type_type.TYPE_COMPONENT.equals((Object)governorLast.getTypetype())) {
            return;
        }
        Component_Type componentType = this.myScope.getMtcSystemComponentType(timestamp, false);
        if (componentType != null && !governorLast.isCompatible(timestamp, componentType, null, null, null)) {
            this.getLocation().reportSemanticError(MessageFormat.format("Incompatible component types: a component reference of type `{0}'' was expected, but `mtc'' has type `{1}''", governorLast.getTypename(), ((Type)componentType).getTypename()));
            this.setIsErroneous(true);
        }
    }

    @Override
    public IValue evaluateValue(CompilationTimeStamp timestamp, Expected_Value_type expectedValue, IReferenceChain referenceChain) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return this.lastValue;
        }
        this.isErroneous = false;
        this.lastTimeChecked = timestamp;
        this.lastValue = this;
        this.checkExpressionOperands(timestamp, referenceChain);
        return this.lastValue;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return true;
    }

    @Override
    public boolean canGenerateSingleExpression() {
        return true;
    }

    @Override
    public void generateCodeExpressionExpression(JavaGenData aData, ExpressionStruct expression) {
        aData.addBuiltinTypeImport("TitanComponent");
        expression.expression.append("new TitanComponent(TitanComponent.MTC_COMPREF)");
    }
}

